/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.mimvista.file.MIMFile;
import com.mimvista.file.j;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public class DicomReadJavascriptFilterManager {
    private List<Invocable> scriptEngines = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicomReadJavascriptFilterManager() {
        String string = System.getProperty("dicomread.filtermanagerpath");
        List<File> list = string != null && new File(string).isDirectory() ? MIMFile.a(new File(string), j.b(new String[]{".js"})) : c.d().a(CascadeSubfolder.o, j.b(new String[]{".js"}));
        for (File file : list) {
            try {
                ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByExtension("js");
                if (scriptEngine != null) {
                    scriptEngine.eval("var Tag = org.dcm4che2.data.Tag; var VR = org.dcm4che2.data.VR;\n");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        scriptEngine.eval(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                    }
                    finally {
                        cm.a((Closeable)fileInputStream);
                    }
                }
                this.scriptEngines.add((Invocable)((Object)scriptEngine));
            }
            catch (Throwable throwable) {
                ay.d((Object)("error loading filter script: " + file), throwable, DicomReadJavascriptFilterManager.class);
            }
        }
    }

    public DicomObject mungeDicomObject(DicomObject dicomObject) {
        if (dicomObject == null || this.scriptEngines.isEmpty()) {
            return dicomObject;
        }
        byte[] byArray = null;
        if (!DicomReadJavascriptFilterManager.wasObjectMunged(dicomObject)) {
            byArray = DicomReadJavascriptFilterManager.objectChecksum(dicomObject);
        }
        for (Invocable invocable : this.scriptEngines) {
            try {
                invocable.invokeFunction("process", dicomObject);
            }
            catch (Exception exception) {
                ay.d((Object)"error executing filter script: ", (Throwable)exception, DicomReadJavascriptFilterManager.class);
            }
        }
        if (!dicomObject.contains(930295847) && !Arrays.equals(DicomReadJavascriptFilterManager.objectChecksum(dicomObject), byArray)) {
            dicomObject.putInt(930295847, VR.IS, 1);
        }
        return dicomObject;
    }

    public static boolean wasObjectMunged(DicomObject dicomObject) {
        return dicomObject.contains(930295847);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] objectChecksum(DicomObject dicomObject) {
        byte[] byArray;
        DigestOutputStream digestOutputStream = null;
        DicomOutputStream dicomOutputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            digestOutputStream = new DigestOutputStream(ByteStreams.nullOutputStream(), messageDigest);
            dicomOutputStream = new DicomOutputStream((OutputStream)digestOutputStream);
            dicomOutputStream.writeDataset(dicomObject, TransferSyntax.ImplicitVRLittleEndian);
            byArray = digestOutputStream.getMessageDigest().digest();
        }
        catch (Throwable throwable) {
            try {
                ay.d((Object)"Error creating dicom object checksum", throwable, DicomReadJavascriptFilterManager.class);
            }
            catch (Throwable throwable2) {
                cm.a(new Closeable[]{digestOutputStream, dicomOutputStream});
                throw throwable2;
            }
            cm.a(new Closeable[]{digestOutputStream, dicomOutputStream});
            return new byte[0];
        }
        cm.a(new Closeable[]{digestOutputStream, dicomOutputStream});
        return byArray;
    }
}

