/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.ExternallyVisible;
import com.mimvista.dicom.DicomImageConverter;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.read.ConfigurableFileExcluder;
import com.mimvista.dicom.read.FileExcluder;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.file.MIMFile;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.MIMContext;
import com.mimvista.util.ay;
import com.mimvista.util.by;
import com.mimvista.util.cc;
import com.mimvista.util.cm;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomCodingException;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.media.FileMetaInformation;
import org.dcm4che2.util.TagUtils;

@ExternallyVisible
public class DicomReader {
    private static final int MAX_VALUE_LENGTH_LIMIT = 1000000000;
    public static FileExcluder fileExcluder;

    protected DicomReader() {
    }

    public static DicomObject readFileIntoDicomObject(File file) {
        return DicomReader.readFileIntoDicomObject(file, -1);
    }

    public static DicomObject readFileIntoDicomObject(String string) {
        return DicomReader.readFileIntoDicomObject(new File(string));
    }

    public static DicomObject readFileIntoDicomObject(String string, int n2) {
        return DicomReader.readFileIntoDicomObject(new File(string), n2);
    }

    public static void main(String[] stringArray) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(new File("E:/signedText.dcm"));
        if (dicomObject != null) {
            System.out.println("Succeeds");
        }
        System.out.println("Done");
    }

    public static DicomObject readFileIntoDicomObject(File file, int n2) {
        return DicomReader.readFileIntoDicomObject(file, n2, true);
    }

    public static DicomObject readStreamIntoDicomObject(InputStream inputStream, int n2, boolean bl2, long l2) {
        try {
            return DicomReader.readStreamIntoDicom(inputStream, DicomReader.getInputHandler(n2, bl2), l2, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static DicomObject readStreamIntoDicomObject(InputStream inputStream, DicomInputHandler dicomInputHandler) {
        return DicomReader.readStreamIntoDicomObject(inputStream, dicomInputHandler, true);
    }

    public static DicomObject readStreamIntoDicomObject(InputStream inputStream, DicomInputHandler dicomInputHandler, boolean bl2) {
        try {
            return DicomReader.readStreamIntoDicom(inputStream, dicomInputHandler, 1000000000L, bl2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static DicomObject readStreamIntoDicomObjectEx(InputStream inputStream, DicomInputHandler dicomInputHandler) throws DicomCodingException {
        return DicomReader.readStreamIntoDicomObjectEx(inputStream, dicomInputHandler, true);
    }

    public static DicomObject readStreamIntoDicomObjectEx(InputStream inputStream, DicomInputHandler dicomInputHandler, boolean bl2) throws DicomCodingException {
        try {
            return DicomReader.readStreamIntoDicom(inputStream, dicomInputHandler, 1000000000L, bl2, false);
        }
        catch (DicomCodingException dicomCodingException) {
            throw dicomCodingException;
        }
        catch (IOException iOException) {
            ay.d((Object)"DICOM reading error:", (Throwable)iOException, DicomReader.class);
            return null;
        }
    }

    public static DicomObject readStreamIntoDicomObject(InputStream inputStream, int n2, boolean bl2) {
        try {
            return DicomReader.readStreamIntoDicom(inputStream, DicomReader.getInputHandler(n2, bl2), 1000000000L, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static DicomObject readStreamIntoDicomObject(InputStream inputStream, int n2) {
        return DicomReader.readStreamIntoDicomObject(inputStream, n2, false);
    }

    public static DicomObject readStreamIntoDicomObject(InputStream inputStream) {
        return DicomReader.readStreamIntoDicomObject(inputStream, -1);
    }

    public static DicomObject readFileIntoDicomObject(File file, int n2, boolean bl2) {
        return DicomReader.readFileIntoDicomObject(file, DicomReader.getInputHandler(n2, bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject readFileIntoDicomObject(File file, DicomInputHandler dicomInputHandler) {
        Throwable throwable = null;
        try {
            DicomObject dicomObject;
            DicomObject dicomObject2 = dicomObject = DicomReader.readIntoDicomObject(file, dicomInputHandler);
            return dicomObject2;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable = outOfMemoryError;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        finally {
            if (throwable != null) {
                ay.d((Object)("Reading DICOM file: " + file.getAbsolutePath()), throwable, DicomReader.class);
            }
        }
        return null;
    }

    protected static DicomObject readIntoDicomObject(File file, int n2, boolean bl2) throws IOException {
        return DicomReader.readIntoDicomObject(file, DicomReader.getInputHandler(n2, bl2));
    }

    protected static DicomObject readIntoDicomObject(File file, DicomInputHandler dicomInputHandler) throws IOException {
        FileInputStream fileInputStream;
        String[] stringArray;
        String string = file.getName().toUpperCase();
        for (String string2 : stringArray = fileExcluder.getExcludedDicomReadExtensions()) {
            if (!string.endsWith(string2.toUpperCase())) continue;
            return null;
        }
        Object var4_5 = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            ay.d((Object)("Reading DICOM file: " + file.getAbsolutePath()), (Throwable)iOException, DicomReader.class);
            return null;
        }
        long l2 = Math.min(file.length(), 1000000000L);
        return DicomReader.readStreamIntoDicom(fileInputStream, dicomInputHandler, l2, true);
    }

    public static DicomInputHandler getInputHandler(int n2, boolean bl2) {
        if (bl2) {
            return new StopTagInputHandler(n2);
        }
        return new FilteredTagInputHandler(new int[]{n2}, FilteredTagInputHandler.FilterMode.EXCLUDE);
    }

    public static DicomObject readStream(InputStream inputStream, DicomInputHandler dicomInputHandler, boolean bl2) throws IOException {
        return DicomReader.readStreamIntoDicom(inputStream, dicomInputHandler, 1000000000L, bl2, false);
    }

    private static DicomObject readStreamIntoDicom(InputStream inputStream, DicomInputHandler dicomInputHandler, long l2, boolean bl2) throws IOException {
        return DicomReader.readStreamIntoDicom(inputStream, dicomInputHandler, l2, bl2, true);
    }

    private static DicomReadResult readStreamIntoResult(InputStream inputStream, DicomInputHandler dicomInputHandler, long l2, boolean bl2) throws IOException {
        DicomReadParams dicomReadParams = new DicomReadParams().setCloseStream(bl2).setHandler(dicomInputHandler).setValueLengthLimit(l2);
        return DicomReader.readStreamIntoDicom(inputStream, dicomReadParams);
    }

    private static DicomObject readStreamIntoDicom(InputStream inputStream, DicomInputHandler dicomInputHandler, long l2, boolean bl2, boolean bl3) throws IOException {
        DicomReadParams dicomReadParams = new DicomReadParams().setCloseStream(bl2).setHandler(dicomInputHandler).setLogIoException(bl3).setValueLengthLimit(l2);
        DicomReadResult dicomReadResult = DicomReader.readStreamIntoDicom(inputStream, dicomReadParams);
        if (dicomReadResult == null) {
            return null;
        }
        DicomObject dicomObject = dicomReadResult.dob;
        return dicomObject;
    }

    public static DicomReadResult readStreamIntoDicomNoThrow(InputStream inputStream, DicomReadParams dicomReadParams) {
        try {
            return DicomReader.readStreamIntoDicom(inputStream, dicomReadParams);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomReadResult readStreamIntoDicom(InputStream inputStream, DicomReadParams dicomReadParams) throws IOException {
        DicomInputStream dicomInputStream = null;
        try {
            Object object;
            dicomInputStream = new DicomInputStream((InputStream)new BufferedInputStream(inputStream));
            dicomInputStream.setAllowPartialPixelData(dicomReadParams.allowPartialPixelData);
            dicomInputStream.setValueLengthLimit(dicomReadParams.valueLengthLimit);
            dicomInputStream.setHandler(dicomReadParams.handler);
            NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
            dicomInputStream.readDicomObject((DicomObject)nonCrashyDicomObject, -1);
            if (dicomReadParams.handler instanceof FilteredTagInputHandler && ((FilteredTagInputHandler)(object = (FilteredTagInputHandler)dicomReadParams.handler)).filterTags != null && ((FilteredTagInputHandler)object).filterTags.size() == 1 && nonCrashyDicomObject.size() == 1) {
                DicomReadResult dicomReadResult = new DicomReadResult((DicomObject)nonCrashyDicomObject, dicomInputStream.wasMissingPixelData());
                return dicomReadResult;
            }
            if (!nonCrashyDicomObject.isEmpty() && nonCrashyDicomObject.size() > 1) {
                object = new DicomReadResult((DicomObject)nonCrashyDicomObject, dicomInputStream.wasMissingPixelData());
                return object;
            }
            object = null;
            return object;
        }
        catch (Exception exception) {
            boolean bl2 = exception instanceof IOException;
            if (!bl2 || dicomReadParams.logIoException) {
                ay.d((Object)"Reading DICOM file", (Throwable)exception, DicomReader.class);
            }
            if (bl2) {
                throw (IOException)exception;
            }
            DicomReadResult dicomReadResult = null;
            return dicomReadResult;
        }
        finally {
            if (dicomReadParams.closeStream) {
                if (dicomInputStream != null) {
                    cm.a((Closeable)dicomInputStream, null, null);
                }
                if (inputStream != null) {
                    cm.a((Closeable)inputStream, null, null);
                }
            }
        }
    }

    public static boolean skipSeq(DicomInputStream dicomInputStream) throws IOException {
        int n2 = dicomInputStream.valueLength();
        if (n2 == 0) {
            return false;
        }
        boolean bl2 = DicomPrefs.skipZeroByteItems.getValue();
        int n3 = dicomInputStream.readHeader();
        while (n3 == -73728) {
            boolean bl3;
            n2 = dicomInputStream.valueLength();
            if (bl2) {
                bl3 = n2 >= 0;
            } else {
                boolean bl4 = bl3 = n2 > 0;
            }
            if (bl3) {
                DicomReader.skipBytes((InputStream)dicomInputStream, n2);
            } else {
                dicomInputStream.readDicomObject();
            }
            n3 = dicomInputStream.readHeader();
        }
        return n3 != -73507;
    }

    private static void skipBytes(InputStream inputStream, long l2) throws IOException {
        long l3;
        for (long i2 = 0L; i2 < l2; i2 += l3) {
            l3 = inputStream.skip(l2 - i2);
            if (l3 > 0L) continue;
            ay.d((Object)"Skip error.", DicomReader.class);
            break;
        }
    }

    public static boolean skipTag(DicomInputStream dicomInputStream) throws IOException {
        int n2 = dicomInputStream.valueLength();
        while (n2 > 0) {
            long l2 = dicomInputStream.skip((long)n2);
            if (l2 <= 0L) {
                return false;
            }
            n2 = (int)((long)n2 - l2);
        }
        return true;
    }

    public static DicomObject readFileIntoDicomObject(String string, int[] nArray) {
        return DicomReader.readFileIntoDicomObject(new File(string), nArray);
    }

    public static DicomObject readFileIntoDicomObject(File file, List<Integer> list) {
        return DicomReader.readFileIntoDicomObject(file, DicomReader.findMinimumStopTag(list));
    }

    public static DicomObject readFileIntoDicomObject(File file, int[] nArray) {
        return DicomReader.readFileIntoDicomObject(file, DicomReader.findMinimumStopTag(nArray));
    }

    public static int findMinimumStopTag(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[i2] = list.get(i2);
        }
        return DicomReader.findMinimumStopTag(nArray);
    }

    public static int findMinimumStopTag(int[] nArray) {
        int n2 = 0;
        for (int n3 : nArray) {
            if (((long)n3 & 0xFFFFFFFFL) <= ((long)n2 & 0xFFFFFFFFL)) continue;
            n2 = n3;
        }
        return ++n2;
    }

    public static DicomElement findFirstElement(DicomObject dicomObject, int n2) {
        DicomElement dicomElement = dicomObject.get(n2);
        if (dicomElement != null) {
            return dicomElement;
        }
        for (DicomElement dicomElement2 : dicomObject) {
            if (!dicomElement2.hasDicomObjects()) continue;
            for (int i2 = 0; i2 < dicomElement2.countItems(); ++i2) {
                dicomElement = DicomReader.findFirstElement(dicomElement2.getDicomObject(i2), n2);
                if (dicomElement == null) continue;
                return dicomElement;
            }
        }
        return null;
    }

    public static float[] findFirstFloats(DicomObject dicomObject, int n2) {
        DicomElement dicomElement = DicomReader.findFirstElement(dicomObject, n2);
        if (dicomElement == null) {
            return null;
        }
        return dicomElement.getFloats(false);
    }

    public static int hexTagToInt(String string) {
        try {
            string = string.replaceAll("[(),]", "");
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static DicomObject getFirstDicomObjectFromSeriesFolder(String string) {
        return DicomReader.getFirstDicomObjectFromSeriesFolder(string, 2145386512);
    }

    public static DicomObject getFirstDicomObjectFromSeriesFolder(String string, int n2) {
        File file = new File(string);
        if (!file.exists()) {
            ay.d((Object)(string + " does not exist"), DicomReader.class);
            return null;
        }
        if (file.isFile()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            ay.d((Object)("Can't get files in folder, most likely due to permissions: " + string), DicomReader.class);
            return null;
        }
        boolean bl2 = true;
        DicomObject dicomObject = null;
        block0: while (true) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string2 = fileArray[i2].getName().toLowerCase();
                if (!string2.endsWith(".xml") && !fileArray[i2].isDirectory() && (!bl2 || string2.endsWith(".dcm")) && (dicomObject = DicomReader.readFileIntoDicomObject(fileArray[i2], n2)) != null) break block0;
            }
            if (!bl2) break;
            bl2 = false;
        }
        return dicomObject;
    }

    public static BufferedImage readFileIntoBufferedImage(String string) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(new File(string));
        BufferedImage bufferedImage = null;
        if (dicomObject != null) {
            bufferedImage = DicomReader.extractPixelData(dicomObject);
        }
        return bufferedImage;
    }

    private static BufferedImage extractPixelData(DicomObject dicomObject) {
        BufferedImage[] bufferedImageArray;
        String string = null;
        try {
            bufferedImageArray = new FileMetaInformation(dicomObject);
            string = bufferedImageArray.getTransferSyntaxUID();
        }
        catch (RuntimeException runtimeException) {
            ay.d((Object)runtimeException, DicomReader.class);
            return null;
        }
        if (DicomJpegDecompressor.isJpegCompressed(string)) {
            bufferedImageArray = DicomJpegDecompressor.getBufferedImageFromDicomObject(dicomObject);
            if (bufferedImageArray != null) {
                return bufferedImageArray[0];
            }
            return null;
        }
        try {
            return DicomImageConverter.toBufferedImage(dicomObject);
        }
        catch (RuntimeException runtimeException) {
            ay.d((Object)runtimeException, DicomReader.class);
            return null;
        }
    }

    public static void uncompressJPEGCompressedUsingDCMTK(File file, File file2, boolean bl2) throws IOException {
        block12: {
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                ay.b((Object)"Need to create parent folder of current dicom file", DicomReader.class);
                if (!file3.mkdirs()) {
                    ay.d((Object)"Failed to create parent folder of current dicom file", DicomReader.class);
                    throw new IOException("Failed to create parent folder of current dicom file");
                }
            }
            if (GetOSPath.isWindows()) {
                DicomReader.decompressUsingWin32Dcmdjpeg(file, file2);
            } else if (GetOSPath.isMacOs()) {
                DicomReader.decompressUsingMacDcmdjpeg(file, file2);
            } else {
                if (GetOSPath.isLinux()) {
                    File file4 = cc.a("/binaries/linux/dcmdjpeg", true);
                    File file5 = cc.a("/binaries/linux/dicom.dic", true);
                    String string = file4.getAbsolutePath();
                    String[] stringArray = new String[]{"DCMDICTPATH=" + file5.getAbsolutePath()};
                    String[] stringArray2 = new String[]{string, file.getAbsolutePath(), file2.getAbsolutePath()};
                    try {
                        Process process = Runtime.getRuntime().exec(stringArray2, stringArray);
                        process.waitFor();
                        if (process.exitValue() != 0) {
                            throw new IOException(by.a(process));
                        }
                        break block12;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException.getMessage());
                    }
                }
                if (bl2) {
                    ay.c((Object)"Decompress dicom files is not supported on current os platform", DicomReader.class);
                    MIMFile.a(file, file2);
                } else {
                    throw new IOException("Can't decompress jpeg dicom on this platform, sorry");
                }
            }
        }
    }

    private static void decompressUsingMacDcmdjpeg(File file, File file2) throws IOException {
        String string = DicomReader.getMacDcmdjpegPath();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String[] stringArray = new String[]{string, file.getAbsolutePath(), file2.getAbsolutePath()};
            String[] stringArray2 = new String[]{"DCMDICTPATH=" + DicomReader.getMacDcmtkDicomDictionaryPath()};
            stringBuilder.append("\nCMD:");
            for (String string2 : stringArray) {
                stringBuilder.append(" " + string2);
            }
            stringBuilder.append("\nENV:");
            for (String string2 : stringArray2) {
                stringBuilder.append(" " + string2);
            }
            Process process = Runtime.getRuntime().exec(stringArray, stringArray2);
            process.waitFor();
            stringBuilder.append("\nOUT: ");
            stringBuilder.append(by.a(process));
            stringBuilder.append("\nERR: ");
            stringBuilder.append(by.b(process));
            if (process.exitValue() != 0) {
                ay.d((Object)("Unsuccessful running process:" + stringBuilder.toString()), DicomReader.class);
                throw new IOException();
            }
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)("Unsuccessful running process:" + stringBuilder.toString()), DicomReader.class);
            throw new IOException(interruptedException);
        }
    }

    private static String getMacDcmtkDicomDictionaryPath() throws IOException {
        File file = cc.a("/binaries/linux/dicom.dic", false);
        return file == null ? null : file.getAbsolutePath();
    }

    private static String getMacDcmdjpegPath() throws IOException {
        File file = cc.a("/binaries/macos/dcmdjpeg", true);
        return file == null ? null : file.getAbsolutePath();
    }

    private static void decompressUsingWin32Dcmdjpeg(File file, File file2) throws IOException {
        String string = DicomReader.getWin32DcmdjpegPath();
        try {
            Process process = Runtime.getRuntime().exec(new String[]{string, file.getAbsolutePath(), file2.getAbsolutePath()});
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IOException(by.a(process));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private static String getWin32DcmdjpegPath() throws IOException {
        File file = cc.a("/binaries/win32/dcmdjpeg.exe", false);
        return file == null ? null : file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject saveOutToTempFileAndDecompress(DicomObject dicomObject) throws IOException {
        File file = null;
        RandomAccessFile randomAccessFile = null;
        try {
            file = File.createTempFile("decompressDICOM", ".dcm");
            randomAccessFile = new RandomAccessFile(file, "rw");
            DicomOutputStream dicomOutputStream = new DicomOutputStream(randomAccessFile);
            dicomOutputStream.setExplicitItemLength(true);
            dicomOutputStream.setExplicitSequenceLength(true);
            dicomOutputStream.writeFileMetaInformation(dicomObject);
            dicomOutputStream.writeDataset(dicomObject, "1.2.840.10008.1.2.1");
            dicomOutputStream.close();
            File file2 = new File(file.getAbsolutePath() + ".decompressed");
            DicomReader.uncompressJPEGCompressedUsingDCMTK(file, file2, false);
            DicomObject dicomObject2 = DicomReader.readFileIntoDicomObject(file2);
            randomAccessFile.close();
            file2.delete();
            file.delete();
            DicomObject dicomObject3 = dicomObject2;
            return dicomObject3;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    public static void sanitizeDicomObject(final DicomObject dicomObject) {
        dicomObject.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement dicomElement) {
                if (dicomElement.vm(dicomObject.getSpecificCharacterSet()) != 1) {
                    return true;
                }
                VR vR = dicomElement.vr();
                if (vR.equals(VR.IS)) {
                    try {
                        dicomElement.getInt(false);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            float f2 = Float.valueOf(dicomObject.getString(dicomElement.tag())).floatValue();
                            dicomObject.putInt(dicomElement.tag(), VR.IS, (int)f2);
                        }
                        catch (NumberFormatException numberFormatException2) {
                            dicomObject.remove(dicomElement.tag());
                        }
                    }
                } else if (vR.equals(VR.DS)) {
                    try {
                        dicomElement.getFloat(false);
                    }
                    catch (NumberFormatException numberFormatException) {
                        dicomObject.remove(dicomElement.tag());
                    }
                } else if (vR.equals(VR.CS) || vR.equals(VR.SH) || vR.equals(VR.PN) || vR.equals(VR.LO)) {
                    String string = dicomObject.getString(dicomElement.tag());
                    StringBuilder stringBuilder = new StringBuilder(string.length());
                    try {
                        for (int i2 = 0; i2 < string.length(); ++i2) {
                            char c2 = string.charAt(i2);
                            if (c2 < ' ') continue;
                            stringBuilder.append(c2);
                        }
                        dicomObject.putString(dicomElement.tag(), vR, stringBuilder.toString());
                    }
                    catch (Throwable throwable) {
                        System.out.println("length: " + string.length());
                        throwable.printStackTrace();
                        dicomObject.remove(dicomElement.tag());
                    }
                } else if (vR.equals(VR.DA) || vR.equals(VR.TM) || vR.equals(VR.DT)) {
                    try {
                        dicomElement.getDate(false);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        dicomObject.remove(dicomElement.tag());
                    }
                    catch (NumberFormatException numberFormatException) {
                        dicomObject.remove(dicomElement.tag());
                    }
                }
                return true;
            }
        });
    }

    public static Integer parseIntegerTag(DicomObject dicomObject, int n2) {
        Integer n3 = null;
        try {
            String string = dicomObject.getString(n2);
            if (string != null) {
                if (string.indexOf(92) >= 0) {
                    string = string.substring(0, string.indexOf(92));
                }
                n3 = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error reading DICOM", (Throwable)exception, DicomReader.class);
        }
        return n3;
    }

    public static boolean isMIMSession(DicomObject dicomObject) {
        return Modality.RAW.isSameModality(dicomObject.getString(524384)) && dicomObject.containsValue(1253424);
    }

    public static boolean isBXPlan(DicomObject dicomObject) {
        return Modality.RAW.isSameModality(dicomObject.getString(524384)) && dicomObject.containsValue(930291986);
    }

    static {
        if (!MIMContext.o() && !MIMContext.p()) {
            fileExcluder = new ConfigurableFileExcluder();
        }
        fileExcluder = new FileExcluder();
    }

    public static class FilteredTagInputHandler
    implements DicomInputHandler {
        private long specificCharacterSetTagLong = 524293L;
        private Set<Long> filterTags;
        private FilterMode mode;
        private long stopTag;
        private int privateTagSizeThreshold = -1;
        private int tgtSeqElement = -1;
        private int tgtDepth = -1;
        private int seqElementNumber = -1;
        private Map<Integer, Integer> specialSequenceIncludes = Maps.newHashMap();
        private int skipDepth = 0;

        public FilteredTagInputHandler() {
            this.stopTag = 0xFFFFFFFFL;
        }

        public FilteredTagInputHandler(int[] nArray, FilterMode filterMode) {
            this(nArray, filterMode, -1);
        }

        public FilteredTagInputHandler(int[] nArray, FilterMode filterMode, int n2) {
            this.mode = filterMode;
            this.filterTags = Sets.newHashSetWithExpectedSize((int)nArray.length);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.filterTags.add((long)nArray[i2] & 0xFFFFFFFFL);
            }
            this.stopTag = n2 == -1 ? (filterMode == FilterMode.INCLUDE ? (long)DicomReader.findMinimumStopTag(nArray) & 0xFFFFFFFFL : 0xFFFFFFFFL) : (long)n2 & 0xFFFFFFFFL;
        }

        public void setSkipLargePrivateTags(int n2) {
            this.privateTagSizeThreshold = n2;
        }

        public void addSpecialSequenceInclude(int n2, int n3) {
            this.specialSequenceIncludes.put(n2, n3);
        }

        public boolean readValue(DicomInputStream dicomInputStream) throws IOException {
            int n2;
            block24: {
                block25: {
                    while (true) {
                        n2 = dicomInputStream.tag();
                        long l2 = (long)dicomInputStream.tag() & 0xFFFFFFFFL;
                        boolean bl2 = false;
                        if (this.skipDepth == 0) {
                            if (l2 >= this.stopTag && dicomInputStream.level() == 0) {
                                return false;
                            }
                            if (l2 < 524288L) {
                                bl2 = false;
                            } else if (l2 == this.specificCharacterSetTagLong) {
                                bl2 = false;
                            } else if (this.privateTagSizeThreshold >= 0 && TagUtils.isPrivateDataElement((int)n2) && (this.privateTagSizeThreshold == 0 || dicomInputStream.valueLength() > this.privateTagSizeThreshold)) {
                                bl2 = true;
                            } else if (this.filterTags != null) {
                                bl2 = this.mode == FilterMode.INCLUDE ^ this.filterTags.contains(l2);
                                if (n2 == -73507 || n2 == -73728 || n2 == -73715) {
                                    bl2 = false;
                                }
                            }
                        } else {
                            bl2 = true;
                        }
                        if (!bl2) break block24;
                        if (this.skipDepth > 0 && n2 == -73715) {
                            return true;
                        }
                        if (dicomInputStream.vr() != VR.SQ) break block25;
                        try {
                            ++this.skipDepth;
                            boolean bl3 = DicomReader.skipSeq(dicomInputStream);
                            --this.skipDepth;
                            if (!bl3) break;
                        }
                        catch (IOException iOException) {
                            String string = Integer.toString(n2, 16);
                            ay.d((Object)("Error skipping seq at depth " + this.skipDepth + "  " + string), this);
                            throw iOException;
                        }
                    }
                    return true;
                }
                return DicomReader.skipTag(dicomInputStream);
            }
            try {
                if (dicomInputStream.vr() == VR.SQ && this.specialSequenceIncludes.containsKey(n2)) {
                    this.tgtSeqElement = this.specialSequenceIncludes.get(n2);
                    this.tgtDepth = dicomInputStream.level() + 1;
                    this.seqElementNumber = 0;
                }
                if (dicomInputStream.tag() == -73728) {
                    try {
                        if (dicomInputStream.level() < this.tgtDepth) {
                            this.tgtDepth = -1;
                            this.tgtSeqElement = -1;
                            this.seqElementNumber = -1;
                        }
                        if (this.tgtSeqElement != -1 && this.seqElementNumber != this.tgtSeqElement && dicomInputStream.level() == this.tgtDepth) {
                            ++this.skipDepth;
                            dicomInputStream.readDicomObject();
                            --this.skipDepth;
                        }
                        if (dicomInputStream.level() == this.tgtDepth) {
                            ++this.seqElementNumber;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        return false;
                    }
                }
                return dicomInputStream.readValue(dicomInputStream);
            }
            catch (Exception exception) {
                ay.e(exception);
                return false;
            }
        }

        public static enum FilterMode {
            INCLUDE,
            EXCLUDE;

        }
    }

    public static class DicomReadResult {
        public DicomObject dob;
        public boolean wasMissingPixelData;

        public DicomReadResult(DicomObject dicomObject, boolean bl2) {
            this.dob = dicomObject;
            this.wasMissingPixelData = bl2;
        }
    }

    public static class DicomReadParams {
        public DicomInputHandler handler = DicomReader.getInputHandler(-1, false);
        public long valueLengthLimit = 1000000000L;
        public boolean closeStream = true;
        public boolean logIoException = true;
        public boolean allowPartialPixelData = false;

        public DicomReadParams setAllowPartialPixelData(boolean bl2) {
            this.allowPartialPixelData = bl2;
            return this;
        }

        public DicomReadParams setCloseStream(boolean bl2) {
            this.closeStream = bl2;
            return this;
        }

        public DicomReadParams setHandler(DicomInputHandler dicomInputHandler) {
            this.handler = dicomInputHandler;
            return this;
        }

        public DicomReadParams setLogIoException(boolean bl2) {
            this.logIoException = bl2;
            return this;
        }

        public DicomReadParams setValueLengthLimit(long l2) {
            this.valueLengthLimit = l2;
            return this;
        }
    }

    public static class AdvanceStreamToTagPathHandler
    implements DicomInputHandler {
        int[] tagPath;
        int curIdx = 0;
        int skipDepth = 0;
        int trueDepth = 0;

        public AdvanceStreamToTagPathHandler(int[] nArray) {
            this.tagPath = nArray;
        }

        public boolean readValue(DicomInputStream dicomInputStream) throws IOException {
            boolean bl2;
            int n2;
            block20: {
                block21: {
                    do {
                        int n3 = dicomInputStream.tag();
                        long l2 = (long)dicomInputStream.tag() & 0xFFFFFFFFL;
                        boolean bl3 = true;
                        if (l2 < 524288L) {
                            bl3 = false;
                        } else if (n3 == -73728) {
                            bl3 = false;
                        }
                        bl2 = false;
                        if (this.skipDepth > 0) {
                            bl3 = true;
                        } else if (n3 == this.tagPath[this.curIdx] && this.trueDepth * 2 == this.curIdx) {
                            bl2 = true;
                            bl3 = false;
                        }
                        if (!bl3) break block20;
                        if (this.skipDepth > 0 && n3 == -73715) {
                            return true;
                        }
                        if (dicomInputStream.vr() != VR.SQ) break block21;
                        ++this.skipDepth;
                        n2 = DicomReader.skipSeq(dicomInputStream);
                        --this.skipDepth;
                    } while (n2 != 0);
                    return true;
                }
                return DicomReader.skipTag(dicomInputStream);
            }
            try {
                if (bl2) {
                    if (dicomInputStream.vr() == VR.SQ && this.curIdx != this.tagPath.length - 1) {
                        ++this.curIdx;
                        n2 = this.tagPath[this.curIdx];
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int n4;
                            dicomInputStream.readHeader();
                            if (dicomInputStream.tag() != -73728) {
                                ay.d((Object)("Expected item tag but got " + Integer.toHexString(dicomInputStream.tag())), this);
                            }
                            if ((n4 = dicomInputStream.valueLength()) > 0) {
                                DicomReader.skipBytes((InputStream)dicomInputStream, n4);
                                continue;
                            }
                            ++this.skipDepth;
                            dicomInputStream.readDicomObject();
                            --this.skipDepth;
                        }
                        ++this.curIdx;
                        dicomInputStream.readHeader();
                        if (dicomInputStream.tag() != -73728) {
                            ay.d((Object)("Expected item tag but got " + Integer.toHexString(dicomInputStream.tag())), this);
                        }
                        ++this.trueDepth;
                        dicomInputStream.readDicomObject();
                        --this.trueDepth;
                        return false;
                    }
                    return false;
                }
                if (dicomInputStream.tag() == -73728) {
                    try {
                        n2 = dicomInputStream.readValue(dicomInputStream);
                        if (this.curIdx == this.tagPath.length - 1) {
                            return false;
                        }
                        return n2 != 0;
                    }
                    catch (NullPointerException nullPointerException) {
                        return false;
                    }
                }
                return dicomInputStream.readValue(dicomInputStream);
            }
            catch (Exception exception) {
                ay.e(exception);
                return false;
            }
        }
    }

    public static class StopBeforeContentInputHandler
    implements DicomInputHandler {
        private static final long SopClassUidTag = 524310L;
        private long stopTag;
        private boolean sopClassUidReady = false;
        private boolean checkModality = false;
        private String sopClassUid;
        private DicomInputHandler otherHandler;

        public StopBeforeContentInputHandler(int n2) {
            this.stopTag = (long)n2 & 0xFFFFFFFFL;
        }

        public StopBeforeContentInputHandler(int n2, DicomInputHandler dicomInputHandler) {
            this(n2);
            this.otherHandler = dicomInputHandler;
        }

        public boolean readValue(DicomInputStream dicomInputStream) throws IOException {
            long l2 = (long)dicomInputStream.tag() & 0xFFFFFFFFL;
            int n2 = dicomInputStream.level();
            if (n2 == 0) {
                if (this.sopClassUidReady) {
                    this.sopClassUid = dicomInputStream.getDicomObject().getString(524310, (String)null);
                    if (SeriesIdentifier.isStructuredReport(this.sopClassUid)) {
                        this.stopTag = Math.min(this.stopTag, 4237104L);
                    } else if ("1.2.840.10008.5.1.4.1.1.481.3".equals(this.sopClassUid)) {
                        this.stopTag = Math.min(this.stopTag, 805699616L);
                    } else if ("1.2.840.10008.5.1.4.1.1.66.3".equals(this.sopClassUid)) {
                        this.stopTag = Math.min(this.stopTag, 6553602L);
                    } else if ("1.2.840.10008.5.1.4.1.1.104.1".equals(this.sopClassUid) || "1.2.840.10008.5.1.4.1.1.104.2".equals(this.sopClassUid)) {
                        this.stopTag = Math.min(this.stopTag, 4325393L);
                    }
                    this.sopClassUidReady = false;
                }
                if (this.checkModality) {
                    String string = dicomInputStream.getDicomObject().getString(524384, (String)null);
                    if (Modality.FINDINGS.isSameModality(string)) {
                        this.stopTag = Math.min(this.stopTag, 930291776L);
                    }
                    this.checkModality = false;
                }
                if (l2 >= this.stopTag) {
                    return false;
                }
                if (l2 == 524310L) {
                    this.sopClassUidReady = true;
                } else if (l2 == 1253424L) {
                    this.stopTag = Math.min(this.stopTag, 930291760L);
                } else if (l2 == 524384L && "1.2.840.10008.5.1.4.1.1.66".equals(this.sopClassUid)) {
                    this.checkModality = true;
                }
            }
            return this.otherHandler == null ? dicomInputStream.readValue(dicomInputStream) : this.otherHandler.readValue(dicomInputStream);
        }
    }
}

