/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.remote.SeriesQuery;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.contour.a;
import com.mimvista.commands.contour.l;
import com.mimvista.commands.contour.localize.LocalizationStrategy;
import com.mimvista.commands.e;
import com.mimvista.commands.f;
import com.mimvista.commands.keyboard.bx;
import com.mimvista.commands.workflow.ASNCOrientationCommand;
import com.mimvista.contouring.RecistPerpCalculator;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.gui.RtStReplaceAppendMergeDialog;
import com.mimvista.dicom.gui.RtStructSelectionDialog;
import com.mimvista.dicom.read.AbstractRtStructLoader;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.MIMTagBackwardCompatibleReader;
import com.mimvista.dicom.rtplan.RtstSessionStateManager;
import com.mimvista.dicom.rtplan.RtstructSessionState;
import com.mimvista.exodus.MIM;
import com.mimvista.file.Path;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.MockDialogPanel;
import com.mimvista.internals.AssistedAlignmentWrapper;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourEdits;
import com.mimvista.internals.DynamicSeriesManager;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleDicomContourCreator;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ab;
import com.mimvista.internals.h;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.ColorTable;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ak;
import com.mimvista.mui.contours.ContourSidePanel;
import com.mimvista.mui.findings.Finding;
import com.mimvista.mui.findings.SessionFindingsState;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.AbstractTwoDContourOverlay;
import com.mimvista.mui.overlays.AngleOverlay;
import com.mimvista.mui.overlays.AnnotationOverlay;
import com.mimvista.mui.overlays.ChrontourOverlay;
import com.mimvista.mui.overlays.LineOverlay;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.OverlayColor;
import com.mimvista.mui.overlays.OverlayDirtParams;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.mui.overlays.PolygonPoint;
import com.mimvista.mui.overlays.RecistPerpOverlay;
import com.mimvista.mui.overlays.SuvBallOverlay;
import com.mimvista.mui.overlays.TwoDContourOverlayish;
import com.mimvista.mui.overlays.TwoDMeasureOverlay;
import com.mimvista.mui.overlays.VennContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.ZeeMeasureOverlay;
import com.mimvista.mui.overlays.findings.FindingsOverlay;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.m;
import com.mimvista.swing.widgets.u;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DicomRtStructLoader
extends AbstractRtStructLoader {
    public static final String quickSavePath = Path.getMIMDataPath() + "/RECOVERY/RTQUICKSAVE";
    public static final String RECOVERY_USE_CUSTOM_DIRECTORY = "RECOVERY_USE_CUSTOM_DIRECTORY";
    public static final boolean RECOVERY_USE_CUSTOM_DIRECTORY_DEFAULT = false;
    public static final String RECOVERY_CUSTOM_DIRECTORY_BASE = "RECOVERY_CUSTOM_DIRECTORY_BASE";
    public static final String RECOVERY_CUSTOM_DIRECTORY_USER_KEYWORD = "%user";
    final ViewController viewController;
    private h loadPrefs = new h();
    private Set<Integer> invalidFrames = Sets.newHashSet();
    private List<Runnable> subJobs = Lists.newArrayList();
    public static boolean magicTestFlag = false;

    public static void showMergeResultsDialog(Component component, List<String> list) {
        String string = props.getProperty("DCM_RT_STRUCT_MERGE_RESULTS_NONE");
        if (list.size() > 0) {
            string = "<html>" + props.getProperty("DCM_RT_STRUCT_MERGE_RESULTS") + "<br /><br />";
            for (String object2 : list) {
                string = string + object2 + "<br />";
            }
            string = string + "</html>";
        }
        String string2 = props.getProperty("DCM_RT_STRUCT_MERGE_RESULTS_TITLE");
        JScrollPane jScrollPane = new JScrollPane(new JLabel(string));
        jScrollPane.setPreferredSize(new Dimension(400, 180));
        MOptionPane.b(component, jScrollPane, string2, 1);
    }

    public static String getRecoveryBasePath() {
        if (!ContourPrefs.recoveryUseCustomDirectory.getValue().booleanValue()) {
            return Path.getMIMDataPath();
        }
        return DicomRtStructLoader.interpolateUserIntoString(ContourPrefs.recoveryCustomDirectoryBase.getValue());
    }

    public static String getQuickSavePath() {
        return DicomRtStructLoader.getRecoveryBasePath() + "/RECOVERY/RTQUICKSAVE";
    }

    public static String getAutoSavePath() {
        return DicomRtStructLoader.getRecoveryBasePath() + "/RECOVERY/RTAUTOSAVE";
    }

    private static String interpolateUserIntoString(String string) {
        String string2 = LoginChecker.getInstance().getUserFullName();
        if ((string2 = Path.safeFilename(string2)) == "") {
            string2 = "MIMUSER";
        }
        return string.replaceAll(RECOVERY_CUSTOM_DIRECTORY_USER_KEYWORD, string2);
    }

    public h getLoadPrefs() {
        return this.loadPrefs;
    }

    public void setLoadPrefs(h h2) {
        this.loadPrefs = h2;
    }

    public DicomRtStructLoader(ViewController viewController, DicomObject dicomObject) {
        this.viewController = viewController;
        this.dicom = dicomObject;
    }

    @Override
    protected SeriesInfo getInfo() {
        return this.viewController.getUncopiedMutableInfo();
    }

    public void showLoadMethodDialog(Window window) {
        this.loadMethod = null;
        if (GraphicsEnvironment.isHeadless()) {
            this.loadMethod = AbstractRtStructLoader.LoadMethod.APPEND;
            return;
        }
        final FuncUtils.f f2 = new FuncUtils.f();
        RtStReplaceAppendMergeDialog rtStReplaceAppendMergeDialog = new RtStReplaceAppendMergeDialog(window, new Runnable(){

            @Override
            public void run() {
                DicomRtStructLoader.this.loadMethod = AbstractRtStructLoader.LoadMethod.REPLACE;
                f2.b();
            }
        }, new Runnable(){

            @Override
            public void run() {
                DicomRtStructLoader.this.loadMethod = AbstractRtStructLoader.LoadMethod.APPEND;
                f2.b();
            }
        }, new Runnable(){

            @Override
            public void run() {
                DicomRtStructLoader.this.loadMethod = AbstractRtStructLoader.LoadMethod.MERGE;
                f2.b();
            }
        }, new Runnable(){

            @Override
            public void run() {
                f2.b();
            }
        });
        rtStReplaceAppendMergeDialog.setVisible(true);
        f2.a();
    }

    public void showMergeResultsDialog(Component component) {
        if (this.loadMethod != AbstractRtStructLoader.LoadMethod.MERGE) {
            return;
        }
        DicomRtStructLoader.showMergeResultsDialog(component, this.mergeResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Progress progress) {
        if (this.dicom == null) {
            this.dicom = DicomReader.readFileIntoDicomObject(this.file);
            if (this.dicom == null) {
                return false;
            }
        }
        this.refdSeriesUID = this.getReferencedSeriesUID();
        SessionFindingsState sessionFindingsState = this.viewController.g().u();
        try {
            MIMSwingUtils.a(() -> sessionFindingsState.b(true));
            Map<Integer, List<AbstractRtStructLoader.RoiInfo>> map = this.loadVennInformation();
            this.loadRtstruct(progress);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Reading RTstruct", throwable, this);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            SwingUtilities.invokeLater(() -> sessionFindingsState.b(false));
        }
        return true;
    }

    protected Map<Integer, List<AbstractRtStructLoader.RoiInfo>> loadVennInformation() {
        TreeMap<Integer, List<AbstractRtStructLoader.RoiInfo>> treeMap = new TreeMap<Integer, List<AbstractRtStructLoader.RoiInfo>>();
        DicomElement dicomElement = this.dicom.get(930283792);
        if (dicomElement == null) {
            return null;
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            int n2 = dicomObject.getInt(805699716);
            List list = (List)treeMap.get(n2);
            if (list == null) {
                list = Lists.newArrayList();
                treeMap.put(n2, list);
            }
            AbstractRtStructLoader.RoiInfo roiInfo = new AbstractRtStructLoader.RoiInfo();
            int[] nArray = dicomObject.getInts(805699626);
            if (nArray != null) {
                roiInfo.color = new ColorTable.RGB(nArray[0], nArray[1], nArray[2]);
            } else {
                ay.b((Object)("ROI #" + roiInfo.referencedRoiNumber + " is missing the ROIDisplayColor, so I'm making it red."), this);
                roiInfo.color = new ColorTable.RGB(255, 0, 0);
            }
            DicomElement dicomElement2 = dicomObject.get(805699648);
            if (dicomElement2 == null) continue;
            for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                DicomObject dicomObject2 = dicomElement2.getDicomObject(i3);
                roiInfo.type = dicomObject2.getString(805699650);
                roiInfo.pointSets.add(new AbstractRtStructLoader.PointSet(dicomObject2.getFloats(805699664)));
            }
            list.add(roiInfo);
        }
        return treeMap;
    }

    @Override
    protected void askToLoadNonAxial() {
        if (!this.askedLoadNonAxial) {
            this.askedLoadNonAxial = true;
            this.loadNonAxial = false;
            final FuncUtils.f f2 = new FuncUtils.f();
            String string = props.getProperty("RTST_LOADER_LOAD_NONAXIAL");
            MockDialogPanel mockDialogPanel = new MockDialogPanel(string, MockDialogPanel.OptionType.b, BasicNotification.NotificationType.d, null, null, null);
            mockDialogPanel.a(f.b(LoadRtStructCommand.class).c());
            mockDialogPanel.b(new MockDialogPanel.b(){

                @Override
                public void mockDialogEvent(MockDialogPanel.MockDialogEvent mockDialogEvent) {
                    if (mockDialogEvent.a() == MockDialogPanel.InputType.a) {
                        DicomRtStructLoader.this.loadNonAxial = true;
                    }
                    f2.b();
                }
            });
            m m2 = new m(mockDialogPanel);
            u.b().c(m2);
            f2.a();
        }
    }

    private boolean allowNon2dContoursOnThisVolume() {
        return !this.viewController.cg() || !MIMContext.M();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processROIs(Progress progress) {
        Object object;
        Object object322;
        if (this.roiInfoMap.size() == 0) {
            return;
        }
        OverlayCollection overlayCollection = this.viewController.aw().n();
        List<AbstractContourOverlayish> list = overlayCollection.R();
        ArrayList arrayList = new ArrayList(this.roiInfoMap.entrySet().size());
        ArrayList<ChrontourInfo> arrayList2 = new ArrayList<ChrontourInfo>();
        int n2 = 0;
        for (Object object322 : this.roiInfoMap.values()) {
            if ("CLOSED_PLANAR".equals(((AbstractRtStructLoader.RoiInfo)object322).type) && this.viewController.bl() && !((AbstractRtStructLoader.RoiInfo)object322).framedPointSets.isEmpty()) {
                for (ArrayList<AbstractRtStructLoader.PointSet> arrayList3 : ((AbstractRtStructLoader.RoiInfo)object322).framedPointSets.values()) {
                    n2 += arrayList3.size();
                }
                continue;
            }
            n2 += ((AbstractRtStructLoader.RoiInfo)object322).pointSets.size();
        }
        String string = this.dicom.getString(524400, "");
        object322 = this.viewController.aw();
        this.checkForAndApplyAccurayFlip(string, (ImageFrame)object322);
        this.checkForAndApplyCMSFlip(string, (ImageFrame)object322);
        progress.b(0);
        progress.a(n2);
        progress.a(false);
        boolean bl2 = false;
        int n3 = this.viewController.ba().a(VolumetricContourOverlay.class, false, false).size();
        int n4 = this.viewController.ba().a(PointContourOverlay.class, false, false).size();
        boolean bl3 = false;
        HashSet hashSet = Sets.newHashSet();
        ArrayList arrayList4 = Lists.newArrayList();
        String string2 = "Load DICOM RTstructure set: " + this.dicom.getString(0x20000E);
        bg.b(string2);
        int n5 = 1;
        for (Map.Entry entry : this.roiInfoMap.entrySet()) {
            if (Progress.Status.e.equals((Object)progress.n())) {
                return;
            }
            progress.b_(MIMFormat.a(props.getProperty("DCM_RT_STRUCT_CONTOUR_LOADING"), n5, this.roiInfoMap.entrySet().size()));
            AbstractRtStructLoader.RoiInfo roiInfo = (AbstractRtStructLoader.RoiInfo)entry.getValue();
            if (cn.g(roiInfo.name)) {
                roiInfo.name = "POINT".equals(roiInfo.type) ? "ROI-" + (n5 + n4) : ("CLOSED_PLANAR".equals(roiInfo.type) ? "ROI-" + (n5 + n3) : "<" + Messages.a("PropertyEditor", "PROPERTY_NONE_ITEM").toLowerCase() + ">");
            }
            ay.a((Object)("Loading RTstruct entry: Name: " + roiInfo.name + ", Type: " + roiInfo.type + ", ObserverLabel: " + roiInfo.obsLabel), this);
            ++n5;
            if ((roiInfo.obsLabel.equalsIgnoreCase("CORONAL") || roiInfo.obsLabel.equalsIgnoreCase("SAGITTAL")) && !this.loadNonAxial || roiInfo.childType != null && !roiInfo.childType.shouldCreateSelf()) continue;
            if (!this.viewController.bl() && !roiInfo.framedPointSets.isEmpty()) {
                bl2 = true;
            }
            if ("CLOSED_PLANAR".equals(roiInfo.type)) {
                for (AbstractRtStructLoader.PointSet bl5 : roiInfo.pointSets) {
                    if (bl5.pointSet.length >= 9) continue;
                    bl3 = true;
                    hashSet.add(roiInfo.name);
                }
                AbstractTwoDContourOverlay.TwoDContourType twoDContourType = AbstractTwoDContourOverlay.TwoDContourType.a(roiInfo.observationInformation.get("type2d"));
                if (this.viewController.bl() && !roiInfo.framedPointSets.isEmpty()) {
                    ay.b((Object)("Contour " + roiInfo.name + " is 4D-type"), this);
                    arrayList2.add(this.build4DContours(roiInfo, twoDContourType, progress));
                    continue;
                }
                if (twoDContourType != null) {
                    ay.b((Object)("Contour " + roiInfo.name + " is 2D-type (" + twoDContourType.name() + " for MIMviewer NB)"), this);
                    arrayList.add(this.build2DContour(roiInfo, twoDContourType));
                    continue;
                }
                if (!this.allowNon2dContoursOnThisVolume()) continue;
                ay.b((Object)("Contour " + roiInfo.name + " is 3D-type"), this);
                arrayList.add(this.build3DContour(roiInfo, progress));
                continue;
            }
            if ("POINT".equals(roiInfo.type)) {
                if (this.viewController.bl() && !roiInfo.framedPointSets.isEmpty()) {
                    for (Map.Entry entry2 : roiInfo.framedPointSets.entrySet()) {
                        object = null;
                        if (this.isFrameLoaded((FrameNumber)entry2.getKey())) {
                            object = (FrameNumber)entry2.getKey();
                        }
                        if (object == null && !this.isPointAnnotation(roiInfo)) continue;
                        arrayList.add(this.buildPointContour(roiInfo, (List)entry2.getValue(), (FrameNumber)object, progress));
                    }
                    continue;
                }
                arrayList.add(this.buildPointContour(roiInfo, roiInfo.pointSets, null, progress));
                continue;
            }
            if ("OPEN_NONPLANAR".equals(roiInfo.type)) {
                if (this.viewController.bl() && !roiInfo.framedPointSets.isEmpty()) {
                    for (Map.Entry entry3 : roiInfo.framedPointSets.entrySet()) {
                        object = null;
                        if (this.isFrameLoaded((FrameNumber)entry3.getKey())) {
                            object = (FrameNumber)entry3.getKey();
                        }
                        arrayList.add(this.buildLineOrAngleOverlay(roiInfo, (List)entry3.getValue(), (FrameNumber)object));
                    }
                    continue;
                }
                if (roiInfo.pointSets.isEmpty()) continue;
                arrayList.add(this.buildLineOrAngleOverlay(roiInfo, roiInfo.pointSets, null));
                continue;
            }
            ay.d((Object)("Unsupported Contour Geometric Type tag: " + roiInfo.type), this);
        }
        arrayList = Lists.newArrayList((Iterable)Iterables.filter(arrayList, (Predicate)Predicates.notNull()));
        String string3 = this.dicom.getString(1576992, "");
        if (this.dicom.getString(524400, "").startsWith("MIM") && string3.startsWith("4.0")) {
            bl2 = false;
        }
        if (Progress.Status.e.equals((Object)progress.n())) {
            return;
        }
        bg.e(string2);
        this.processVennContours(overlayCollection, arrayList);
        long l2 = System.currentTimeMillis();
        for (Overlayish overlayish : arrayList) {
            object = this.viewController.bl() && overlayish.aH() != null ? ((ImageVolumeShort)((ViewController3D)this.viewController).cE().a(overlayish.aH())).n() : overlayCollection;
            if (overlayish instanceof FindingsOverlay) {
                OverlayDirtParams overlayDirtParams = OverlayDirtParams.a(OverlayDirtParams.OverlayChangeGranularity.c);
                overlayish.b(overlayDirtParams);
            }
            ((OverlayCollection)object).a(overlayish, true, null, false);
            if (((OverlayCollection)object).R().size() == 1 && overlayish.u()) {
                ((OverlayCollection)object).d((AbstractContourOverlayish)overlayish);
            }
            if (overlayish instanceof AbstractContourOverlayish) {
                AbstractContourOverlayish abstractContourOverlayish2 = (AbstractContourOverlayish)overlayish;
                abstractContourOverlayish2.b(l2);
                abstractContourOverlayish2.a(l2);
            }
            if (!(overlayish instanceof VolumetricContourOverlay)) continue;
            arrayList4.add((VolumetricContourOverlay)overlayish);
        }
        FuncUtils.a(this.subJobs, (ThreadPoolExecutor)com.mimvista.util.work.m.c);
        this.addRtstToPerSessionObject(arrayList4);
        for (ChrontourInfo chrontourInfo2 : arrayList2) {
            if (((ChrontourFrameList)chrontourInfo2.y).size() == 1 && ((ChrontourFrameInfo)((ChrontourFrameList)chrontourInfo2.y).get(0)).contour2d != null) {
                this.add2D4DContours((AbstractRtStructLoader.RoiInfo)chrontourInfo2.x, (ChrontourFrameList)chrontourInfo2.y);
                continue;
            }
            if (!this.allowNon2dContoursOnThisVolume()) continue;
            this.add4DContours((AbstractRtStructLoader.RoiInfo)chrontourInfo2.x, (ChrontourFrameList)chrontourInfo2.y);
        }
        boolean bl4 = InterfacePrefs.promptForMissingFrames.getValue();
        boolean bl5 = InterfacePrefs.promptForDynamicRtstStaticVolume.getValue();
        if (bl3 && !this.viewController.g().T() && InterfacePrefs.showRtStructDegeneratePolylineWarning.getValue().booleanValue()) {
            void var23_40;
            Object[] objectArray2;
            object = new JOptionPane();
            String string5 = props.b("DCM_RT_STRUCT_DEGENERATE_POLYLINE_WARNING");
            string5 = string5 + "\n\n";
            for (Object[] objectArray2 : hashSet) {
                String string6 = (String)var23_40 + (String)objectArray2 + "\n";
            }
            JCheckBox jCheckBox = new JCheckBox(props.b("DCM_RT_STRUCT_DEGENERATE_NO_WARNING"));
            objectArray2 = new Object[]{var23_40, jCheckBox};
            ((JOptionPane)object).setMessage(objectArray2);
            ((JOptionPane)object).setMessageType(2);
            JDialog jDialog = ((JOptionPane)object).createDialog(ak.b().O(), props.b("DCM_RT_STRUCT_DEGENERATE_POLYLINE_TITLE"));
            jDialog.setDefaultCloseOperation(2);
            MIMSwingUtils.b(() -> jDialog.setVisible(true));
            Object object2 = ((JOptionPane)object).getValue();
            jDialog.dispose();
            int n6 = (Integer)object2;
            if (n6 == 0 && jCheckBox.isSelected()) {
                InterfacePrefs.showRtStructDegeneratePolylineWarning.setValue(false);
            }
        }
        if (this.invalidFrames.size() != 0) {
            object = "";
            ArrayList arrayList3 = Lists.newArrayList();
            arrayList3.addAll(this.invalidFrames);
            Collections.sort(arrayList3);
            for (int i2 = 0; i2 < arrayList3.size() - 1; ++i2) {
                object = (String)object + arrayList3.get(i2) + ",";
            }
            object = (String)object + arrayList3.get(arrayList3.size() - 1);
            ay.c((Object)("Loaded 4D RTstruct without having following frames loaded: " + (String)object), this);
            if (bl4 && !this.viewController.g().T()) {
                String string7 = props.b("DCM_RT_STRUCT_INVALID_FRAMES_MESSAGE");
                string7 = string7.replace("{1}", this.viewController.aw().getUncopiedMutableInfo().seriesDesc);
                string7 = string7.replace("{0}", this.viewController.aw().getUncopiedMutableInfo().patientName);
                string7 = string7 + "  " + (String)object;
                JOptionPane.showMessageDialog(ak.b().O(), string7, props.b("DCM_RT_STRUCT_INVALID_FRAMES_TITLE"), 2);
            }
        }
        if (bl2) {
            ay.c((Object)"Attempted to load 4D RTstruct on non-4D series", this);
            if (bl5 && !this.viewController.g().T()) {
                object = props.b("DCM_RT_STRUCT_DYNAMIC_RTST_STATIC_VOLUME");
                JOptionPane.showMessageDialog(ak.b().O(), object, props.b("DCM_RT_STRUCT_DYNAMIC_RTST_STATIC_VOLUME_TITLE"), 2);
            }
        }
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.REPLACE && list != null && list.size() > 0) {
            for (AbstractContourOverlayish abstractContourOverlayish3 : list) {
                if (abstractContourOverlayish3.A_() && abstractContourOverlayish3.bO_()) continue;
                overlayCollection.b((Overlayish)abstractContourOverlayish3, true);
            }
        }
        if (overlayCollection.R().size() == 0) {
            if (!this.viewController.g().u().g()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.viewController.g().u().g()) {
                        this.viewController.g().u().i();
                    }
                });
            }
            return;
        }
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.MERGE) {
            this.mergeResults = overlayCollection.q();
        }
        object = Sets.newHashSet((Iterable)arrayList);
        Set set = arrayList2.stream().flatMap(chrontourInfo -> ((ChrontourFrameList)chrontourInfo.y).stream()).map(chrontourFrameInfo -> (Contour)chrontourFrameInfo.x).collect(Collectors.toSet());
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.REPLACE || this.viewController.au().k().flatMap(imageFrame -> imageFrame.n().R().stream()).filter(abstractContourOverlayish -> abstractContourOverlayish.I_()).filter(arg_0 -> DicomRtStructLoader.lambda$processROIs$8((Set)object, arg_0)).allMatch(abstractContourOverlayish -> abstractContourOverlayish instanceof ChrontourOverlay && object6.contains(((ChrontourOverlay)abstractContourOverlayish).aq()))) {
            SwingUtilities.invokeLater(() -> this.viewController.g().u().i());
        }
        ContourSidePanel.e();
    }

    private void addRtstToPerSessionObject(List<VolumetricContourOverlay> list) {
        String string = this.dicom.getString(524312);
        String string2 = cn.i(this.dicom.getString(806223874));
        RtstSessionStateManager.getForSession(this.viewController.g()).addState(new RtstructSessionState(string, list));
        RtstructSessionState rtstructSessionState = RtstSessionStateManager.getForSession(this.viewController.g()).getState(string);
        rtstructSessionState.setApprovalStatus(string2);
        for (RtstructSessionState.ContourInfo contourInfo : rtstructSessionState.getAllContourInfos()) {
            ay.b((Object)("Loaded contour " + contourInfo.getName() + " into ROI Ref #" + contourInfo.getReferencedRoiNumber()), this);
        }
    }

    private boolean isPointAnnotation(AbstractRtStructLoader.RoiInfo roiInfo) {
        return "POINT".equals(roiInfo.type) && "point annotation".equals(roiInfo.observationInformation.get("type"));
    }

    private void checkForAndApplyCMSFlip(String string, ImageFrame imageFrame) {
        if (imageFrame.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("cms") && !imageFrame.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("mim software")) {
            int n2;
            float[] fArray = imageFrame.getUncopiedMutableInfo().origImageOrientation;
            boolean bl2 = false;
            for (n2 = 0; n2 < 6; ++n2) {
                float f2 = Math.abs(fArray[n2]);
                if (MathUtils.a(f2, 0.0f, 0.001f) || MathUtils.b((double)f2, 1.0, (double)0.001f)) continue;
                bl2 = true;
            }
            if (!bl2) {
                return;
            }
            n2 = 0;
            if (this.loadPrefs.c) {
                n2 = 1;
            } else if (!MIM.isHeadless()) {
                Messages messages = Messages.a("Dicom");
                int n3 = n2 = 0 == JOptionPane.showConfirmDialog(ak.b().O(), messages.b("LOADTASK_RTDOSE_CMS_NONORTHO_RTST_WARNING"), messages.b("LOADTASK_RTDOSE_CMS_NONORTHO_RTST_WARNING_TITLE"), 0, 3) ? 1 : 0;
            }
            if (n2 != 0) {
                float f3 = (float)Math.atan2(fArray[1], fArray[0]);
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.rotZ(f3 *= 2.0f);
                Vector3f vector3f = new Vector3f((float[])imageFrame.G().clone());
                vector3f.z = 0.0f;
                vector3f.negate();
                matrix4f.setTranslation(vector3f);
                DicomPoint3f dicomPoint3f = new DicomPoint3f(imageFrame);
                for (AbstractRtStructLoader.RoiInfo roiInfo : this.roiInfoMap.values()) {
                    if ("POINT".equals(roiInfo.type)) continue;
                    for (AbstractRtStructLoader.PointSet pointSet : roiInfo.pointSets) {
                        int n4 = pointSet.pointSet.length / 3;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            dicomPoint3f.x = pointSet.pointSet[3 * i2];
                            dicomPoint3f.y = pointSet.pointSet[3 * i2 + 1];
                            dicomPoint3f.z = pointSet.pointSet[3 * i2 + 2];
                            matrix4f.transform((Point3f)dicomPoint3f);
                            pointSet.pointSet[3 * i2] = dicomPoint3f.x;
                            pointSet.pointSet[3 * i2 + 1] = dicomPoint3f.y;
                            pointSet.pointSet[3 * i2 + 2] = dicomPoint3f.z;
                        }
                    }
                }
            }
        }
    }

    private void checkForAndApplyAccurayFlip(String string, ImageFrame imageFrame) {
        if (string.contains("Accuray") && ab.a(imageFrame.getUncopiedMutableInfo().origImageOrientation, new float[]{-1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f}, 0.001f)) {
            int n2;
            int n3;
            float f2 = 2.1474836E9f;
            float f3 = -2.1474836E9f;
            float f4 = 2.1474836E9f;
            float f5 = -2.1474836E9f;
            VoxelPoint3f voxelPoint3f = new VoxelPoint3f((float)imageFrame.a()[0], (float)imageFrame.a()[1], 0.0f, imageFrame);
            DicomPoint3f dicomPoint3f = voxelPoint3f.b().d();
            VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(0.0f, 0.0f, 0.0f, imageFrame);
            DicomPoint3f dicomPoint3f2 = voxelPoint3f2.b().d();
            for (Object object2 : this.roiInfoMap.values()) {
                for (AbstractRtStructLoader.PointSet object3 : ((AbstractRtStructLoader.RoiInfo)object2).pointSets) {
                    Object object = object3.pointSet;
                    n3 = ((float[])object).length / 3;
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (object[3 * n2] < f2) {
                            f2 = object[3 * n2];
                        }
                        if (object[3 * n2] > f3) {
                            f3 = object[3 * n2];
                        }
                        if (object[3 * n2 + 1] < f4) {
                            f4 = object[3 * n2 + 1];
                        }
                        if (!(object[3 * n2 + 1] > f5)) continue;
                        f5 = object[3 * n2 + 1];
                    }
                }
            }
            if (!ab.a(imageFrame.getUncopiedMutableInfo().imageOrientation, ab.a(), 0.001f)) {
                dicomPoint3f.x = dicomPoint3f2.x;
                dicomPoint3f.y = dicomPoint3f2.y;
            }
            if (f2 >= dicomPoint3f.x && f4 >= dicomPoint3f.y) {
                boolean bl2 = this.loadPrefs.b ? true : (!this.viewController.g().T() && InterfacePrefs.promptForAccurayProneFix.getValue() != false ? 0 == JOptionPane.showConfirmDialog(ak.b().O(), props.b("DCM_RT_STRUCT_ACCURAY_PRONE_WARNING"), props.b("DCM_RT_STRUCT_ACCURAY_PRONE_WARNING_TITLE"), 0, 3) : true);
                if (!bl2) {
                    return;
                }
                for (Object object4 : this.roiInfoMap.values()) {
                    for (Object object : ((AbstractRtStructLoader.RoiInfo)object4).pointSets) {
                        n3 = object.pointSet.length / 3;
                        for (n2 = 0; n2 < n3; ++n2) {
                            object.pointSet[3 * n2] = 2.0f * dicomPoint3f.x - object.pointSet[3 * n2];
                            object.pointSet[3 * n2 + 1] = 2.0f * dicomPoint3f.y - object.pointSet[3 * n2 + 1];
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void readRoiContourSequence() {
        Object[] objectArray;
        Object object;
        boolean bl2 = false;
        if (this.dicom.get(930283794) != null) {
            if (this.viewController.g().T()) {
                bl2 = true;
            } else if (DicomPrefs.loadHighResRtst.hasValueOnDisk()) {
                bl2 = DicomPrefs.loadHighResRtst.getValue();
            } else {
                object = new JCheckBox(props.b("DCM_RT_STRUCT_LOADING_DO_NOT_ASK"));
                ((AbstractButton)object).setSelected(false);
                objectArray = new Object[]{props.b("DCM_RT_STRUCT_LOADING_HIGH_RES_DATA"), object};
                int n2 = JOptionPane.showConfirmDialog(ak.b().O(), objectArray, props.b("DCM_RT_STRUCT_LOADING_HIGH_RES_DATA_TITLE"), 0, 3);
                boolean bl3 = bl2 = n2 == 0;
                if ((n2 == 1 || n2 == 0) && ((AbstractButton)object).isSelected()) {
                    DicomPrefs.loadHighResRtst.setValue(bl2);
                }
            }
        }
        if (bl2) {
            object = MIMTagBackwardCompatibleReader.getString(this.dicom, 930295832);
            if (object != null && AssistedAlignmentWrapper.StudyType.b.name().equals(((String)object).trim())) {
                objectArray = new ASNCOrientationCommand(this.viewController);
                objectArray.execute();
            }
            this.readRoiContourSequence(930283794);
        } else {
            this.readRoiContourSequence(805699641);
        }
    }

    private void processVennContours(OverlayCollection overlayCollection, List<Overlayish> list) {
        Map<Integer, List<AbstractRtStructLoader.RoiInfo>> map = this.loadVennInformation();
        if (map != null) {
            for (Map.Entry<Integer, List<AbstractRtStructLoader.RoiInfo>> entry : map.entrySet()) {
                Object object;
                Object object2 = null;
                for (Overlayish overlayish : list) {
                    if (!(overlayish instanceof VennContourOverlay)) continue;
                    object = (VennContourOverlay)overlayish;
                    if (((VennContourOverlay)object).savedRefRoiNumber != entry.getKey()) continue;
                    object2 = object;
                    break;
                }
                if (object2 == null) {
                    ay.d((Object)("Unable to locate VennContourOverlay for newly loaded contour set:" + this.dicom.getString(0x20000E)), this);
                    continue;
                }
                Object object3 = null;
                ArrayList arrayList = Lists.newArrayList();
                for (AbstractRtStructLoader.RoiInfo roiInfo : entry.getValue()) {
                    ImageFrame imageFrame = this.viewController.aw();
                    Contour contour = new Contour(imageFrame);
                    this.fillContour(roiInfo, (SimpleImageVolume)((Object)imageFrame), (SimpleContour)contour, (Progress)new com.mimvista.util.progress.o());
                    arrayList.add(contour);
                    object3 = roiInfo.color.a();
                }
                ((VennContourOverlay)object2).b(arrayList);
                if (object3 != null) {
                    object = overlayCollection.r().a((Color)object3);
                    ((VennContourOverlay)object2).c((OverlayColor)object);
                }
                ((VennContourOverlay)object2).savedRefRoiNumber = -1;
            }
        }
    }

    private Overlay buildPointContour(AbstractRtStructLoader.RoiInfo roiInfo, List<AbstractRtStructLoader.PointSet> list, FrameNumber frameNumber, Progress progress) {
        Iterator<AbstractRtStructLoader.PointSet> iterator;
        if (this.isPointAnnotation(roiInfo)) {
            return this.buildPointAnnotationContour(roiInfo, list, frameNumber);
        }
        ImageFrame imageFrame = frameNumber != null && this.viewController.bl() ? (ImageFrame)((ViewController3D)this.viewController).cE().a(frameNumber) : this.viewController.aw();
        PointContourOverlay pointContourOverlay = new PointContourOverlay(this.viewController, imageFrame);
        if (imageFrame instanceof SimpleImageVolume) {
            iterator = SimpleDicomContourCreator.a.a((SimpleImageVolume)((Object)imageFrame), this.dicom);
            if (((SimpleDicomContourCreator.a)((Object)iterator)).a == SimpleDicomContourCreator.BadMIMRTstType.b) {
                list = SimpleDicomContourCreator.a(list, (SimpleImageFrame)imageFrame, iterator);
            }
        }
        if (list != null && list.size() > 0) {
            for (AbstractRtStructLoader.PointSet object2 : list) {
                pointContourOverlay.a(object2.pointSet);
            }
        }
        iterator = imageFrame.n();
        OverlayColor overlayColor = ((OverlayCollection)((Object)iterator)).r().a(roiInfo.color.a());
        overlayColor.b();
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.REPLACE) {
            pointContourOverlay.a(roiInfo.referencedRoiNumber);
        }
        pointContourOverlay.c(roiInfo.name);
        if (roiInfo.name.startsWith("Point-")) {
            try {
                int exception = Integer.parseInt(roiInfo.name.substring(6));
                pointContourOverlay.b(exception);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pointContourOverlay.a(overlayColor);
        pointContourOverlay.l(true);
        pointContourOverlay.c_(roiInfo.description);
        pointContourOverlay.b(roiInfo.observationDesc);
        pointContourOverlay.a(roiInfo.interpretedType);
        Overlay.a(pointContourOverlay);
        this.linkUpFindings(pointContourOverlay, roiInfo);
        return pointContourOverlay;
    }

    private AnnotationOverlay buildPointAnnotationContour(AbstractRtStructLoader.RoiInfo roiInfo, List<AbstractRtStructLoader.PointSet> list, FrameNumber frameNumber) {
        String string;
        Object object;
        PresentationType presentationType = null;
        String string2 = roiInfo.observationInformation.get("plane");
        if ("AXIAL".equalsIgnoreCase(string2)) {
            presentationType = PresentationType.a;
        } else if ("SAGITTAL".equalsIgnoreCase(string2)) {
            presentationType = PresentationType.b;
        } else if ("CORONAL".equalsIgnoreCase(string2)) {
            presentationType = PresentationType.c;
        } else {
            ay.c((Object)("Skipping point contour " + roiInfo.name + ": no plane attribute in RTROIObservationSequence"), this);
            return null;
        }
        ImageFrame imageFrame = this.viewController.bl() && frameNumber != null ? (ImageFrame)((ViewController3D)this.viewController).cE().a(frameNumber) : this.viewController.aw();
        if (imageFrame instanceof SimpleImageVolume) {
            object = SimpleDicomContourCreator.a.a((SimpleImageVolume)((Object)imageFrame), this.dicom);
            if (((SimpleDicomContourCreator.a)object).a == SimpleDicomContourCreator.BadMIMRTstType.b) {
                list = SimpleDicomContourCreator.a(list, (SimpleImageFrame)imageFrame, (SimpleDicomContourCreator.a)object);
            }
        }
        if (((Object)(object = (Object)list.get((int)0).pointSet)).length != 6) {
            ay.c((Object)("Skipping point contour " + roiInfo.name + ": incorrect number of points"), this);
            return null;
        }
        AnnotationOverlay annotationOverlay = new AnnotationOverlay(this.viewController, imageFrame, presentationType, 0.0f);
        MetricPoint3f metricPoint3f = new DicomPoint3f((float)object[0], (float)object[1], (float)object[2], imageFrame).c();
        MetricPoint3f metricPoint3f2 = new DicomPoint3f((float)object[3], (float)object[4], (float)object[5], imageFrame).c();
        annotationOverlay.a(metricPoint3f, metricPoint3f2, false);
        annotationOverlay.c_(roiInfo.description);
        annotationOverlay.am().b();
        this.setColorForOverlay(roiInfo, imageFrame, annotationOverlay);
        String string3 = roiInfo.observationInformation.get("font-size");
        if (string3 != null) {
            try {
                annotationOverlay.a(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = roiInfo.observationInformation.get("all-slices")) != null) {
            annotationOverlay.d_(Boolean.parseBoolean(string));
        }
        this.linkUpFindings(annotationOverlay, roiInfo);
        return annotationOverlay;
    }

    private Overlay buildLineOrAngleOverlay(AbstractRtStructLoader.RoiInfo roiInfo, List<AbstractRtStructLoader.PointSet> list, FrameNumber frameNumber) {
        return this.buildLineOrAngleOverlay(roiInfo, list, frameNumber, false);
    }

    private Overlay buildLineOrAngleOverlay(AbstractRtStructLoader.RoiInfo roiInfo, List<AbstractRtStructLoader.PointSet> list, FrameNumber frameNumber, boolean bl2) {
        FindingsOverlay findingsOverlay;
        Object object;
        ImageFrame imageFrame = frameNumber != null && this.viewController.bl() ? (ImageFrame)((ViewController3D)this.viewController).cE().a(frameNumber) : this.viewController.aw();
        if (imageFrame instanceof SimpleImageVolume) {
            object = SimpleDicomContourCreator.a.a((SimpleImageVolume)((Object)imageFrame), this.dicom);
            if (((SimpleDicomContourCreator.a)object).a == SimpleDicomContourCreator.BadMIMRTstType.b) {
                list = SimpleDicomContourCreator.a(list, (SimpleImageFrame)imageFrame, (SimpleDicomContourCreator.a)object);
            }
        }
        object = list.get((int)0).pointSet;
        PresentationType presentationType = this.findPlaneOfPoints(roiInfo, (float[])object);
        DicomPoint3f dicomPoint3f = new DicomPoint3f((float)object[0], (float)object[1], (float)object[2], imageFrame);
        DicomPoint3f dicomPoint3f2 = new DicomPoint3f((float)object[3], (float)object[4], (float)object[5], imageFrame);
        String string = roiInfo.observationInformation.get("type");
        if ("2D measure line".equals(string)) {
            TwoDMeasureOverlay twoDMeasureOverlay = new TwoDMeasureOverlay(this.viewController, imageFrame, presentationType, 0.0f);
            twoDMeasureOverlay.a(this.convertToMetricArray((float[])object), false);
            findingsOverlay = twoDMeasureOverlay;
        } else if ("suv ball".equals(string)) {
            findingsOverlay = new SuvBallOverlay(this.viewController, dicomPoint3f.c(), dicomPoint3f.distance(dicomPoint3f2));
            findingsOverlay.p(false);
        } else if (((Object)object).length == 6) {
            LineOverlay lineOverlay;
            if (roiInfo.childType == AbstractRtStructLoader.ChildOverlayType.RECIST || roiInfo.childType == AbstractRtStructLoader.ChildOverlayType.PERP) {
                boolean bl3 = roiInfo.childType == AbstractRtStructLoader.ChildOverlayType.RECIST;
                lineOverlay = new RecistPerpOverlay.RecistPerpLine(this.viewController, imageFrame, presentationType, dicomPoint3f.c().f()[presentationType.a()[2]], bl3);
                ay.b((Object)("R/P in loader: " + bl3), this);
            } else {
                lineOverlay = "z-measurement".equals(string) ? new ZeeMeasureOverlay(this.viewController, imageFrame, presentationType) : new LineOverlay(this.viewController, imageFrame, presentationType, dicomPoint3f.c().f()[presentationType.a()[2]]);
            }
            lineOverlay.a(dicomPoint3f.c(), dicomPoint3f2.c(), false);
            findingsOverlay = lineOverlay;
        } else if (((Object)object).length == 9) {
            AngleOverlay angleOverlay = new AngleOverlay(this.viewController, imageFrame, presentationType);
            DicomPoint3f dicomPoint3f3 = new DicomPoint3f((float)object[6], (float)object[7], (float)object[8], imageFrame);
            angleOverlay.a(dicomPoint3f.c(), dicomPoint3f2.c(), dicomPoint3f3.c(), false);
            findingsOverlay = angleOverlay;
        } else {
            return null;
        }
        ((Overlay)findingsOverlay).c(roiInfo.name);
        if (frameNumber != null && this.viewController.bl()) {
            ((Overlay)findingsOverlay).a(frameNumber);
        }
        findingsOverlay.am().b();
        this.setColorForOverlay(roiInfo, imageFrame, findingsOverlay, bl2);
        this.linkUpFindings(findingsOverlay, roiInfo);
        return findingsOverlay;
    }

    private void setColorForOverlay(AbstractRtStructLoader.RoiInfo roiInfo, ImageFrame imageFrame, Overlay overlay) {
        this.setColorForOverlay(roiInfo, imageFrame, overlay, false);
    }

    private void setColorForOverlay(AbstractRtStructLoader.RoiInfo roiInfo, ImageFrame imageFrame, Overlay overlay, boolean bl2) {
        OverlayCollection overlayCollection = imageFrame.n();
        OverlayColor overlayColor = overlayCollection.r().a(roiInfo.color.a());
        if (bl2) {
            overlayColor = new OverlayColor(overlayColor);
        }
        overlay.a(overlayColor);
        overlay.l(true);
    }

    private PresentationType findPlaneOfPoints(AbstractRtStructLoader.RoiInfo roiInfo, float[] fArray) {
        if (fArray == null) {
            return PresentationType.a;
        }
        PresentationType presentationType = null;
        try {
            if (roiInfo.observationInformation != null && roiInfo.observationInformation.containsKey("plane")) {
                String string = roiInfo.observationInformation.get("plane");
                presentationType = PresentationType.a(string);
            }
            if (presentationType == null && fArray.length % 3 == 0) {
                float f2 = Float.MAX_VALUE;
                for (PresentationType presentationType2 : new PresentationType[]{PresentationType.a, PresentationType.b, PresentationType.c}) {
                    int n2;
                    float f3 = 0.0f;
                    for (int i2 = n2 = presentationType2.a()[2]; i2 < fArray.length; i2 += 3) {
                        f3 += Math.abs(fArray[n2] - fArray[i2]);
                    }
                    if (!(f3 < f2)) continue;
                    f2 = f3;
                    presentationType = presentationType2;
                }
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error finding plane of measurement", (Throwable)exception, this);
        }
        if (presentationType == null) {
            presentationType = PresentationType.b;
            float f4 = Math.abs(fArray[0] - fArray[3]);
            block8: for (int i3 = 1; i3 < 3; ++i3) {
                if (!(Math.abs(fArray[i3] - fArray[i3 + 3]) < f4)) continue;
                f4 = Math.abs(fArray[i3] - fArray[i3 + 3]);
                switch (i3) {
                    case 1: {
                        presentationType = PresentationType.c;
                        continue block8;
                    }
                    case 2: {
                        presentationType = PresentationType.a;
                    }
                }
            }
        }
        return presentationType;
    }

    public MetricPoint3f[] convertToMetricArray(float[] fArray) {
        if (fArray != null && fArray.length % 3 == 0) {
            MetricPoint3f[] metricPoint3fArray = new MetricPoint3f[fArray.length / 3];
            for (int i2 = 0; i2 < fArray.length; i2 += 3) {
                metricPoint3fArray[i2 / 3] = new DicomPoint3f(fArray[i2], fArray[i2 + 1], fArray[i2 + 2], this.viewController.aw()).c();
            }
            return metricPoint3fArray;
        }
        return null;
    }

    private VolumetricContourOverlayish build3DContour(AbstractRtStructLoader.RoiInfo roiInfo, Progress progress) {
        VolumetricContourOverlay volumetricContourOverlay;
        ImageFrame imageFrame = this.viewController.aw();
        Contour contour = new Contour(imageFrame);
        this.fillContour(roiInfo, (SimpleImageVolume)((Object)imageFrame), (SimpleContour)contour, progress);
        OverlayCollection overlayCollection = this.viewController.aw().n();
        OverlayColor overlayColor = overlayCollection.r().a(roiInfo.color.a());
        String string = roiInfo.observationInformation.get("Multicontour");
        if (roiInfo.observationDesc != null && string != null && "true".equals(string)) {
            VennContourOverlay vennContourOverlay = new VennContourOverlay(this.viewController, contour);
            vennContourOverlay.savedRefRoiNumber = roiInfo.referencedRoiNumber;
            volumetricContourOverlay = vennContourOverlay;
        } else {
            volumetricContourOverlay = com.mimvista.mui.overlays.f.a(this.viewController, contour);
        }
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.REPLACE) {
            volumetricContourOverlay.a(roiInfo.referencedRoiNumber);
        }
        volumetricContourOverlay.c(roiInfo.name);
        volumetricContourOverlay.a(roiInfo.operatorNames);
        this.setRoiDisplayNumber(roiInfo, volumetricContourOverlay);
        volumetricContourOverlay.a(overlayColor);
        volumetricContourOverlay.c_(roiInfo.description);
        volumetricContourOverlay.b(roiInfo.observationDesc);
        volumetricContourOverlay.a(roiInfo.interpretedType);
        Overlay.a(volumetricContourOverlay);
        volumetricContourOverlay.f(roiInfo.referencedRoiNumber);
        this.addChildOverlays(volumetricContourOverlay, roiInfo, progress);
        this.linkUpFindings(volumetricContourOverlay, roiInfo);
        return volumetricContourOverlay;
    }

    private void setRoiDisplayNumber(AbstractRtStructLoader.RoiInfo roiInfo, VolumetricContourOverlayish volumetricContourOverlayish) {
        if (roiInfo.name.startsWith("ROI-")) {
            try {
                int n2 = Integer.parseInt(roiInfo.name.substring(4));
                volumetricContourOverlayish.b(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addChildOverlays(final VolumetricContourOverlayish volumetricContourOverlayish, final AbstractRtStructLoader.RoiInfo roiInfo, final Progress progress) {
        this.subJobs.add(new Runnable(){

            @Override
            public void run() {
                AbstractRtStructLoader.RoiInfo roiInfo6 = null;
                AbstractRtStructLoader.RoiInfo roiInfo2 = null;
                AbstractRtStructLoader.RoiInfo roiInfo3 = null;
                AbstractRtStructLoader.RoiInfo roiInfo4 = null;
                for (Map.Entry<Integer, AbstractRtStructLoader.ChildOverlayType> entry : roiInfo.children.entrySet()) {
                    AbstractRtStructLoader.RoiInfo roiInfo5;
                    if (entry.getValue() == AbstractRtStructLoader.ChildOverlayType.RECIST) {
                        roiInfo5 = (AbstractRtStructLoader.RoiInfo)DicomRtStructLoader.this.roiInfoMap.get(entry.getKey());
                        if (roiInfo6 != null || roiInfo5.pointSets.isEmpty() || !roiInfo5.framedPointSets.isEmpty()) continue;
                        roiInfo6 = roiInfo5;
                        continue;
                    }
                    if (entry.getValue() == AbstractRtStructLoader.ChildOverlayType.PERP) {
                        roiInfo5 = (AbstractRtStructLoader.RoiInfo)DicomRtStructLoader.this.roiInfoMap.get(entry.getKey());
                        if (roiInfo2 != null || roiInfo5.pointSets.isEmpty() || !roiInfo5.framedPointSets.isEmpty()) continue;
                        roiInfo2 = roiInfo5;
                        continue;
                    }
                    if (entry.getValue() == AbstractRtStructLoader.ChildOverlayType.SUV_PEAK) {
                        roiInfo5 = (AbstractRtStructLoader.RoiInfo)DicomRtStructLoader.this.roiInfoMap.get(entry.getKey());
                        if (roiInfo3 != null || roiInfo5.pointSets.isEmpty() || !roiInfo5.framedPointSets.isEmpty()) continue;
                        roiInfo3 = roiInfo5;
                        continue;
                    }
                    if (entry.getValue() != AbstractRtStructLoader.ChildOverlayType.CV) continue;
                    roiInfo5 = (AbstractRtStructLoader.RoiInfo)DicomRtStructLoader.this.roiInfoMap.get(entry.getKey());
                    if (roiInfo4 != null || roiInfo5.pointSets.isEmpty() || !roiInfo5.framedPointSets.isEmpty()) continue;
                    roiInfo4 = roiInfo5;
                }
                if (roiInfo3 != null) {
                    DicomRtStructLoader.this.addSUVPeakToContour(volumetricContourOverlayish, roiInfo3, progress);
                }
                if (roiInfo4 != null) {
                    DicomRtStructLoader.this.addCVToContour(volumetricContourOverlayish, roiInfo4, roiInfo4.pointSets.get((int)0).pointSet, progress);
                }
                if (roiInfo6 != null && roiInfo2 != null) {
                    DicomRtStructLoader.this.addRecistAndPerpToContour(volumetricContourOverlayish, roiInfo6, roiInfo6.pointSets, roiInfo2, roiInfo2.pointSets);
                } else if (roiInfo6 != roiInfo2) {
                    ay.c((Object)"RTstruct contained one of RECIST or PERP, but not the other. Unable to load saved measurements.", DicomRtStructLoader.class);
                }
            }
        });
    }

    private void addSUVPeakToContour(VolumetricContourOverlayish volumetricContourOverlayish, AbstractRtStructLoader.RoiInfo roiInfo, Progress progress) {
        l l2 = new l(LocalizationStrategy.a);
        l2.a(true);
        volumetricContourOverlayish.bF_().c(l2);
    }

    private void addCVToContour(VolumetricContourOverlayish volumetricContourOverlayish, AbstractRtStructLoader.RoiInfo roiInfo, float[] fArray, Progress progress) {
        a a2 = new a(LocalizationStrategy.a);
        a2.a(true);
        volumetricContourOverlayish.bF_().c(a2);
    }

    private void addRecistAndPerpToContour(VolumetricContourOverlayish volumetricContourOverlayish, AbstractRtStructLoader.RoiInfo roiInfo, List<AbstractRtStructLoader.PointSet> list, AbstractRtStructLoader.RoiInfo roiInfo2, List<AbstractRtStructLoader.PointSet> list2) {
        ay.a((Object)"Adding RP deriver for RP info found in RTST.", this);
        RecistPerpOverlay.RecistPerpLine recistPerpLine = (RecistPerpOverlay.RecistPerpLine)this.buildLineOrAngleOverlay(roiInfo, list, volumetricContourOverlayish.aH(), true);
        RecistPerpOverlay.RecistPerpLine recistPerpLine2 = (RecistPerpOverlay.RecistPerpLine)this.buildLineOrAngleOverlay(roiInfo2, list2, volumetricContourOverlayish.aH(), true);
        RecistPerpCalculator.RecistPerpDeriver recistPerpDeriver = new RecistPerpCalculator.RecistPerpDeriver(recistPerpLine, recistPerpLine2);
        volumetricContourOverlayish.bF_().c(recistPerpDeriver);
    }

    private void addChildOverlays(ChrontourOverlay chrontourOverlay, AbstractRtStructLoader.RoiInfo roiInfo, Progress progress) {
        Object object;
        Object object3;
        Map.Entry<Integer, AbstractRtStructLoader.ChildOverlayType> entry22;
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        HashMap hashMap3 = Maps.newHashMap();
        HashMap hashMap4 = Maps.newHashMap();
        for (Map.Entry<Integer, AbstractRtStructLoader.ChildOverlayType> entry22 : roiInfo.children.entrySet()) {
            if (entry22.getValue() == AbstractRtStructLoader.ChildOverlayType.RECIST) {
                object3 = (AbstractRtStructLoader.RoiInfo)this.roiInfoMap.get(entry22.getKey());
                for (FrameNumber frameNumber : ((AbstractRtStructLoader.RoiInfo)object3).framedPointSets.keySet()) {
                    hashMap.put(frameNumber, object3);
                }
                continue;
            }
            if (entry22.getValue() == AbstractRtStructLoader.ChildOverlayType.PERP) {
                object3 = (AbstractRtStructLoader.RoiInfo)this.roiInfoMap.get(entry22.getKey());
                for (FrameNumber frameNumber : ((AbstractRtStructLoader.RoiInfo)object3).framedPointSets.keySet()) {
                    hashMap2.put(frameNumber, object3);
                }
                continue;
            }
            if (entry22.getValue() == AbstractRtStructLoader.ChildOverlayType.SUV_PEAK) {
                object3 = (AbstractRtStructLoader.RoiInfo)this.roiInfoMap.get(entry22.getKey());
                for (FrameNumber frameNumber : ((AbstractRtStructLoader.RoiInfo)object3).framedPointSets.keySet()) {
                    hashMap3.put(frameNumber, object3);
                }
                continue;
            }
            if (entry22.getValue() != AbstractRtStructLoader.ChildOverlayType.CV) continue;
            object3 = (AbstractRtStructLoader.RoiInfo)this.roiInfoMap.get(entry22.getKey());
            for (FrameNumber frameNumber : ((AbstractRtStructLoader.RoiInfo)object3).framedPointSets.keySet()) {
                hashMap4.put(frameNumber, object3);
            }
        }
        for (Map.Entry<Integer, AbstractRtStructLoader.ChildOverlayType> entry22 : hashMap3.keySet()) {
            object3 = (AbstractRtStructLoader.RoiInfo)hashMap3.get(entry22);
            object = this.getVolIndex((FrameNumber)((Object)entry22));
            if (object == null) continue;
            ChrontourOverlay chrontourOverlay2 = chrontourOverlay.e((Integer)object);
            this.addSUVPeakToContour(chrontourOverlay2, (AbstractRtStructLoader.RoiInfo)object3, progress);
        }
        for (Map.Entry<Integer, AbstractRtStructLoader.ChildOverlayType> entry22 : hashMap4.keySet()) {
            object3 = (AbstractRtStructLoader.RoiInfo)hashMap4.get(entry22);
            object = this.getVolIndex((FrameNumber)((Object)entry22));
            if (object == null) continue;
            ChrontourOverlay chrontourOverlay3 = chrontourOverlay.e((Integer)object);
            this.addCVToContour(chrontourOverlay3, (AbstractRtStructLoader.RoiInfo)object3, ((AbstractRtStructLoader.RoiInfo)object3).framedPointSets.get((Object)entry22).get((int)0).pointSet, progress);
        }
        Iterator<Map.Entry<Integer, AbstractRtStructLoader.ChildOverlayType>> iterator = Sets.intersection(hashMap.keySet(), hashMap2.keySet());
        entry22 = Sets.union(hashMap.keySet(), hashMap2.keySet());
        object3 = iterator.iterator();
        while (object3.hasNext()) {
            object = (FrameNumber)object3.next();
            AbstractRtStructLoader.RoiInfo roiInfo2 = (AbstractRtStructLoader.RoiInfo)hashMap.get(object);
            AbstractRtStructLoader.RoiInfo roiInfo3 = (AbstractRtStructLoader.RoiInfo)hashMap2.get(object);
            Integer n2 = this.getVolIndex((FrameNumber)object);
            if (n2 == null) continue;
            ChrontourOverlay chrontourOverlay4 = chrontourOverlay.e(n2);
            this.addRecistAndPerpToContour(chrontourOverlay4, roiInfo2, (List<AbstractRtStructLoader.PointSet>)roiInfo2.framedPointSets.get(object), roiInfo3, (List<AbstractRtStructLoader.PointSet>)roiInfo3.framedPointSets.get(object));
        }
        if (entry22.size() > iterator.size()) {
            ay.c((Object)"RTstruct contained one of RECIST or PERP, but not the other. Unable to load all saved measurements.", DicomRtStructLoader.class);
        }
    }

    private Integer getVolIndex(FrameNumber frameNumber) {
        ViewController3D viewController3D;
        ImageFrame imageFrame;
        if (this.viewController.bl() && (imageFrame = (ImageFrame)(viewController3D = (ViewController3D)this.viewController).cE().a(frameNumber)) != null) {
            return viewController3D.cE().b((SimpleImageFrame)((ImageVolumeShort)imageFrame));
        }
        return null;
    }

    private boolean isFrameLoaded(FrameNumber frameNumber) {
        if (this.viewController.bl()) {
            ViewController3D viewController3D = (ViewController3D)this.viewController;
            ImageFrame imageFrame = (ImageFrame)viewController3D.cE().a(frameNumber);
            return imageFrame != null;
        }
        return false;
    }

    private void add2D4DContours(AbstractRtStructLoader.RoiInfo roiInfo, ChrontourFrameList chrontourFrameList) {
        ChrontourFrameInfo chrontourFrameInfo = (ChrontourFrameInfo)chrontourFrameList.get(0);
        o o2 = this.viewController.bh().cE();
        ImageFrame imageFrame = (ImageFrame)o2.c((Integer)chrontourFrameInfo.y);
        TwoDContourOverlayish twoDContourOverlayish = chrontourFrameInfo.contour2d;
        imageFrame.n().a((Overlayish)twoDContourOverlayish, true);
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.REPLACE) {
            twoDContourOverlayish.a(roiInfo.referencedRoiNumber);
        }
        twoDContourOverlayish.c(roiInfo.name);
        this.setRoiDisplayNumber(roiInfo, twoDContourOverlayish);
        twoDContourOverlayish.a(roiInfo.operatorNames);
        twoDContourOverlayish.c_(roiInfo.description);
        twoDContourOverlayish.b(roiInfo.observationDesc);
        twoDContourOverlayish.a(roiInfo.interpretedType);
        Overlay.a(twoDContourOverlayish);
        OverlayColor overlayColor = imageFrame.n().r().a(roiInfo.color.a());
        twoDContourOverlayish.a(overlayColor);
        twoDContourOverlayish.b(twoDContourOverlayish.r());
    }

    private void add4DContours(AbstractRtStructLoader.RoiInfo roiInfo, ChrontourFrameList chrontourFrameList) {
        Object object;
        OverlayCollection overlayCollection = this.viewController.aw().n();
        boolean bl2 = true;
        if (roiInfo.observationInformation.containsKey("True4d")) {
            bl2 = Boolean.parseBoolean(roiInfo.observationInformation.get("True4d"));
        }
        ChrontourOverlay chrontourOverlay = (ChrontourOverlay)overlayCollection.b(true, bl2);
        chrontourOverlay.j_(bl2);
        if (bl2) {
            for (ChrontourFrameInfo chrontourFrameInfo : chrontourFrameList) {
                chrontourOverlay.a((Contour)chrontourFrameInfo.x, (int)((Integer)chrontourFrameInfo.y));
            }
        } else {
            object = new Contour((Contour)((ChrontourFrameInfo)chrontourFrameList.get((int)0)).x);
            for (int i2 = 1; i2 < chrontourFrameList.size(); ++i2) {
                ((SimpleContour)object).d((SimpleContour)((ChrontourFrameInfo)chrontourFrameList.get((int)i2)).x);
            }
            chrontourOverlay.a((Contour)object);
            ContourEdits.MergeChrontourEdit mergeChrontourEdit = new ContourEdits.MergeChrontourEdit(((Contour)object).c(), chrontourOverlay, "Load 4D Contour", true);
            chrontourOverlay.aD().r().a(mergeChrontourEdit);
        }
        if (this.loadMethod == AbstractRtStructLoader.LoadMethod.REPLACE) {
            chrontourOverlay.a(roiInfo.referencedRoiNumber);
        }
        chrontourOverlay.c(roiInfo.name);
        chrontourOverlay.a(roiInfo.operatorNames);
        this.setRoiDisplayNumber(roiInfo, chrontourOverlay);
        chrontourOverlay.c_(roiInfo.description);
        chrontourOverlay.b(roiInfo.observationDesc);
        chrontourOverlay.a(roiInfo.interpretedType);
        Overlay.a(chrontourOverlay);
        this.addChildOverlays(chrontourOverlay, roiInfo, (Progress)com.mimvista.util.progress.o.o());
        object = overlayCollection.r().a(roiInfo.color.a());
        chrontourOverlay.a((OverlayColor)object);
        chrontourOverlay.b(chrontourOverlay.r());
        DynamicSeriesManager.bumpFrame(this.viewController);
    }

    private ChrontourInfo build4DContours(AbstractRtStructLoader.RoiInfo roiInfo, AbstractTwoDContourOverlay.TwoDContourType twoDContourType, Progress progress) {
        ChrontourFrameList chrontourFrameList = new ChrontourFrameList();
        ViewController3D viewController3D = (ViewController3D)this.viewController;
        for (Map.Entry<FrameNumber, ArrayList<AbstractRtStructLoader.PointSet>> entry : roiInfo.framedPointSets.entrySet()) {
            ImageFrame imageFrame = (ImageFrame)viewController3D.cE().a(entry.getKey());
            if (imageFrame != null) {
                int n2 = viewController3D.cE().b((SimpleImageFrame)((ImageVolumeShort)imageFrame));
                Contour contour = new Contour(imageFrame);
                if (twoDContourType == null) {
                    if (!this.allowNon2dContoursOnThisVolume()) continue;
                    this.fillContour((List<AbstractRtStructLoader.PointSet>)entry.getValue(), (SimpleImageVolume)((Object)imageFrame), (SimpleContour)contour, progress);
                    chrontourFrameList.add(new ChrontourFrameInfo(contour, (Integer)n2));
                    continue;
                }
                AbstractTwoDContourOverlay abstractTwoDContourOverlay = this.build2DContour(roiInfo, twoDContourType);
                chrontourFrameList.add(new ChrontourFrameInfo(abstractTwoDContourOverlay, (Integer)n2));
                continue;
            }
            this.invalidFrames.add(entry.getKey().a());
        }
        return new ChrontourInfo(roiInfo, chrontourFrameList);
    }

    private void linkUpFindings(Overlayish overlayish, AbstractRtStructLoader.RoiInfo roiInfo) {
        String string = roiInfo.observationInformation.get("finding");
        if (string != null) {
            for (Finding finding : this.viewController.g().u()) {
                if (!finding.getName().equals(string)) continue;
                overlayish.a(finding);
                return;
            }
            SessionFindingsState sessionFindingsState = this.viewController.g().u();
            overlayish.a(sessionFindingsState.a(string, true, true));
        }
    }

    private AbstractTwoDContourOverlay build2DContour(AbstractRtStructLoader.RoiInfo roiInfo, AbstractTwoDContourOverlay.TwoDContourType twoDContourType) {
        ArrayList<PolygonPoint> arrayList;
        Object object;
        AbstractTwoDContourOverlay abstractTwoDContourOverlay = twoDContourType.a(this.viewController);
        if (abstractTwoDContourOverlay == null) {
            return null;
        }
        abstractTwoDContourOverlay.d(false);
        if (twoDContourType == AbstractTwoDContourOverlay.TwoDContourType.a) {
            float f2 = Float.parseFloat(roiInfo.observationInformation.get("radius"));
            object = roiInfo.observationInformation.get("center");
            String[] stringArray = ((String)object).split("x");
            float[] fArray = new float[3];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                fArray[i2] = Float.parseFloat(stringArray[i2]);
            }
            MetricPoint3f metricPoint3f = new MetricPoint3f(fArray, (SimpleImageFrame)this.viewController.aE());
            MetricPoint3f metricPoint3f2 = new MetricPoint3f(metricPoint3f);
            metricPoint3f2.y += f2;
            arrayList = new ArrayList(2);
            arrayList.add(new PolygonPoint(abstractTwoDContourOverlay, metricPoint3f));
            arrayList.add(new PolygonPoint(abstractTwoDContourOverlay, metricPoint3f2));
        } else {
            Object object2;
            ImageFrame imageFrame = this.viewController.aE();
            object = roiInfo.pointSets;
            if (imageFrame instanceof SimpleImageVolume) {
                object2 = SimpleDicomContourCreator.a.a((SimpleImageVolume)((Object)imageFrame), this.dicom);
                if (((SimpleDicomContourCreator.a)object2).a == SimpleDicomContourCreator.BadMIMRTstType.b) {
                    object = SimpleDicomContourCreator.a((List<AbstractRtStructLoader.PointSet>)object, (SimpleImageFrame)imageFrame, (SimpleDicomContourCreator.a)object2);
                }
            }
            object2 = object.get(0);
            if (((AbstractRtStructLoader.PointSet)object2).pointSet.length % 3 != 0) {
                return null;
            }
            int n2 = ((AbstractRtStructLoader.PointSet)object2).pointSet.length / 3;
            arrayList = new ArrayList<PolygonPoint>(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                MetricPoint3f metricPoint3f = new DicomPoint3f(((AbstractRtStructLoader.PointSet)object2).pointSet[3 * i3], ((AbstractRtStructLoader.PointSet)object2).pointSet[3 * i3 + 1], ((AbstractRtStructLoader.PointSet)object2).pointSet[3 * i3 + 2], imageFrame).c();
                arrayList.add(new PolygonPoint(abstractTwoDContourOverlay, metricPoint3f));
            }
        }
        abstractTwoDContourOverlay.a((List<PolygonPoint>)arrayList);
        abstractTwoDContourOverlay.c(roiInfo.name);
        abstractTwoDContourOverlay.a(roiInfo.operatorNames);
        this.setRoiDisplayNumber(roiInfo, abstractTwoDContourOverlay);
        OverlayCollection overlayCollection = abstractTwoDContourOverlay.aL();
        if ("true".equals(roiInfo.observationInformation.get("background"))) {
            overlayCollection.a(abstractTwoDContourOverlay);
        }
        object = overlayCollection.r().a(roiInfo.color.a());
        ((OverlayColor)object).b();
        abstractTwoDContourOverlay.a(object);
        return abstractTwoDContourOverlay;
    }

    @Override
    protected String[] getManufacturersWithoutKeyholesPref() {
        return ContourPrefs.manufacturersWithoutKeyholes.getValue();
    }

    private static /* synthetic */ boolean lambda$processROIs$8(Set set, AbstractContourOverlayish abstractContourOverlayish) {
        return !set.contains(abstractContourOverlayish);
    }

    @e(e="quicksave_recover", f="recover_quicksave_command", b="command_quicksave_recover", a="General", h="folder_quicksave", k=MIMFeatureCategory.CONTOURING, j={LicenseOption.BASE, LicenseOption.ULTRASOUND_3D, LicenseOption.ENAD_BASE})
    public static class RecoverQuickSaveCommand
    extends LoadRtStructCommand {
        @Override
        public SearchSource getSearchSource(ViewController viewController) {
            return new LocalSearchSource("Recover", DicomRtStructLoader.getQuickSavePath());
        }

        @Override
        protected String getNoResultsMessage() {
            return "<html><center>" + AbstractRtStructLoader.props.getProperty("DCM_QS_RECOVER_ERROR") + "</center></html>";
        }
    }

    @e(e="load_rtstruct", f="load_rtstruct", b="command_load_rtstruct", a="General", h="folder_RTstruct", k=MIMFeatureCategory.CONTOURING, j={LicenseOption.BASE, LicenseOption.ULTRASOUND_3D, LicenseOption.ENAD_BASE})
    public static class LoadRtStructCommand
    extends bx.a {
        @Override
        public void execute(final ViewController viewController) {
            if (!(viewController instanceof ViewController3D)) {
                return;
            }
            final ProgressPanel progressPanel = new ProgressPanel();
            progressPanel.a(false);
            progressPanel.a(AbstractRtStructLoader.props.getProperty("DCM_RT_STRUCT_TASK"));
            ProgressQueueNotification.a(progressPanel);
            MIMSwingUtils.e(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SeriesQuery seriesQuery = this.buildQuery(viewController);
                    try {
                        List<DcmSeries> list = null;
                        if (seriesQuery != null) {
                            list = seriesQuery.search();
                        }
                        if (list == null || list.isEmpty()) {
                            progressPanel.b();
                            MockDialogPanel mockDialogPanel = new MockDialogPanel(this.getNoResultsMessage(), BasicNotification.NotificationType.c);
                            mockDialogPanel.a(f.b(LoadRtStructCommand.class).c());
                            m m2 = new m(mockDialogPanel);
                            u.b().c(m2);
                            return;
                        }
                        RtStructSelectionDialog rtStructSelectionDialog = new RtStructSelectionDialog((Window)ak.b().O(), seriesQuery, (ViewController3D)viewController);
                        rtStructSelectionDialog.open();
                    }
                    finally {
                        progressPanel.b();
                    }
                }
            });
        }

        protected SearchSource getSearchSource(ViewController viewController) {
            return viewController.bK();
        }

        protected String getNoResultsMessage() {
            return AbstractRtStructLoader.props.getProperty("DCM_RT_STRUCT_ERROR");
        }

        public SeriesQuery buildQuery(ViewController viewController) {
            SeriesInfo seriesInfo = viewController.getUncopiedMutableInfo();
            return LoadRtStructCommand.buildQuery(seriesInfo.patientNameRaw, seriesInfo.N(), seriesInfo.ag(), this.getSearchSource(viewController));
        }

        public static SeriesQuery buildQuery(String string, String string2, String string3, SearchSource searchSource) {
            if (searchSource != null) {
                SeriesParameters seriesParameters = new SeriesParameters();
                seriesParameters.searchType = 1;
                seriesParameters.modality = "RTst";
                seriesParameters.studyDate = string2;
                seriesParameters.contentDate = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
                seriesParameters.name = string;
                seriesParameters.uidList = new ArrayList<String>(1);
                seriesParameters.uidList.add(string3);
                SeriesQuery seriesQuery = new SeriesQuery(seriesParameters);
                seriesQuery.setSearchSource(searchSource);
                return seriesQuery;
            }
            return null;
        }
    }

    private static class ChrontourInfo
    extends Pair<AbstractRtStructLoader.RoiInfo, ChrontourFrameList> {
        private static final long serialVersionUID = -2598229527778359022L;

        protected ChrontourInfo(AbstractRtStructLoader.RoiInfo roiInfo, ChrontourFrameList chrontourFrameList) {
            super(roiInfo, chrontourFrameList);
        }
    }

    private static class ChrontourFrameList
    extends ArrayList<ChrontourFrameInfo> {
        private static final long serialVersionUID = 5496980128931603325L;

        private ChrontourFrameList() {
        }
    }

    private static class ChrontourFrameInfo
    extends Pair<Contour, Integer> {
        private static final long serialVersionUID = 1L;
        private TwoDContourOverlayish contour2d = null;

        protected ChrontourFrameInfo(Contour contour, Integer n2) {
            super(contour, n2);
        }

        protected ChrontourFrameInfo(TwoDContourOverlayish twoDContourOverlayish, Integer n2) {
            super(twoDContourOverlayish.aq(), n2);
            this.contour2d = twoDContourOverlayish;
        }
    }
}

