/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.read.LoadTaskStructuredReport;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.OldReportCaptureAndAudioConverterMajig;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.VoxelPoint2f;
import com.mimvista.report.codes.ConceptCode;
import com.mimvista.report.codes.GeneralConcept;
import com.mimvista.report.codes.GenericConceptCode;
import com.mimvista.report.comprehensive.GraphicType;
import com.mimvista.report.comprehensive.NodeRelationshipType;
import com.mimvista.report.comprehensive.NodeType;
import com.mimvista.report.comprehensive.a;
import com.mimvista.report.comprehensive.a.j;
import com.mimvista.report.comprehensive.images.ImageReference;
import com.mimvista.report.comprehensive.nodes.ReportNodeFactory;
import com.mimvista.report.nodes.Report;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.SeriesInfo;
import java.util.Date;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DicomSRLoader {
    private DicomObject dicom;
    private LoaderDataProvider loader;
    private boolean isOldReport;
    private static final GenericConceptCode captureConceptCode54 = new GenericConceptCode("121080", "DCM", null, "Best illustration of finding", null);

    public DicomSRLoader(LoaderDataProvider loaderDataProvider) {
        this.loader = loaderDataProvider;
        this.dicom = loaderDataProvider.getFirstDicomObj();
    }

    public DicomObject getDicom() {
        return this.dicom;
    }

    public Report load(Progress progress) {
        SeriesInfo seriesInfo = this.loader.getUncopiedMutableInfo();
        String string = this.dicom.get(131091).getString(null, false);
        this.isOldReport = LoadTaskStructuredReport.isOldVersionOr3rdPartySR(string, seriesInfo);
        com.mimvista.report.comprehensive.nodes.a<?> a2 = this.readNode(this.dicom);
        a a3 = new a(seriesInfo, a2);
        j j2 = new j(a3);
        j2.a((Report)null);
        Report report = new Report(a3, j2);
        a3.a = string;
        return report;
    }

    private com.mimvista.report.comprehensive.nodes.a<?> readNode(DicomObject dicomObject) {
        ConceptCode conceptCode = this.readConceptCode(dicomObject.getNestedDicomObject(4235331));
        NodeType nodeType = this.readNodeType(dicomObject);
        NodeRelationshipType nodeRelationshipType = this.readRelationshipToParent(dicomObject);
        if (conceptCode == null) {
            ay.c((Object)"Node in structured report doesn't have a concept code and may cause problems with rendering", this);
        }
        com.mimvista.report.comprehensive.nodes.a a2 = null;
        if (this.isOldReport && captureConceptCode54.equals(conceptCode)) {
            a2 = OldReportCaptureAndAudioConverterMajig.fixupCaptureNodesForOldReports(dicomObject);
        } else if (this.isOldReport && GeneralConcept.h.getCode().equals(conceptCode)) {
            a2 = OldReportCaptureAndAudioConverterMajig.fixupAudioNodeForOldReport(dicomObject);
        } else if (nodeType != null) {
            switch (nodeType) {
                case c: {
                    a2 = this.readCodeNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case l: {
                    a2 = this.readCompositeNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case a: {
                    a2 = this.readContainerNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case f: {
                    a2 = this.readDateNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case h: {
                    a2 = this.readDateTimeNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case j: {
                    a2 = this.readImageNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case d: {
                    a2 = this.readNumberNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case e: {
                    a2 = this.readPnameNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case m: {
                    a2 = this.readScoordName(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case b: {
                    a2 = this.readTextNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case g: {
                    a2 = this.readTimeNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case i: {
                    a2 = this.readUidNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
                case k: {
                    a2 = this.readWaveformNode(conceptCode, nodeRelationshipType, dicomObject);
                    break;
                }
            }
            if (a2 != null) {
                this.readAndAppendChildren(dicomObject, a2);
            }
        }
        return a2;
    }

    private void readAndAppendChildren(DicomObject dicomObject, com.mimvista.report.comprehensive.nodes.a<?> a2) {
        DicomElement dicomElement = dicomObject.get(4237104);
        if (dicomElement != null && !dicomElement.isEmpty()) {
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                com.mimvista.report.comprehensive.nodes.a<?> a3 = this.readNode(dicomObject2);
                if (a3 == null) continue;
                a2.a(a3);
                a3.b(a2);
            }
        }
    }

    private ConceptCode readConceptCode(DicomObject dicomObject) {
        if (dicomObject == null) {
            return null;
        }
        String string = dicomObject.getString(524544);
        String string2 = dicomObject.getString(524546);
        String string3 = dicomObject.getString(524548);
        return com.mimvista.report.codes.a.a(string, string2, string3);
    }

    private NodeType readNodeType(DicomObject dicomObject) {
        String string = dicomObject.getString(0x40A040, (String)null);
        try {
            return NodeType.valueOf(string);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Unrecognized node type: " + string), this);
            return null;
        }
    }

    private NodeRelationshipType readRelationshipToParent(DicomObject dicomObject) {
        String string = dicomObject.getString(4235280, (String)null);
        try {
            return NodeRelationshipType.a(string);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Unrecognized node relationship: " + string), this);
            return null;
        }
    }

    private ReportNodeFactory.SopReference readSopReference(DicomObject dicomObject) {
        if (dicomObject == null) {
            return null;
        }
        DicomObject dicomObject2 = dicomObject.getNestedDicomObject(528793);
        if (dicomObject2 == null) {
            return null;
        }
        String string = dicomObject2.getString(524310);
        String string2 = dicomObject2.getString(524312);
        return new ReportNodeFactory.SopReference(string, string2);
    }

    private com.mimvista.report.comprehensive.nodes.a<?> readCodeNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        ConceptCode conceptCode2 = this.readConceptCode(dicomObject.getNestedDicomObject(4235624));
        if (conceptCode2 == null) {
            ay.c((Object)"Node in structured report did not have a valid concept code", this);
        } else if (GeneralConcept.aj.equals(conceptCode2.d())) {
            return ReportNodeFactory.a(conceptCode, nodeRelationshipType, "");
        }
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, conceptCode2);
    }

    private ReportNodeFactory.j readCompositeNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        ReportNodeFactory.SopReference sopReference = this.readSopReference(dicomObject);
        if (sopReference == null || !sopReference.a()) {
            ay.c((Object)"Node in structured report has invalid referenced SOP sequence", this);
        }
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, sopReference);
    }

    private com.mimvista.report.comprehensive.nodes.a<?> readContainerNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        if (dicomObject.contains(805568600)) {
            float[] fArray = dicomObject.getFloats(805568600);
            return ReportNodeFactory.a(fArray);
        }
        if (dicomObject.contains(2145386512)) {
            byte[] byArray = dicomObject.getBytes(2145386512);
            return ReportNodeFactory.a(byArray);
        }
        if (dicomObject.contains(928055808)) {
            DicomObject dicomObject2 = dicomObject.getNestedDicomObject(928055808);
            return ReportNodeFactory.a(dicomObject2);
        }
        ReportNodeFactory.ContinuityOfContent continuityOfContent = this.readContinuityOfContent(dicomObject);
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, continuityOfContent);
    }

    private ReportNodeFactory.ContinuityOfContent readContinuityOfContent(DicomObject dicomObject) {
        String string = dicomObject.getString(4235344);
        try {
            return ReportNodeFactory.ContinuityOfContent.valueOf(string);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Could not recognize continuity of content tag: " + string), this);
            return ReportNodeFactory.ContinuityOfContent.a;
        }
    }

    private ReportNodeFactory.d readDateNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        Date date = dicomObject.getDate(4235553);
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, date);
    }

    private ReportNodeFactory.d readDateTimeNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        Date date = dicomObject.getDate(4235552);
        return ReportNodeFactory.c(conceptCode, nodeRelationshipType, date);
    }

    private ReportNodeFactory.g readImageNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        ReportNodeFactory.SopReference sopReference = this.readSopReference(dicomObject);
        int[] nArray = dicomObject.getInts(528736, (int[])null);
        ImageReference imageReference = new ImageReference(sopReference, nArray);
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, imageReference);
    }

    private ReportNodeFactory.h readNumberNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        ReportNodeFactory.MeasuredValue measuredValue = this.readMeasuredValue(dicomObject);
        if (measuredValue == null) {
            ay.c((Object)"Invalid measured value in structured report", this);
        }
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, measuredValue);
    }

    private ReportNodeFactory.MeasuredValue readMeasuredValue(DicomObject dicomObject) {
        DicomObject dicomObject2 = dicomObject.getNestedDicomObject(4236032);
        if (dicomObject2 == null) {
            return null;
        }
        double d2 = dicomObject2.getDouble(4236042, Double.NaN);
        ConceptCode conceptCode = this.readConceptCode(dicomObject2.getNestedDicomObject(4196586));
        return new ReportNodeFactory.MeasuredValue(d2, conceptCode);
    }

    private ReportNodeFactory.k readPnameNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        String string = dicomObject.getString(4235555);
        return ReportNodeFactory.b(conceptCode, nodeRelationshipType, string);
    }

    private ReportNodeFactory.i readScoordName(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        ReportNodeFactory.SliceCoordinates sliceCoordinates = this.readSliceCoordinates(dicomObject);
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, sliceCoordinates);
    }

    private ReportNodeFactory.SliceCoordinates readSliceCoordinates(DicomObject dicomObject) {
        GraphicType graphicType = this.readGraphicType(dicomObject);
        VoxelPoint2f[] voxelPoint2fArray = this.readPolylineData(dicomObject);
        return new ReportNodeFactory.SliceCoordinates(graphicType, voxelPoint2fArray);
    }

    private GraphicType readGraphicType(DicomObject dicomObject) {
        String string = dicomObject.getString(7340067);
        try {
            return GraphicType.valueOf(string);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Invalid Graphic Type: " + string + ".  Falling back to POINT"), this);
            return GraphicType.a;
        }
    }

    private VoxelPoint2f[] readPolylineData(DicomObject dicomObject) {
        float[] fArray = dicomObject.getFloats(0x700022);
        try {
            if (fArray != null && fArray.length > 0 && fArray.length % 2 == 0) {
                int n2 = fArray.length / 2;
                VoxelPoint2f[] voxelPoint2fArray = new VoxelPoint2f[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    voxelPoint2fArray[i2] = new VoxelPoint2f(fArray[i2 * 2], fArray[i2 * 2 + 1], PresentationType.a);
                }
            } else {
                ay.d((Object)"Invalid Graphic Data in structured report", this);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Invalid Graphic Data in structured report", this);
        }
        return new VoxelPoint2f[0];
    }

    private ReportNodeFactory.k readTextNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        return this.readTextNode(conceptCode, nodeRelationshipType, dicomObject, 4235616);
    }

    private ReportNodeFactory.d readTimeNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        Date date = dicomObject.getDate(4235554);
        return ReportNodeFactory.b(conceptCode, nodeRelationshipType, date);
    }

    private ReportNodeFactory.k readUidNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        return this.readTextNode(conceptCode, nodeRelationshipType, dicomObject, 4235556);
    }

    private ReportNodeFactory.m readWaveformNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject) {
        ReportNodeFactory.SopReference sopReference = this.readSopReference(dicomObject);
        int[] nArray = dicomObject.getInts(4235440, (int[])null);
        byte[] byArray = DicomSRLoader.readWaveformData(dicomObject);
        ReportNodeFactory.Waveform waveform = new ReportNodeFactory.Waveform(sopReference, byArray, nArray);
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, waveform);
    }

    public static byte[] readWaveformData(DicomObject dicomObject) {
        DicomObject dicomObject2 = dicomObject.getNestedDicomObject(1409286400);
        if (dicomObject2 != null) {
            return dicomObject2.getBytes(1409290256);
        }
        return null;
    }

    private ReportNodeFactory.k readTextNode(ConceptCode conceptCode, NodeRelationshipType nodeRelationshipType, DicomObject dicomObject, int n2) {
        String string = dicomObject.getString(n2);
        string = cn.i(string);
        return ReportNodeFactory.a(conceptCode, nodeRelationshipType, string);
    }
}

