/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.mimvista.dicom.DicomColorUtilities;
import com.mimvista.dicom.read.AbstractRtStructLoader;
import com.mimvista.internals.Contour;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleDicomContourCreator;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.VCRef;
import com.mimvista.internals.ViewController;
import com.mimvista.mesh.MeshOverlay;
import com.mimvista.mesh.VoxelMesh;
import com.mimvista.mui.overlays.GhostableOverlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.util.ay;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomSurfaceSegLoader {
    private DicomObject dicom;
    final VCRef vcRef;
    private Map<Integer, String> nameMap;
    private MeshOverlay.MeshRenderChoice renderChoice;
    boolean loadAsContours;
    private List<List<VoxelPoint3f>> verticesList;
    private List<List<int[]>> trianglesList;
    List<Contour> segContourList = Lists.newArrayList();
    List<List<Integer>> segRefSurfList = Lists.newArrayList();
    List<String> segNameList = Lists.newArrayList();
    List<Color> segColors = Lists.newArrayList();

    public DicomSurfaceSegLoader(DicomObject dicomObject, ViewController viewController, boolean bl2) {
        this.dicom = dicomObject;
        this.vcRef = new VCRef(viewController);
        this.renderChoice = this.pullRenderChoice();
        this.loadAsContours = bl2;
        this.verticesList = Lists.newArrayList();
        this.trianglesList = Lists.newArrayList();
        this.createContours();
        this.pullVerticesAndTriangles();
    }

    private MeshOverlay.MeshRenderChoice pullRenderChoice() {
        String string = this.dicom.getString(new int[]{0x660002, 0, 0x66000D});
        if (string.equalsIgnoreCase("surface")) {
            return MeshOverlay.MeshRenderChoice.c;
        }
        if (string.equalsIgnoreCase("wireframe")) {
            return MeshOverlay.MeshRenderChoice.a;
        }
        if (string.equalsIgnoreCase("points")) {
            // empty if block
        }
        return MeshOverlay.MeshRenderChoice.a;
    }

    private void createContours() {
        DicomElement dicomElement = this.dicom.get(0x620002);
        int n2 = 0;
        if (dicomElement != null) {
            n2 = dicomElement.countItems();
        }
        int n3 = 0;
        while (n3 < n2) {
            this.segContourList.add(new Contour(this.vcRef.b().aw()));
            String string = this.dicom.getString(new int[]{0x620002, n3, 6422533});
            this.segNameList.add(string);
            ArrayList arrayList = Lists.newArrayList();
            int n4 = this.dicom.getInt(new int[]{0x620002, n3, 6684714});
            int n5 = 0;
            while (n5 < n4) {
                int n6 = this.dicom.getInt(new int[]{0x620002, n3, 6684715, n5++, 6684716});
                arrayList.add(n6 - 1);
            }
            this.segRefSurfList.add(arrayList);
            int[] nArray = this.dicom.getInts(new int[]{0x620002, n3++, 6422541});
            int[] nArray2 = DicomColorUtilities.getSRGBFromIntegerScaledCIELabPCS(nArray);
            Color color = new Color(nArray2[0], nArray2[1], nArray2[2]);
            this.segColors.add(color);
        }
    }

    private void pullVerticesAndTriangles() {
        int n2 = 0;
        DicomElement dicomElement = this.dicom.get(0x660002);
        if (dicomElement != null) {
            n2 = dicomElement.countItems();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            float[] fArray = dicomObject.getFloats(new int[]{0x660011, 0, 0x660016});
            int[] nArray = this.vcRef.b().aw().C();
            ArrayList arrayList = Lists.newArrayList();
            AbstractRtStructLoader.PointSet pointSet = new AbstractRtStructLoader.PointSet(fArray);
            for (VoxelPoint3f voxelPoint3f : SimpleDicomContourCreator.a(pointSet, (SimpleImageFrame)this.vcRef.b().aw())) {
                voxelPoint3f.a(nArray);
                arrayList.add(voxelPoint3f);
            }
            Object object3 = dicomObject.getInts(new int[]{6684691, 0, 6684737}, VR.UL);
            if (object3 == null) {
                object3 = dicomObject.getInts(new int[]{6684691, 0, 6684707});
            }
            ArrayList object2 = Lists.newArrayList();
            for (int i3 = 0; i3 < ((Object)object3).length - 2; i3 += 3) {
                object2.add(new int[]{(int)(object3[i3] - true), (int)(object3[i3 + 1] - true), (int)(object3[i3 + 2] - true)});
            }
            this.verticesList.add(arrayList);
            this.trianglesList.add(object2);
        }
    }

    public List<Overlayish> loadOverlays() {
        Serializable serializable;
        int n2;
        ArrayList arrayList = Lists.newArrayList();
        for (n2 = 0; n2 < this.verticesList.size(); ++n2) {
            serializable = new VoxelMesh(new Point3f.PointVolumeInfo(this.vcRef.b().aw()), this.verticesList.get(n2), this.trianglesList.get(n2));
            if (!this.loadAsContours) continue;
            Contour contour = new Contour(this.vcRef.b().aw());
            contour = ((VoxelMesh)serializable).a(contour);
            for (int i2 = 0; i2 < this.segContourList.size(); ++i2) {
                if (!this.segRefSurfList.get(i2).contains(n2)) continue;
                ay.a((Object)("adding " + n2 + " contour to surf " + i2), this);
                this.segContourList.get(i2).d((SimpleContour)contour);
            }
        }
        for (n2 = 0; n2 < this.segContourList.size(); ++n2) {
            serializable = f.a(this.vcRef.b(), this.segContourList.get(n2));
            ((GhostableOverlay)serializable).c(this.segNameList.get(n2));
            ((GhostableOverlay)serializable).a(this.vcRef.b().ba().r().a(this.segColors.get(n2)));
            arrayList.add(serializable);
        }
        return arrayList;
    }
}

