/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.read.Dicom2DLoader;
import com.mimvista.dicom.read.DicomVolumeLoader;
import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.internals.MimPlanarImage;
import com.mimvista.internals.x;
import com.mimvista.mui.Session;
import com.mimvista.preferencesNew.ConfigPrefs;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.util.bz;
import com.mimvista.util.ca;
import java.awt.GraphicsEnvironment;

public class DicomVolumeLoaderFactory {
    public static final String AUTO_REORIENT_AXIAL = "AUTO_REORIENT_AXIAL";
    public static final String ASK_OMIT_DUP_SLICES = "ASK_OMIT_DUP_SLICES";
    public static final String PROMPT_FOR_HAWKEYE = "PROMPT_FOR_HAWKEYE";

    private DicomVolumeLoaderFactory() {
    }

    public static DicomVolumeLoader getDefaultDicomVolumeLoader(Session session) {
        if (session == null) {
            throw new NullPointerException("A Session is required to create a loader");
        }
        try {
            return (DicomVolumeLoader)bz.b("com.mimvista.dicom.read.DicomVolumeLoaderImpl").getConstructor(Session.class).newInstance(session);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static DicomVolumeLoader getVolumeLoaderForBinning(Session session) {
        try {
            DicomVolumeLoader dicomVolumeLoader = DicomVolumeLoaderFactory.getDefaultDicomVolumeLoader(session);
            x x2 = new x();
            x2.f = true;
            dicomVolumeLoader.setLoaderPrefs(x2);
            return dicomVolumeLoader;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Dicom2DLoader<MimPlanarImage> getDefault2DLoader() {
        try {
            return (Dicom2DLoader)bz.b("com.mimvista.dicom.read.MimDicom2DLoaderImpl").newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static x getDefaultLoaderPrefs(Session session) {
        boolean bl2 = InterfacePrefs.askOmitDupSlices.getValue();
        boolean bl3 = !GraphicsEnvironment.isHeadless() && !session.T();
        x x2 = new x();
        x2.a = bl2;
        x2.d = InterfacePrefs.autoReorientAxial.getValue();
        x2.e.ask = bl3 ? ReorientationParams.AskReorientPref.AskIfNecessary : ReorientationParams.AskReorientPref.DoNotAsk;
        x2.b = DicomVolumeLoaderFactory.getMaxMatrixSize();
        x2.c = session.T();
        x2.a(ca.e());
        return x2;
    }

    private static int getMaxMatrixSize() {
        try {
            return Integer.parseInt(ConfigPrefs.maxMatrixSize.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

