/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.f;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

class DoseFrameSelectNotification
extends InputNotification {
    final ViewController3D vc;
    List<ImageVolumeShort> userSelectedFrame = null;
    l<UserOption> comboInput = null;
    FuncUtils.f commandLock = new FuncUtils.f();

    public DoseFrameSelectNotification(ViewController3D viewController3D) {
        super(new Notification.a(viewController3D), Messages.a("Dicom", "LOADTASK_RTDOSE_ACCURAY_BAD_DOSE_FIX_TITLE"), BasicNotification.NotificationType.c.b());
        this.vc = viewController3D;
    }

    public List<ImageVolumeShort> getFrame(ImageFrame imageFrame) {
        this.buildNotification(imageFrame);
        this.addListeners();
        u.b().c(this);
        this.commandLock.a();
        return this.userSelectedFrame;
    }

    private void buildNotification(ImageFrame imageFrame) {
        this.addExplanationText(imageFrame);
        this.addSeparator();
        this.addFrameSelectionCombo();
    }

    private void addListeners() {
        this.addDismissListener();
        this.addOkListener();
    }

    private void addExplanationText(ImageFrame imageFrame) {
        String string = IsodoseOverlay.a(imageFrame);
        String string2 = MIMFormat.a(Messages.a("Dicom", "LOADTASK_RTDOSE_REF_FRAME_NOT_DETECTED"), string);
        this.addTextAreaAsLabel(string2);
    }

    private void addFrameSelectionCombo() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.vc.bl()) {
            List<ImageVolumeShort> list = this.vc.cE().l();
            arrayList.add(new UserOption(MIMFormat.a(Messages.a("Dicom", "LOADTASK_RTDOSE_CURRENT_FRAME"), this.vc.cw().getUncopiedMutableInfo().seriesDesc), list.indexOf(this.vc.cw())));
            for (ImageVolumeShort imageVolumeShort : list) {
                int n2 = this.vc.cE().a((SimpleImageVolume<ImageCube.ImageCubeShort>)imageVolumeShort).a();
                arrayList.add(new UserOption(MIMFormat.a(Messages.a("Dicom", "LOADTASK_RTDOSE_FRAME_NUMBER"), n2, imageVolumeShort.getUncopiedMutableInfo().seriesDesc), list.indexOf(imageVolumeShort)));
            }
            arrayList.add(new UserOption(Messages.a("Dicom", "LOADTASK_RTDOSE_ALL_FRAMES"), -1));
        } else {
            arrayList.add(new UserOption(Messages.a("Dicom", "LOADTASK_RTDOSE_CURRENT_FRAME"), 0));
        }
        this.comboInput = this.addComboBox("", arrayList.toArray(new UserOption[arrayList.size()]), new UserOptionListCellRenderer());
    }

    private void addDismissListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DoseFrameSelectNotification.this.commandLock.b();
            }
        };
        this.setDismissActionListener(actionListener);
    }

    private void addOkListener() {
        this.addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserOption userOption = DoseFrameSelectNotification.this.comboInput.b();
                DoseFrameSelectNotification.this.userSelectedFrame = userOption.getSelectedVolume();
                DoseFrameSelectNotification.this.commandLock.b();
            }
        });
    }

    private static class UserOptionListCellRenderer
    extends JLabel
    implements ListCellRenderer<UserOption> {
        private static final long serialVersionUID = 1L;
        private static int maxWidth = 0;
        private static int padding = 10;

        private UserOptionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends UserOption> jList, UserOption userOption, int n2, boolean bl2, boolean bl3) {
            Object object;
            if (userOption == null) {
                this.setText(null);
                this.setToolTipText(null);
                return this;
            }
            if (maxWidth == 0) {
                this.getMaxWidth(jList.getModel());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><table><tr><td align=\"left\" valign=\"middle\" width=\"");
            stringBuilder.append(maxWidth);
            stringBuilder.append("\" nowrap=\"nowrap\">");
            stringBuilder.append(userOption.text);
            stringBuilder.append("</td><td nowrap=\"nowrap\">");
            if (userOption.frameIndex != -1) {
                object = userOption.frame.I();
                stringBuilder.append(f.b(Integer.MAX_VALUE, (SeriesInfo)object));
            } else {
                stringBuilder.append("&nbsp;");
            }
            stringBuilder.append("</td></tr></table></html>");
            object = stringBuilder.toString();
            this.setText(stringBuilder.toString());
            this.setToolTipText((String)object);
            return this;
        }

        private void getMaxWidth(ListModel<? extends UserOption> listModel) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            int n2 = 0;
            Font font = this.getFont();
            for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
                UserOption userOption = listModel.getElementAt(i2);
                if (userOption.frameIndex < 0) continue;
                int n3 = graphics.getFontMetrics(font).stringWidth(userOption.text);
                n2 = Math.max(n2, n3);
            }
            graphics.dispose();
            maxWidth = n2 + padding;
        }
    }

    private class UserOption {
        final String text;
        final int frameIndex;
        final ImageVolumeShort frame;

        UserOption(String string, int n2) {
            this.text = string;
            this.frameIndex = n2;
            this.frame = n2 != -1 ? (ImageVolumeShort)DoseFrameSelectNotification.this.vc.cE().c(n2) : null;
        }

        public List<ImageVolumeShort> getSelectedVolume() {
            if (!DoseFrameSelectNotification.this.vc.bl()) {
                return Lists.asList((Object)DoseFrameSelectNotification.this.vc.cw(), (Object[])new ImageVolumeShort[0]);
            }
            List<ImageVolumeShort> list = DoseFrameSelectNotification.this.vc.cE().l();
            if (this.frameIndex < 0) {
                return list;
            }
            if (list.size() > this.frameIndex) {
                return Lists.asList((Object)list.get(this.frameIndex), (Object[])new ImageVolumeShort[0]);
            }
            return null;
        }

        public String toString() {
            return this.text;
        }
    }
}

