/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.mimvista.archive.o;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.q;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ImageCube;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.logging.a.c;
import com.mimvista.viewer.SeriesInfo;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3f;

public class DynamicVolumeSieve<IVType extends SimpleImageVolume<ImageCube.ImageCubeShort>> {
    private final q<IVType> dSeries;
    private List<SliceInfo> slices;
    private static c log = ay.b(DynamicVolumeSieve.class);
    ArrayListMultimap<Point3f, SliceInfo> slicePositions;
    private int minDupeLevel;
    private int maxDupeLevel;
    final int numTimeSlots;
    private boolean someAreMissingSlices = false;
    private boolean binner = false;
    private boolean rpmModified = false;
    private boolean rpmSketchy = false;
    private Set<String> selectionBad = Sets.newLinkedHashSet();
    Exception unhandledFailure = null;
    private boolean useSeriesSortValueAsPercentageForDisplay = true;
    private Function<SeriesInfo, String> customFrameDescriptionMaker = null;
    private Function<SeriesInfo, Float> percentageFuncFor4D;
    private o openParams;
    List<Class<? extends SieveScreen>> screenOrdering = Lists.newArrayList((Object[])new Class[]{ExplicitFrameNumberScreen.class, MIMBinNumberScreen.class, EchoTimeSieveScreen.class, TriggerTimeSieveScreen.class, TemporalPositionSieveScreen.class, FrameRefrenceTimeSieveScreen.class, ImageCommentsSieveScreen.class, GEPercentRPeakSieveScreen.class, GEReconstructionMatrixSieveScreen.class, SeriesNumberSieveScreen.class, AcquisitionNumberSieveScreen.class, TimeSlotsAndImageIndexScreen.class, SequenceNameSieveScreen.class, InstanceNumberSieveScreen.class, ContentTimeSieveScreen.class, Siemens4DCTScanOptionsScreen.class, ScanOptionsScreen.class, ScanOptionsPlusEchoTimeSieveScreen.class, Philips4DMRPhaseNumberScreen.class, SeriesInstanceUIDScreen.class});

    public DynamicVolumeSieve(q<IVType> q2, List<SliceInfo> list, int n2, o o2, boolean bl2) {
        this.dSeries = q2;
        this.slices = list;
        this.numTimeSlots = n2;
        this.openParams = o2;
        this.binner = bl2;
    }

    public Function<SeriesInfo, Float> getPercentageFuncFor4D() {
        return this.percentageFuncFor4D;
    }

    public boolean useSeriesSortValueAsPercentageForDisplay() {
        return this.useSeriesSortValueAsPercentageForDisplay;
    }

    public boolean useCustomFrameDescription() {
        return this.customFrameDescriptionMaker != null;
    }

    public String getCustomFrameDescription(SeriesInfo seriesInfo) {
        return (String)this.customFrameDescriptionMaker.apply((Object)seriesInfo);
    }

    public void process(Function<SliceInfo, SeriesInfo> function) throws DuplicatedSliceException {
        try {
            this.cleanDupedSopInstanceUIDs();
            this.cleanWeirdOrientationsAndLocalizers();
            this.slicePositions = ArrayListMultimap.create();
            for (SliceInfo object : this.slices) {
                this.slicePositions.put((Object)new Point3f(object.ipp), (Object)object);
            }
            boolean bl2 = false;
            this.minDupeLevel = Integer.MAX_VALUE;
            this.maxDupeLevel = 1;
            for (Collection collection : this.slicePositions.asMap().values()) {
                int n2 = collection.size();
                if (n2 <= 1) continue;
                bl2 = true;
                this.maxDupeLevel = Math.max(this.maxDupeLevel, n2);
                this.minDupeLevel = Math.min(this.minDupeLevel, n2);
            }
            if (!bl2) {
                this.addVolToDynSeries(this.slices);
                return;
            }
            if (this.tryBinning()) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            this.unhandledFailure = runtimeException;
            throw runtimeException;
        }
        this.bailOutWithExceptionPickingFirstFromDupeGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryBinning() {
        if (this.binner) {
            boolean bl2 = false;
            try {
                this.buildBinningProxy();
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    this.dSeries.d();
                }
            }
            return bl2;
        }
        return this.tryRegularBinning();
    }

    private void buildBinningProxy() {
        int n2 = this.slicePositions.keySet().size();
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        for (int i2 = 0; i2 < this.maxDupeLevel; ++i2) {
            tIntObjectHashMap.put(i2, (Object)Lists.newArrayListWithCapacity((int)n2));
        }
        for (Collection collection : this.slicePositions.asMap().values()) {
            int n3 = -1;
            for (SliceInfo sliceInfo : collection) {
                ((List)tIntObjectHashMap.get(++n3)).add(sliceInfo);
            }
        }
        for (int i3 = 0; i3 < this.maxDupeLevel; ++i3) {
            this.addVolToDynSeries((List)tIntObjectHashMap.get(i3));
        }
    }

    private boolean tryRegularBinning() {
        for (boolean bl2 : new boolean[]{false, true}) {
            for (boolean bl3 : new boolean[]{true, false}) {
                for (Class<? extends SieveScreen> clazz : this.screenOrdering) {
                    SieveScreen sieveScreen;
                    try {
                        sieveScreen = clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Can't instantiate sieve screen", throwable, this);
                        continue;
                    }
                    if (!sieveScreen.preCheck(this) || !this.binSlices(sieveScreen, bl3, bl2)) continue;
                    this.useSeriesSortValueAsPercentageForDisplay = sieveScreen.useSeriesSortValueAsPercentageForDisplay();
                    this.customFrameDescriptionMaker = sieveScreen.getCustomFrameDescriptionMaker();
                    return true;
                }
            }
        }
        return false;
    }

    private void bailOutWithExceptionPickingFirstFromDupeGroups() throws DuplicatedSliceException {
        ArrayList arrayList = Lists.newArrayList();
        for (Collection collection : this.slicePositions.asMap().values()) {
            if (collection.size() > 1) {
                List list = Ordering.natural().onResultOf((Function)new Function<SliceInfo, Integer>(){

                    public Integer apply(SliceInfo sliceInfo) {
                        return sliceInfo.sliceNumber;
                    }
                }).sortedCopy((Iterable)collection);
                arrayList.add(list.iterator().next());
                continue;
            }
            arrayList.add(collection.iterator().next());
        }
        this.addVolToDynSeries(arrayList);
        throw new DuplicatedSliceException(this.minDupeLevel, this.maxDupeLevel);
    }

    private IVType addVolToDynSeries(List<SliceInfo> list) {
        IVType IVType = this.dSeries.m();
        ((SimpleImageVolume)IVType).a(list);
        SliceInfo sliceInfo = list.get(0);
        int[] nArray = new int[]{sliceInfo.width, sliceInfo.height, list.size()};
        ((SimpleImageVolume)IVType).a((ImageCube.ImageCubeShort)ImageCube.ImageCubeShort.a(nArray, 0));
        this.dSeries.b(IVType);
        return IVType;
    }

    public void cleanDupedSopInstanceUIDs() {
        HashMap<String, SliceInfo> hashMap = new HashMap<String, SliceInfo>();
        for (SliceInfo sliceInfo : this.slices) {
            hashMap.put(sliceInfo.sopInstanceUID, sliceInfo);
        }
        int n2 = this.slices.size();
        this.slices.clear();
        this.slices.addAll(hashMap.values());
        if (n2 != this.slices.size()) {
            log.b(String.format("%d duplicated instance UIDs removed!", n2 - this.slices.size()));
        }
    }

    public int getRemainingSliceCount() {
        return this.slices.size();
    }

    public boolean areSomeMissingSlices() {
        return this.someAreMissingSlices;
    }

    public boolean wasRPMModified() {
        return this.rpmModified;
    }

    public boolean isRPMSketchy() {
        return this.rpmSketchy;
    }

    public boolean isSliceSelectionBad() {
        return !this.selectionBad.isEmpty();
    }

    public List<String> getBadSelections() {
        return Lists.newArrayList(this.selectionBad);
    }

    private void cleanWeirdOrientationsAndLocalizers() {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (SliceInfo sliceInfo : this.slices) {
            arrayListMultimap.put(this.toFuzzyArray(sliceInfo.iop), (Object)sliceInfo);
        }
        this.pickBiggestSet(arrayListMultimap.asMap(), "orientation");
    }

    private void pickBiggestSet(Map<?, Collection<SliceInfo>> map, String string) {
        if (map.size() > 1) {
            Collection<Object> collection = Collections.emptyList();
            for (Collection<SliceInfo> collection2 : map.values()) {
                if (collection2.size() <= collection.size()) continue;
                collection = collection2;
            }
            ay.b((Object)("Non-uniformity in " + string + " detected - discarding " + (this.slices.size() - collection.size()) + " slices."), this);
            this.slices = Lists.newArrayList(collection);
        }
    }

    private List<Float> toFuzzyArray(float[] fArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (float f2 : fArray) {
            f2 = Math.round(f2 * 100.0f);
            arrayList.add(Float.valueOf(f2));
        }
        return arrayList;
    }

    private boolean binSlices(final SieveScreen sieveScreen, boolean bl2, boolean bl3) {
        try {
            ArrayListMultimap<Object, SliceInfo> arrayListMultimap = ArrayListMultimap.create();
            if (sieveScreen.getBinKey(this.slices.get(0)) == null) {
                return false;
            }
            System.currentTimeMillis();
            for (SliceInfo sliceInfo : this.slices) {
                Object object = sieveScreen.getBinKey(sliceInfo);
                if (object == null) {
                    return false;
                }
                arrayListMultimap.put(object, (Object)sliceInfo);
            }
            if (bl3) {
                arrayListMultimap = this.removeDupeSlicesAtZ(arrayListMultimap);
            }
            int n2 = this.slicePositions.asMap().size();
            int n3 = arrayListMultimap.asMap().size();
            if (n3 == 1 || n3 == this.slices.size() && n2 > 1) {
                return false;
            }
            int n4 = 0;
            for (Collection collection : arrayListMultimap.asMap().values()) {
                n4 += collection.size();
            }
            if (n4 % n3 != 0 && bl2) {
                return false;
            }
            if (n4 / n2 != n3 && bl2) {
                ay.e((Object)("slice positions not properly matched up to number of bins using " + sieveScreen.description()), this);
                return false;
            }
            if (!bl2) {
                int n5 = 0;
                int n6 = 0;
                for (Map.Entry entry : arrayListMultimap.asMap().entrySet()) {
                    Collection collection = (Collection)entry.getValue();
                    if (collection.size() == n2) {
                        ++n6;
                        continue;
                    }
                    if (collection.size() > n2) {
                        ay.e("Found surplus slices in a frame. Moving on.");
                        return false;
                    }
                    n5 += n2 - collection.size();
                }
                if (n6 == 0) {
                    ay.e("All " + n3 + " frames missing slices using " + sieveScreen.description());
                }
                ay.e("" + n5 + " missing slices in " + (n3 - n6) + "/" + n3 + " frames " + " out of " + n2 * n3 + " total slices using " + sieveScreen.description());
                float f2 = DicomPrefs.fourdPerFrameMaxMissingSlicePercentage.getValue().floatValue();
                if ((float)n5 > (float)n4 * f2) {
                    return false;
                }
                this.someAreMissingSlices = true;
            }
            for (Collection collection : arrayListMultimap.asMap().values()) {
                ArrayList<SliceInfo> arrayList = new ArrayList<SliceInfo>(collection);
                this.addVolToDynSeries(arrayList);
            }
            this.dSeries.a((Comparator<IVType>)Ordering.natural().onResultOf(new Function<IVType, BigDecimal>(){

                public BigDecimal apply(IVType IVType) {
                    return sieveScreen.getSortKeyAsBigDecimal(((SimpleImageVolume)IVType).getUncopiedMutableInfo());
                }
            }));
            if (sieveScreen.useSeriesInfoValueAsDescription()) {
                this.percentageFuncFor4D = new Function<SeriesInfo, Float>(){

                    public Float apply(SeriesInfo seriesInfo) {
                        return Float.valueOf(sieveScreen.getSortKey(seriesInfo).floatValue());
                    }
                };
            }
            return true;
        }
        catch (Throwable throwable) {
            ay.c((Object)"Volume binning method failed", throwable, this);
            return false;
        }
    }

    private ArrayListMultimap<Object, SliceInfo> removeDupeSlicesAtZ(ArrayListMultimap<Object, SliceInfo> arrayListMultimap) {
        ArrayListMultimap arrayListMultimap2 = ArrayListMultimap.create();
        for (Object k2 : arrayListMultimap.asMap().keySet()) {
            List list = arrayListMultimap.get(k2);
            ArrayList arrayList = Lists.newArrayList();
            ArrayList arrayList2 = Lists.newArrayList();
            for (SliceInfo sliceInfo : list) {
                if (arrayList2.contains(new Point3f(sliceInfo.ipp))) continue;
                arrayList2.add(new Point3f(sliceInfo.ipp));
                arrayList.add(sliceInfo);
            }
            arrayListMultimap2.putAll(k2, (Iterable)arrayList);
        }
        return arrayListMultimap2;
    }

    static Integer getPhaseFromScanOptions(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("TM") && !string.startsWith("TP") || !string.endsWith("C3000")) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\d{1,3}");
        Matcher matcher = pattern.matcher(string.substring(2).replace("C3000", ""));
        if (matcher.find()) {
            int n2 = Integer.parseInt(matcher.toMatchResult().group());
            if (string.toUpperCase().startsWith("TP")) {
                n2 = 201 - n2;
            }
            return n2;
        }
        return null;
    }

    static Integer getPhaseFromImageComment(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d{1,3}) %");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            int n2 = Integer.parseInt(matcher.toMatchResult().group().replaceAll(" %", ""));
            if (string.toUpperCase().contains("% IN")) {
                n2 = 200 - n2;
            }
            return n2;
        }
        return null;
    }

    public static class DuplicatedSliceException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final int min;
        public final int max;

        public DuplicatedSliceException(int n2, int n3) {
            super("Duplicated slices: min dupage of " + n2 + " max dupage of " + n3);
            this.min = n2;
            this.max = n3;
        }
    }

    static class SeriesInstanceUIDScreen
    extends SieveScreen {
        SeriesInstanceUIDScreen() {
        }

        @Override
        public Object getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.seriesInstanceUID;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.f().getTime());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        String description() {
            return "series UID";
        }

        @Override
        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return new Function<SeriesInfo, String>(){

                public String apply(SeriesInfo seriesInfo) {
                    return seriesInfo.seriesNumber;
                }
            };
        }
    }

    static class ExplicitFrameNumberScreen
    extends SieveScreen {
        ExplicitFrameNumberScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            if (sliceInfo.explicitFrame != null) {
                return sliceInfo.explicitFrame.a();
            }
            return null;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            if (seriesInfo.frameNumFromSeriesDesc != null) {
                return Float.valueOf(seriesInfo.frameNumFromSeriesDesc.a());
            }
            return null;
        }

        @Override
        String description() {
            return "explicit frame number";
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }
    }

    static class MIMBinNumberScreen
    extends SieveScreen {
        MIMBinNumberScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            if (sliceInfo.binNumber == -1) {
                return null;
            }
            return sliceInfo.binNumber;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return new Float(seriesInfo.binNum);
        }

        @Override
        String description() {
            return "bin number";
        }

        @Override
        public boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }

        @Override
        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return new Function<SeriesInfo, String>(){

                public String apply(SeriesInfo seriesInfo) {
                    return seriesInfo.binDesc;
                }
            };
        }
    }

    static class ContentTimeSieveScreen
    extends SieveScreen {
        ContentTimeSieveScreen() {
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.contentTime);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            try {
                return Float.valueOf(sliceInfo.contentTime);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        String description() {
            return "content time";
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return false;
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }
    }

    static class InstanceNumberSieveScreen
    extends SieveScreen {
        InstanceNumberSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.sliceNumber;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return Float.valueOf(seriesInfo.instanceNum);
        }

        @Override
        String description() {
            return "instance number";
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }
    }

    static class ImageCommentsSieveScreen
    extends SieveScreen {
        ImageCommentsSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return DynamicVolumeSieve.getPhaseFromImageComment(sliceInfo.imageComments);
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            Integer n2 = DynamicVolumeSieve.getPhaseFromImageComment(seriesInfo.imageComments);
            if (n2 != null) {
                return Float.valueOf(n2.floatValue());
            }
            return null;
        }

        @Override
        String description() {
            return "image comments";
        }

        @Override
        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return new Function<SeriesInfo, String>(){

                public String apply(SeriesInfo seriesInfo) {
                    String string = seriesInfo.imageComments.toUpperCase();
                    boolean bl2 = string.contains(" % EX");
                    boolean bl3 = string.contains(" % IN");
                    if (bl2 || bl3) {
                        Pattern pattern = Pattern.compile("(\\d{1,3}) % [EI][XN]");
                        Matcher matcher = pattern.matcher(string);
                        matcher.find();
                        return matcher.toMatchResult().group();
                    }
                    return DynamicVolumeSieve.getPhaseFromImageComment(seriesInfo.imageComments) + " %";
                }
            };
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }
    }

    static class SequenceNameSieveScreen
    extends SieveScreen {
        SequenceNameSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            try {
                return Float.valueOf(sliceInfo.sequenceName.replaceAll("[^0-9]", ""));
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.sequenceName.replaceAll("[^0-9]", ""));
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }

        @Override
        public String description() {
            return "seq name";
        }
    }

    static class AcquisitionNumberSieveScreen
    extends SieveScreen {
        AcquisitionNumberSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            try {
                return Float.valueOf(sliceInfo.acquisitionNumber);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.acquisitionNumber);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }

        @Override
        public String description() {
            return "acq number";
        }
    }

    static class SeriesNumberSieveScreen
    extends SieveScreen {
        SeriesNumberSieveScreen() {
        }

        @Override
        public Long getBinKey(SliceInfo sliceInfo) {
            try {
                return Long.valueOf(sliceInfo.seriesNumber);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public Long getSortKey(SeriesInfo seriesInfo) {
            try {
                return Long.valueOf(seriesInfo.seriesNumber);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }

        @Override
        public String description() {
            return "series number";
        }
    }

    static class GEReconstructionMatrixSieveScreen
    extends SieveScreen {
        GEReconstructionMatrixSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.gePrivateReconstructionMatrix;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            if (seriesInfo.gePrivateReconstructionMatrix != null) {
                return Float.valueOf(seriesInfo.gePrivateReconstructionMatrix.floatValue());
            }
            return null;
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }

        @Override
        public String description() {
            return "ge private recon matrix";
        }
    }

    static class GEPercentRPeakSieveScreen
    extends SieveScreen {
        GEPercentRPeakSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.gePrivatePctRpeakDelay;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            if (seriesInfo.gePrivatePctRpeakDelay != null) {
                return Float.valueOf(seriesInfo.gePrivatePctRpeakDelay.floatValue());
            }
            return null;
        }

        @Override
        public String description() {
            return "ge private percent rpeak delay";
        }

        @Override
        boolean useSeriesInfoValueAsDescription() {
            return true;
        }
    }

    static class FrameRefrenceTimeSieveScreen
    extends SieveScreen {
        FrameRefrenceTimeSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.frameReferenceTime;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return Float.valueOf(seriesInfo.frameReferenceTime);
        }

        @Override
        String description() {
            return "frame ref time";
        }
    }

    static class TemporalPositionSieveScreen
    extends SieveScreen {
        TemporalPositionSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.temporalPositionID;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return Float.valueOf(seriesInfo.temporalPositionID);
        }

        @Override
        String description() {
            return "temporal position";
        }
    }

    static class TriggerTimeSieveScreen
    extends SieveScreen {
        TriggerTimeSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.triggerTime;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return Float.valueOf(seriesInfo.triggerTime);
        }

        @Override
        public String description() {
            return "trigger time";
        }
    }

    static class ScanOptionsScreen
    extends SieveScreen {
        ScanOptionsScreen() {
        }

        @Override
        public String getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.scanOptions;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.f().getTime());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public String description() {
            return "scan options";
        }

        @Override
        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return new Function<SeriesInfo, String>(){

                public String apply(SeriesInfo seriesInfo) {
                    return seriesInfo.scanOptions;
                }
            };
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }
    }

    static class Siemens4DCTScanOptionsScreen
    extends SieveScreen {
        Siemens4DCTScanOptionsScreen() {
        }

        @Override
        public Object getBinKey(SliceInfo sliceInfo) {
            return DynamicVolumeSieve.getPhaseFromScanOptions(sliceInfo.scanOptions);
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            Integer n2 = DynamicVolumeSieve.getPhaseFromScanOptions(seriesInfo.scanOptions);
            if (n2 != null) {
                return Float.valueOf(n2.floatValue());
            }
            return null;
        }

        @Override
        public String description() {
            return "siemens 4DCT scan options";
        }

        @Override
        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return new Function<SeriesInfo, String>(){

                public String apply(SeriesInfo seriesInfo) {
                    String string = seriesInfo.scanOptions;
                    Pattern pattern = Pattern.compile("\\d{1,3}");
                    Matcher matcher = pattern.matcher(string.substring(2).replace("C3000", ""));
                    matcher.find();
                    int n2 = Integer.parseInt(matcher.toMatchResult().group());
                    return n2 + "% " + (seriesInfo.scanOptions.startsWith("TP") ? "IN" : "EX");
                }
            };
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }
    }

    static class Philips4DMRPhaseNumberScreen
    extends SieveScreen {
        Philips4DMRPhaseNumberScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.philipsPrivatePhaseNumber;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return Float.valueOf(seriesInfo.philipsPrivatePhaseNumber.floatValue());
        }

        @Override
        String description() {
            return "Philips 4DMR Private Phase Number";
        }
    }

    static class ScanOptionsPlusEchoTimeSieveScreen
    extends SieveScreen {
        ScanOptionsPlusEchoTimeSieveScreen() {
        }

        @Override
        public String getBinKey(SliceInfo sliceInfo) {
            if (sliceInfo.scanOptions != null && sliceInfo.echoTime != null) {
                return sliceInfo.scanOptions + "," + sliceInfo.echoTime;
            }
            return null;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.echoTime);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public String description() {
            return "scan options plus echo time";
        }

        @Override
        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return new Function<SeriesInfo, String>(){

                public String apply(SeriesInfo seriesInfo) {
                    return seriesInfo.scanOptions + ", " + seriesInfo.echoTime;
                }
            };
        }

        @Override
        boolean useSeriesSortValueAsPercentageForDisplay() {
            return false;
        }
    }

    static class EchoTimeSieveScreen
    extends SieveScreen {
        EchoTimeSieveScreen() {
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            return sliceInfo.echoTime;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            try {
                return Float.valueOf(seriesInfo.echoTime);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public String description() {
            return "echo time";
        }
    }

    static class TimeSlotsAndImageIndexScreen
    extends SieveScreen {
        private int groupSize;

        TimeSlotsAndImageIndexScreen() {
        }

        @Override
        boolean preCheck(DynamicVolumeSieve<?> dynamicVolumeSieve) {
            if (dynamicVolumeSieve.numTimeSlots < 1) {
                return false;
            }
            this.groupSize = dynamicVolumeSieve.slicePositions.asMap().keySet().size();
            return ((DynamicVolumeSieve)dynamicVolumeSieve).slices.size() / dynamicVolumeSieve.numTimeSlots == this.groupSize;
        }

        @Override
        public Number getBinKey(SliceInfo sliceInfo) {
            if (sliceInfo.imageIndex == null) {
                return null;
            }
            return (sliceInfo.imageIndex - 1) / this.groupSize;
        }

        @Override
        public Float getSortKey(SeriesInfo seriesInfo) {
            return Float.valueOf(seriesInfo.triggerTime);
        }

        @Override
        String description() {
            return "time slots and image index";
        }
    }

    private static abstract class SieveScreen {
        private SieveScreen() {
        }

        boolean preCheck(DynamicVolumeSieve<?> dynamicVolumeSieve) {
            return true;
        }

        boolean useSeriesInfoValueAsDescription() {
            return false;
        }

        boolean useSeriesSortValueAsPercentageForDisplay() {
            return true;
        }

        public abstract Object getBinKey(SliceInfo var1);

        public abstract Number getSortKey(SeriesInfo var1);

        public BigDecimal getSortKeyAsBigDecimal(SeriesInfo seriesInfo) {
            Number number = this.getSortKey(seriesInfo);
            return number == null ? null : new BigDecimal(number.toString());
        }

        abstract String description();

        public Function<SeriesInfo, String> getCustomFrameDescriptionMaker() {
            return null;
        }
    }
}

