/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.mimcloud.c.a;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;

public class EmbeddedDataProvider
extends LoaderDataProvider {
    private int idx;
    private Integer cachedFileCount;
    private LoaderDataProvider provider;

    public EmbeddedDataProvider(LoaderDataProvider loaderDataProvider, int n2) {
        this.provider = loaderDataProvider;
        this.idx = n2;
    }

    public int getFileCount() {
        int n2;
        if (this.cachedFileCount != null) {
            return this.cachedFileCount;
        }
        DicomReader.FilteredTagInputHandler filteredTagInputHandler = new DicomReader.FilteredTagInputHandler(new int[]{930291808, 930291856}, DicomReader.FilteredTagInputHandler.FilterMode.INCLUDE);
        filteredTagInputHandler.addSpecialSequenceInclude(930291808, this.idx);
        InputStream inputStream = this.provider.getStream(this.provider.getFilenames().get(0));
        DicomInputStream dicomInputStream = null;
        try {
            dicomInputStream = new DicomInputStream((InputStream)new BufferedInputStream(inputStream));
            dicomInputStream.setHandler((DicomInputHandler)filteredTagInputHandler);
            DicomObject dicomObject = dicomInputStream.readDicomObject();
            DicomElement dicomElement = dicomObject.get(930291808);
            if (dicomElement.countItems() != 1) {
                ay.d((Object)("Filter failed... Got " + dicomElement.countItems() + " RT objects"), this);
            }
            DicomObject dicomObject2 = dicomElement.getDicomObject(0);
            DicomElement dicomElement2 = dicomObject2.get(930291856);
            this.cachedFileCount = dicomElement2.countItems();
            n2 = this.cachedFileCount;
        }
        catch (Exception exception) {
            try {
                ay.d((Object)"Error trying to parse", (Throwable)exception, this);
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                cm.a(dicomInputStream, null, null);
                cm.a((Closeable)inputStream, null, null);
                throw throwable;
            }
        }
        cm.a((Closeable)dicomInputStream, null, null);
        cm.a((Closeable)inputStream, null, null);
        return n2;
    }

    @Override
    public List<String> getFilenames() {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < this.getFileCount(); ++i2) {
            arrayList.add(i2 + ".dcm");
        }
        return arrayList;
    }

    @Override
    public InputStream getStream(String string) {
        int n2 = this.getFilenames().indexOf(string);
        if (n2 < 0) {
            ay.d((Object)"Bad embedded filename", this);
            return null;
        }
        DicomReader.FilteredTagInputHandler filteredTagInputHandler = new DicomReader.FilteredTagInputHandler(new int[]{930291808, 930291856, 930291840}, DicomReader.FilteredTagInputHandler.FilterMode.INCLUDE);
        filteredTagInputHandler.addSpecialSequenceInclude(930291808, this.idx);
        filteredTagInputHandler.addSpecialSequenceInclude(930291856, n2);
        InputStream inputStream = this.provider.getStream(this.provider.getFilenames().get(0));
        DicomInputStream dicomInputStream = null;
        try {
            DicomReader.AdvanceStreamToTagPathHandler advanceStreamToTagPathHandler = new DicomReader.AdvanceStreamToTagPathHandler(new int[]{930291808, this.idx, 930291856, n2, 930291840});
            dicomInputStream = new DicomInputStream(inputStream);
            dicomInputStream.setHandler((DicomInputHandler)advanceStreamToTagPathHandler);
            dicomInputStream.readDicomObject();
            int n3 = dicomInputStream.valueLength();
            a a2 = new a((InputStream)dicomInputStream, n3);
            a2.b(true);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(a2);
            DicomInputStream dicomInputStream2 = new DicomInputStream((InputStream)new BufferedInputStream(gZIPInputStream));
            return dicomInputStream2;
        }
        catch (Exception exception) {
            ay.d((Object)"Error", (Throwable)exception, this);
            cm.a(dicomInputStream, null, null);
            cm.a((Closeable)inputStream, null, null);
            return null;
        }
    }
}

