/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.encrypt.DecryptReader;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchProviderException;
import org.bouncycastle.cms.CMSException;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;

public class EncryptedDicomReader
extends DicomReader {
    public static DicomObject readFileIntoDicomObject(File file, char[] cArray) {
        return EncryptedDicomReader.readFileIntoDicomObject(file, -1, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject readFileIntoDicomObject(File file, int n2, char[] cArray) {
        DicomObject dicomObject;
        try {
            dicomObject = DicomReader.readIntoDicomObject(file, n2, true);
            if (!dicomObject.isEmpty() && dicomObject.size() > 1) {
                return dicomObject;
            }
        }
        catch (IOException iOException) {
            dicomObject = null;
        }
        catch (RuntimeException runtimeException) {
            dicomObject = null;
        }
        Throwable throwable = null;
        DicomInputStream dicomInputStream = null;
        try {
            dicomInputStream = new DicomInputStream(DecryptReader.decryptFromStream(new FileInputStream(file), cArray));
            dicomInputStream.setValueLengthLimit(Long.MAX_VALUE);
            if (n2 > 0) {
                dicomInputStream.setHandler((DicomInputHandler)new StopTagInputHandler(n2));
            }
            if (!(dicomObject = dicomInputStream.readDicomObject()).isEmpty() && dicomObject.size() > 1) {
                DicomObject dicomObject2 = dicomObject;
                return dicomObject2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throwable = fileNotFoundException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throwable = noSuchProviderException;
        }
        catch (CMSException cMSException) {
            throwable = cMSException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable = outOfMemoryError;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throwable = invalidAlgorithmParameterException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throwable = generalSecurityException;
        }
        finally {
            if (throwable != null) {
                ay.d((Object)("Reading Encrypted DICOM file " + file.getAbsolutePath()), throwable, DicomReader.class);
            }
            if (dicomInputStream != null) {
                try {
                    dicomInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }
}

