/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileExcluder {
    public static String[] extensions = new String[]{".EXE", ".DLL", ".XML", ".DOC", ".PDF", ".TXT", ".JS", ".XFM", ".JAR", ".MIM", ".PLIST", ".DS_STORE", ".BAK", ".DIRECTORY"};

    public String[] getExcludedDicomReadExtensions() {
        return extensions;
    }

    public FilenameFilter getFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                for (String string2 : extensions) {
                    if (!string.toUpperCase().endsWith(string2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public <T extends File> List<T> getFilteredList(Collection<? extends T> collection) {
        FilenameFilter filenameFilter = this.getFilenameFilter();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : collection) {
            if (!filenameFilter.accept(file.getParentFile(), file.getName())) continue;
            arrayList.add(file);
        }
        return arrayList;
    }
}

