/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ArrayTable;
import com.mimvista.gui.util.c;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrameDurationCorrector {
    private static Messages props = Messages.a("Util");

    public static void verifyFrameDurationsMatchFrameReferenceTimes(o o2) {
        int n2;
        Object object;
        TimeTag[] timeTagArray;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<TimeTag, List<Integer>> hashMap = new HashMap<TimeTag, List<Integer>>();
        HashMap<TimeTag, Boolean> hashMap2 = new HashMap<TimeTag, Boolean>();
        ArrayTable arrayTable = ArrayTable.create(Arrays.asList(TimeTag.values()), Arrays.asList(TimeTag.values()));
        TimeTag[] timeTagArray2 = timeTagArray = TimeTag.values();
        int n3 = timeTagArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            object = timeTagArray2[i2];
            hashMap.put((TimeTag)((Object)object), new ArrayList());
            hashMap2.put((TimeTag)((Object)object), false);
            for (TimeTag timeTag : timeTagArray) {
                arrayTable.put(object, (Object)timeTag, (Object)true);
            }
        }
        boolean bl2 = true;
        for (n3 = 0; n3 < o2.n() - 1; ++n3) {
            SeriesInfo seriesInfo = ((ImageVolumeShort)o2.c(n3)).getUncopiedMutableInfo();
            object = ((ImageVolumeShort)o2.c(n3 + 1)).getUncopiedMutableInfo();
            arrayList.add(seriesInfo.actualFrameDuration);
            TimeTag[] timeTagArray3 = timeTagArray;
            int n4 = timeTagArray3.length;
            for (n2 = 0; n2 < n4; ++n2) {
                TimeTag timeTag;
                timeTag = timeTagArray3[n2];
                float f2 = timeTag.getValueFor((SeriesInfo)object) - timeTag.getValueFor(seriesInfo);
                ((List)hashMap.get((Object)timeTag)).add((int)f2);
                boolean bl3 = (Boolean)hashMap2.get((Object)timeTag) != false || f2 > 0.0f && f2 != (float)seriesInfo.actualFrameDuration;
                hashMap2.put(timeTag, bl3);
                for (int i3 = 0; i3 <= timeTag.ordinal(); ++i3) {
                    boolean bl4;
                    if (i3 != timeTag.ordinal()) {
                        bl4 = ((Integer)((List)hashMap.get((Object)timeTag)).get(n3)).intValue() == ((Integer)((List)hashMap.get((Object)timeTagArray[i3])).get(n3)).intValue();
                        arrayTable.put((Object)timeTag, (Object)timeTagArray[i3], (Object)((Boolean)arrayTable.get((Object)timeTag, (Object)timeTagArray[i3]) != false && bl4 ? 1 : 0));
                        continue;
                    }
                    bl4 = (Integer)((List)hashMap.get((Object)timeTag)).get(n3) == 0;
                    arrayTable.put((Object)timeTag, (Object)timeTag, (Object)((Boolean)arrayTable.get((Object)timeTag, (Object)timeTag) != false && bl4 ? 1 : 0));
                }
            }
            if (n3 == o2.n() - 2) {
                arrayList.add(((SeriesInfo)object).actualFrameDuration);
                for (TimeTag timeTag : hashMap.keySet()) {
                    List list = (List)hashMap.get((Object)timeTag);
                    list.add(list.get(list.size() - 1));
                }
            }
            bl2 &= seriesInfo.actualFrameDuration == ((SeriesInfo)object).actualFrameDuration;
        }
        n3 = 0;
        for (TimeTag timeTag : TimeTag.values()) {
            n3 |= (Boolean)hashMap2.get((Object)timeTag) == false && (Boolean)arrayTable.get((Object)timeTag, (Object)timeTag) == false ? 1 : 0;
        }
        if (n3 != 0 || !bl2) {
            return;
        }
        for (TimeTag timeTag : timeTagArray) {
            for (n2 = 0; n2 <= timeTag.ordinal(); ++n2) {
                if (!((Boolean)arrayTable.get((Object)timeTag, (Object)timeTagArray[n2])).booleanValue() && ((Boolean)hashMap2.get((Object)timeTag)).booleanValue()) continue;
                hashMap.remove((Object)timeTag);
            }
        }
        if (hashMap.isEmpty()) {
            return;
        }
        u.b().c(new FrameDurationMismatchNotification(arrayList, hashMap, o2, new Notification.a(o2.g())));
    }

    private static class FrameDurationMismatchNotification
    extends BasicNotification {
        JPanel vBox;
        Box hBox;
        JButton cancelButton;
        Map<TimeTag, JButton> acceptButtons;
        List<Integer> actualFrameDurations;
        Map<TimeTag, List<Integer>> timeDiffsMap;
        o dSeries;

        public FrameDurationMismatchNotification(List<Integer> list, Map<TimeTag, List<Integer>> map, o o2, Notification.a a2) {
            super(BasicNotification.NotificationType.d, FrameDurationMismatchNotification.buildHeader(o2), a2);
            this.actualFrameDurations = list;
            this.timeDiffsMap = map;
            this.dSeries = o2;
            this.build();
        }

        private static String buildHeader(o o2) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            SeriesInfo seriesInfo = ((ImageVolumeShort)o2.c(0)).I();
            stringBuilder.append(seriesInfo.patientName + ", " + seriesInfo.modality + seriesInfo.M());
            stringBuilder.append("<br></br><br></br>");
            stringBuilder.append(props.getProperty("FRAMEDURCORR_MESSAGE"));
            stringBuilder.append("<br></br><br></br></html>");
            return stringBuilder.toString();
        }

        private String buildMessage() {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            StringBuilder stringBuilder2 = new StringBuilder("<table width=\"100%%\"> <tr align=\"center\"> <th>" + props.getProperty("FRAMEDURCORR_FRAME_NUMBER_TITLE") + "</th>");
            stringBuilder2.append("<th>" + props.getProperty("FRAMEDURCORR_FRAME_DURATION_TITLE") + "</th>");
            for (TimeTag timeTag : this.timeDiffsMap.keySet()) {
                stringBuilder2.append("<th>" + timeTag.getColumnTitle() + "</th>");
            }
            stringBuilder2.append("</tr>");
            stringBuilder.append(stringBuilder2.toString());
            String string = "<tr align=\"center\">" + cn.b("<td>%d</td>", this.timeDiffsMap.size() + 2) + "</tr>";
            for (int i2 = 0; i2 < this.actualFrameDurations.size(); ++i2) {
                Object[] objectArray = new Object[this.timeDiffsMap.size() + 2];
                objectArray[0] = i2 + 1;
                objectArray[1] = (int)this.actualFrameDurations.get(i2);
                int n2 = 0;
                for (TimeTag timeTag : this.timeDiffsMap.keySet()) {
                    objectArray[2 + n2++] = (int)this.timeDiffsMap.get((Object)timeTag).get(i2);
                }
                stringBuilder.append(String.format(string, objectArray));
            }
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }

        private void build() {
            this.vBox = new JPanel(new BorderLayout());
            JComponent jComponent = super.getContent();
            JLabel jLabel = new JLabel(this.buildMessage());
            JScrollPane jScrollPane = new JScrollPane(jLabel);
            this.vBox.add((Component)jComponent, "North");
            this.vBox.add((Component)jScrollPane, "Center");
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            jScrollPane.setHorizontalScrollBarPolicy(31);
            Dimension dimension = jScrollPane.getPreferredSize();
            dimension.height = 400;
            jScrollPane.setPreferredSize(dimension);
            Dimension dimension2 = jScrollPane.getSize();
            dimension2.height = 400;
            jScrollPane.setSize(dimension2);
            Dimension dimension3 = jLabel.getPreferredSize();
            dimension3.width = jComponent.getParent().getSize().width - 50;
            jLabel.setPreferredSize(dimension3);
            Dimension dimension4 = jLabel.getSize();
            dimension4.width = jComponent.getParent().getSize().width - 50;
            jLabel.setSize(dimension4);
            this.hBox = Box.createHorizontalBox();
            this.vBox.add((Component)this.hBox, "South");
            this.hBox.add(Box.createGlue());
            Box box = Box.createVerticalBox();
            ActionListener actionListener = actionEvent -> u.b().d(this);
            this.cancelButton = c.a(actionListener, props.getProperty("FRAMEDURCORR_FRAME_DURATION_TIP"));
            this.cancelButton.setText(props.getProperty("FRAMEDURCORR_FRAME_DURATION_BUTTON"));
            box.add(this.cancelButton);
            box.add(Box.createVerticalGlue());
            this.hBox.add(box);
            Box box2 = Box.createVerticalBox();
            box2.setAlignmentX(1.0f);
            this.acceptButtons = new HashMap<TimeTag, JButton>();
            for (TimeTag timeTag : this.timeDiffsMap.keySet()) {
                ActionListener actionListener2 = actionEvent -> {
                    this.updateActualFrameDurations(this.timeDiffsMap.get((Object)timeTag));
                    u.b().d(this);
                };
                JButton jButton = c.c(actionListener2, timeTag.getButtonTip());
                jButton.setText(timeTag.getButtonTitle());
                this.acceptButtons.put(timeTag, jButton);
                if (box2.getComponentCount() > 0) {
                    box2.add(Box.createVerticalStrut(5));
                }
                box2.add(jButton);
            }
            this.hBox.add(Box.createHorizontalStrut(5));
            this.hBox.add(box2);
            this.hBox.add(Box.createHorizontalGlue());
        }

        private void updateActualFrameDurations(List<Integer> list) {
            for (int i2 = 0; i2 < this.dSeries.n(); ++i2) {
                SeriesInfo seriesInfo = ((ImageVolumeShort)this.dSeries.c(i2)).getUncopiedMutableInfo();
                seriesInfo.actualFrameDuration = list.get(i2);
            }
        }

        @Override
        public JComponent getContent() {
            return this.vBox;
        }
    }

    private static enum TimeTag {
        REFERENCE_TIME(seriesInfo -> Float.valueOf(seriesInfo.frameReferenceTime)),
        ACQUISITION_TIME(seriesInfo -> Float.valueOf(seriesInfo.acqTime.getTime())),
        FRAME_TIME(seriesInfo -> Float.valueOf(seriesInfo.frameTime)),
        TRIGGER_TIME(seriesInfo -> Float.valueOf(seriesInfo.triggerTime));

        private final Function<SeriesInfo, Float> value;

        private TimeTag(Function<SeriesInfo, Float> function) {
            this.value = function;
        }

        public String getColumnTitle() {
            return props.getProperty("FRAMEDURCORR_" + this.name() + "_TITLE");
        }

        public String getButtonTitle() {
            return props.getProperty("FRAMEDURCORR_" + this.name() + "_BUTTON");
        }

        public String getButtonTip() {
            return props.getProperty("FRAMEDURCORR_" + this.name() + "_TIP");
        }

        public float getValueFor(SeriesInfo seriesInfo) {
            return this.value.apply(seriesInfo).floatValue();
        }
    }
}

