/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.commands.keyboard.bk;
import com.mimvista.commands.workflow.AssignRtImageOrientationCommand;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.dicom.read.Dicom2DLoader;
import com.mimvista.dicom.read.Dicom2DLoaderImpl;
import com.mimvista.dicom.read.DicomVolumeLoaderFactory;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTaskViewController;
import com.mimvista.dicom.read.LoadableFactory;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.internals.MimPlanarImage;
import com.mimvista.internals.PlanarImage;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ac;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.IOP;
import com.mimvista.numerics.Point3f;
import com.mimvista.preferencesNew.NukesPrefs;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.logging.MIMLogLevel;
import com.mimvista.util.logging.k;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.RTImageSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class LoadTask2D
extends LoadTaskViewController {
    private AtomicLoadUnit targetALU;
    private boolean doNotConvertTo3D;
    private static boolean doBadMIMCineVersionCheck = false;

    public LoadTask2D(LoaderDataProvider loaderDataProvider, g g2, AtomicLoadUnit atomicLoadUnit, com.mimvista.archive.o o2) {
        super(loaderDataProvider, g2, o2);
        this.targetALU = atomicLoadUnit;
    }

    public void setDoNotConvertTo3D(boolean bl2) {
        this.doNotConvertTo3D = bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoadListener.LoadEvent loadVolume() {
        void var4_9;
        Object object;
        Serializable serializable;
        Object object3;
        List<PlanarImage.a> list;
        block15: {
            if (this.getProgress().n() == Progress.Status.d || this.getProgress().n() == Progress.Status.e) {
                LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
                loadEvent.successfullyLoaded = false;
                loadEvent.vc = this.viewController;
                return loadEvent;
            }
            list = null;
            if (this.targetALU != null) {
                list = this.targetALU.getPlanarKeys();
            }
            if (this.targetALU != null && list != null) {
                object3 = Lists.newArrayList();
                for (PlanarImage.a object22 : list) {
                    serializable = (MimPlanarImage)this.targetALU.getPreviouslyLoadedImage(object22);
                    if (serializable != null) {
                        ((ArrayList)object3).add(serializable);
                        continue;
                    }
                    break block15;
                }
                object = new LoadListener.LoadEvent();
                ((LoadListener.LoadEvent)object).successfullyLoaded = true;
                ((LoadListener.LoadEvent)object).vc = this.viewController;
                this.setDataIntoLoadEventMaybeConvertingTo3D((List<MimPlanarImage>)object3, (LoadListener.LoadEvent)object);
                return object;
            }
        }
        object3 = DicomVolumeLoaderFactory.getDefault2DLoader();
        object3.load(this.getProgress(), this.dataProvider);
        try {
            this.searchForRTPlanAndFillMissingTags((Dicom2DLoader<MimPlanarImage>)object3);
        }
        catch (Exception exception) {
            ay.d((Object)"Error filling in missing RTImage values from RTplan", (Throwable)exception, this);
        }
        object = new LoadListener.LoadEvent();
        ((LoadListener.LoadEvent)object).vc = this.viewController;
        ((LoadListener.LoadEvent)object).partialSeriesInfoFromDataProvider = this.dataProvider.getUncopiedMutableInfo();
        ((LoadListener.LoadEvent)object).successfullyLoaded = object3.isSuccessfullyLoaded();
        if (!((LoadListener.LoadEvent)object).successfullyLoaded) {
            return object;
        }
        if (this.targetALU != null && list != null) {
            PlanarImage.a a22;
            Iterator iterator2;
            serializable = Maps.newHashMap();
            boolean bl2 = true;
            for (Iterator iterator2 : object3.getImages()) {
                a22 = ((PlanarImage)((Object)iterator2)).O();
                serializable.put(a22, iterator2);
                if (a22.a == null) continue;
                bl2 = false;
            }
            ArrayList arrayList = Lists.newArrayList();
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
            for (PlanarImage.a a22 : list) {
                if (bl2) {
                    a22 = new PlanarImage.a(a22.c, a22.b, null);
                }
                linkedHashSet.add(a22);
            }
            iterator2 = linkedHashSet.iterator();
            while (iterator2.hasNext()) {
                a22 = (PlanarImage.a)iterator2.next();
                MimPlanarImage mimPlanarImage = (MimPlanarImage)serializable.remove(a22);
                if (mimPlanarImage == null) {
                    ay.d((Object)("We didn't find one of the images we were expecting from this load, failing. (Metabase series/SOP id doesn't agree with what's on disk?)\n\tWe expected to find: " + a22 + " But all we have is: " + serializable.keySet()), this);
                    this.getProgress().k();
                    ((LoadListener.LoadEvent)object).successfullyLoaded = false;
                    return object;
                }
                arrayList.add(mimPlanarImage);
            }
            this.targetALU.stashAwayLoadedImagesForClones(serializable.values());
        } else {
            ArrayList arrayList = object3.getImages();
        }
        this.setDataIntoLoadEventMaybeConvertingTo3D((List<MimPlanarImage>)var4_9, (LoadListener.LoadEvent)object);
        return object;
    }

    private void searchForRTPlanAndFillMissingTags(Dicom2DLoader<MimPlanarImage> dicom2DLoader) {
        HashMap hashMap = Maps.newHashMap();
        for (MimPlanarImage mimPlanarImage : dicom2DLoader.getImages()) {
            boolean bl2;
            String string;
            boolean bl3;
            ModalitySeriesInfo modalitySeriesInfo = mimPlanarImage.getUncopiedMutableInfo().modInfo;
            if (modalitySeriesInfo == null || !(modalitySeriesInfo instanceof RTImageSeriesInfo)) continue;
            RTImageSeriesInfo rTImageSeriesInfo = (RTImageSeriesInfo)modalitySeriesInfo;
            boolean bl4 = Float.isNaN(rTImageSeriesInfo.sourceAxisDistance) || rTImageSeriesInfo.sourceAxisDistance < 1.0E-4f;
            boolean bl5 = !rTImageSeriesInfo.hasIsocenter;
            boolean bl6 = bl3 = mimPlanarImage.getUncopiedMutableInfo().origPatientPosition == null;
            if ((bl4 || bl5 || bl3) && rTImageSeriesInfo.referencedBeamNumber != null && (string = rTImageSeriesInfo.referencedRTPlanSopInstanceUID) != null && !"".equals(string) && !(bl2 = this.fillFromSessionRTplan(mimPlanarImage.getUncopiedMutableInfo(), string, bl4, bl5, bl3))) {
                this.fillFromRTplanDirect(hashMap, mimPlanarImage.getUncopiedMutableInfo(), string, bl4, bl5);
            }
            if (mimPlanarImage.getUncopiedMutableInfo().origPatientPosition != null) continue;
            ay.c((Object)"RTimage did not contain patient position information, and the information could not be found in its RTplan.", this);
        }
    }

    private boolean fillFromSessionRTplan(SeriesInfo seriesInfo, String string, boolean bl2, boolean bl3, boolean bl4) {
        RtplanSessionState rtplanSessionState;
        RTImageSeriesInfo rTImageSeriesInfo = (RTImageSeriesInfo)seriesInfo.modInfo;
        RtplanStateManager rtplanStateManager = this.getViewController().g().o().getStateObjectIfItExists(RtplanStateManager.class);
        if (rtplanStateManager != null && (rtplanSessionState = rtplanStateManager.getState(string)) != null) {
            for (ReportableRtplanState.BeamRecord beamRecord : rtplanSessionState.getBeamRecords()) {
                Object object;
                if (!rTImageSeriesInfo.referencedBeamNumber.equals(beamRecord.getRefBeamNumber())) continue;
                if (bl2) {
                    rTImageSeriesInfo.sourceAxisDistance = beamRecord.getSourceAxisDistance().getValue();
                }
                if (bl3 && (object = beamRecord.getIsocenter()) != null) {
                    rTImageSeriesInfo.isocenter = ((Point3f)((Object)object)).f();
                    rTImageSeriesInfo.hasIsocenter = true;
                }
                if (!bl4 || (object = beamRecord.getPatientPosition()) == null) break;
                seriesInfo.origPatientPosition = object;
                break;
            }
            return true;
        }
        return false;
    }

    private void fillFromRTplanDirect(Map<UIDContainer.SOPInstanceUID, DicomObject> map, SeriesInfo seriesInfo, String string, boolean bl2, boolean bl3) {
        Object object;
        SeriesParameters seriesParameters;
        SearchSource searchSource;
        RTImageSeriesInfo rTImageSeriesInfo = (RTImageSeriesInfo)seriesInfo.modInfo;
        UIDContainer.SOPInstanceUID sOPInstanceUID = new UIDContainer.SOPInstanceUID(string);
        DicomObject dicomObject2 = null;
        if (!map.containsKey(sOPInstanceUID)) {
            try {
                LoaderDataProvider loaderDataProvider;
                searchSource = this.targetALU.getSearchSource();
                seriesParameters = new SeriesParameters();
                seriesParameters.modality = "RTPLAN";
                seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{string});
                seriesParameters.searchType = 5;
                object = searchSource.a(seriesParameters);
                if (object != null && !object.isEmpty() && (loaderDataProvider = searchSource.d((DcmSeries)object.get(0))) != null) {
                    dicomObject2 = loaderDataProvider.getFirstDicomObj();
                }
            }
            catch (Exception exception) {
                ay.d((Object)"Error retrieving RTplan to fill in missing RTIMAGE tags", (Throwable)exception, this);
            }
            map.put(sOPInstanceUID, dicomObject2);
        } else {
            dicomObject2 = map.get(sOPInstanceUID);
        }
        if (dicomObject2 != null) {
            searchSource = dicomObject2.get(805961904);
            if (searchSource != null) {
                for (int i2 = 0; i2 < searchSource.countItems(); ++i2) {
                    float[] fArray;
                    DicomObject dicomObject3;
                    DicomElement dicomElement;
                    float f2;
                    int n2;
                    object = searchSource.getDicomObject(i2);
                    if (object == null || !rTImageSeriesInfo.referencedBeamNumber.equals(n2 = object.getInt(805961920, -554495177))) continue;
                    if (bl2 && !Float.isNaN(f2 = object.getFloat(805961908, Float.NaN))) {
                        rTImageSeriesInfo.sourceAxisDistance = f2;
                    }
                    if (!bl3 || (dicomElement = object.get(805962001)) == null || dicomElement.countItems() <= 0 || (dicomObject3 = dicomElement.getDicomObject(0)) == null || (fArray = dicomObject3.getFloats(805962028, (float[])null)) == null) break;
                    rTImageSeriesInfo.isocenter = (float[])fArray.clone();
                    rTImageSeriesInfo.hasIsocenter = true;
                    break;
                }
            }
            if ((seriesParameters = dicomObject2.get(805962112)) != null && seriesParameters.countItems() > 1) {
                if (searchSource == null) {
                    searchSource = dicomObject2.get(805962658);
                }
                if (searchSource != null) {
                    int n3 = IntStream.range(0, searchSource.countItems()).mapToObj(arg_0 -> ((DicomElement)searchSource).getDicomObject(arg_0)).filter(dicomObject -> dicomObject.getInt(805961920, -1) == rTImageSeriesInfo.referencedBeamNumber.intValue()).findFirst().map(dicomObject -> dicomObject.getInt(806092906, -1)).orElse(-1);
                    if (n3 >= 0) {
                        IntStream.range(0, seriesParameters.countItems()).mapToObj(arg_0 -> ((DicomElement)seriesParameters).getDicomObject(arg_0)).filter(dicomObject -> dicomObject.getInt(805962114, -1) == n3).findFirst().map(dicomObject -> dicomObject.getString(1593600, "")).map(SimpleOrientationHelper.PatientPosition::a).ifPresent(patientPosition -> {
                            seriesInfo.origPatientPosition = patientPosition;
                        });
                    }
                }
            }
        }
    }

    private void setDataIntoLoadEventMaybeConvertingTo3D(List<MimPlanarImage> list, LoadListener.LoadEvent loadEvent) {
        int[] nArray = list.get(0).a();
        String string = list.get((int)0).getUncopiedMutableInfo().frameOfRefUID;
        boolean bl2 = list.get((int)0).getUncopiedMutableInfo().missingFrameOfReference;
        boolean bl3 = this.doNotConvertTo3D;
        for (MimPlanarImage mimPlanarImage : list) {
            boolean bl4;
            bl3 |= !Arrays.equals(nArray, mimPlanarImage.a());
            bl3 |= mimPlanarImage.getUncopiedMutableInfo().samplesPerPix == 3;
            boolean bl5 = mimPlanarImage.getUncopiedMutableInfo().missingFrameOfReference;
            boolean bl6 = bl4 = bl5 && bl2;
            if (!bl4) {
                String string2 = mimPlanarImage.getUncopiedMutableInfo().frameOfRefUID;
                bl3 |= !string.equals(string2);
            }
            if (!bl3) continue;
            break;
        }
        loadEvent.series2d = new ac<List<MimPlanarImage>>(list);
        loadEvent.series2d.e();
        if (bl3) {
            return;
        }
        ViewController viewController = this.viewController;
        this.viewController = LoadableFactory.buildVCForAtomicLoadUnit(this.targetALU, viewController == null ? null : viewController.g());
        this.viewController.a(this.targetALU.getSearchSource());
        boolean bl7 = LoadTask2D.isLikelyBadMIMCine(loadEvent.series2d);
        o o2 = new o(this.viewController.g());
        o2.c(true);
        k k2 = new k();
        for (MimPlanarImage mimPlanarImage : loadEvent.series2d.h()) {
            o2.b(this.convertPlanarTo3D(mimPlanarImage, bl7, k2));
        }
        k2.a(MIMLogLevel.b, this);
        o2.c(false);
        o2.h();
        loadEvent.series2d = null;
        loadEvent.dSeries = o2;
        this.viewController.bh().a(o2);
        loadEvent.vc = this.viewController;
    }

    private boolean shouldTrustIop(SeriesInfo seriesInfo) {
        if (!(Modality.NM.isSameModality(seriesInfo.modality) || Modality.CT.isSameModality(seriesInfo.modality) || Modality.XA.isSameModality(seriesInfo.modality))) {
            return false;
        }
        if (seriesInfo.imageOrientationWasBlank) {
            return false;
        }
        if (Modality.NM.isSameModality(seriesInfo.modality)) {
            if (SeriesIdentifier.hasBeenTouchedByMayoGateway(seriesInfo)) {
                ay.a((Object)"Trusting IOP from gateway image.", this);
                return true;
            }
            List<String> list = NukesPrefs.regexModelNamesOf2DCamerasThatUnderstandIOP.getValue();
            if (seriesInfo.modelName != null) {
                String string = seriesInfo.modelName.toLowerCase();
                for (String string2 : list) {
                    Pattern pattern = Pattern.compile(string2);
                    if (!pattern.matcher(string).find()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean tryToDetermineIopForDynamicXa(ImageVolumeShort imageVolumeShort) {
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        if (Modality.XA != Modality.get(seriesInfo.modality)) {
            return false;
        }
        if (seriesInfo.priPositionerAngle == null || seriesInfo.secPositionerAngle == null || seriesInfo.priPositionerAngleInc == null || seriesInfo.secPositionerAngleInc == null) {
            return false;
        }
        int n2 = imageVolumeShort.c();
        if (n2 > seriesInfo.priPositionerAngleInc.length) {
            ay.c((Object)("Not enough elements in pri angle increment tag.  Needed at least " + (n2 + 1) + ", but got " + seriesInfo.priPositionerAngleInc.length), this);
            return false;
        }
        if (n2 > seriesInfo.secPositionerAngleInc.length) {
            ay.c((Object)("Not enough elements in sec angle increment tag.  Needed at least " + (n2 + 1) + ", but got " + seriesInfo.priPositionerAngleInc.length), this);
            return false;
        }
        float f2 = seriesInfo.priPositionerAngle.floatValue() + seriesInfo.priPositionerAngleInc[n2];
        float f3 = seriesInfo.secPositionerAngle.floatValue() + seriesInfo.secPositionerAngleInc[n2];
        IOP iOP = SimpleOrientationHelper.a(f2, f3);
        seriesInfo.overriddenIopForDisplay = IOP.b(iOP);
        return true;
    }

    private ImageVolumeShort convertPlanarTo3D(MimPlanarImage mimPlanarImage, boolean bl2, k k2) {
        int n2;
        Object object;
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort(this.viewController);
        imageVolumeShort.b(mimPlanarImage.getUncopiedMutableInfo());
        imageVolumeShort.a(mimPlanarImage.z());
        imageVolumeShort.a(mimPlanarImage.b());
        imageVolumeShort.d(true);
        imageVolumeShort.f(true);
        imageVolumeShort.a(mimPlanarImage.c());
        imageVolumeShort.a(mimPlanarImage.s());
        SliceInfo sliceInfo = new SliceInfo();
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        sliceInfo.sopInstanceUID = seriesInfo.sopInstanceUID;
        sliceInfo.sliceDicomCenter = Boolean.TRUE.equals(seriesInfo.hasImagePositionPatient) && !bl2 ? mimPlanarImage.G() : new float[3];
        boolean bl3 = !bl2 && this.shouldTrustIop(seriesInfo);
        TagPath tagPath = new TagPath(new int[]{5505058, 930295820}, new int[]{mimPlanarImage.c(), -1});
        ImmutableList<Float> immutableList = null;
        JsonDicomSeries jsonDicomSeries = seriesInfo.y();
        try {
            object = tagPath.toJsonPath();
            if (jsonDicomSeries.exists((JsonPath)object)) {
                immutableList = jsonDicomSeries.getTagValues((JsonPath)object, Float.class);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error trying to read special MIM IOP", throwable, this);
        }
        if (immutableList == null || immutableList.isEmpty()) {
            try {
                immutableList = jsonDicomSeries.getTagValues(930295820, Float.class);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error trying to read special MIM IOP", throwable, this);
            }
        }
        if (immutableList != null && !immutableList.isEmpty()) {
            object = new float[6];
            for (n2 = 0; n2 < immutableList.size(); n2 += 1) {
                object[n2] = ((Float)immutableList.get(n2)).floatValue();
            }
            seriesInfo.overriddenIopForDisplay = (float[])object;
            bl3 = true;
        }
        if (!bl3 && (object = Dicom2DLoaderImpl.tryToGuessCorrectIop(imageVolumeShort, false)) != null) {
            k2.a("Setting IOP to " + ((bk)object).getExternalizedString() + " based on DICOM tags.");
            seriesInfo.overriddenIopForDisplay = IOP.b(((bk)object).b());
            bl3 = true;
        }
        if (!bl3 && this.tryToDetermineIopForDynamicXa(imageVolumeShort)) {
            k2.a("Setting viewing IOP based on dynamic XA logic.");
            bl3 = true;
        }
        seriesInfo.imageOrientationWasBlank = !bl3;
        seriesInfo.h(bl3);
        ((SimpleImageVolume)imageVolumeShort).a(Lists.newArrayList((Object[])new SliceInfo[]{sliceInfo}));
        imageVolumeShort.a(this.targetALU.getSearchSource());
        imageVolumeShort.b(sliceInfo.sliceDicomCenter);
        if (seriesInfo.modInfo instanceof RTImageSeriesInfo) {
            object = (RTImageSeriesInfo)seriesInfo.modInfo;
            n2 = AssignRtImageOrientationCommand.canAssignOrientation(imageVolumeShort, ((RTImageSeriesInfo)object).gantryAngle) ? 1 : 0;
            seriesInfo.imageOrientationWasBlank = n2 == 0;
            seriesInfo.h(n2 != 0);
            AssignRtImageOrientationCommand.assignOrientation(imageVolumeShort, ((RTImageSeriesInfo)object).gantryAngle);
            float[] fArray = ((RTImageSeriesInfo)object).imagePlanePixelSpacing;
            float f2 = 1.0f;
            if (!Float.isNaN(((RTImageSeriesInfo)object).sourceAxisDistance)) {
                float f3 = ((RTImageSeriesInfo)object).sourceAxisDistance;
                float f4 = 0.0f;
                if (((RTImageSeriesInfo)object).sourceImageDistance != null) {
                    f4 = ((RTImageSeriesInfo)object).sourceImageDistance.floatValue();
                } else {
                    float f5 = -((RTImageSeriesInfo)object).xrayImageReceptorTranslation[2];
                    f4 = f3 + f5;
                }
                f2 = f3 / f4;
            }
            imageVolumeShort.b(((RTImageSeriesInfo)object).isocenter);
            imageVolumeShort.a(new float[]{fArray[0] * f2, fArray[1] * f2, 1.0f});
            sliceInfo.sliceDicomCenter = ((RTImageSeriesInfo)object).isocenter;
        }
        return imageVolumeShort;
    }

    private static boolean isLikelyBadMIMCine(ac<MimPlanarImage> ac2) {
        Object[] objectArray;
        Object object;
        String string = null;
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        for (MimPlanarImage mimPlanarImage : ac2) {
            if (!SeriesIdentifier.isCine(mimPlanarImage.I())) {
                return false;
            }
            JsonDicomSeries jsonDicomSeries = mimPlanarImage.I().y();
            if (jsonDicomSeries == null) {
                return false;
            }
            object = (String)mimPlanarImage.I().y().getTagValue(131091);
            if (cn.h((String)object)) {
                return false;
            }
            if (!((String)object).contains("MIM")) {
                return false;
            }
            objectArray = ((String)object).split(" ");
            if (objectArray.length < 2) {
                return false;
            }
            VersionNumber versionNumber = new VersionNumber(objectArray[1]);
            VersionNumber versionNumber2 = new VersionNumber(6, 2, 0, "");
            if (((String)object).contains("MIMviewer")) {
                versionNumber2 = new VersionNumber(3, 2, 0, "");
            }
            if (doBadMIMCineVersionCheck && !versionNumber.lessThanEqualToUpTo(versionNumber2, VersionNumberComparator.b)) {
                return false;
            }
            float[] fArray = mimPlanarImage.G();
            if (fArray == null || fArray.length != 3) {
                return false;
            }
            arrayList.add(fArray);
            if (string != null) continue;
            string = mimPlanarImage.I().toString();
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        Collections.sort(arrayList, new Comparator<float[]>(){

            @Override
            public int compare(float[] fArray, float[] fArray2) {
                return Float.compare(fArray[2], fArray2[2]);
            }
        });
        float f2 = ((float[])arrayList.get(0))[0];
        float f3 = ((float[])arrayList.get(0))[1];
        Object object2 = ((float[])arrayList.get(0))[2];
        object = arrayList.iterator();
        while (object.hasNext()) {
            objectArray = (float[])object.next();
            if (Float.compare(f2, (float)objectArray[0]) != 0 && Float.compare(f3, (float)objectArray[1]) != 0) {
                return false;
            }
            if (Float.compare(object2, (float)objectArray[2]) == 0) continue;
            float f4 = Math.abs((float)(objectArray[2] - object2));
            if (Float.compare(1.0f, f4) == 0) {
                object2 = objectArray[2];
                continue;
            }
            return false;
        }
        ay.b((Object)("Series determined to be bad MIM Cine: " + string), LoadTask2D.class);
        return true;
    }
}

