/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.commands.keyboard.r;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.BackgroundVolumeLoaderDelegate;
import com.mimvista.dicom.read.DicomVolumeLoader;
import com.mimvista.dicom.read.DicomVolumeLoaderFactory;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask2D;
import com.mimvista.dicom.read.LoadTaskViewController;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.exodus.MIM;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.MimPlanarImage;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ac;
import com.mimvista.internals.av;
import com.mimvista.internals.o;
import com.mimvista.internals.q;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.internals.x;
import com.mimvista.mimcloud.connection.d;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.Session;
import com.mimvista.mui.ao;
import com.mimvista.mui.bm;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.mui.presenters.display.p;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.viewer.SeriesInfo;
import java.awt.GraphicsEnvironment;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3i;
import org.dcm4che2.data.DicomObject;

public class LoadTask3D
extends LoadTaskViewController {
    private final ReorientationParams reorientationParams;

    public LoadTask3D(LoaderDataProvider loaderDataProvider, g g2, ReorientationParams reorientationParams, com.mimvista.archive.o o2) {
        super(loaderDataProvider, g2, o2);
        this.reorientationParams = reorientationParams.clone();
    }

    @Override
    protected LoadListener.LoadEvent loadVolume() {
        SeriesInfo seriesInfo;
        if (this.viewController == null) {
            ay.d((Object)"Null VC in load task, bad state.", this);
        }
        if ((seriesInfo = this.dataProvider.getUncopiedMutableInfo()) == null) {
            Object var2_2 = null;
            DicomObject dicomObject = null;
            if (this.dataProvider != null) {
                this.dataProvider.getFilenames();
                dicomObject = this.dataProvider.getFirstDicomObj(2145386512);
            }
            ay.d((Object)("Null sourceInfo, failure imminent. LDP: " + this.dataProvider + " Filenames: " + var2_2 + " SS: " + this.viewController.bJ() + " VC: " + this.viewController + " First DOB: " + dicomObject), this);
        }
        boolean bl2 = Modality.US.isSameModality(seriesInfo.modality) && "1.2.840.10008.5.1.4.1.1.6.1".equals(seriesInfo.sopClassUID);
        boolean bl3 = "1.2.840.10008.5.1.4.1.1.3.1".equals(seriesInfo.sopClassUID);
        if (bl2 && !bl3) {
            return this.loadUSVolumeAs3D();
        }
        DicomVolumeLoader dicomVolumeLoader = DicomVolumeLoaderFactory.getDefaultDicomVolumeLoader(this.viewController.g());
        dicomVolumeLoader.setDataProvider(this.dataProvider);
        x x2 = DicomVolumeLoaderFactory.getDefaultLoaderPrefs(this.viewController.g());
        if (this.reorientationParams.isForcingSomething()) {
            x2.e.set(this.reorientationParams);
            if (x2.e.ask != ReorientationParams.AskReorientPref.AskAlways) {
                x2.e.ask = ReorientationParams.AskReorientPref.DoNotAsk;
            }
            x2.h = this.params;
        }
        if (this.reorientationParams.askAboutGantryTilt != null) {
            x2.e.askAboutGantryTilt = this.reorientationParams.askAboutGantryTilt;
        }
        if (this.reorientationParams.gantryAnswer != null) {
            x2.e.gantryAnswer = this.reorientationParams.gantryAnswer;
        }
        dicomVolumeLoader.setLoaderPrefs(x2);
        if (!seriesInfo.S() && MIMContext.j() && d.s()) {
            dicomVolumeLoader.setBackgroundLoaderDelegate(new MIMBackgroundLoaderDelegate());
        }
        try {
            dicomVolumeLoader.load(this.getProgress());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ay.d((Object)illegalArgumentException, this);
        }
        if (dicomVolumeLoader.isSuccessfullyLoaded()) {
            LoadTask3D.correct(dicomVolumeLoader.getDynamicSeries().e(), seriesInfo);
        }
        LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
        loadEvent.vc = this.viewController;
        loadEvent.partialSeriesInfoFromDataProvider = seriesInfo;
        loadEvent.successfullyLoaded = dicomVolumeLoader.isSuccessfullyLoaded();
        if (loadEvent.successfullyLoaded) {
            loadEvent.dSeries = dicomVolumeLoader.getDynamicSeries();
        }
        return loadEvent;
    }

    private LoadListener.LoadEvent loadUSVolumeAs3D() {
        LoadTask2D loadTask2D = new LoadTask2D(this.dataProvider, new com.mimvista.util.progress.o(), null, this.params);
        loadTask2D.setDoNotConvertTo3D(true);
        LoadListener.LoadEvent loadEvent = loadTask2D.loadVolume();
        Session session = bm.g();
        av av2 = (av)LoadTask3D.load2D(loadEvent, session);
        o o2 = LoadTask3D.convertViewController2DToDynamicSeries(av2, this.viewController.g(), this.getProgress());
        LoadListener.LoadEvent loadEvent2 = new LoadListener.LoadEvent();
        if (o2 != null && this.getProgress().n() != Progress.Status.e) {
            loadEvent2.successfullyLoaded = true;
            loadEvent2.dSeries = o2;
        }
        loadEvent2.partialSeriesInfoFromDataProvider = this.dataProvider.getUncopiedMutableInfo();
        loadEvent2.vc = this.viewController;
        av2.ac();
        this.getProgress().b();
        return loadEvent2;
    }

    public static o convertViewController2DToDynamicSeries(av av2, Session session, g g2) {
        ImageVolumeShort imageVolumeShort;
        Object object;
        String string = av2.getUncopiedMutableInfo().ag();
        if (GraphicsEnvironment.isHeadless() || MIM.isHeadless()) {
            object = r.a(av2, session, new Float(5.0f));
            imageVolumeShort = r.a(av2, ((r.a)object).a, ((r.a)object).b, g2);
        } else {
            imageVolumeShort = r.a(av2, session, g2);
        }
        if (imageVolumeShort == null) {
            return null;
        }
        imageVolumeShort.getUncopiedMutableInfo().j(string);
        imageVolumeShort.getUncopiedMutableInfo().needsNewSeriesUID = true;
        object = new o(session);
        ((q)object).b(imageVolumeShort);
        return object;
    }

    public static ViewController load2D(LoadListener.LoadEvent loadEvent, Session session) {
        ViewController viewController = loadEvent.vc;
        if (viewController == null) {
            ac<MimPlanarImage> ac2 = loadEvent.series2d;
            av av2 = new av();
            av2.a(ac2);
            av2.d((ImageFrame)ac2.a(0));
            session.a((ViewController)av2, (ViewLoadState)null);
            av2.a(session);
            return av2;
        }
        if (viewController instanceof av) {
            ((av)viewController).a(loadEvent.series2d);
        }
        viewController.d(viewController.aE());
        session.a(viewController, (ViewLoadState)null);
        viewController.a(session);
        return loadEvent.vc;
    }

    private static void correct(ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo) {
        LoadTask3D.checkForAndApplyHawkeyeAdjustment(imageVolumeShort, seriesInfo);
    }

    private static void checkForAndApplyHawkeyeAdjustment(ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo) {
        boolean bl2;
        boolean bl3 = bl2 = seriesInfo.manufacturer.toLowerCase().contains("ge medical systems") && !seriesInfo.manufacturer.toLowerCase().contains("mim software") && seriesInfo.modelName.toLowerCase().contains("infinia") && seriesInfo.softwareVersions.contains("2.105.030.11");
        if (bl2 && DicomPrefs.promptForHawkeye.getValue().booleanValue()) {
            if (!MIMContext.P() && DicomPrefs.promptForGeHawkeyeOrientation.getValue().booleanValue()) {
                String string = Messages.a("Dicom").getProperty("HAWKEYE_ORIENTATION_WARNING");
                String string2 = Messages.a("Dicom").getProperty("HAWKEYE_ORIENTATION_TITLE");
                int n2 = MOptionPane.a(ao.S(), string, string2, 0, 2, null, null, null);
                if (n2 == 1) {
                    return;
                }
            }
            ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).f();
            seriesInfo.origPatientPosition = SimpleOrientationHelper.PatientPosition.a;
            seriesInfo.origImageOrientation = SimpleOrientationHelper.PatientPosition.a.a();
            seriesInfo.imageOrientation = SimpleOrientationHelper.PatientPosition.a.a();
        }
    }

    private class MIMBackgroundLoaderDelegate
    extends BackgroundVolumeLoaderDelegate {
        private MIMBackgroundLoaderDelegate() {
        }

        @Override
        public boolean shouldBackgroundLoad() {
            return true;
        }

        @Override
        public void loadingFinished() {
            this.dataWasUpdated(this.getCurrentVolume());
        }

        @Override
        public SimpleImageVolume<ImageCube.ImageCubeShort> getCurrentVolume() {
            if (LoadTask3D.this.viewController.bh().cE() == null) {
                return null;
            }
            ImageVolumeShort imageVolumeShort = LoadTask3D.this.viewController.bh().cx();
            return imageVolumeShort;
        }

        @Override
        public void dataWasUpdated(SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume) {
            if (simpleImageVolume == this.getCurrentVolume()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (ViewController viewController : p.l(LoadTask3D.this.viewController)) {
                            viewController.bz();
                        }
                        for (ViewController viewController : p.m(LoadTask3D.this.viewController)) {
                            viewController.bz();
                        }
                        LoadTask3D.this.viewController.bz();
                        LoadTask3D.this.viewController.g().Q();
                    }
                });
            }
        }

        @Override
        public Point3i getCurrentLocalizedVoxelPoint() {
            try {
                VoxelIndexPoint3f voxelIndexPoint3f = LoadTask3D.this.viewController.bc().b().c();
                return new Point3i((int)voxelIndexPoint3f.x, (int)voxelIndexPoint3f.y, (int)voxelIndexPoint3f.z);
            }
            catch (Exception exception) {
                return super.getCurrentLocalizedVoxelPoint();
            }
        }

        @Override
        public boolean shouldStopLoading() {
            return LoadTask3D.this.viewController.aU();
        }

        @Override
        public int getBonusPoints() {
            try {
                Session session = LoadTask3D.this.viewController.g();
                if (!session.ag()) {
                    return 0;
                }
                boolean bl2 = false;
                boolean bl3 = false;
                block2: for (ViewController viewController : session.ac().e()) {
                    if (viewController.aS() == LoadTask3D.this.viewController) {
                        bl2 = true;
                        for (ViewPort viewPort : viewController.aZ()) {
                            if (viewPort.L().U() != PresentationType.f) continue;
                            bl3 = true;
                            break block2;
                        }
                    }
                    if (!viewController.U()) continue;
                    s s2 = (s)viewController;
                    if (s2.V().aS() == LoadTask3D.this.viewController) {
                        bl2 = true;
                    }
                    if (s2.W().aS() != LoadTask3D.this.viewController) continue;
                    bl2 = true;
                }
                if (bl3) {
                    return 10;
                }
                if (bl2) {
                    return 1;
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)"Checking if visible", throwable, this);
            }
            return 0;
        }
    }
}

