/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.workflow.dose.DoseHideShowCommand;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.DicomVolumeLoaderFactory;
import com.mimvista.dicom.read.DoseFrameSelectNotification;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.dicom.rtdose.DoseOrientationCorrector;
import com.mimvista.dicom.rtdose.DoseRefFinder;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtplan.DicomRtPlan;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.dose.bed.BEDSerializationUtil;
import com.mimvista.dose.bed.ui.BEDIsodoseOverlay;
import com.mimvista.exodus.MIM;
import com.mimvista.gui.util.MockDialogPanel;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.internals.x;
import com.mimvista.mui.Session;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.state.VolumeSourceInfo;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.m;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.g;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class LoadTaskRtDose
extends LoadTask {
    private final Session session;
    private final SearchSource loadedFrom;
    private boolean autoApplyDoseCorrection = false;
    private String manualSeriesUID = null;

    public LoadTaskRtDose(Session session, LoaderDataProvider loaderDataProvider, SearchSource searchSource, g g2, com.mimvista.archive.o o2) {
        super(loaderDataProvider, g2, o2);
        this.session = session;
        this.loadedFrom = searchSource;
    }

    public void setParentUid(String string) {
        this.manualSeriesUID = string;
    }

    public void setAutoApplyDoseCorrection(boolean bl2) {
        this.autoApplyDoseCorrection = bl2;
    }

    @Override
    public JsonDicomBundle getDicomBundleForExtensions() {
        return null;
    }

    @Override
    protected LoadListener.LoadEvent loadVolume() {
        LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
        loadEvent.partialSeriesInfoFromDataProvider = this.dataProvider.getUncopiedMutableInfo();
        try {
            loadEvent.successfullyLoaded = this.loadRTDose();
            if (loadEvent.successfullyLoaded) {
                this.fireLoadFinished(loadEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loadEvent.successfullyLoaded = false;
        }
        return loadEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadRTDose() {
        g g2 = this.getProgress();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DicomObject dicomObject = this.dataProvider.getFirstDicomObj();
            if (dicomObject == null) {
                ay.d((Object)"No DICOM files found for RTDose, cannot load RTDose", this);
                boolean bl2 = false;
                return bl2;
            }
            DoseRefFinder.DoseLoadTarget doseLoadTarget = null;
            if (this.manualSeriesUID == null) {
                doseLoadTarget = DoseRefFinder.findRefVC(this.session, dicomObject, this.dataProvider.getUncopiedMutableInfo());
            } else {
                object4 = DoseRefFinder.findVolBySeriesUid(this.session, Sets.newHashSet((Object[])new String[]{this.manualSeriesUID}));
                if (object4 != null) {
                    doseLoadTarget = new DoseRefFinder.DoseLoadTarget((DynamicVolumeRef)object4);
                }
            }
            object4 = dicomObject.getString(0x200052, "");
            if (doseLoadTarget == null) {
                ay.d((Object)("Series referenced by RTDose " + dicomObject.getString(0x20000E) + " does not appear to be loaded. Cannot load RTDose."), this);
                boolean bl3 = false;
                return bl3;
            }
            if (!((String)object4).equals(doseLoadTarget.tgtVc.getUncopiedMutableInfo().frameOfRefUID)) {
                object3 = Messages.a("Dicom");
                if (!MIM.isHeadless()) {
                    object2 = new MockDialogPanel(((Messages)object3).b("LOADTASK_RTDOSE_NON_MATCHING_FOR"), MockDialogPanel.OptionType.a, BasicNotification.NotificationType.b, null, null, null);
                    ((MockDialogPanel)object2).a(((Messages)object3).b("LOADTASK_RTDOSE_NON_MATCHING_FOR_TITLE"));
                    object = new m((MockDialogPanel)object2);
                    u.b().c((Notification)object);
                } else {
                    ay.d((Object)((Messages)object3).getProperty("LOADTASK_RTDOSE_NON_MATCHING_FOR"), LoadTaskRtDose.class);
                }
            }
            if (dicomObject.vm(2145386512) <= 0) {
                object3 = Messages.a("Dicom");
                if (!MIM.isHeadless()) {
                    object2 = new MockDialogPanel(((Messages)object3).b("LOADTASK_RTDOSE_NO_PIXEL"), MockDialogPanel.OptionType.a, BasicNotification.NotificationType.b, null, null, null);
                    ((MockDialogPanel)object2).a(((Messages)object3).b("LOADTASK_RTDOSE_ACCURAY_BAD_DOSE_FIX_TITLE"));
                    object = new m((MockDialogPanel)object2);
                    u.b().c((Notification)object);
                } else {
                    ay.d((Object)((Messages)object3).getProperty("LOADTASK_RTDOSE_NO_PIXEL"), LoadTaskRtDose.class);
                }
                boolean bl4 = false;
                return bl4;
            }
            object3 = DicomVolumeLoaderFactory.getDefaultDicomVolumeLoader(this.session);
            object2 = new x();
            ((x)object2).a = false;
            ((x)object2).e.ask = ReorientationParams.AskReorientPref.DoNotAsk;
            ((x)object2).e.reorient = ReorientationParams.ReorientPref.DoNotReorient;
            ((x)object2).d = false;
            ((x)object2).c = this.session.T();
            object3.setLoaderPrefs((x)object2);
            object3.setDataProvider(this.dataProvider);
            object3.load(g2);
            if (object3.isSuccessfullyLoaded()) {
                object = object3.getDynamicSeries().e();
                this.postProcessLoadedDose(dicomObject, (ImageVolumeShort)object, doseLoadTarget.tgtVc);
                ((RTDoseSeriesInfo)((SimpleImageVolume)object).getUncopiedMutableInfo().modInfo).b = ((RTDoseSeriesInfo)this.dataProvider.getUncopiedMutableInfo().modInfo).b;
                boolean bl5 = LoadTaskRtDose.createAndAddIsodoseOverlay((ImageVolumeShort)object, doseLoadTarget);
                return bl5;
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error loading RTdose", (Throwable)exception, this);
        }
        finally {
            g2.b();
        }
        return false;
    }

    private void setRxDoseToDoseMax(ImageVolumeShort imageVolumeShort) {
        float f2 = imageVolumeShort.b(Math.round(imageVolumeShort.ai()));
        this.setRxDoseToValue(imageVolumeShort, RTDoseSeriesInfo.RxType.MAX, f2);
    }

    private void setRxDoseToValue(ImageVolumeShort imageVolumeShort, RTDoseSeriesInfo.RxType rxType, float f2) {
        RTDoseSeriesInfo.RxDose rxDose;
        DoseValue doseValue = new DoseValue();
        doseValue.setValueInGy(f2);
        ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).curDose = rxDose = new RTDoseSeriesInfo.RxDose(doseValue, rxType);
        ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).origDose = rxDose.k();
    }

    private void postProcessLoadedDose(DicomObject dicomObject, ImageVolumeShort imageVolumeShort, ViewController viewController) {
        Object object;
        Object object2;
        if (!(imageVolumeShort.getUncopiedMutableInfo().modInfo instanceof RTDoseSeriesInfo)) {
            imageVolumeShort.getUncopiedMutableInfo().modInfo = new RTDoseSeriesInfo(dicomObject);
        }
        VolumeSourceInfo volumeSourceInfo = imageVolumeShort.D();
        volumeSourceInfo.a(false);
        volumeSourceInfo.a(this.loadedFrom);
        this.setRxDoseToDoseMax(imageVolumeShort);
        if ((((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).referencedSeriesUID == null || ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).referencedSeriesUID.length() == 0) && (object2 = DoseRefFinder.findReferencedStructureSet(dicomObject, imageVolumeShort, viewController)) != null && (object = ((DcmSeries)object2).getDataProvider().getFirstDicomObj()).getString(524310).equals("1.2.840.10008.5.1.4.1.1.481.3")) {
            ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).referencedSeriesUID = object.getString(new int[]{805699600, 0, 805699602, 0, 805699604, 0, 0x20000E}, "");
        }
        try {
            this.retrieveDataFromRTplan(dicomObject, imageVolumeShort, viewController);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Couldn't read info from RTplan", throwable);
            throwable.printStackTrace();
        }
        this.setRxDoseFromMIMPrivateTag(dicomObject, imageVolumeShort);
        this.setRxDoseForARTAssistProcessing(imageVolumeShort, viewController);
        if (imageVolumeShort.getUncopiedMutableInfo().acqDate == null) {
            imageVolumeShort.getUncopiedMutableInfo().acqDate = viewController.getUncopiedMutableInfo().j();
        }
        DoseOrientationCorrector.correct(imageVolumeShort, viewController, this.autoApplyDoseCorrection);
        imageVolumeShort.a(MatrixMultiplier.b());
        object2 = dicomObject.getString(930304000, (String)null);
        if (object2 != null) {
            imageVolumeShort.getUncopiedMutableInfo().extraInfo.put("BED ALGORITHM INFO", (String)object2);
            object = imageVolumeShort.getUncopiedMutableInfo().u();
            ((UnitHelper)object).a("BED");
        }
        viewController.g().q().e(imageVolumeShort, viewController.aw(), false);
        imageVolumeShort.a(this.loadedFrom);
    }

    private void retrieveDataFromRTplan(DicomObject dicomObject, ImageVolumeShort imageVolumeShort, ViewController viewController) {
        Cloneable cloneable;
        Object object;
        Object object2;
        List<Object> list = Lists.newArrayList();
        DicomObject dicomObject2 = null;
        DicomElement dicomElement = dicomObject.get(806092802);
        if (dicomElement != null) {
            object2 = dicomElement.getDicomObject().getString(528725);
            object = RtplanStateManager.getForSession(this.session).getState((String)object2);
            if (object != null) {
                list = ((DicomRtPlan)object).getAllRxDoses();
                dicomObject2 = ((DicomRtPlan)object).getDicomObject();
            } else {
                DicomElement dicomElement2;
                cloneable = DoseRefFinder.findReferencedRTPlan(dicomObject, imageVolumeShort, viewController);
                if (cloneable != null && (dicomElement2 = (dicomObject2 = ((DcmSeries)cloneable).getDataProvider().getFirstDicomObj()).get(805961744)) != null) {
                    list = RtplanSessionState.parseRxDoses(dicomObject2);
                }
            }
        }
        if (!list.isEmpty() && imageVolumeShort.getUncopiedMutableInfo().modInfo != null && imageVolumeShort.getUncopiedMutableInfo().modInfo instanceof RTDoseSeriesInfo) {
            object2 = (RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo;
            object = list.iterator();
            while (object.hasNext()) {
                cloneable = (RTDoseSeriesInfo.RxDose)object.next();
                if (((RTDoseSeriesInfo.RxDose)cloneable).h()) {
                    this.setRxDoseToValue(imageVolumeShort, RTDoseSeriesInfo.RxType.PRESCRIPTION, ((RTDoseSeriesInfo.RxDose)cloneable).c().getValueInGy());
                }
                ((RTDoseSeriesInfo)object2).a((RTDoseSeriesInfo.RxDose)cloneable);
            }
        }
        if (dicomObject2 != null) {
            object2 = new StringBuilder(imageVolumeShort.getUncopiedMutableInfo().seriesDesc);
            this.appendIfNotPresent((StringBuilder)object2, dicomObject2.getString(0x300A0003, ""), imageVolumeShort.getUncopiedMutableInfo().doseComment);
            this.appendIfNotPresent((StringBuilder)object2, dicomObject2.getString(805961730, ""), imageVolumeShort.getUncopiedMutableInfo().doseComment);
            this.appendIfNotPresent((StringBuilder)object2, dicomObject2.getString(805961732, ""), imageVolumeShort.getUncopiedMutableInfo().doseComment);
            this.appendIfNotPresent((StringBuilder)object2, dicomObject2.getString(528446, ""), imageVolumeShort.getUncopiedMutableInfo().doseComment);
            imageVolumeShort.getUncopiedMutableInfo().seriesDesc = ((StringBuilder)object2).toString();
            if (imageVolumeShort.getUncopiedMutableInfo().acqDate == null && (object = dicomObject2.getDate(524321, dicomObject2.getDate(524322, dicomObject2.getDate(805699592, dicomObject2.getDate(524320, dicomObject2.getDate(524323, dicomObject2.getDate(805961734))))))) != null) {
                imageVolumeShort.getUncopiedMutableInfo().acqDate = (Date)((Date)object).clone();
            }
        }
    }

    private void appendIfNotPresent(StringBuilder stringBuilder, String string, String string2) {
        if (!cn.h(string) && stringBuilder.indexOf(string) == -1 && !string2.contains(string)) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
    }

    private void setRxDoseFromMIMPrivateTag(DicomObject dicomObject, ImageVolumeShort imageVolumeShort) {
        String string;
        RTDoseSeriesInfo.RxType rxType = null;
        Float f2 = null;
        String string2 = dicomObject.getString(930283808, (String)null);
        if (!cn.g(string2)) {
            try {
                rxType = RTDoseSeriesInfo.RxType.valueOf(string2);
            }
            catch (Throwable throwable) {
                ay.e("Unknown Rx Dose type: " + string2);
            }
        }
        if (!cn.g(string = dicomObject.getString(930283810, (String)null))) {
            try {
                f2 = Float.valueOf(Float.parseFloat(string));
            }
            catch (Throwable throwable) {
                ay.e("Unparseable Rx Dose value: " + string);
            }
        }
        if (rxType != null && f2 != null) {
            if (rxType == RTDoseSeriesInfo.RxType.MAX) {
                this.setRxDoseToDoseMax(imageVolumeShort);
            } else {
                this.setRxDoseToValue(imageVolumeShort, rxType, f2.floatValue());
            }
        }
    }

    private void setRxDoseForARTAssistProcessing(ImageVolumeShort imageVolumeShort, ViewController viewController) {
        if (MIMContext.r()) {
            Session session = viewController.g();
            Pair<RTDoseSeriesInfo.RxType, Float> pair = session.a(new UIDContainer.SOPInstanceUID(imageVolumeShort.getUncopiedMutableInfo().sopInstanceUID));
            if (pair != null) {
                RTDoseSeriesInfo.RxType rxType = (RTDoseSeriesInfo.RxType)((Object)pair.x);
                try {
                    ay.b((Object)("Setting ART Assist planning dose prescription: " + pair.toString()), this);
                    if (rxType == RTDoseSeriesInfo.RxType.MAX) {
                        this.setRxDoseToDoseMax(imageVolumeShort);
                    }
                    Float f2 = (Float)pair.y;
                    if (f2 != null) {
                        this.setRxDoseToValue(imageVolumeShort, rxType, f2.floatValue());
                    }
                    throw new IllegalArgumentException("Misconfigured Prescription Dose setting - type is not MAX but no prescription value was specified.");
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Error setting ART Assist Prescription dose.", throwable);
                }
            } else {
                ay.c((Object)"Loaded an RTDOSE while running ART Assist but didn't find Prescription Dose info!", this);
            }
        }
    }

    public static boolean createAndAddIsodoseOverlay(ImageVolumeShort imageVolumeShort, DoseRefFinder.DoseLoadTarget doseLoadTarget) {
        List<ImageVolumeShort> list;
        String string = imageVolumeShort.I().extraInfo.get("BED ALGORITHM INFO");
        BEDSerializationUtil.AppliedAlgorithmInfo appliedAlgorithmInfo = null;
        if (string != null) {
            appliedAlgorithmInfo = BEDSerializationUtil.a(string);
        }
        ArrayList arrayList = Lists.newArrayList();
        if (doseLoadTarget.tgtVol == null) {
            if (!doseLoadTarget.tgtVc.bi()) {
                ay.d((Object)"Can't load a dose onto dynamic 2D without a definite frame match.", LoadTaskRtDose.class);
                return false;
            }
            ViewController3D viewController3D = doseLoadTarget.tgtVc.bh();
            o o2 = viewController3D.cE();
            if (o2.n() == 1) {
                arrayList.add(o2.c(0));
            } else {
                Object object = new DoseFrameSelectNotification(viewController3D);
                list = ((DoseFrameSelectNotification)object).getFrame(imageVolumeShort);
                if (list != null) {
                    arrayList.addAll(list);
                } else if (((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).b != null && ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).b.get() != null) {
                    arrayList.add((ImageFrame)((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).b.get());
                } else {
                    ay.b((Object)"User did not select any frames, dose will not be loaded!", LoadTaskRtDose.class);
                }
            }
        } else {
            arrayList.add(doseLoadTarget.tgtVol);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        boolean bl2 = true;
        for (Object object : arrayList) {
            list = null;
            list = appliedAlgorithmInfo != null ? new BEDIsodoseOverlay(appliedAlgorithmInfo, doseLoadTarget.tgtVc, (ImageFrame)object, imageVolumeShort) : new IsodoseOverlay(doseLoadTarget.tgtVc, (ImageFrame)object, imageVolumeShort, bl2);
            object.n().a((Overlayish)((Object)list), false);
            if (!bl2) {
                DoseHideShowCommand doseHideShowCommand = new DoseHideShowCommand(doseLoadTarget.tgtVc, (IsodoseOverlay)((Object)list), true);
                doseHideShowCommand.execute();
            }
            bl2 = false;
        }
        return true;
    }
}

