/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.o;
import com.mimvista.brachytherapy.d;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.dicom.read.DicomRTplanReader;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.internals.BrachyLdrPlanReader;
import com.mimvista.internals.ViewController;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.k;
import com.mimvista.license.q;
import com.mimvista.mui.Session;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.g;
import com.mimvista.viewer.RTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.util.HashMap;
import java.util.List;
import org.dcm4che2.data.DicomObject;

public class LoadTaskRtPlan
extends LoadTask {
    private Session session;
    private HashMap<String, String> references;
    private boolean loadedOnReferencedSeries;
    public ViewController vc;
    public ViewController srcVc;
    public ViewController destVc;
    private DicomObject dicom;
    private SeriesInfo rtPlan;
    private RTSeriesInfo modInfo;
    private String refdSeriesUID;
    private BrachyLdrPlanReader rtPlanLoader;
    private boolean tryAddingSlicesForIntra;

    public static void preventReorientationOfReslicedSeries(AtomicLoadUnit atomicLoadUnit, List<AtomicLoadUnit> list, List<AtomicLoadUnit> list2) {
        String string;
        SeriesInfo seriesInfo = atomicLoadUnit.getDataProvider().getUncopiedMutableInfo();
        if (seriesInfo != null && seriesInfo.modInfo instanceof RTSeriesInfo && (string = ((RTSeriesInfo)seriesInfo.modInfo).rtPlanBrachyResliceVector) != null) {
            String string2 = ((RTSeriesInfo)seriesInfo.modInfo).referencedRtStructUID;
            HashMap<String, String> hashMap = atomicLoadUnit.getSeries().getRtPlanMap();
            String string3 = (String)hashMap.get(string2);
            if (!cn.g(string3)) {
                AtomicLoadUnit atomicLoadUnit2 = null;
                for (AtomicLoadUnit atomicLoadUnit3 : list) {
                    if (atomicLoadUnit3 == null || atomicLoadUnit3.getSeriesUid() == null || !string3.equals(atomicLoadUnit3.getSeriesUid().uid)) continue;
                    atomicLoadUnit2 = atomicLoadUnit3;
                    break;
                }
                for (AtomicLoadUnit atomicLoadUnit3 : list2) {
                    if (atomicLoadUnit3 == null || atomicLoadUnit3.getSeriesUid() == null || !string3.equals(atomicLoadUnit3.getSeriesUid().uid) && (atomicLoadUnit2 == null || !atomicLoadUnit3.getSeries().equals(atomicLoadUnit2.getSeries()))) continue;
                    atomicLoadUnit3.getReorientationParams().reorient = ReorientationParams.ReorientPref.DoNotReorient;
                    break;
                }
            }
        }
    }

    public LoadTaskRtPlan(HashMap<String, String> hashMap, Session session, LoaderDataProvider loaderDataProvider, g g2, boolean bl2, o o2) {
        super(loaderDataProvider, g2, o2);
        this.loadedOnReferencedSeries = bl2;
        this.session = session;
        this.references = hashMap;
        this.dicom = loaderDataProvider.getFirstDicomObj();
        this.rtPlan = loaderDataProvider.getUncopiedMutableInfo();
        this.modInfo = (RTSeriesInfo)this.rtPlan.modInfo;
        if (this.references != null) {
            this.refdSeriesUID = this.references.get(this.rtPlan.ag());
        }
        if (this.refdSeriesUID == null && this.modInfo != null) {
            this.refdSeriesUID = this.modInfo.referencedSeriesUID;
        }
        this.tryAddingSlicesForIntra = false;
    }

    @Override
    public LoadListener.LoadEvent loadVolume() {
        return this.loadVolume(true);
    }

    public LoadListener.LoadEvent loadVolume(boolean bl2) {
        LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
        try {
            if (this.dicom != null) {
                this.fillDicomHolderForExtensions(new JsonDicomBundle(this.dicom));
            }
            loadEvent.successfullyLoaded = this.loadRTplan(bl2);
        }
        catch (Exception exception) {
            ay.d((Object)"Error loading RTPlan", (Throwable)exception, this.getClass());
            loadEvent.successfullyLoaded = false;
        }
        return loadEvent;
    }

    @Override
    public JsonDicomBundle getDicomBundleForExtensions() {
        return this.getContentsOfDicomHolderForExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRTplan(boolean bl2) {
        boolean bl3;
        try {
            Object object;
            if (this.vc == null) {
                if (this.refdSeriesUID == null) {
                    if (BrachyLdrPlanReader.a(this.dicom)) {
                        if (this.session.af().size() == 0) {
                            boolean bl4 = false;
                            return bl4;
                        }
                        ViewController viewController = this.session.af().get(0);
                        if (this.destVc == null) {
                            this.destVc = viewController;
                        }
                        BrachyLdrPlanReader brachyLdrPlanReader = new BrachyLdrPlanReader(viewController, this.srcVc, this.destVc, this.dicom, bl2, this.tryAddingSlicesForIntra);
                        brachyLdrPlanReader.a(this.getProgress());
                        if (brachyLdrPlanReader.a()) {
                            LoadTaskRtPlan.displaySeedsOffVolumeWarning(viewController);
                        }
                        if (brachyLdrPlanReader.b()) {
                            LoadTaskRtPlan.displayTemplateMismatchError(viewController);
                        }
                        boolean bl5 = true;
                        return bl5;
                    }
                    ay.d((Object)("No referenced series for RTplan " + this.rtPlan.ag() + " found. Cannot load RTplan"), this);
                    boolean bl6 = false;
                    return bl6;
                }
                boolean bl7 = this.findVC();
                if (!bl7) {
                    boolean bl8 = false;
                    return bl8;
                }
            }
            if (BrachyLdrPlanReader.a(this.dicom)) {
                object = new boolean[1];
                LicenseTransformer.runLicensed(new k((boolean[])object){
                    final /* synthetic */ boolean[] val$licensed;
                    {
                        this.val$licensed = blArray;
                    }

                    @Override
                    @q(b="Load Brachytherapy LDR RTplan", a={LicenseOption.BRACHYTHERAPY})
                    public void run() {
                        this.val$licensed[0] = true;
                    }
                });
                if (object[0] == false && !BrachyLdrPlanReader.b(this.dicom)) {
                    this.displayNotLicensedWarning();
                    boolean bl9 = false;
                    return bl9;
                }
                bl3 = this.isLoadingSecondPlan();
                if (bl3 && this.loadedOnReferencedSeries) {
                    BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, Messages.a("Brachytherapy").getProperty("SYMPHONY_ERROR_LOAD_PLAN_ON_PLAN"), new Notification.a(this.session));
                    u.b().c(basicNotification);
                    boolean bl10 = false;
                    return bl10;
                }
                if (this.srcVc == null) {
                    boolean bl11 = this.findSrcVcAndCheckVc();
                    if (bl11) {
                        boolean bl12 = false;
                        return bl12;
                    }
                    if (this.srcVc == null) {
                        this.srcVc = this.vc;
                    }
                }
                if (this.destVc == null) {
                    this.destVc = this.vc;
                }
                this.rtPlanLoader = new BrachyLdrPlanReader(this.vc, this.srcVc, this.destVc, this.dicom, this.loadedOnReferencedSeries, this.tryAddingSlicesForIntra);
                this.rtPlanLoader.a(this.getProgress());
                this.rtPlanLoader.c();
                if (this.rtPlanLoader.a()) {
                    LoadTaskRtPlan.displaySeedsOffVolumeWarning(this.vc);
                }
                if (this.rtPlanLoader.b()) {
                    LoadTaskRtPlan.displayTemplateMismatchError(this.vc);
                }
            } else {
                object = new DicomRTplanReader(this.vc, this.dicom);
                ((DicomRTplanReader)object).load(this.getProgress());
            }
            boolean bl13 = true;
            return bl13;
        }
        catch (Exception exception) {
            ay.d((Object)"Error loading rtplan", (Throwable)exception, this.getClass());
            bl3 = true;
            return bl3;
        }
        finally {
            this.getProgress().b();
        }
    }

    private void displayNotLicensedWarning() {
        String string = Messages.a("Brachytherapy").getProperty("VOL_LOAD_PLAN_NO_LICENSE");
        if (MIMContext.P()) {
            ay.c((Object)string, LoadTaskRtPlan.class);
        } else {
            BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.a, string, new Notification.a(this.vc));
            u.b().c(basicNotification);
        }
    }

    private boolean isLoadingSecondPlan() {
        if (BrachySidePanel.v(this.session) == null || BrachySidePanel.v(this.session).g() == null) {
            return false;
        }
        String string = BrachySidePanel.v(this.session).g().aP().ag();
        boolean bl2 = false;
        if (string != null) {
            for (String string2 : this.references.values()) {
                if (cn.g(string2) || !string2.equals(string)) continue;
                for (ViewController viewController : this.session.af()) {
                    if (!string2.equalsIgnoreCase(viewController.aP().ag())) continue;
                    bl2 = true;
                }
            }
        }
        return !bl2;
    }

    public static void displayTemplateMismatchError(ViewController viewController) {
        String string = Messages.a("Brachytherapy").getProperty("VOL_LOAD_PLAN_TEMPLATE_MISMATCH");
        if (MIMContext.P()) {
            ay.c((Object)string, LoadTaskRtPlan.class);
        } else {
            BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.a, string, new Notification.a(viewController));
            u.b().c(basicNotification);
        }
    }

    public static void displaySeedsOffVolumeWarning(ViewController viewController) {
        String string = Messages.a("Brachytherapy").getProperty("VOL_LOAD_PLAN_SEEDS_OFF_VOLUME_WARNING");
        if (MIMContext.P()) {
            ay.c((Object)string, LoadTaskRtPlan.class);
        } else {
            BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, string, new Notification.a(viewController));
            u.b().c(basicNotification);
        }
    }

    public d getRtPlanState() {
        return this.rtPlanLoader.c();
    }

    public boolean findVC() {
        for (ViewController viewController : this.session.af()) {
            if (!this.refdSeriesUID.equals(viewController.getUncopiedMutableInfo().ag())) continue;
            this.vc = viewController;
            return true;
        }
        ay.d((Object)("Series referenced by RTplan " + this.refdSeriesUID + " not found. Cannot load RTplan: " + this.rtPlan.ag()), this);
        return false;
    }

    public boolean findSrcVcAndCheckVc() {
        String string;
        if (BrachyLdrPlanReader.c(this.dicom) && this.modInfo.rtPlanBrachyReferencedRtStructUID != null && !"".equals(this.modInfo.rtPlanBrachyReferencedRtStructUID) && (string = this.references.get(this.modInfo.rtPlanBrachyReferencedRtStructUID)) != null && !"".equals(string)) {
            if (string.equals(this.refdSeriesUID)) {
                String string2;
                this.srcVc = this.vc;
                if (this.modInfo.referencedRtStructUID != null && !"".equals(this.modInfo.referencedRtStructUID) && !this.refdSeriesUID.equals(string2 = this.references.get(this.modInfo.referencedRtStructUID))) {
                    this.vc = null;
                    this.refdSeriesUID = string2;
                    if (this.refdSeriesUID != null && !"".equals(this.refdSeriesUID)) {
                        for (ViewController viewController : this.session.af()) {
                            if (!this.refdSeriesUID.equals(viewController.getUncopiedMutableInfo().ag())) continue;
                            this.vc = viewController;
                        }
                    }
                    if (this.vc == null) {
                        ay.d((Object)("Series referenced by RTplan " + this.refdSeriesUID + " not found. Cannot load RTplan: " + this.rtPlan.ag()), this);
                        return true;
                    }
                }
            } else {
                for (ViewController viewController : this.session.af()) {
                    if (!string.equals(viewController.getUncopiedMutableInfo().ag())) continue;
                    this.srcVc = viewController;
                }
            }
        }
        return false;
    }

    public void setTryAddingSlicesForIntra(boolean bl2) {
        this.tryAddingSlicesForIntra = bl2;
    }
}

