/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.o;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.AbstractRtStructLoader;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.DicomRtStructLoader;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.rtdose.DoseRefFinder;
import com.mimvista.exodus.MIM;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.h;
import com.mimvista.internals.volumes.ImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.ao;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.g;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class LoadTaskRtStruct
extends LoadTask {
    private Session session;
    private boolean overridePromptAndAppend = false;
    private h loadPrefs = new h();
    private String overriddenReferencedSeriesUID = null;

    public h getLoadPrefs() {
        return this.loadPrefs;
    }

    public void setLoadPrefs(h h2) {
        this.loadPrefs = h2;
    }

    public LoadTaskRtStruct(Session session, LoaderDataProvider loaderDataProvider, g g2, o o2) {
        super(loaderDataProvider, g2, o2);
        this.session = session;
    }

    @Override
    protected LoadListener.LoadEvent loadVolume() {
        LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
        loadEvent.partialSeriesInfoFromDataProvider = this.dataProvider.getUncopiedMutableInfo();
        try {
            loadEvent.successfullyLoaded = this.loadRTst();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loadEvent.successfullyLoaded = false;
        }
        return loadEvent;
    }

    public void setOverridePromptAndAppend(boolean bl2) {
        this.overridePromptAndAppend = bl2;
    }

    @Override
    public JsonDicomBundle getDicomBundleForExtensions() {
        return this.getContentsOfDicomHolderForExtensions();
    }

    public Set<String> getReferencedSopInstanceUids(DicomObject dicomObject) {
        HashSet hashSet = Sets.newHashSet();
        try {
            DicomElement dicomElement = dicomObject.get(new int[]{805699600, 0, 805699602, 0, 805699604, 0, 805699606});
            if (dicomElement == null) {
                return hashSet;
            }
            int n2 = dicomElement.countItems();
            for (int i2 = 0; i2 < n2; ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                String string = dicomObject2.getString(528725);
                if (string == null) continue;
                hashSet.add(string);
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Problem trying to determine referenced SOPs of RTST.", (Throwable)exception, this);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadRTst() {
        g g2 = this.getProgress();
        try {
            boolean bl2;
            DicomRtStructLoader dicomRtStructLoader;
            block31: {
                Object object2;
                Object object;
                Object object3;
                Object object4;
                Object object52;
                Object object6;
                String string;
                DicomObject dicomObject = this.dataProvider.getFirstDicomObj();
                if (dicomObject == null) {
                    ay.d((Object)"No DICOM files found for RTstruct, cannot load RTstruct", this);
                    boolean bl3 = false;
                    return bl3;
                }
                this.fillDicomHolderForExtensions(new JsonDicomBundle(dicomObject));
                boolean bl4 = false;
                if (this.overriddenReferencedSeriesUID != null) {
                    string = this.overriddenReferencedSeriesUID;
                    bl4 = true;
                } else {
                    string = dicomObject.getString(new int[]{805699600, 0, 805699602, 0, 805699604, 0, 0x20000E});
                }
                TIntHashSet tIntHashSet = null;
                int[] nArray = dicomObject.getInts(930291984, VR.IS);
                if (nArray != null) {
                    tIntHashSet = new TIntHashSet(nArray);
                }
                ArrayList object8 = Lists.newArrayList();
                block5: for (ViewController object9 : this.session.ad()) {
                    ImageFrame imageFrame;
                    if (object9.U()) continue;
                    object6 = object9.au();
                    object52 = object6.l();
                    object4 = new TIntHashSet();
                    object3 = Sets.newHashSet();
                    object = object52.iterator();
                    while (object.hasNext()) {
                        imageFrame = object.next();
                        object4.add(imageFrame.c());
                        if (imageFrame instanceof ImageVolume) {
                            List<SliceInfo> list = ((ImageVolume)imageFrame).as();
                            for (SliceInfo sliceInfo : list) {
                                object3.add(sliceInfo.sopInstanceUID);
                            }
                            continue;
                        }
                        object3.add(imageFrame.getUncopiedMutableInfo().sopInstanceUID);
                    }
                    if (tIntHashSet != null && !object4.containsAll((TIntCollection)tIntHashSet)) continue;
                    object = object52.iterator();
                    while (object.hasNext()) {
                        imageFrame = object.next();
                        if (!string.equals(imageFrame.getUncopiedMutableInfo().ag())) continue;
                        object8.add(new DynamicVolumeRef(object9, imageFrame));
                        continue block5;
                    }
                }
                if (object8.size() > 1) {
                    object2 = this.getReferencedSopInstanceUids(dicomObject);
                    ArrayList bl5 = Lists.newArrayList();
                    for (Object object52 : object8) {
                        object4 = ((DynamicVolumeRef)object52).b();
                        object3 = ((ViewController)object4).bI();
                        if (!object2.isEmpty() && Sets.intersection((Set)object2, (Set)object3).isEmpty()) continue;
                        bl5.add(object52);
                    }
                    if (!bl5.isEmpty()) {
                        object8 = bl5;
                    } else {
                        ay.c((Object)"Tried to narrow down RTST target using SOPs, but none of the VCs have matching SOPs.", this);
                    }
                }
                object2 = null;
                if (object8.size() > 0) {
                    if (object8.size() > 1) {
                        ay.c((Object)"RTST matches multiple VCs in the session; picking one arbitrarily.", this);
                    }
                    DynamicVolumeRef dynamicVolumeRef = (DynamicVolumeRef)object8.get(0);
                    object2 = dynamicVolumeRef.b();
                    ((ViewController)object2).d(dynamicVolumeRef.c());
                }
                if (object2 == null) {
                    if (!MIM.isHeadless()) {
                        String string2 = dicomObject.getString(new int[]{805699600, 0, 0x200052});
                        object6 = Messages.a("Dicom");
                        object52 = dicomObject.getString(0x30060006, dicomObject.getString(528446, ""));
                        object4 = DicomLoadingUtility.getBestSeriesDate(dicomObject);
                        if (object4 != null) {
                            object52 = (String)object52 + "\n" + DateFormat.getDateTimeInstance().format((Date)object4);
                        }
                        object52 = (String)object52 + "\n" + dicomObject.getString(528432, "");
                        object3 = ((Messages)object6).getProperty("WARNING_RTST_FOR_SEARCH");
                        object = ((Messages)object6).getProperty("WARNING_RTST_FOR_SEARCH_TITLE");
                        object2 = DoseRefFinder.findMatchingFORSeriesInSession(this.session, string2, (String)object, (String)object3, (String)object52, Modality.RTST.get(), true);
                    }
                    if (object2 == null) {
                        ay.d((Object)("Series referenced by RTstruct " + string + " does not appear to be loaded. Cannot load RTstruct."), this);
                        boolean bl3 = false;
                        return bl3;
                    }
                    ay.c((Object)("Series referenced by RTstruct " + string + " does not appear to be loaded. Loading to user selected FOR matching series instead."), this);
                    bl4 = true;
                }
                dicomRtStructLoader = new DicomRtStructLoader((ViewController)object2, dicomObject);
                dicomRtStructLoader.setLoadPrefs(this.getLoadPrefs());
                dicomRtStructLoader.setAllowUIDMismatch(bl4);
                object6 = ((ViewController)object2).aw().n();
                object52 = ((OverlayCollection)object6).D();
                boolean bl5 = bl2 = object52 != null && object52.size() > 0 && !this.overridePromptAndAppend;
                if (bl2) {
                    object3 = object52.iterator();
                    while (object3.hasNext()) {
                        object = (AbstractContourOverlayish)object3.next();
                        if (object.K() && !(object instanceof PointContourOverlay)) continue;
                        break block31;
                    }
                    bl2 = false;
                    dicomRtStructLoader.setLoadMethod(AbstractRtStructLoader.LoadMethod.REPLACE);
                }
            }
            if (this.overridePromptAndAppend) {
                dicomRtStructLoader.setLoadMethod(AbstractRtStructLoader.LoadMethod.APPEND);
            }
            if (bl2) {
                g2.a(true);
                g2.b_(Messages.a("Dicom", "LOADTASK_WAIT_FOR_USER"));
                if (ao.Q() != null) {
                    dicomRtStructLoader.showLoadMethodDialog(ao.Q().O());
                }
                g2.a(false);
            }
            g2.b_(Messages.a("Dicom", "LOADTASK_BEGIN_LOAD"));
            boolean bl6 = dicomRtStructLoader.load(g2);
            if (bl6) {
                if (ao.R() != null) {
                    dicomRtStructLoader.showMergeResultsDialog(ao.Q().O());
                }
                boolean bl7 = true;
                return bl7;
            }
        }
        finally {
            g2.b();
        }
        return false;
    }

    public String getOverriddenReferencedSeriesUID() {
        return this.overriddenReferencedSeriesUID;
    }

    public void setOverriddenReferencedSeriesUID(String string) {
        this.overriddenReferencedSeriesUID = string;
    }
}

