/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.archive.o;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.read.DicomSRLoader;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.mui.bm;
import com.mimvista.report.b;
import com.mimvista.report.codes.BrachyConcept;
import com.mimvista.report.comprehensive.a.b.c;
import com.mimvista.report.comprehensive.a.j;
import com.mimvista.report.nodes.Report;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.g;
import com.mimvista.viewer.SeriesInfo;

public class LoadTaskStructuredReport
extends LoadTask {
    private SearchSource loadedFrom = null;
    private static final VersionNumber MIN_VERSION_NUMBER = new VersionNumber("5.5.0");
    private static final VersionNumber MIN_VERSION_VIEWER_NUMBER = new VersionNumber("3.2.0");

    public LoadTaskStructuredReport(LoaderDataProvider loaderDataProvider, g g2, o o2, SearchSource searchSource) {
        super(loaderDataProvider, g2, o2);
        this.loadedFrom = searchSource;
    }

    @Override
    public JsonDicomBundle getDicomBundleForExtensions() {
        return this.getContentsOfDicomHolderForExtensions();
    }

    @Override
    protected LoadListener.LoadEvent loadVolume() {
        LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
        try {
            Object object;
            DicomSRLoader dicomSRLoader = new DicomSRLoader(this.dataProvider);
            this.fillDicomHolderForExtensions(new JsonDicomBundle(dicomSRLoader.getDicom()));
            Report report = dicomSRLoader.load(this.getProgress());
            report.a(this.loadedFrom);
            report.a(j.a(report.n()));
            report.a(j.b(report.n()));
            report.r();
            if ("1.2.840.10008.5.1.4.1.1.88.11".equals(cn.i(this.dataProvider.getFirstDicomObj().getString(524310)))) {
                object = new com.mimvista.report.gui.content.formatting.b(report);
                ((com.mimvista.report.gui.content.formatting.b)object).a();
            }
            if (report.u()) {
                report.o().e().a(report.e());
            }
            loadEvent.successfullyLoaded = true;
            this.getProgress().b();
            bm.b().a(report);
            if (LoadTaskStructuredReport.isOldVersionOr3rdPartySR(report.n().a, report.d())) {
                new c(report).a();
                b.a(report);
            } else {
                if (report.w() != null && report.w().i() == BrachyReportPlanState.SymphonyContext.b && !report.g()) {
                    report.a(BrachyConcept.x);
                }
                object = b.b(report);
                object.get();
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            loadEvent.successfullyLoaded = false;
        }
        return loadEvent;
    }

    public static boolean isOldVersionOr3rdPartySR(String string, SeriesInfo seriesInfo) {
        VersionNumber versionNumber;
        String[] stringArray = string.split(" ");
        if (stringArray.length > 1) {
            versionNumber = new VersionNumber(stringArray[1]);
            if ("MIM".equals(stringArray[0])) {
                return versionNumber.lessThanUpTo(MIN_VERSION_NUMBER, VersionNumberComparator.c);
            }
            if ("MIMviewer".equals(stringArray[0])) {
                return versionNumber.lessThanUpTo(MIN_VERSION_VIEWER_NUMBER, VersionNumberComparator.c);
            }
        }
        versionNumber = new VersionNumber(seriesInfo.softwareVersions);
        if ("MIM".equalsIgnoreCase(seriesInfo.modelName)) {
            return versionNumber.lessThanUpTo(MIN_VERSION_NUMBER, VersionNumberComparator.c);
        }
        if ("MIMviewer".equalsIgnoreCase(seriesInfo.modelName)) {
            return versionNumber.lessThanUpTo(MIN_VERSION_VIEWER_NUMBER, VersionNumberComparator.c);
        }
        return true;
    }
}

