/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.archive.o;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.DicomSurfaceSegLoader;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.rtdose.DoseRefFinder;
import com.mimvista.exodus.MIM;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.Session;
import com.mimvista.mui.findings.SessionFindingsState;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.g;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.dcm4che2.data.DicomObject;

public class LoadTaskSurfSeg
extends LoadTask {
    private Session session;
    private boolean loadAsContours = true;

    public LoadTaskSurfSeg(Session session, LoaderDataProvider loaderDataProvider, g g2, o o2) {
        super(loaderDataProvider, g2, o2);
        this.session = session;
        this.loadAsContours = true;
    }

    public LoadTaskSurfSeg(Session session, LoaderDataProvider loaderDataProvider, g g2, o o2, boolean bl2) {
        this(session, loaderDataProvider, g2, o2);
        this.loadAsContours = bl2;
    }

    @Override
    protected LoadListener.LoadEvent loadVolume() {
        LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
        loadEvent.partialSeriesInfoFromDataProvider = this.dataProvider.getUncopiedMutableInfo();
        try {
            loadEvent.successfullyLoaded = this.loadSeg();
        }
        catch (Exception exception) {
            ay.d((Object)"Error loading surface segmentation", (Throwable)exception, LoadTaskSurfSeg.class);
            loadEvent.successfullyLoaded = false;
        }
        return loadEvent;
    }

    @Override
    public JsonDicomBundle getDicomBundleForExtensions() {
        return this.getContentsOfDicomHolderForExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSeg() {
        g g2 = this.getProgress();
        try {
            Object object;
            Object object2;
            DicomObject dicomObject = this.dataProvider.getFirstDicomObj();
            if (dicomObject == null) {
                ay.d((Object)"No DICOM files found for Surface Segmentation, cannot load Surface Segmentation", this);
                boolean bl2 = false;
                return bl2;
            }
            this.fillDicomHolderForExtensions(new JsonDicomBundle(dicomObject));
            String string = dicomObject.getString(new int[]{528661, 0, 0x20000E});
            int[] nArray = dicomObject.getInts(new int[]{528661, 0, 528736});
            ViewController object4 = null;
            if (string != null) {
                for (ViewController object32 : this.session.af()) {
                    if (!string.equals(object32.getUncopiedMutableInfo().ag()) || nArray != null && nArray[0] != object32.aw().c()) continue;
                    object4 = object32;
                    break;
                }
            }
            if (object4 == null) {
                if (!MIM.isHeadless()) {
                    object2 = dicomObject.getString(0x200052);
                    Messages messages = Messages.a("Dicom");
                    object = dicomObject.getString(528446);
                    Date date = DicomLoadingUtility.getBestSeriesDate(dicomObject);
                    if (date != null) {
                        object = (String)object + "\n" + DateFormat.getDateTimeInstance().format(date);
                    }
                    object = (String)object + "\n" + dicomObject.getString(528432, "");
                    String string2 = messages.getProperty("WARNING_SEG_FOR_SEARCH");
                    String string3 = messages.getProperty("WARNING_SEG_FOR_SEARCH_TITLE");
                    object4 = DoseRefFinder.findMatchingFORSeriesInSession(this.session, (String)object2, string3, string2, (String)object, Modality.SEG.get(), true);
                }
                if (object4 == null) {
                    ay.d((Object)("Series referenced by Surface Segmentation " + string + " does not appear to be loaded. Cannot load Surface Segmentation."), this);
                    boolean bl3 = false;
                    return bl3;
                }
                ay.c((Object)("Series referenced by Surface Segmentation " + string + " does not appear to be loaded. Loading to user selected FOR matching series instead."), this);
            }
            object2 = new DicomSurfaceSegLoader(dicomObject, object4, this.loadAsContours);
            OverlayCollection overlayCollection = object4.aw().n();
            object = object4.g().u();
            try {
                MIMSwingUtils.a(() -> LoadTaskSurfSeg.lambda$loadSeg$0((SessionFindingsState)object));
                for (Overlayish overlayish : ((DicomSurfaceSegLoader)object2).loadOverlays()) {
                    overlayCollection.a(overlayish, true);
                }
            }
            finally {
                SwingUtilities.invokeLater(() -> LoadTaskSurfSeg.lambda$loadSeg$1((SessionFindingsState)object));
            }
            boolean bl2 = true;
            return bl2;
        }
        finally {
            g2.b();
        }
    }

    private static /* synthetic */ void lambda$loadSeg$1(SessionFindingsState sessionFindingsState) {
        sessionFindingsState.b(false);
    }

    private static /* synthetic */ void lambda$loadSeg$0(SessionFindingsState sessionFindingsState) {
        sessionFindingsState.b(true);
    }
}

