/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoadTaskViewController;
import com.mimvista.extensions.util.ExtensionUtils;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import javax.swing.JOptionPane;

public class Loadable
implements Comparable<Loadable> {
    public static Messages props = Messages.a("mui");
    private SeriesInfo info;
    private Session session;
    private LoadTask loadTask;
    private boolean synchronousLoad;
    private boolean noOp = false;

    public Loadable(Session session, LoadTaskViewController loadTaskViewController) {
        this.session = session;
        this.loadTask = loadTaskViewController;
        if (loadTaskViewController.dataProvider != null) {
            this.info = loadTaskViewController.dataProvider.getUncopiedMutableInfo();
        }
    }

    public Loadable(SeriesInfo seriesInfo, Session session, LoadTask loadTask) {
        this.info = seriesInfo;
        this.session = session;
        this.loadTask = loadTask;
    }

    public void setSynchronousLoad(boolean bl2) {
        this.synchronousLoad = bl2;
    }

    public LoadTask getLoadTask() {
        return this.loadTask;
    }

    public ViewController getViewController() {
        if (this.loadTask instanceof LoadTaskViewController) {
            return ((LoadTaskViewController)this.loadTask).getViewController();
        }
        return null;
    }

    public void setSourceLoadedFrom(SearchSource searchSource) {
        if (this.getViewController() != null) {
            this.getViewController().a(searchSource);
        }
    }

    public void setNoOp(boolean bl2) {
        this.noOp = bl2;
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    public void load() {
        if (this.noOp) {
            return;
        }
        try {
            this.loadTask.addListener(new LoadListener(){

                @Override
                public void loadFinished(LoadListener.LoadEvent loadEvent) {
                    JsonDicomBundle jsonDicomBundle = Loadable.this.loadTask.getDicomBundleForExtensions();
                    if (jsonDicomBundle != null && ExtensionUtils.g()) {
                        Loadable.this.session.a(jsonDicomBundle);
                    }
                }
            });
            if (this.getViewController() != null) {
                if (this.synchronousLoad) {
                    this.loadTask.run();
                } else {
                    m.c.a(this.loadTask, this.session);
                }
            } else {
                this.loadTask.run();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ay.d((Object)"Out of mem", (Throwable)outOfMemoryError, this);
            if (this.getViewController() != null) {
                this.getViewController().ac();
            }
            String string = props.getProperty("SESSION_NO_MEMORY");
            String string2 = props.getProperty("SESSION_NO_MEMORY_MESSAGE");
            JOptionPane.showMessageDialog(ak.b().O(), string2, string, 0);
            this.loadTask.getProgress().k();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Load task failed hard.", throwable, this);
            String string = null;
            if (this.info != null) {
                string = this.info.seriesDesc;
            }
            if (string == null || string.length() == 0) {
                string = "???";
            }
            this.loadTask.params.j.add(MIMFormat.a(props.b("BASICSERIES_LOAD_UNKNOWN_FAIL"), string));
            this.loadTask.getProgress().k();
        }
    }

    public void addLoadListener(LoadListener loadListener) {
        this.loadTask.addListener(loadListener);
    }

    @Override
    public int compareTo(Loadable loadable) {
        if (this.getViewController() != null && loadable.getViewController() != null) {
            if (this.info.isMultiSeries4d && loadable.info.isMultiSeries4d) {
                return loadable.getLoadTask().dataProvider.getFilenames().size() - this.getLoadTask().dataProvider.getFilenames().size();
            }
            return 0;
        }
        if (this.info.modality.equalsIgnoreCase("rtplan")) {
            return 1;
        }
        if (loadable.info.modality.equalsIgnoreCase("rtplan")) {
            return -1;
        }
        if (this.getViewController() == null && loadable.getViewController() == null) {
            int n2 = this.info.M().compareTo(loadable.info.M());
            if (n2 == 0) {
                return this.info.P().compareTo(loadable.info.P());
            }
            return n2;
        }
        if (loadable.getViewController() == null) {
            return -1;
        }
        return 1;
    }
}

