/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.gui.l;
import com.mimvista.archive.o;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.audio.DicomWavHelper;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.dicom.read.BasicMultiSeriesFrameData;
import com.mimvista.dicom.read.LoadListener;
import com.mimvista.dicom.read.LoadListener2D;
import com.mimvista.dicom.read.LoadListener3D;
import com.mimvista.dicom.read.LoadListenerMultiSeries4D;
import com.mimvista.dicom.read.LoadTask;
import com.mimvista.dicom.read.LoadTask2D;
import com.mimvista.dicom.read.LoadTask3D;
import com.mimvista.dicom.read.LoadTaskDefReg;
import com.mimvista.dicom.read.LoadTaskMimData;
import com.mimvista.dicom.read.LoadTaskOther;
import com.mimvista.dicom.read.LoadTaskReg;
import com.mimvista.dicom.read.LoadTaskRtDose;
import com.mimvista.dicom.read.LoadTaskRtPlan;
import com.mimvista.dicom.read.LoadTaskRtStruct;
import com.mimvista.dicom.read.LoadTaskStructuredReport;
import com.mimvista.dicom.read.LoadTaskSurfSeg;
import com.mimvista.dicom.read.LoadTaskViewController;
import com.mimvista.dicom.read.Loadable;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.PemLoadListener;
import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.dicom.read.dynamic.DynamicPatternMatcher;
import com.mimvista.dicom.read.dynamic.DynamicSeriesPattern;
import com.mimvista.gui.util.MockDialogPanel;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.RealLoadState;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.av;
import com.mimvista.internals.o;
import com.mimvista.internals.s;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.k;
import com.mimvista.license.q;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.properties.ab;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.m;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.viewer.DynamicSignature;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.i;
import java.awt.GraphicsEnvironment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;

public class LoadableFactory {
    private static final Messages dicomProps = Messages.a("Dicom");
    private Map<LoadableType, List<LoadListener>> defaultListeners = Maps.newHashMap();
    private boolean create2Ds = true;
    private ViewLoadState loadState;
    private Map<DynamicSignature, MultiSeriesVCWrapper> cachedDynSeriesVCs = Maps.newHashMap();
    private boolean openDupFramesAsNew = false;
    private boolean alreadyAskedAboutDupeFrames = false;
    private com.mimvista.archive.o params;
    private DynamicPatternMatcher matcher;

    public static ViewController3D buildVCForAtomicLoadUnit(AtomicLoadUnit atomicLoadUnit, Session session) {
        DcmSeries dcmSeries = atomicLoadUnit.getSeries();
        LoaderDataProvider loaderDataProvider = dcmSeries.getDataProvider();
        ViewController3D viewController3D = new ViewController3D();
        viewController3D.a(session);
        viewController3D.b(dcmSeries.getWorkflowDisplayName());
        viewController3D.a(loaderDataProvider);
        return viewController3D;
    }

    public LoadableFactory(ViewLoadState viewLoadState) {
        this(viewLoadState, new com.mimvista.archive.o());
    }

    public LoadableFactory(ViewLoadState viewLoadState, com.mimvista.archive.o o2) {
        this.loadState = viewLoadState;
        this.params = o2;
        for (LoadableType loadableType : LoadableType.values()) {
            this.defaultListeners.put(loadableType, new ArrayList());
        }
    }

    public void initialize4DInfo(List<AtomicLoadUnit> list) {
        this.matcher = new DynamicPatternMatcher(list);
    }

    public static boolean shouldLoadAs3D(AtomicLoadUnit atomicLoadUnit, SeriesInfo seriesInfo) {
        return LoadableFactory.shouldLoadAs3D(atomicLoadUnit, seriesInfo, new AtomicBoolean());
    }

    private static boolean shouldLoadAs3D(AtomicLoadUnit atomicLoadUnit, SeriesInfo seriesInfo, AtomicBoolean atomicBoolean) {
        Object object;
        atomicBoolean.set(false);
        if (Modality.US.isSameModality(seriesInfo.modality) && "1.2.840.10008.5.1.4.1.1.6.1".equals(seriesInfo.sopClassUID) && !"1.2.840.10008.5.1.4.1.1.3.1".equals(seriesInfo.sopClassUID) && (object = atomicLoadUnit.shouldLoadThis2dUsAs3d()) == null) {
            atomicBoolean.set(LoadableFactory.getUSLoadingPref());
        }
        object = atomicLoadUnit.getDataProviderForLoading();
        boolean bl2 = SeriesIdentifier.is3DVolume(seriesInfo, ((LoaderDataProvider)object).getFilenames().size());
        return (bl2 |= atomicBoolean.get()) && !LoadableFactory.isCine(seriesInfo);
    }

    public Loadable buildLoadable(AtomicLoadUnit atomicLoadUnit, Session session) {
        Serializable serializable;
        LoaderDataProvider loaderDataProvider = atomicLoadUnit.getDataProviderForLoading();
        SeriesInfo seriesInfo = loaderDataProvider.getUncopiedMutableInfo();
        if (this.loadState instanceof RealLoadState && ((RealLoadState)(serializable = (RealLoadState)this.loadState)).d()) {
            loaderDataProvider = new l.a(((RealLoadState)serializable).j());
            DynamicPatternMatcher dynamicPatternMatcher = new DynamicPatternMatcher(((RealLoadState)serializable).j());
            for (AtomicLoadUnit atomicLoadUnit2 : ((RealLoadState)serializable).j()) {
                DynamicSeriesPattern dynamicSeriesPattern = dynamicPatternMatcher.getMatchingPattern(atomicLoadUnit2);
                if (dynamicSeriesPattern == null || seriesInfo != null && seriesInfo.numOfBins > 0) continue;
                BasicMultiSeriesFrameData basicMultiSeriesFrameData = new BasicMultiSeriesFrameData();
                dynamicSeriesPattern.fillFrameData(basicMultiSeriesFrameData);
                atomicLoadUnit2.setMultiFrameData(basicMultiSeriesFrameData);
            }
            return this.build3dLoadableWithDataProvider(atomicLoadUnit, session, loaderDataProvider, true);
        }
        if (seriesInfo == null) {
            loaderDataProvider.destroy();
            return null;
        }
        serializable = new AtomicBoolean();
        if (LoadableFactory.shouldLoadAs3D(atomicLoadUnit, seriesInfo, (AtomicBoolean)serializable)) {
            Object object;
            if (this.loadState instanceof RealLoadState && ((RealLoadState)(object = (RealLoadState)this.loadState)).e() != null && ((RealLoadState)object).e().a) {
                return this.buildStateRestorifiedMultiSeries4DLoadable(atomicLoadUnit, session, seriesInfo, loaderDataProvider);
            }
            object = this.getMatchingDynamicPattern(atomicLoadUnit);
            if (seriesInfo.numOfBins > 0) {
                seriesInfo.setFrameNumberFromSeriesDesc(new FrameNumber(seriesInfo.binNum));
                seriesInfo.setMaxFramesFromSeriesDesc(seriesInfo.numOfBins);
                seriesInfo.setFrameDesc(seriesInfo.binDesc);
                seriesInfo.setMultiSeries4d(true);
            } else if (object != null) {
                ((DynamicSeriesPattern)object).fillFrameData(seriesInfo);
            }
            if (seriesInfo.numOfBins > 0 || object != null) {
                Loadable loadable = this.buildMultiSeries4DLoadable(atomicLoadUnit, session, loaderDataProvider);
                if (loadable == null) {
                    loadable = new Loadable(null, null, null);
                    loadable.setNoOp(true);
                }
                return loadable;
            }
            Loadable loadable = this.build3dLoadableWithDataProvider(atomicLoadUnit, session, loaderDataProvider, false);
            if (((AtomicBoolean)serializable).get()) {
                loadable.getLoadTask().addListener(new LoadListener(){

                    @Override
                    public void loadSucceeded(LoadListener.LoadEvent loadEvent) {
                        if (loadEvent.vc != null) {
                            loadEvent.vc.aw().q().c(true);
                        }
                    }
                });
            }
            return loadable;
        }
        if (SeriesIdentifier.isDataFile(seriesInfo.y())) {
            if ("1.2.840.10008.5.1.4.1.1.481.3".equals(seriesInfo.sopClassUID)) {
                return this.buildRtStructLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if ("1.2.840.10008.5.1.4.1.1.66.1".equals(seriesInfo.sopClassUID)) {
                return this.buildRegLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if ("1.2.840.10008.5.1.4.1.1.66.3".equals(seriesInfo.sopClassUID)) {
                return this.buildDeformableRegLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if ("1.2.840.10008.5.1.4.1.1.481.5".equals(seriesInfo.sopClassUID) || "1.2.840.10008.5.1.4.1.1.481.8".equals(seriesInfo.sopClassUID) || seriesInfo.y().getTagValue(930291986) != null) {
                return this.buildRTplanLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if ("1.2.840.10008.5.1.4.1.1.66".equals(seriesInfo.sopClassUID)) {
                return this.buildMimDataLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if ("1.2.840.10008.5.1.4.1.1.481.2".equals(seriesInfo.sopClassUID) || "1.2.840.10008.5.1.4.1.1.128".equals(seriesInfo.sopClassUID) && seriesInfo.u().v()) {
                return this.buildRTDoseLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if (SeriesIdentifier.isStructuredReport(seriesInfo.sopClassUID)) {
                return this.buildStructuredReportLoadable(atomicLoadUnit, session, loaderDataProvider);
            }
            if ("1.2.840.10008.5.1.4.1.1.9.4.1".equals(seriesInfo.sopClassUID)) {
                boolean bl2 = DicomPrefs.playDicomAudioFiles.getValue();
                if (bl2) {
                    DicomWavHelper.LoadTaskAudio loadTaskAudio = new DicomWavHelper.LoadTaskAudio(loaderDataProvider, atomicLoadUnit.getLoadProgress(), this.params, session);
                    return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskAudio);
                }
            } else if ("1.2.840.10008.5.1.4.1.1.66.5".equals(seriesInfo.sopClassUID)) {
                return this.buildSurfSegLoadable(atomicLoadUnit, session);
            }
        } else if (this.create2Ds) {
            return this.build2dLoadable(atomicLoadUnit, session);
        }
        LoaderDataProvider loaderDataProvider2 = atomicLoadUnit.getDataProviderForLoading();
        LoadTaskOther loadTaskOther = new LoadTaskOther(loaderDataProvider2, atomicLoadUnit.getLoadProgress(), this.params, session);
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskOther);
    }

    private static boolean getUSLoadingPref() {
        String string = DicomPrefs.load2dUsAs3d.getValue();
        final boolean[] blArray = new boolean[]{false};
        if (string.equals("0")) {
            blArray[0] = false;
        } else if (string.equals("1")) {
            blArray[0] = true;
        } else if (!GraphicsEnvironment.isHeadless() && !MIMContext.j()) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            MockDialogPanel mockDialogPanel = new MockDialogPanel(ab.a.getProperty("LOAD_2D_US_AS_3D_QUESTION"), MockDialogPanel.OptionType.b, BasicNotification.NotificationType.d, null, null, null);
            m m2 = new m(mockDialogPanel);
            mockDialogPanel.b(new MockDialogPanel.b(){

                @Override
                public void mockDialogEvent(MockDialogPanel.MockDialogEvent mockDialogEvent) {
                    try {
                        blArray[0] = mockDialogEvent.a() == MockDialogPanel.InputType.a;
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
            u.b().c(m2);
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)interruptedException, LoadableFactory.class);
            }
        } else {
            blArray[0] = !MIMContext.j();
        }
        return blArray[0];
    }

    private Loadable build3dLoadableWithDataProvider(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider, boolean bl2) {
        boolean bl3;
        ViewController3D viewController3D = LoadableFactory.buildVCForAtomicLoadUnit(atomicLoadUnit, session);
        if (MIMContext.M() && loaderDataProvider.getUncopiedMutableInfo().S()) {
            atomicLoadUnit.getReorientationParams().reorient = ReorientationParams.ReorientPref.DoNotReorient;
        }
        if ((bl3 = LicenseTransformer.runLicensed(new k(){

            @Override
            @q(b="Delphi reorientation", a={LicenseOption.ULTRASOUND_3D})
            public void run() {
            }
        })) && loaderDataProvider.getUncopiedMutableInfo().aa()) {
            viewController3D.b(atomicLoadUnit.getSeries().getWorkflowDisplayName());
        }
        LoadTask3D loadTask3D = new LoadTask3D(loaderDataProvider, atomicLoadUnit.getLoadProgress(), atomicLoadUnit.getReorientationParams(), this.params);
        loadTask3D.setViewController(viewController3D);
        loadTask3D.addListener(LoadableFactory.getRegisterLoadListener(atomicLoadUnit, this.loadState));
        loadTask3D.addListener(new PemLoadListener());
        loadTask3D.addListener(new LoadListener3D(atomicLoadUnit, this.params, bl2));
        loadTask3D.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.VOL3D));
        return new Loadable(session, loadTask3D);
    }

    private Loadable buildMultiSeries4DLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        Object object;
        SeriesInfo seriesInfo = loaderDataProvider.getUncopiedMutableInfo();
        LoadTask3D loadTask3D = new LoadTask3D(loaderDataProvider, atomicLoadUnit.getLoadProgress(), atomicLoadUnit.getReorientationParams(), this.params);
        ViewController3D viewController3D = null;
        if (this.params.d) {
            viewController3D = session.e(atomicLoadUnit.getVcId()) ? (ViewController3D)session.b(atomicLoadUnit.getVcId()) : this.createNewMultiSeries4dViewController(atomicLoadUnit, session, loadTask3D);
        } else {
            object = seriesInfo.J();
            MultiSeriesVCWrapper multiSeriesVCWrapper = this.cachedDynSeriesVCs.get(object);
            if (multiSeriesVCWrapper != null) {
                ViewController3D viewController3D2 = null;
                i i2 = atomicLoadUnit.getWorkflowTarget();
                for (ViewController3D viewController3D3 : multiSeriesVCWrapper.vcs) {
                    i i3 = multiSeriesVCWrapper.wfTargets.get(viewController3D3);
                    if (i2 != null && i3 != null && !i2.equals(i3)) continue;
                    boolean bl2 = false;
                    if (viewController3D3.cE().c(seriesInfo.frameNumFromSeriesDesc)) {
                        bl2 = true;
                    }
                    if (!bl2) {
                        for (AtomicLoadUnit atomicLoadUnit2 : multiSeriesVCWrapper.alus.get((Object)viewController3D3)) {
                            if (!seriesInfo.frameNumFromSeriesDesc.equals(atomicLoadUnit2.getDataProviderForLoading().getUncopiedMutableInfo().frameNumFromSeriesDesc)) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (bl2) continue;
                    viewController3D2 = viewController3D3;
                    break;
                }
                if (viewController3D2 == null) {
                    boolean bl3;
                    boolean bl4 = bl3 = i2 != null || this.askIfShouldOpenDupFramesAsNew();
                    if (!bl3) {
                        return null;
                    }
                } else {
                    viewController3D = viewController3D2;
                    multiSeriesVCWrapper.put(viewController3D2, atomicLoadUnit);
                }
            } else {
                List<ViewController> list = session.a((DynamicSignature)object);
                if (!list.isEmpty()) {
                    int n2;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        ViewController3D viewController3D4 = (ViewController3D)list.get(n2);
                        if (viewController3D4.cE().c(seriesInfo.frameNumFromSeriesDesc)) continue;
                        viewController3D = viewController3D4;
                        break;
                    }
                    if (viewController3D == null && (n2 = (int)(this.askIfShouldOpenDupFramesAsNew() ? 1 : 0)) == 0) {
                        return null;
                    }
                }
            }
        }
        if (viewController3D == null) {
            viewController3D = this.createNewMultiSeries4dViewController(atomicLoadUnit, session, loadTask3D);
        }
        loadTask3D.setViewController(viewController3D);
        loadTask3D.addListener(new LoadListenerMultiSeries4D(atomicLoadUnit, this.loadState, this.params));
        loadTask3D.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.VOL_MultiSeries4D));
        object = new Loadable(session, loadTask3D);
        return object;
    }

    private boolean askIfShouldOpenDupFramesAsNew() {
        if (!this.alreadyAskedAboutDupeFrames) {
            String string = dicomProps.getProperty("SERIESLOAD_DUP_FRAME");
            String string2 = dicomProps.getProperty("SERIESLOAD_DUP_FRAME_TITLE");
            String string3 = dicomProps.getProperty("SERIESLOAD_DUP_FRAME_STOP");
            Object[] objectArray = new String[]{dicomProps.getProperty("SERIESLOAD_DUP_FRAME_LOAD"), dicomProps.getProperty("SERIESLOAD_DUP_FRAME_STOP")};
            int n2 = JOptionPane.showOptionDialog(ak.b().k, string, string2, 1, 3, null, objectArray, string3);
            if (n2 == 0) {
                this.openDupFramesAsNew = true;
            }
            this.alreadyAskedAboutDupeFrames = true;
        }
        return this.openDupFramesAsNew;
    }

    Loadable buildStateRestorifiedMultiSeries4DLoadable(AtomicLoadUnit atomicLoadUnit, Session session, SeriesInfo seriesInfo, LoaderDataProvider loaderDataProvider) {
        o.a a2 = ((RealLoadState)this.loadState).e();
        a2.a(seriesInfo);
        LoadTask3D loadTask3D = new LoadTask3D(loaderDataProvider, atomicLoadUnit.getLoadProgress(), atomicLoadUnit.getReorientationParams(), this.params);
        ViewController3D viewController3D = session.e(atomicLoadUnit.getVcId()) ? (ViewController3D)session.b(atomicLoadUnit.getVcId()) : this.createNewMultiSeries4dViewController(atomicLoadUnit, session, loadTask3D);
        loadTask3D.setViewController(viewController3D);
        loadTask3D.addListener(new LoadListenerMultiSeries4D(atomicLoadUnit, this.loadState, this.params));
        loadTask3D.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.VOL_MultiSeries4D));
        return new Loadable(session, loadTask3D);
    }

    private ViewController3D createNewMultiSeries4dViewController(AtomicLoadUnit atomicLoadUnit, Session session, LoadTask loadTask) {
        LoaderDataProvider loaderDataProvider = atomicLoadUnit.getDataProvider();
        SeriesInfo seriesInfo = loaderDataProvider.getUncopiedMutableInfo();
        ViewController3D viewController3D = LoadableFactory.buildVCForAtomicLoadUnit(atomicLoadUnit, session);
        o o2 = new o(session);
        viewController3D.a(o2);
        loadTask.addListener(LoadableFactory.getRegisterLoadListener(atomicLoadUnit, this.loadState));
        MultiSeriesVCWrapper multiSeriesVCWrapper = this.cachedDynSeriesVCs.get(seriesInfo.J());
        if (multiSeriesVCWrapper == null) {
            this.cachedDynSeriesVCs.put(seriesInfo.J(), new MultiSeriesVCWrapper(viewController3D, atomicLoadUnit));
        } else {
            multiSeriesVCWrapper.put(viewController3D, atomicLoadUnit);
        }
        return viewController3D;
    }

    static LoadListener getRegisterLoadListener(final AtomicLoadUnit atomicLoadUnit, final ViewLoadState viewLoadState) {
        return new LoadListener(){

            @Override
            public void loadSucceeded(LoadListener.LoadEvent loadEvent) {
                Long l2 = atomicLoadUnit.getVcId();
                if (l2 != -1L) {
                    if (viewLoadState.getSession().e(l2)) {
                        ay.c((Object)"Trying to load over an existing VC, something is wrong.", this);
                    } else {
                        loadEvent.vc.c(l2);
                    }
                }
                loadEvent.vc.g().a(loadEvent.vc, viewLoadState);
            }
        };
    }

    private Loadable build2dLoadable(AtomicLoadUnit atomicLoadUnit, Session session) {
        LoaderDataProvider loaderDataProvider = atomicLoadUnit.getDataProviderForLoading();
        av av2 = new av();
        av2.a(session);
        av2.b(atomicLoadUnit.getWorkflowDisplayName());
        LoadTask2D loadTask2D = new LoadTask2D(loaderDataProvider, atomicLoadUnit.getLoadProgress(), atomicLoadUnit, this.params);
        loadTask2D.setViewController(av2);
        loadTask2D.addListener(LoadableFactory.getRegisterLoadListener(atomicLoadUnit, this.loadState));
        loadTask2D.addListener(this.get2Dor3DLoadListenerAdapter(atomicLoadUnit, this.params));
        loadTask2D.addListener(this.get2Dor3DDefaultLoadListenerWrapper());
        return new Loadable(session, loadTask2D);
    }

    private LoadListener get2Dor3DLoadListenerAdapter(final AtomicLoadUnit atomicLoadUnit, final com.mimvista.archive.o o2) {
        return new LoadListener(){

            @Override
            public void loadFailed(LoadListener.LoadEvent loadEvent) {
                if (loadEvent.dSeries == null) {
                    new LoadListener2D(atomicLoadUnit, o2).loadFailed(loadEvent);
                } else {
                    new LoadListener3D(atomicLoadUnit, o2, false).loadFailed(loadEvent);
                }
            }

            @Override
            public void loadSucceeded(LoadListener.LoadEvent loadEvent) {
                if (loadEvent.dSeries == null) {
                    new LoadListener2D(atomicLoadUnit, o2).loadSucceeded(loadEvent);
                } else {
                    new LoadListener3D(atomicLoadUnit, o2, false).loadSucceeded(loadEvent);
                }
            }

            @Override
            public void loadFinished(LoadListener.LoadEvent loadEvent) {
                if (loadEvent.dSeries == null) {
                    new LoadListener2D(atomicLoadUnit, o2).loadFinished(loadEvent);
                } else {
                    new LoadListener3D(atomicLoadUnit, o2, false).loadFinished(loadEvent);
                }
            }
        };
    }

    private LoadListener get2Dor3DDefaultLoadListenerWrapper() {
        return new LoadListener(){

            private List<LoadListener> getListeners(LoadListener.LoadEvent loadEvent) {
                List list = (List)LoadableFactory.this.defaultListeners.get((Object)(loadEvent.vc.is2D() ? LoadableType.VOL2D : LoadableType.VOL3D));
                if (list == null) {
                    return Collections.emptyList();
                }
                return list;
            }

            @Override
            public void loadFailed(LoadListener.LoadEvent loadEvent) {
                for (LoadListener loadListener : this.getListeners(loadEvent)) {
                    loadListener.loadFailed(loadEvent);
                }
            }

            @Override
            public void loadFinished(LoadListener.LoadEvent loadEvent) {
                for (LoadListener loadListener : this.getListeners(loadEvent)) {
                    loadListener.loadFinished(loadEvent);
                }
            }

            @Override
            public void loadSucceeded(LoadListener.LoadEvent loadEvent) {
                for (LoadListener loadListener : this.getListeners(loadEvent)) {
                    loadListener.loadSucceeded(loadEvent);
                }
            }
        };
    }

    private Loadable buildRtStructLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskRtStruct loadTaskRtStruct = new LoadTaskRtStruct(session, loaderDataProvider, atomicLoadUnit.getLoadProgress(), this.params);
        loadTaskRtStruct.setOverriddenReferencedSeriesUID(atomicLoadUnit.getOverriddenReferencedSeriesUID());
        loadTaskRtStruct.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.RTST));
        if (this.loadState instanceof RealLoadState) {
            RealLoadState realLoadState = (RealLoadState)this.loadState;
            loadTaskRtStruct.setOverridePromptAndAppend(realLoadState.c());
        }
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskRtStruct);
    }

    private Loadable buildStructuredReportLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskStructuredReport loadTaskStructuredReport = new LoadTaskStructuredReport(loaderDataProvider, atomicLoadUnit.getLoadProgress(), this.params, atomicLoadUnit.getSearchSource());
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskStructuredReport);
    }

    private Loadable buildRegLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskReg loadTaskReg = new LoadTaskReg(session, loaderDataProvider, atomicLoadUnit.getLoadProgress(), this.params);
        loadTaskReg.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.REG));
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskReg);
    }

    private Loadable buildDeformableRegLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskDefReg loadTaskDefReg = new LoadTaskDefReg(session, loaderDataProvider, atomicLoadUnit.getLoadProgress(), this.params);
        loadTaskDefReg.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.DEFREG));
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskDefReg);
    }

    private Loadable buildRTplanLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskRtPlan loadTaskRtPlan = new LoadTaskRtPlan(atomicLoadUnit.getSeries().getRtPlanMap(), session, atomicLoadUnit.getDataProvider(), atomicLoadUnit.getLoadProgress(), true, this.params);
        loadTaskRtPlan.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.RTPLAN));
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskRtPlan);
    }

    private Loadable buildMimDataLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskMimData loadTaskMimData = new LoadTaskMimData(loaderDataProvider, atomicLoadUnit.getLoadProgress(), atomicLoadUnit.getSearchSource(), this.params);
        loadTaskMimData.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.MIMDATA));
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskMimData);
    }

    private Loadable buildRTDoseLoadable(AtomicLoadUnit atomicLoadUnit, Session session, LoaderDataProvider loaderDataProvider) {
        LoadTaskRtDose loadTaskRtDose = new LoadTaskRtDose(session, loaderDataProvider, atomicLoadUnit.getSearchSource(), atomicLoadUnit.getLoadProgress(), this.params);
        loadTaskRtDose.setParentUid(atomicLoadUnit.getOverriddenReferencedSeriesUID());
        loadTaskRtDose.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.RTDOSE));
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskRtDose);
    }

    private Loadable buildSurfSegLoadable(AtomicLoadUnit atomicLoadUnit, Session session) {
        LoaderDataProvider loaderDataProvider = atomicLoadUnit.getDataProviderForLoading();
        LoadTaskSurfSeg loadTaskSurfSeg = new LoadTaskSurfSeg(session, loaderDataProvider, atomicLoadUnit.getLoadProgress(), this.params);
        loadTaskSurfSeg.addListeners((Collection<LoadListener>)this.defaultListeners.get((Object)LoadableType.SURFSEG));
        return new Loadable(loaderDataProvider.getUncopiedMutableInfo(), session, loadTaskSurfSeg);
    }

    public Loadable buildFusionLoadable(ViewController viewController, ViewController viewController2, Session session, long l2, final Matrix4f matrix4f) {
        final s s2 = new s(viewController, viewController2);
        s2.a(session);
        LoadTaskViewController loadTaskViewController = new LoadTaskViewController(null, com.mimvista.util.progress.o.o(), this.params){

            @Override
            protected LoadListener.LoadEvent loadVolume() {
                LoadListener.LoadEvent loadEvent = new LoadListener.LoadEvent();
                s2.b(matrix4f);
                s2.cj();
                return loadEvent;
            }
        };
        loadTaskViewController.setViewController(s2);
        Loadable loadable = new Loadable(session, loadTaskViewController);
        this.registerViewControllerWithSession(s2, session, l2);
        return loadable;
    }

    private long registerViewControllerWithSession(ViewController viewController, Session session, long l2) {
        if (l2 == -1L) {
            session.a(viewController, this.loadState);
            return viewController.aV();
        }
        viewController.c(l2);
        session.a(viewController, this.loadState);
        return l2;
    }

    private static boolean isCine(SeriesInfo seriesInfo) {
        if (!SeriesIdentifier.isCine(seriesInfo)) {
            return false;
        }
        String string = MIMFormat.a(dicomProps.getProperty("SERIESLOAD_DETECT"), seriesInfo.patientName, seriesInfo.seriesDesc);
        String string2 = dicomProps.getProperty("SERIESLOAD_DETECT_TITLE");
        int n2 = JOptionPane.showConfirmDialog(ak.b().O(), string, string2, 0, 1);
        return n2 == 0;
    }

    private DynamicSeriesPattern getMatchingDynamicPattern(AtomicLoadUnit atomicLoadUnit) {
        if (this.matcher != null) {
            return this.matcher.getMatchingPattern(atomicLoadUnit);
        }
        return null;
    }

    public void addDefaultListener(LoadableType loadableType, LoadListener loadListener) {
        if (loadListener == null) {
            return;
        }
        this.defaultListeners.get((Object)loadableType).add(loadListener);
    }

    private class MultiSeriesVCWrapper {
        Set<ViewController3D> vcs = Sets.newLinkedHashSet();
        Multimap<ViewController3D, AtomicLoadUnit> alus = HashMultimap.create();
        Map<ViewController3D, i> wfTargets = Maps.newHashMap();

        private MultiSeriesVCWrapper(ViewController3D viewController3D, AtomicLoadUnit atomicLoadUnit) {
            this.put(viewController3D, atomicLoadUnit);
        }

        void put(ViewController3D viewController3D, AtomicLoadUnit atomicLoadUnit) {
            this.vcs.add(viewController3D);
            this.alus.put((Object)viewController3D, (Object)atomicLoadUnit);
            if (this.wfTargets.get(viewController3D) == null) {
                this.wfTargets.put(viewController3D, atomicLoadUnit.getWorkflowTarget());
            }
        }
    }

    public static enum LoadableType {
        VOL2D,
        VOL3D,
        VOL_MultiSeries4D,
        RTST,
        REG,
        DEFREG,
        RTPLAN,
        MIMDATA,
        RTDOSE,
        SURFSEG;

    }
}

