/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.MultiSeriesFrameData;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.dicom.read.TheDicomFilterManager;
import com.mimvista.file.MIMFile;
import com.mimvista.util.as;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.viewer.SeriesInfo;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.StopTagInputHandler;

public abstract class LoaderDataProvider
implements SeriesInfo.a,
Closeable {
    public static final String OLD_CACHEFILE_NAME = "mim_cache.xml";
    public static final String CACHEFILE_NAME = "mimfancycache.mim";
    public static final String META_CACHEFILE_NAME = "metacache.mim";
    public static final ImmutableSet<String> GOON_NON_DICOM_FILES_OFTEN_FOUND_IN_ARCHIVE_DIRS = ImmutableSet.of((Object)"mim_cache.xml", (Object)"mimfancycache.mim", (Object)"metacache.mim");
    protected SeriesInfo cachedInfo;
    protected Set<String> sopsToLoad;
    protected boolean specialStickyProvider = false;
    protected Predicate<String> fileInclusionPredicate = new Predicate<String>(){

        public boolean apply(String string) {
            return LoaderDataProvider.this.isFileIncluded(string);
        }
    };
    private static final Pattern SOP_EXTRACT_REGEX = Pattern.compile("([0-9.]+)\\.dcm$", 2);

    public abstract List<String> getFilenames();

    public abstract InputStream getStream(String var1);

    public DicomObject getDicomObject(String string, DicomInputHandler dicomInputHandler) {
        try {
            List<String> list = this.getFilenames();
            if (list == null) {
                ay.d((Object)"Got an empty file list for this series", this);
                return null;
            }
            if (!as.b(list, string)) {
                ay.d((Object)(string + " is not in the list of filenames for this series"), this);
                return null;
            }
            return DicomReader.readStreamIntoDicomObject(this.getStream(string), dicomInputHandler);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Couldn't get DicomObject from file: " + string), this);
            return null;
        }
    }

    public DicomObject getFirstDicomObj() {
        return this.getFirstDicomObj(-1);
    }

    public DicomObject getFirstDicomObj(int n2) {
        StopTagInputHandler stopTagInputHandler = new StopTagInputHandler(n2);
        return this.getFirstDicomObj((DicomInputHandler)stopTagInputHandler);
    }

    public DicomObject getFirstDicomObj(DicomInputHandler dicomInputHandler) {
        List<String> list = this.getFilenames();
        if (list == null) {
            ay.d((Object)"Got null file list for series", this);
            return null;
        }
        block0: for (String string : list) {
            String string2 = string.toUpperCase();
            for (String string3 : DicomReader.fileExcluder.getExcludedDicomReadExtensions()) {
                if (string2.endsWith(string3)) continue block0;
            }
            DicomObject dicomObject = this.getDicomObject(string, dicomInputHandler);
            if (dicomObject == null || dicomObject.isEmpty()) continue;
            return dicomObject;
        }
        return null;
    }

    public void setSopsToLoad(Iterable<String> iterable) {
        this.sopsToLoad = null;
        if (iterable != null && !Iterables.isEmpty(iterable)) {
            this.sopsToLoad = Sets.newHashSet(iterable);
        }
    }

    protected boolean isFileIncluded(String string) {
        Matcher matcher;
        if (this.sopsToLoad != null && (matcher = SOP_EXTRACT_REGEX.matcher(string)).find()) {
            return this.sopsToLoad.contains(matcher.group(1));
        }
        return true;
    }

    public DicomObject getSpecifiedTagsFromFirstDicomObj(int[] nArray) {
        DicomReader.FilteredTagInputHandler filteredTagInputHandler = new DicomReader.FilteredTagInputHandler(nArray, DicomReader.FilteredTagInputHandler.FilterMode.INCLUDE);
        return this.getFirstDicomObj(filteredTagInputHandler);
    }

    public void destroy() {
    }

    public OutputStream getStreamToSaveCache() {
        return null;
    }

    public InputStream getCacheFile() {
        return null;
    }

    public void fetchNext(String string) {
    }

    public boolean supportsPrefetchRequests() {
        return false;
    }

    public boolean deliberatelyContainsMultipleSeries() {
        return false;
    }

    public SeriesInfo getUncopiedMutableInfoIfAlreadyLoaded() {
        return this.cachedInfo;
    }

    @Override
    public SeriesInfo getUncopiedMutableInfo() {
        if (this.cachedInfo != null) {
            return this.cachedInfo;
        }
        this.getInfoFromCache();
        if (this.cachedInfo != null) {
            return this.cachedInfo;
        }
        DicomObject dicomObject = this.getFirstDicomObj(new DicomReader.StopBeforeContentInputHandler(2145386512));
        if (dicomObject != null && !dicomObject.isEmpty()) {
            this.cachedInfo = DicomLoadingUtility.getSeriesInfo(dicomObject);
        }
        return this.cachedInfo;
    }

    public List<String> getBlockingFilesFor(String string) {
        return Collections.emptyList();
    }

    public List<String> getAlreadyAvailableFiles() {
        return Collections.emptyList();
    }

    protected InputStream getCacheStreamForInfo() {
        return this.getCacheFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getInfoFromCache() {
        block12: {
            InputStream inputStream = null;
            try {
                inputStream = this.getCacheStreamForInfo();
                if (inputStream == null) break block12;
                GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
                while (true) {
                    try {
                        Object object;
                        while (!((object = objectInputStream.readObject()) instanceof DicomObject)) {
                        }
                        NonCrashyDicomObject nonCrashyDicomObject = NonCrashyDicomObject.copyIfCrashy((DicomObject)object);
                        nonCrashyDicomObject = TheDicomFilterManager.filter((DicomObject)nonCrashyDicomObject);
                        this.cachedInfo = DicomLoadingUtility.getSeriesInfo((DicomObject)nonCrashyDicomObject);
                        if (this.cachedInfo != null) {
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        ay.d((Object)"Bad cast?", (Throwable)classCastException, this);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            catch (IOException iOException) {
                ay.d((Object)"Failed to load information from cache file", this);
            }
            finally {
                cm.a((Closeable)inputStream);
            }
        }
    }

    public Map<Integer, String[]> getValuesForDicomTags(int[] nArray) {
        DicomObject dicomObject = this.getSpecifiedTagsFromFirstDicomObj(nArray);
        if (dicomObject == null) {
            return null;
        }
        HashMap<Integer, String[]> hashMap = new HashMap<Integer, String[]>();
        for (int n2 : nArray) {
            String[] stringArray;
            block4: {
                stringArray = null;
                try {
                    stringArray = dicomObject.getStrings(n2, (String[])null);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    String string = dicomObject.getString(n2, (String)null);
                    if (string == null) break block4;
                    stringArray = new String[]{string};
                }
            }
            if (stringArray == null) continue;
            hashMap.put(n2, stringArray);
        }
        return hashMap;
    }

    public String getValueForDicomTag(int n2) {
        Map<Integer, String[]> map = this.getValuesForDicomTags(new int[]{n2});
        if (map == null) {
            return null;
        }
        String[] stringArray = map.get(n2);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getValuesForDicomTag(int n2) {
        Map<Integer, String[]> map = this.getValuesForDicomTags(new int[]{n2});
        if (map == null) {
            return null;
        }
        return map.get(n2);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public MultiSeriesFrameData getFrameDataForFile(String string) {
        return this.getUncopiedMutableInfo();
    }

    public void setSpecialStickyProvider(boolean bl2) {
        this.specialStickyProvider = bl2;
    }

    public boolean isSpecialStickyProvider() {
        return this.specialStickyProvider;
    }

    public void copyCachedStateTo(LoaderDataProvider loaderDataProvider) {
        loaderDataProvider.cachedInfo = this.cachedInfo;
    }

    public static class FileBasedLoaderDataProvider
    extends LoaderDataProvider {
        HashMap<String, File> fileMap = Maps.newLinkedHashMap();
        private File parentDir;

        public FileBasedLoaderDataProvider(File[] fileArray) {
            this(Lists.newArrayList((Object[])fileArray));
        }

        public FileBasedLoaderDataProvider(Iterable<? extends File> iterable) {
            this(iterable, new Function<File, String>(){

                public String apply(File file) {
                    return file.getName();
                }
            });
        }

        public FileBasedLoaderDataProvider(Iterable<? extends File> iterable, Function<File, String> function) {
            for (File file : iterable) {
                this.parentDir = file.getParentFile();
                boolean bl2 = true;
                for (String string : DicomReader.fileExcluder.getExcludedDicomReadExtensions()) {
                    if (!file.getName().toUpperCase().endsWith(string)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                this.fileMap.put((String)function.apply((Object)file), file);
            }
        }

        @Override
        public DicomObject getFirstDicomObj(DicomInputHandler dicomInputHandler) {
            DicomObject dicomObject = super.getFirstDicomObj(dicomInputHandler);
            if (dicomObject == null) {
                ay.a((Object)("Dir with no valid files: " + this.parentDir), this);
            }
            return dicomObject;
        }

        public MIMFile getFirstDicomFile() {
            for (String string : this.getFilenames()) {
                DicomObject dicomObject = DicomReader.readStreamIntoDicomObject(this.getStream(string), (DicomInputHandler)new StopTagInputHandler(524293));
                if (dicomObject == null || dicomObject.isEmpty()) continue;
                return new MIMFile(this.fileMap.get(string));
            }
            ay.d((Object)"No valid DICOM files found when getting info", this);
            return null;
        }

        @Override
        public List<String> getFilenames() {
            return Lists.newArrayList((Iterable)Sets.filter(this.fileMap.keySet(), (Predicate)this.fileInclusionPredicate));
        }

        @Override
        public InputStream getStream(String string) {
            File file = this.fileMap.get(string);
            if (file == null || !file.exists()) {
                ay.d((Object)("File not found for: " + string), this);
                return null;
            }
            try {
                return this.openFileStream(file);
            }
            catch (IOException iOException) {
                ay.d((Object)iOException, DicomReader.class);
                return null;
            }
        }

        @Override
        public InputStream getCacheFile() {
            if (this.sopsToLoad != null && !this.sopsToLoad.isEmpty()) {
                return null;
            }
            File file = this.getCacheFileLocation();
            try {
                if (file != null && file.isFile()) {
                    return this.openFileStream(file);
                }
                return null;
            }
            catch (IOException iOException) {
                ay.b((Object)iOException, this);
                return null;
            }
        }

        private File getCacheFileLocation() {
            File file;
            if (this.fileMap.containsKey(LoaderDataProvider.CACHEFILE_NAME)) {
                return this.fileMap.get(LoaderDataProvider.CACHEFILE_NAME);
            }
            File file2 = null;
            try {
                file = this.fileMap.values().iterator().next();
                file2 = file.getParentFile();
            }
            catch (NoSuchElementException noSuchElementException) {
                file2 = this.parentDir;
            }
            file = new File(file2, LoaderDataProvider.CACHEFILE_NAME);
            return file;
        }

        @Override
        public OutputStream getStreamToSaveCache() {
            if (this.sopsToLoad != null && !this.sopsToLoad.isEmpty()) {
                return null;
            }
            File file = this.getCacheFileLocation();
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ay.d((Object)fileNotFoundException, this);
                return null;
            }
        }

        protected InputStream openFileStream(File file) throws IOException {
            return new BufferedInputStream(new FileInputStream(file));
        }

        @Override
        public void copyCachedStateTo(LoaderDataProvider loaderDataProvider) {
            super.copyCachedStateTo(loaderDataProvider);
            if (loaderDataProvider instanceof FileBasedLoaderDataProvider) {
                ((FileBasedLoaderDataProvider)loaderDataProvider).fileMap = this.fileMap;
            }
        }
    }
}

