/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.read.SuvCorrector;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputError;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.af;
import com.mimvista.gui.util.k;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.aj;
import com.mimvista.internals.o;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.internals.volumes.ImageVolume;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.preferencesNew.ConfigPrefs;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.preferencesNew.PemPrefs;
import com.mimvista.preferencesNew.SuvPrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.az;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import com.mimvista.viewer.algo.SuvCalculator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class MuiSuvCorrector
extends SuvCorrector {
    public static Messages props = Messages.a("Util");
    private aj infoChangeListener;
    private List<Runnable> calcListeners = new ArrayList<Runnable>();
    private Session sess;
    private long vcId = -1L;
    private boolean isPEM = false;

    public MuiSuvCorrector(ViewController3D viewController3D) {
        this.sess = viewController3D.g();
        this.vcId = viewController3D.aV();
        this.infoChangeListener = viewController3D.cw();
        this.isPEM = viewController3D.getUncopiedMutableInfo().S();
    }

    public MuiSuvCorrector(com.mimvista.mui.az az2) {
        this((ViewController3D)az2.n());
    }

    public void setInfoChangeListener(aj aj2) {
        this.infoChangeListener = aj2;
    }

    public void addCalculationListener(Runnable runnable) {
        this.calcListeners.add(runnable);
    }

    public ViewController getVc() {
        return this.sess.b(this.vcId);
    }

    @Override
    public SuvCalculator.CalculationType getCurrentCalculation() {
        ViewController viewController = this.getVc();
        if (viewController == null) {
            return null;
        }
        UnitHelper.AppliedImageUnit appliedImageUnit = viewController.getUncopiedMutableInfo().u().m();
        SuvCalculator.CalculationType calculationType = SuvCalculator.CalculationType.a(appliedImageUnit.unit);
        if (calculationType == null) {
            calculationType = SuvCalculator.CalculationType.a;
        }
        return calculationType;
    }

    @Override
    public SuvCalculator.CalculationType getPreferredCalcType() {
        return SuvCalculator.CalculationType.a(SuvPrefs.suvCalculationType.getValue());
    }

    @Override
    public void setPreferredCalcType(SuvCalculator.CalculationType calculationType) {
        SuvPrefs.suvCalculationType.setValue(calculationType.a());
    }

    public JPopupMenu getSuvMenu(final com.mimvista.mui.az az2) {
        boolean bl2;
        final SeriesInfo seriesInfo = az2.aR_().getUncopiedMutableInfo();
        if (!"PT".equalsIgnoreCase(seriesInfo.modality) || "GML".equals(seriesInfo.af()) || seriesInfo.u().a(DataUnitUtils.COUNTS_CANON_) || "counts".equalsIgnoreCase(seriesInfo.af()) || "cnts".equalsIgnoreCase(seriesInfo.af())) {
            return null;
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(props.getProperty("SUVCORR_MENU_ITEM") + "...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuvCalculator.CalculationType calculationType = MuiSuvCorrector.this.getCurrentCalculation();
                List<String> list = MuiSuvCorrector.this.testForPossibleOutOfRangeFields(calculationType, seriesInfo);
                String string = "";
                if (list.size() > 0) {
                    string = MuiSuvCorrector.this.getPossibleOutOfRangeMessage(list, calculationType);
                }
                if (calculationType == SuvCalculator.CalculationType.d) {
                    JOptionPane.showMessageDialog(jPopupMenu, props.getProperty("SUVCORR_CANNOT_BQML"));
                } else {
                    MuiSuvCorrector.this.showSuvCorrector(calculationType, az2, seriesInfo, string, true);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenu jMenu = new JMenu(props.getProperty("SUVCORR_MENU_ITEM_TYPE"));
        jPopupMenu.add(jMenu);
        JMenuItem jMenuItem2 = new JMenuItem(props.getProperty("SUVCORR_BODY_WEIGHT") + " (" + props.getProperty("SUVCORR_BODY_WEIGHT_ABBREV") + ")");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuiSuvCorrector.this.applyCalcChange(seriesInfo, SuvCalculator.CalculationType.a, az2);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(props.getProperty("SUVCORR_LEAN_BODY_MASS") + " (" + props.getProperty("SUVCORR_LEAN_BODY_MASS_ABBREV") + ")");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuiSuvCorrector.this.applyCalcChange(seriesInfo, SuvCalculator.CalculationType.b, az2);
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(props.getProperty("SUVCORR_BODY_SURFACE_AREA") + " (" + props.getProperty("SUVCORR_BODY_SURFACE_AREA_ABBREV") + ")");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuiSuvCorrector.this.applyCalcChange(seriesInfo, SuvCalculator.CalculationType.c, az2);
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(MIMFormat.a(props.getProperty("SUVCORR_BQML"), OverlayStatistician.t()));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuiSuvCorrector.this.applyCalcChange(seriesInfo, SuvCalculator.CalculationType.d, az2);
            }
        });
        jMenu.add(jMenuItem5);
        SuvCalculator.CalculationType calculationType = this.getCurrentCalculation();
        if (calculationType == SuvCalculator.CalculationType.d) {
            jMenuItem5.setIcon(ImageManipulator.c("checkmark_green", 18));
        } else if (calculationType == SuvCalculator.CalculationType.b) {
            jMenuItem3.setIcon(ImageManipulator.c("checkmark_green", 18));
        } else if (calculationType == SuvCalculator.CalculationType.c) {
            jMenuItem4.setIcon(ImageManipulator.c("checkmark_green", 18));
        } else if (calculationType == SuvCalculator.CalculationType.a) {
            jMenuItem2.setIcon(ImageManipulator.c("checkmark_green", 18));
        }
        String string = az2.n().aw().I().af();
        boolean bl3 = bl2 = !cn.h(string) && string.toUpperCase().contains("SUV");
        if (bl2) {
            String string2 = props.getProperty("SUVCORR_CANNOT_CORRECT_WHEN_ALREADY_SUV_TOOLTIP");
            jMenuItem.setEnabled(false);
            jMenu.setEnabled(false);
            jMenuItem.setToolTipText(string2);
            jMenu.setToolTipText(string2);
        } else if (calculationType == SuvCalculator.CalculationType.d) {
            jMenuItem.setEnabled(false);
            jMenuItem.setToolTipText(MIMFormat.a(props.getProperty("SUVCORR_CANNOT_BQML_TOOLTIP"), OverlayStatistician.StatUnitCategory.f.c(null)));
        }
        return jPopupMenu;
    }

    private <DicomObject> void applyCalcChange(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType, com.mimvista.mui.az az2) {
        List<String> list = this.testForPossibleOutOfRangeFields(calculationType, seriesInfo);
        if (list.size() > 0 && calculationType != SuvCalculator.CalculationType.d) {
            String string = this.getPossibleOutOfRangeMessage(list, calculationType);
            this.showSuvCorrector(calculationType, az2, seriesInfo, string, true);
            return;
        }
        boolean bl2 = SuvCalculator.tryCalcSuv(seriesInfo, calculationType);
        if (!bl2) {
            this.showErrorComputingSuvMessage(seriesInfo, calculationType);
        } else {
            this.finishCalcChangeAndHandleDynamics(seriesInfo, calculationType);
        }
        this.runCalculationListeners();
        az2.ah().b().Q();
    }

    private void finishCalcChangeAndHandleDynamics(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType) {
        this.finishCalcChangeAndHandleDynamics(seriesInfo, calculationType, null);
    }

    private void finishCalcChangeAndHandleDynamics(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType, SuvParameters suvParameters) {
        ViewController3D viewController3D = (ViewController3D)this.sess.b(this.vcId);
        o o2 = viewController3D.cE();
        if (o2 != null && !o2.l().isEmpty()) {
            for (ImageVolumeShort imageVolumeShort : o2.l()) {
                this.applyToVol(imageVolumeShort, calculationType, suvParameters);
            }
        } else if (viewController3D.cw() != null) {
            this.applyToVol(viewController3D.cw(), calculationType, suvParameters);
        }
        this.infoChangeListener.b(seriesInfo);
        this.setPreferredCalcType(calculationType);
    }

    private void applyToVol(ImageVolume<?> imageVolume, SuvCalculator.CalculationType calculationType, SuvParameters suvParameters) {
        if (suvParameters != null) {
            suvParameters.apply(imageVolume.getUncopiedMutableInfo(), calculationType);
        }
        SuvCalculator.tryCalcSuv(imageVolume.getUncopiedMutableInfo(), calculationType);
        imageVolume.an_();
    }

    @Override
    protected void fixDynamicInfos(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType) {
        this.finishCalcChangeAndHandleDynamics(seriesInfo, calculationType, new SuvParameters(seriesInfo));
    }

    private void runCalculationListeners() {
        for (Runnable runnable : this.calcListeners) {
            runnable.run();
        }
    }

    private void showSuvCorrector(final SuvCalculator.CalculationType calculationType, final com.mimvista.mui.az az2, final SeriesInfo seriesInfo, String string, boolean bl2) {
        if (calculationType == SuvCalculator.CalculationType.d) {
            return;
        }
        if (seriesInfo.SUVComputationDeclined && !bl2) {
            return;
        }
        Notification.a a2 = new Notification.a();
        if (az2 != null) {
            a2 = new Notification.a(az2.n());
        } else if (this.sess != null && this.vcId != -1L) {
            a2 = new Notification.a(this.sess.b(this.vcId));
        }
        final InputNotification inputNotification = new InputNotification(a2, props.b("SUVCORR_MENU_ITEM"), this.isPEM ? "puv_ball" : "suv_ball");
        inputNotification.setCancelButtonText(props.getProperty("SUVCORR_NO_COMPUTE"));
        inputNotification.setCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                seriesInfo.SUVComputationDeclined = true;
            }
        });
        inputNotification.setScrollBarType(AbstractInputContainer.ScrollBarType.b);
        String string2 = "HHmmss";
        String string3 = "yyyyMMdd";
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        final SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string3);
        String string4 = "[012][0-9][0-5][0-9][0-5][0-9]";
        String string5 = "[12][0-9][0-9][0-9][01][0-9][0-3][0-9]";
        String string6 = "";
        if (seriesInfo.startDate != null) {
            string6 = String.valueOf(simpleDateFormat2.format(seriesInfo.startDate));
        }
        String string7 = "";
        if (seriesInfo.startTime != null) {
            string7 = String.valueOf(simpleDateFormat.format(seriesInfo.startTime));
        }
        String string8 = "";
        if (seriesInfo.sex != null) {
            string8 = seriesInfo.sex;
        }
        Float f2 = null;
        if (!Float.valueOf(seriesInfo.weight).isNaN()) {
            f2 = Float.valueOf(seriesInfo.weight);
        }
        Float f3 = null;
        if (!Float.valueOf(seriesInfo.dose).isNaN()) {
            f3 = Float.valueOf(seriesInfo.dose / this.getDoseScaleFactor());
        }
        Float f4 = null;
        if (!Float.valueOf(seriesInfo.halflife).isNaN()) {
            f4 = Float.valueOf(seriesInfo.halflife);
        }
        Float f5 = null;
        if (!Float.valueOf(seriesInfo.patientSize).isNaN()) {
            f5 = Float.valueOf(seriesInfo.patientSize);
        }
        String string9 = "<html>" + seriesInfo.patientName + ", " + seriesInfo.modality + seriesInfo.M() + "<br><br>" + string + "</html>";
        inputNotification.addLabel(string9);
        inputNotification.addSeparator();
        final com.mimvista.gui.util.u<Float> u2 = inputNotification.addFloatField(this.getWeightScaleFactor() > 1.0f ? props.getProperty("SUVCORR_WEIGHT_LBS") : props.getProperty("SUVCORR_WEIGHT"));
        if (f2 != null) {
            f2 = Float.valueOf(f2.floatValue() * this.getWeightScaleFactor());
        }
        u2.c(f2);
        u2.a(InputError.c, props.getProperty("SUVCORR_WEIGHT_ERROR"));
        u2.a(InputError.a, props.getProperty("SUVCORR_WEIGHT_ERROR"));
        u2.a(InputError.b, props.getProperty("SUVCORR_WEIGHT_ERROR"));
        final com.mimvista.gui.util.u<Float> u3 = inputNotification.addFloatField(props.getProperty(ConfigPrefs.doseInMbq.getValue() != false ? "SUVCORR_DOSE_MBQL" : "SUVCORR_DOSE"));
        u3.c(f3);
        u3.b(Float.valueOf(0.0f));
        u3.a(InputError.c, props.getProperty("SUVCORR_DOSE_ERROR"));
        u3.a(InputError.a, props.getProperty("SUVCORR_DOSE_ERROR"));
        u3.a(InputError.b, props.getProperty("SUVCORR_DOSE_ERROR"));
        final l<String> l2 = inputNotification.addTextField(props.getProperty("SUVCORR_START_DATE"));
        l2.a(string6).b((String)((Object)new DateTimeValidator(simpleDateFormat2, props.getProperty("SUVCORR_START_DATE_ERROR"), string5)));
        final l<String> l3 = inputNotification.addTextField(props.getProperty("SUVCORR_START"));
        l3.a(string7).b((String)((Object)new DateTimeValidator(simpleDateFormat, props.getProperty("SUVCORR_START_ERROR"), string4)));
        final com.mimvista.gui.util.u<Float> u4 = inputNotification.addFloatField(props.getProperty("SUVCORR_HALF"));
        u4.c(f4);
        u4.a(InputError.c, props.getProperty("SUVCORR_HALF_ERROR"));
        u4.a(InputError.a, props.getProperty("SUVCORR_HALF_ERROR"));
        u4.a(InputError.b, props.getProperty("SUVCORR_HALF_ERROR"));
        az<Date> az3 = SuvCalculator.getScanDateTimeQIBAMethod(seriesInfo);
        final l<String> l4 = inputNotification.addTextField(props.getProperty("SUVCORR_SCAN_DATE"));
        if (az3.a()) {
            l4.a(simpleDateFormat2.format(az3.b()));
        }
        l4.b((String)((Object)new DateTimeValidator(simpleDateFormat2, props.getProperty("SUVCORR_SCAN_DATE_ERROR"), string5)));
        final l<String> l5 = inputNotification.addTextField(props.getProperty("SUVCORR_SCAN_TIME"));
        if (az3.a()) {
            l5.a(simpleDateFormat.format(az3.b()));
        }
        l5.b((String)((Object)new DateTimeValidator(simpleDateFormat, props.getProperty("SUVCORR_SCAN_TIME_ERROR"), string4)));
        final com.mimvista.gui.util.u<Float> u5 = inputNotification.addFloatField(props.getProperty("SUVCORR_SIZE"));
        u5.c(f5);
        if (calculationType == SuvCalculator.CalculationType.b || calculationType == SuvCalculator.CalculationType.c) {
            u5.a(InputError.c, props.getProperty("SUVCORR_SIZE_ERROR"));
            u5.a(InputError.a, props.getProperty("SUVCORR_SIZE_ERROR"));
            u5.a(InputError.b, props.getProperty("SUVCORR_SIZE_ERROR"));
        }
        final af af2 = inputNotification.addStringField(props.getProperty("SUVCORR_SEX"));
        af2.d(string8);
        if (calculationType == SuvCalculator.CalculationType.b) {
            af2.c("m|M|f|F").b(0).a(1).d(string8);
            af2.a(InputError.f, props.getProperty("SUVCORR_SEX_ERROR"));
        }
        if (calculationType != SuvCalculator.CalculationType.a) {
            JButton jButton = inputNotification.addButton(props.getProperty("SUVCORR_TRY_SUVBW_BUTTON_TIP"), props.getProperty("SUVCORR_TRY_SUVBW_BUTTON_TEXT"), null, props.getProperty("SUVCORR_TRY_SUVBW_BUTTON_TIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List<String> list = MuiSuvCorrector.this.testForPossibleOutOfRangeFields(SuvCalculator.CalculationType.a, seriesInfo);
                    if (list.size() > 0) {
                        u.b().d(inputNotification);
                        String string = "";
                        if (list.size() > 0) {
                            string = MuiSuvCorrector.this.getPossibleOutOfRangeMessage(list, SuvCalculator.CalculationType.a);
                        }
                        MuiSuvCorrector.this.showSuvCorrector(SuvCalculator.CalculationType.a, az2, seriesInfo, string, true);
                    } else {
                        boolean bl2 = MuiSuvCorrector.this.handleSUVCalculationAttempt(SuvCalculator.CalculationType.a, seriesInfo, inputNotification, simpleDateFormat, simpleDateFormat2, u2, u3, l2, l3, u4, l4, l5, u5, af2);
                        MuiSuvCorrector.this.setPreferredCalcType(calculationType);
                        if (bl2) {
                            u.b().d(inputNotification);
                        }
                    }
                }
            });
        }
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MuiSuvCorrector.this.handleSUVCalculationAttempt(calculationType, seriesInfo, inputNotification, simpleDateFormat, simpleDateFormat2, u2, u3, l2, l3, u4, l4, l5, u5, af2);
                MuiSuvCorrector.this.runCalculationListeners();
            }
        });
        inputNotification.setHighlightInvalidInputFields(true);
        inputNotification.addToGrandNotifier();
    }

    private float getWeightScaleFactor() {
        if (ConfigPrefs.weightInLb.getValue().booleanValue()) {
            return 2.2046225f;
        }
        return 1.0f;
    }

    private float getDoseScaleFactor() {
        return this.getDoseScaleFactor(false);
    }

    private float getDoseScaleFactor(boolean bl2) {
        if (!bl2 && ConfigPrefs.doseInMbq.getValue().booleanValue()) {
            return 1000000.0f;
        }
        return 3.7E7f;
    }

    private boolean handleSUVCalculationAttempt(SuvCalculator.CalculationType calculationType, SeriesInfo seriesInfo, InputNotification inputNotification, SimpleDateFormat simpleDateFormat, SimpleDateFormat simpleDateFormat2, com.mimvista.gui.util.u<Float> u2, com.mimvista.gui.util.u<Float> u3, l<String> l2, l<String> l3, com.mimvista.gui.util.u<Float> u4, l<String> l4, l<String> l5, com.mimvista.gui.util.u<Float> u5, af af2) {
        boolean bl2 = false;
        try {
            bl2 = this.trySuvCalcWithNewData(calculationType, seriesInfo, new SuvParameters(((Float)u2.b()).floatValue() / this.getWeightScaleFactor(), ((Float)u3.b()).floatValue() * this.getDoseScaleFactor(), ((Float)u4.b()).floatValue(), ((Float)u5.b()).floatValue(), simpleDateFormat2.parse(l2.b()), simpleDateFormat.parse(l3.b()), simpleDateFormat2.parse(l4.b()), simpleDateFormat.parse(l5.b()), (String)af2.b()));
            if (bl2) {
                this.infoChangeListener.b(seriesInfo);
                bm.b().Q();
            } else {
                inputNotification.setErrorText(props.getProperty("SUVCORR_CALC_ERROR"));
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        return bl2;
    }

    @Override
    public List<String> testForPossibleOutOfRangeFields(SuvCalculator.CalculationType calculationType, SeriesInfo seriesInfo) {
        az<Date> az2;
        float f2;
        ArrayList<String> arrayList = new ArrayList<String>();
        float f3 = this.isPEM ? PemPrefs.weightUpperLimitKg.getValue().floatValue() : SuvPrefs.weightUpperLimitKg.getValue().floatValue();
        float f4 = this.isPEM ? PemPrefs.fdgDoseLowerLimitMci.getValue().floatValue() : SuvPrefs.fdgDoseLowerLimitMci.getValue().floatValue();
        float f5 = this.isPEM ? PemPrefs.fdgDoseUpperLimitMci.getValue().floatValue() : SuvPrefs.fdgDoseUpperLimitMci.getValue().floatValue();
        float f6 = this.isPEM ? PemPrefs.fdgDoseToScanIntervalLowerLimitMin.getValue().floatValue() : SuvPrefs.fdgDoseToScanIntervalLowerLimitMin.getValue().floatValue();
        float f7 = f2 = this.isPEM ? PemPrefs.fdgDoseToScanIntervalUpperLimitMin.getValue().floatValue() : SuvPrefs.fdgDoseToScanIntervalUpperLimitMin.getValue().floatValue();
        if (Float.valueOf(seriesInfo.weight).isNaN()) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_WEIGHT"));
        } else if (seriesInfo.weight > f3) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_UPPER_WEIGHT"));
        }
        if (Float.valueOf(seriesInfo.dose / this.getDoseScaleFactor(true)).isNaN()) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_DOSE"));
        } else if (seriesInfo.dose / this.getDoseScaleFactor(true) < f4) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_LOWER_DOSE"));
        } else if (seriesInfo.dose / this.getDoseScaleFactor(true) > f5) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_UPPER_DOSE"));
        }
        if (seriesInfo.startDate == null) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_START_DATE"));
        }
        if (seriesInfo.startTime == null) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_START"));
        }
        if (Float.valueOf(seriesInfo.halflife).isNaN()) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_HALFLIFE"));
        }
        if (!(az2 = SuvCalculator.getScanDateTimeQIBAMethod(seriesInfo)).a()) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_SCAN_TIME"));
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(az2.b());
            Calendar calendar2 = Calendar.getInstance();
            Date date = SuvCalculator.getRadiopharmStartDateIncludingDateAndTime(seriesInfo);
            if (date != null) {
                calendar2.setTime(date);
                double d2 = (double)(calendar.getTimeInMillis() - calendar2.getTimeInMillis()) / 1000.0 / 60.0;
                if (d2 > (double)f2) {
                    arrayList.add(props.getProperty("SUVCORR_TOLERANCE_UPPER_INTERVAL"));
                }
                if (d2 < (double)f6) {
                    arrayList.add(props.getProperty("SUVCORR_TOLERANCE_LOWER_INTERVAL"));
                }
            }
        }
        if (calculationType == SuvCalculator.CalculationType.b || calculationType == SuvCalculator.CalculationType.c) {
            float f8;
            float f9 = this.isPEM ? PemPrefs.patientSizeLowerLimitM.getValue().floatValue() : SuvPrefs.patientSizeLowerLimitM.getValue().floatValue();
            float f10 = f8 = this.isPEM ? PemPrefs.patientSizeUpperLimitM.getValue().floatValue() : SuvPrefs.patientSizeUpperLimitM.getValue().floatValue();
            if (Float.valueOf(seriesInfo.patientSize).isNaN()) {
                arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_SIZE"));
            } else if (seriesInfo.patientSize > f8) {
                arrayList.add(props.getProperty("SUVCORR_TOLERANCE_UPPER_SIZE"));
            } else if (seriesInfo.patientSize < f9) {
                arrayList.add(props.getProperty("SUVCORR_TOLERANCE_LOWER_SIZE"));
            }
        }
        if (calculationType == SuvCalculator.CalculationType.b && seriesInfo.sex == null) {
            arrayList.add(props.getProperty("SUVCORR_TOLERANCE_NO_SEX"));
        }
        return arrayList;
    }

    private boolean trySuvCalcWithNewData(SuvCalculator.CalculationType calculationType, SeriesInfo seriesInfo, SuvParameters suvParameters) {
        SuvParameters suvParameters2 = new SuvParameters(seriesInfo);
        suvParameters.apply(seriesInfo, calculationType);
        boolean bl2 = SuvCalculator.tryCalcSuv(seriesInfo, calculationType);
        if (!bl2) {
            suvParameters2.apply(seriesInfo, calculationType);
            seriesInfo.u().b(seriesInfo.u().a());
        } else {
            this.finishCalcChangeAndHandleDynamics(seriesInfo, calculationType, suvParameters);
        }
        return bl2;
    }

    private String getPossibleOutOfRangeMessage(List<String> list, SuvCalculator.CalculationType calculationType) {
        String string = "<b>SUV" + calculationType.a().toLowerCase() + "</b>";
        if (this.isPEM) {
            string = "<b>PUV</b>";
        }
        String string2 = MIMFormat.a(props.getProperty("SUVCORR_OUT_OF_RANGE"), string) + "<br><br>";
        for (String string3 : list) {
            string2 = string2 + "<b>" + string3 + "</b><br>";
        }
        string2 = string2 + "<br>";
        return string2;
    }

    @Override
    public void showPossibleOutOfRangeMessage(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType, List<String> list) {
        this.showSuvCorrector(calculationType, null, seriesInfo, this.getPossibleOutOfRangeMessage(list, calculationType), false);
    }

    private String getErrorComputingSuvMessage() {
        return props.getProperty("SUVCORR_ERROR_COMPUTING") + "<br><br>";
    }

    @Override
    public void showErrorComputingSuvMessage(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType) {
        this.showSuvCorrector(calculationType, null, seriesInfo, this.getErrorComputingSuvMessage(), false);
    }

    private String getCombinedMessage(List<String> list, SuvCalculator.CalculationType calculationType) {
        String string = this.getErrorComputingSuvMessage();
        String string2 = this.getPossibleOutOfRangeMessage(list, calculationType);
        return string + string2;
    }

    @Override
    public void showOutOfRangeAndErrorComputingMessage(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType, List<String> list) {
        this.showSuvCorrector(calculationType, null, seriesInfo, this.getCombinedMessage(list, calculationType), false);
    }

    @Override
    public boolean shouldPromptIfSuvCalcFails() {
        MIMPref<Boolean> mIMPref = this.isPEM ? PemPrefs.promptIfSuvCalculationFails : SuvPrefs.promptIfSuvCalculationFails;
        return mIMPref.getValue();
    }

    public static class SuvParameters {
        public float weight;
        public float dose;
        public float halflife;
        public float size;
        public Date startDate;
        public Date startTime;
        public Date acqDate;
        public Date acqTime;
        public String sex;

        public SuvParameters(float f2, float f3, float f4, float f5, Date date, Date date2, Date date3, Date date4, String string) {
            this.weight = f2;
            this.dose = f3;
            this.halflife = f4;
            this.size = f5;
            this.startDate = date;
            this.startTime = date2;
            this.acqDate = date3;
            this.acqTime = date4;
            this.sex = string;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(date2);
            calendar2.setTime(date);
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, calendar.get(13));
            date = calendar2.getTime();
        }

        public SuvParameters(SeriesInfo seriesInfo) {
            this.weight = seriesInfo.weight;
            this.dose = seriesInfo.dose;
            this.halflife = seriesInfo.halflife;
            this.size = seriesInfo.patientSize;
            this.startTime = seriesInfo.startTime;
            this.startDate = seriesInfo.startDate;
            az<Date> az2 = SuvCalculator.getScanDateTimeQIBAMethod(seriesInfo);
            if (az2.a()) {
                this.acqDate = DateUtils.f(az2.b());
                this.acqTime = az2.b();
            }
            this.sex = seriesInfo.sex;
        }

        public void apply(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType) {
            seriesInfo.weight = this.weight;
            seriesInfo.dose = this.dose;
            seriesInfo.halflife = this.halflife;
            seriesInfo.patientSize = this.size;
            seriesInfo.startTime = this.startTime;
            seriesInfo.startDate = this.startDate;
            seriesInfo.c(DateUtils.b(this.acqDate));
            seriesInfo.f(DateUtils.e(this.acqTime));
            seriesInfo.acqDate = this.acqDate;
            seriesInfo.acqTime = this.acqTime;
            seriesInfo.sex = this.sex;
        }
    }

    private static final class DateTimeValidator
    implements k {
        private DateFormat format;
        private String errorInfo;
        private String regex;

        public DateTimeValidator(DateFormat dateFormat, String string, String string2) {
            this.errorInfo = string;
            this.format = dateFormat;
            this.regex = string2;
        }

        @Override
        public String validate(Object object) {
            assert (object != null);
            if (this.regex != null && !object.toString().matches(this.regex)) {
                return this.errorInfo;
            }
            try {
                this.format.parse(object.toString());
                return null;
            }
            catch (Exception exception) {
                return this.errorInfo;
            }
        }
    }
}

