/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.util.TagUtils;
import com.mimvista.util.ay;
import java.util.Arrays;
import java.util.Date;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class NonCrashyDicomObject
extends BasicDicomObject {
    private static final long serialVersionUID = -9087476890158683523L;

    public static NonCrashyDicomObject copyIfCrashy(DicomObject dicomObject) {
        if (dicomObject instanceof NonCrashyDicomObject) {
            return (NonCrashyDicomObject)dicomObject;
        }
        NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
        dicomObject.copyTo((DicomObject)nonCrashyDicomObject, false);
        return nonCrashyDicomObject;
    }

    public DicomObject getNestedDicomObject(int n2) {
        DicomObject dicomObject = super.getNestedDicomObject(n2);
        if (dicomObject != null && !(dicomObject instanceof NonCrashyDicomObject)) {
            NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
            dicomObject.copyTo((DicomObject)nonCrashyDicomObject, false);
            return nonCrashyDicomObject;
        }
        return dicomObject;
    }

    public Date getDate(int n2) {
        return this.getDatePro(n2, null, null, null);
    }

    public Date getDate(int n2, Date date) {
        return this.getDatePro(n2, null, null, date);
    }

    public Date getDate(int n2, VR vR) {
        return this.getDatePro(n2, null, vR, null);
    }

    public Date getDate(int n2, VR vR, Date date) {
        return this.getDatePro(n2, null, vR, date);
    }

    public Date getDate(int[] nArray) {
        return this.getDatePro(0, nArray, null, null);
    }

    public Date getDate(int[] nArray, Date date) {
        return this.getDatePro(0, nArray, null, date);
    }

    public Date getDate(int[] nArray, VR vR) {
        return this.getDatePro(0, nArray, vR, null);
    }

    public Date getDate(int[] nArray, VR vR, Date date) {
        return this.getDatePro(0, nArray, vR, date);
    }

    private Date getDatePro(int n2, int[] nArray, VR vR, Date date) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return date;
                }
                if (vR != null) {
                    return vR.toDate(byArray);
                }
                return nArray == null ? super.getDate(n2, date) : super.getDate(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toDate(byArray);
                }
                return TagUtils.vrOfTag(n2).toDate(byArray);
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getDate failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return date;
        }
    }

    public Date[] getDates(int[] nArray) {
        return this.getDatesPro(0, nArray, null, null);
    }

    public Date[] getDates(int[] nArray, Date[] dateArray) {
        return this.getDatesPro(0, nArray, null, dateArray);
    }

    public Date[] getDates(int[] nArray, VR vR) {
        return this.getDatesPro(0, nArray, vR, null);
    }

    public Date[] getDates(int[] nArray, VR vR, Date[] dateArray) {
        return this.getDatesPro(0, nArray, vR, dateArray);
    }

    public Date[] getDates(int n2) {
        return this.getDatesPro(n2, null, null, null);
    }

    public Date[] getDates(int n2, Date[] dateArray) {
        return this.getDatesPro(n2, null, null, dateArray);
    }

    public Date[] getDates(int n2, VR vR) {
        return this.getDatesPro(n2, null, vR, null);
    }

    public Date[] getDates(int n2, VR vR, Date[] dateArray) {
        return this.getDatesPro(n2, null, vR, dateArray);
    }

    private Date[] getDatesPro(int n2, int[] nArray, VR vR, Date[] dateArray) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return dateArray;
                }
                if (vR != null) {
                    return vR.toDates(byArray);
                }
                return nArray == null ? super.getDates(n2, dateArray) : super.getDates(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toDates(byArray);
                }
                return TagUtils.vrOfTag(n2).toDates(byArray);
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getDates failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return dateArray;
        }
    }

    public DateRange getDateRange(int n2) {
        return this.getDateRangePro(n2, null, null, null);
    }

    public DateRange getDateRange(int n2, DateRange dateRange) {
        return this.getDateRangePro(n2, null, null, dateRange);
    }

    public DateRange getDateRange(int n2, VR vR) {
        return this.getDateRangePro(n2, null, vR, null);
    }

    public DateRange getDateRange(int n2, VR vR, DateRange dateRange) {
        return this.getDateRangePro(n2, null, vR, dateRange);
    }

    public DateRange getDateRange(int[] nArray) {
        return this.getDateRangePro(0, nArray, null, null);
    }

    public DateRange getDateRange(int[] nArray, DateRange dateRange) {
        return this.getDateRangePro(0, nArray, null, dateRange);
    }

    public DateRange getDateRange(int[] nArray, VR vR) {
        return this.getDateRangePro(0, nArray, vR, null);
    }

    public DateRange getDateRange(int[] nArray, VR vR, DateRange dateRange) {
        return this.getDateRangePro(0, nArray, vR, dateRange);
    }

    private DateRange getDateRangePro(int n2, int[] nArray, VR vR, DateRange dateRange) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return dateRange;
                }
                if (vR != null) {
                    return vR.toDateRange(byArray);
                }
                return nArray == null ? super.getDateRange(n2, dateRange) : super.getDateRange(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toDateRange(byArray);
                }
                return TagUtils.vrOfTag(n2).toDateRange(byArray);
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getDateRange failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return dateRange;
        }
    }

    public short[] getShorts(int[] nArray) {
        return this.getShortsPro(0, nArray, null, null);
    }

    public short[] getShorts(int[] nArray, short[] sArray) {
        return this.getShortsPro(0, nArray, null, sArray);
    }

    public short[] getShorts(int[] nArray, VR vR) {
        return this.getShortsPro(0, nArray, vR, null);
    }

    public short[] getShorts(int[] nArray, VR vR, short[] sArray) {
        return this.getShortsPro(0, nArray, vR, sArray);
    }

    public short[] getShorts(int n2) {
        return this.getShortsPro(n2, null, null, null);
    }

    public short[] getShorts(int n2, short[] sArray) {
        return this.getShortsPro(n2, null, null, sArray);
    }

    public short[] getShorts(int n2, VR vR) {
        return this.getShortsPro(n2, null, vR, null);
    }

    public short[] getShorts(int n2, VR vR, short[] sArray) {
        return this.getShortsPro(n2, null, vR, sArray);
    }

    private short[] getShortsPro(int n2, int[] nArray, VR vR, short[] sArray) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return sArray;
                }
                if (vR != null) {
                    return vR.toShorts(byArray, this.bigEndian());
                }
                return nArray == null ? super.getShorts(n2, sArray) : super.getShorts(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toShorts(byArray, this.bigEndian());
                }
                return TagUtils.vrOfTag(n2).toShorts(byArray, this.bigEndian());
            }
        }
        catch (NumberFormatException numberFormatException) {
            float[] fArray = this.getFloatsPro(n2, nArray, vR, null);
            if (fArray == null) {
                return sArray;
            }
            ay.c((Object)("DCM getShorts precision loss: " + Arrays.toString(fArray)), (Object)this);
            short[] sArray2 = new short[fArray.length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                sArray2[i2] = (short)fArray[i2];
            }
            return sArray2;
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getShorts failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return sArray;
        }
    }

    public int getInt(int n2) {
        return this.getIntPro(n2, null, null, 0);
    }

    public int getInt(int n2, int n3) {
        return this.getIntPro(n2, null, null, n3);
    }

    public int getInt(int n2, VR vR) {
        return this.getIntPro(n2, null, vR, 0);
    }

    public int getInt(int n2, VR vR, int n3) {
        return this.getIntPro(n2, null, vR, n3);
    }

    public int getInt(int[] nArray) {
        return this.getIntPro(0, nArray, null, 0);
    }

    public int getInt(int[] nArray, int n2) {
        return this.getIntPro(0, nArray, null, n2);
    }

    public int getInt(int[] nArray, VR vR) {
        return this.getIntPro(0, nArray, vR, 0);
    }

    public int getInt(int[] nArray, VR vR, int n2) {
        return this.getIntPro(0, nArray, vR, n2);
    }

    private int getIntPro(int n2, int[] nArray, VR vR, int n3) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return n3;
                }
                if (vR != null) {
                    return vR.toInt(byArray, this.bigEndian());
                }
                return nArray == null ? super.getInt(n2, n3) : super.getInt(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toInt(byArray, this.bigEndian());
                }
                return TagUtils.vrOfTag(n2).toInt(byArray, this.bigEndian());
            }
        }
        catch (NumberFormatException numberFormatException) {
            float f2 = this.getFloatPro(n2, nArray, vR, n3);
            ay.c((Object)("DCM getInt precision loss: " + f2), (Object)this);
            return (int)f2;
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getInt failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return n3;
        }
    }

    public int[] getInts(int[] nArray) {
        return this.getIntsPro(0, nArray, null, null);
    }

    public int[] getInts(int[] nArray, int[] nArray2) {
        return this.getIntsPro(0, nArray, null, nArray2);
    }

    public int[] getInts(int[] nArray, VR vR) {
        return this.getIntsPro(0, nArray, vR, null);
    }

    public int[] getInts(int[] nArray, VR vR, int[] nArray2) {
        return this.getIntsPro(0, nArray, vR, nArray2);
    }

    public int[] getInts(int n2) {
        return this.getIntsPro(n2, null, null, null);
    }

    public int[] getInts(int n2, int[] nArray) {
        return this.getIntsPro(n2, null, null, nArray);
    }

    public int[] getInts(int n2, VR vR) {
        return this.getIntsPro(n2, null, vR, null);
    }

    public int[] getInts(int n2, VR vR, int[] nArray) {
        return this.getIntsPro(n2, null, vR, nArray);
    }

    private int[] getIntsPro(int n2, int[] nArray, VR vR, int[] nArray2) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return nArray2;
                }
                if (vR != null) {
                    return vR.toInts(byArray, this.bigEndian());
                }
                return nArray == null ? super.getInts(n2, nArray2) : super.getInts(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toInts(byArray, this.bigEndian());
                }
                return TagUtils.vrOfTag(n2).toInts(byArray, this.bigEndian());
            }
        }
        catch (NumberFormatException numberFormatException) {
            float[] fArray = this.getFloatsPro(n2, nArray, vR, null);
            if (fArray == null) {
                return nArray2;
            }
            ay.c((Object)("DCM getInts precision loss: " + Arrays.toString(fArray)), (Object)this);
            int[] nArray3 = new int[fArray.length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                nArray3[i2] = (int)fArray[i2];
            }
            return nArray3;
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getInts failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return nArray2;
        }
    }

    public float getFloat(int n2) {
        return this.getFloatPro(n2, null, null, 0.0f);
    }

    public float getFloat(int n2, float f2) {
        return this.getFloatPro(n2, null, null, f2);
    }

    public float getFloat(int n2, VR vR) {
        return this.getFloatPro(n2, null, vR, 0.0f);
    }

    public float getFloat(int n2, VR vR, float f2) {
        return this.getFloatPro(n2, null, vR, f2);
    }

    public float getFloat(int[] nArray) {
        return this.getFloatPro(0, nArray, null, 0.0f);
    }

    public float getFloat(int[] nArray, float f2) {
        return this.getFloatPro(0, nArray, null, f2);
    }

    public float getFloat(int[] nArray, VR vR) {
        return this.getFloatPro(0, nArray, vR, 0.0f);
    }

    public float getFloat(int[] nArray, VR vR, float f2) {
        return this.getFloatPro(0, nArray, vR, f2);
    }

    private float getFloatPro(int n2, int[] nArray, VR vR, float f2) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return f2;
                }
                if (vR != null) {
                    return vR.toFloat(byArray, this.bigEndian());
                }
                return nArray == null ? super.getFloat(n2, f2) : super.getFloat(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                VR vR2 = nArray != null ? TagUtils.vrOfTag(nArray) : TagUtils.vrOfTag(n2);
                try {
                    return vR2.toFloat(byArray, this.bigEndian());
                }
                catch (UnsupportedOperationException unsupportedOperationException2) {
                    return Float.valueOf(this.getString(n2, vR2)).floatValue();
                }
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getFloat failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return f2;
        }
    }

    public float[] getFloats(int[] nArray) {
        return this.getFloatsPro(0, nArray, null, null);
    }

    public float[] getFloats(int[] nArray, float[] fArray) {
        return this.getFloatsPro(0, nArray, null, fArray);
    }

    public float[] getFloats(int[] nArray, VR vR) {
        return this.getFloatsPro(0, nArray, vR, null);
    }

    public float[] getFloats(int[] nArray, VR vR, float[] fArray) {
        return this.getFloatsPro(0, nArray, vR, fArray);
    }

    public float[] getFloats(int n2) {
        return this.getFloatsPro(n2, null, null, null);
    }

    public float[] getFloats(int n2, float[] fArray) {
        return this.getFloatsPro(n2, null, null, fArray);
    }

    public float[] getFloats(int n2, VR vR) {
        return this.getFloatsPro(n2, null, vR, null);
    }

    public float[] getFloats(int n2, VR vR, float[] fArray) {
        return this.getFloatsPro(n2, null, vR, fArray);
    }

    private float[] getFloatsPro(int n2, int[] nArray, VR vR, float[] fArray) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return fArray;
                }
                if (vR != null) {
                    return vR.toFloats(byArray, this.bigEndian());
                }
                return nArray == null ? super.getFloats(n2, fArray) : super.getFloats(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toFloats(byArray, this.bigEndian());
                }
                return TagUtils.vrOfTag(n2).toFloats(byArray, this.bigEndian());
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getFloats failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return fArray;
        }
    }

    public double getDouble(int n2) {
        return this.getDoublePro(n2, null, null, 0.0);
    }

    public double getDouble(int n2, double d2) {
        return this.getDoublePro(n2, null, null, d2);
    }

    public double getDouble(int n2, VR vR) {
        return this.getDoublePro(n2, null, vR, 0.0);
    }

    public double getDouble(int n2, VR vR, double d2) {
        return this.getDoublePro(n2, null, vR, d2);
    }

    public double getDouble(int[] nArray) {
        return this.getDoublePro(0, nArray, null, 0.0);
    }

    public double getDouble(int[] nArray, double d2) {
        return this.getDoublePro(0, nArray, null, d2);
    }

    public double getDouble(int[] nArray, VR vR) {
        return this.getDoublePro(0, nArray, vR, 0.0);
    }

    public double getDouble(int[] nArray, VR vR, double d2) {
        return this.getDoublePro(0, nArray, vR, d2);
    }

    private double getDoublePro(int n2, int[] nArray, VR vR, double d2) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return d2;
                }
                if (vR != null) {
                    return vR.toDouble(byArray, this.bigEndian());
                }
                return nArray == null ? super.getDouble(n2, d2) : super.getDouble(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                VR vR2 = nArray != null ? TagUtils.vrOfTag(nArray) : TagUtils.vrOfTag(n2);
                try {
                    return vR2.toDouble(byArray, this.bigEndian());
                }
                catch (UnsupportedOperationException unsupportedOperationException2) {
                    return Double.valueOf(this.getString(n2, vR2));
                }
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getDouble failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return d2;
        }
    }

    public double[] getDoubles(int[] nArray) {
        return this.getDoublesPro(0, nArray, null, null);
    }

    public double[] getDoubles(int[] nArray, double[] dArray) {
        return this.getDoublesPro(0, nArray, null, dArray);
    }

    public double[] getDoubles(int[] nArray, VR vR) {
        return this.getDoublesPro(0, nArray, vR, null);
    }

    public double[] getDoubles(int[] nArray, VR vR, double[] dArray) {
        return this.getDoublesPro(0, nArray, vR, dArray);
    }

    public double[] getDoubles(int n2) {
        return this.getDoublesPro(n2, null, null, null);
    }

    public double[] getDoubles(int n2, double[] dArray) {
        return this.getDoublesPro(n2, null, null, dArray);
    }

    public double[] getDoubles(int n2, VR vR) {
        return this.getDoublesPro(n2, null, vR, null);
    }

    public double[] getDoubles(int n2, VR vR, double[] dArray) {
        return this.getDoublesPro(n2, null, vR, dArray);
    }

    private double[] getDoublesPro(int n2, int[] nArray, VR vR, double[] dArray) {
        try {
            byte[] byArray = nArray == null ? this.getBytes(n2) : this.getBytes(nArray);
            try {
                if (byArray == null || byArray.length == 0) {
                    return dArray;
                }
                if (vR != null) {
                    return vR.toDoubles(byArray, this.bigEndian());
                }
                return nArray == null ? super.getDoubles(n2, dArray) : super.getDoubles(nArray);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (nArray != null) {
                    return TagUtils.vrOfTag(nArray).toDoubles(byArray, this.bigEndian());
                }
                return TagUtils.vrOfTag(n2).toDoubles(byArray, this.bigEndian());
            }
        }
        catch (Throwable throwable) {
            ay.a((Object)("DCM getDoubles failure: " + Integer.toHexString(n2) + " " + throwable.getMessage()), (Object)this);
            return dArray;
        }
    }
}

