/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.DerivedSliceInfo;
import com.mimvista.internals.SliceInfo;
import java.util.List;

public class NonUniformHelper {
    public static float THRESH_PERCENT = 0.99f;
    private List<SliceInfo> slices;
    private List<Float> sliceZPositions = Lists.newArrayList();
    private List<Boolean> sliceIsSmallest;

    public NonUniformHelper(List<SliceInfo> list, List<Float> list2, List<Boolean> list3) {
        this.slices = list;
        this.sliceZPositions = list2;
        this.sliceIsSmallest = list3;
        if (list2.size() != list3.size() || list.size() != list2.size()) {
            throw new RuntimeException("these list must be same size!!!!!");
        }
    }

    public DerivedSliceInfo getDerivedSliceByDistanceFromTop(float f2) {
        int n2 = this.zToIndex(f2);
        float f3 = 1.0f;
        DerivedSliceInfo derivedSliceInfo = new DerivedSliceInfo();
        if (n2 < 0) {
            derivedSliceInfo.first = this.slices.get(0);
        } else if (n2 >= this.sliceZPositions.size() - 1) {
            derivedSliceInfo.first = this.slices.get(this.slices.size() - 1);
        } else {
            derivedSliceInfo.first = this.slices.get(n2);
            derivedSliceInfo.second = this.slices.get(n2 + 1);
            float f4 = f2 - this.sliceZPositions.get(n2).floatValue();
            float f5 = this.sliceZPositions.get(n2 + 1).floatValue() - f2;
            f3 = this.sliceZPositions.get(n2 + 1).floatValue() - this.sliceZPositions.get(n2).floatValue();
            derivedSliceInfo.firstPercent = f5 / f3;
            derivedSliceInfo.secondPercent = f4 / f3;
        }
        return derivedSliceInfo;
    }

    private int zToIndex(float f2) {
        int n2;
        if (this.sliceZPositions.isEmpty() || this.sliceZPositions.get(0).floatValue() > f2) {
            return -1;
        }
        for (n2 = 0; n2 < this.sliceZPositions.size() - 1 && !(this.sliceZPositions.get(n2 + 1).floatValue() > f2); ++n2) {
        }
        return n2;
    }

    public float determineOptimalStartingZOffset(float f2) {
        float f3;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.sliceZPositions.size(); ++i2) {
            int n4 = this.countNumberOfExactlyHitThinSlices(i2, f2);
            if (n4 <= n3) continue;
            n3 = n4;
            n2 = i2;
        }
        for (f3 = this.sliceZPositions.get(n2).floatValue(); f3 > this.sliceZPositions.get(0).floatValue(); f3 -= f2) {
        }
        return f3;
    }

    private int countNumberOfExactlyHitThinSlices(int n2, float f2) {
        float f3;
        float f4;
        for (f4 = f3 = this.sliceZPositions.get(n2).floatValue(); f4 > f2; f4 -= f2) {
        }
        int n3 = (int)((this.sliceZPositions.get(this.sliceZPositions.size() - 1).floatValue() - this.sliceZPositions.get(0).floatValue()) / f2);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            float f5 = f4 + (float)i2 * f2;
            DerivedSliceInfo derivedSliceInfo = this.getDerivedSliceByDistanceFromTop(f5);
            if (!this.isExactlyHitThinSlice(derivedSliceInfo, f5)) continue;
            ++n4;
        }
        return n4;
    }

    private boolean isExactlyHitThinSlice(DerivedSliceInfo derivedSliceInfo, float f2) {
        int n2 = this.zToIndex(f2);
        if (n2 < 0) {
            return false;
        }
        if (n2 >= this.sliceZPositions.size() - 1) {
            return false;
        }
        if (derivedSliceInfo.firstPercent > THRESH_PERCENT && this.sliceIsSmallest.get(n2).booleanValue()) {
            return true;
        }
        return derivedSliceInfo.secondPercent > THRESH_PERCENT && this.sliceIsSmallest.get(n2 + 1) != false;
    }
}

