/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.PixelDataRescaler;
import com.mimvista.dicom.util.DicomRLEDecompressor;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.internals.SliceInfo;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dcm4che2.data.DicomObject;

public class PixelDataExtractor {
    public static Integer readPixelPaddingValue(DicomObject dicomObject) {
        Integer n2 = null;
        if (dicomObject.contains(2621728)) {
            n2 = dicomObject.getInt(2621728);
            int n3 = dicomObject.getInt(2621699, 1);
            if (n3 == 1) {
                if (dicomObject.getInt(2621697) == 16) {
                    short s2 = (short)n2.intValue();
                    n2 = s2;
                }
            } else {
                int n4 = dicomObject.getInt(2621696);
                int n5 = dicomObject.getInt(2621697);
                if (n5 == n4) {
                    int n6 = 0;
                    if (n5 == 16) {
                        n6 = Short.MIN_VALUE;
                    } else if (n5 == 32) {
                        n6 = Integer.MIN_VALUE;
                    }
                    n2 = n2 + n6;
                }
            }
        }
        return n2;
    }

    public static short[] extractPixelData(DicomObject dicomObject, RescaleParameters rescaleParameters) {
        boolean bl2;
        String string;
        ByteOrder byteOrder = dicomObject.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int n2 = dicomObject.getInt(2621699, 1);
        int n3 = dicomObject.getInt(2621696);
        int n4 = dicomObject.getInt(2621697);
        DicomObject dicomObject2 = dicomObject.fileMetaInfo();
        if (dicomObject2 != null && (string = dicomObject2.getString(131088)) != null) {
            if (DicomJpegDecompressor.isJpegCompressed(string)) {
                DicomJpegDecompressor.DecompressResult decompressResult = DicomJpegDecompressor.getDecompressResultFromDataset(dicomObject, true);
                if (decompressResult != null) {
                    rescaleParameters.intercept -= (float)decompressResult.appliedOffset * rescaleParameters.slope;
                    return decompressResult.decompressedData;
                }
                return null;
            }
            if (string.equals("1.2.840.10008.1.2") || string.equals("1.2.840.10008.1.2.1")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if (string.equals("1.2.840.10008.1.2.2")) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
        }
        if (n3 == 16 && n2 == 0) {
            long l2 = n4 < n3 ? 0L : -32768L;
            rescaleParameters.intercept -= (float)l2 * rescaleParameters.slope;
        }
        boolean bl3 = bl2 = rescaleParameters.slope < 0.0f;
        byte[] byArray = dicomObject2 != null && DicomRLEDecompressor.isRLECompressed(dicomObject2.getString(131088)) ? DicomRLEDecompressor.getPixelDataFromCompressedRLEDicomObject(dicomObject) : dicomObject.getBytes(2145386512, byteOrder == ByteOrder.BIG_ENDIAN);
        if (byArray == null || byArray.length == 0) {
            throw new MissingPixelDataException();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(byteOrder);
        if (n4 > n3) {
            ay.c((Object)"Bits Stored shouldn't be larger than Bits Allocated!", PixelDataExtractor.class);
            n4 = n3;
        }
        int n5 = 32 - n4;
        long l3 = 0L;
        for (int i2 = 0; i2 < n4; ++i2) {
            l3 += 1L << i2;
        }
        short[] sArray = null;
        switch (n3) {
            case 8: {
                sArray = new short[byteBuffer.capacity()];
                for (int i3 = 0; i3 < sArray.length; ++i3) {
                    short s2 = n2 == 0 ? (short)((long)byteBuffer.get() & l3) : (short)(byteBuffer.get() << n5 >> n5);
                    if (bl2) {
                        s2 = (short)(s2 * -1 - 1);
                    }
                    sArray[i3] = s2;
                }
                if (!bl2 || rescaleParameters.pixelPadding == null) break;
                rescaleParameters.pixelPadding = rescaleParameters.pixelPadding * -1 - 1;
                break;
            }
            case 16: {
                sArray = new short[byteBuffer.capacity() / 2];
                long l4 = n4 < n3 ? 0L : -32768L;
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    short s3 = byteBuffer.getShort();
                    short s4 = n2 == 0 ? (short)(((long)s3 & l3) + l4) : (short)(s3 << n5 >> n5);
                    if (bl2) {
                        s4 = (short)(s4 * -1 - 1);
                    }
                    sArray[i4] = s4;
                }
                if (!bl2 || rescaleParameters.pixelPadding == null) break;
                rescaleParameters.pixelPadding = rescaleParameters.pixelPadding * -1 - 1;
                break;
            }
            case 24: {
                sArray = PixelDataExtractor.load24bit(dicomObject, rescaleParameters, byteBuffer, n2, bl2, n5, l3);
                break;
            }
            case 32: {
                sArray = PixelDataExtractor.load32bit(dicomObject, rescaleParameters, byteBuffer, n2, bl2, n5, l3, n4, n3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bit width: " + String.valueOf(n3));
            }
        }
        if (bl2) {
            rescaleParameters.slope *= -1.0f;
            rescaleParameters.intercept += rescaleParameters.slope;
        }
        return sArray;
    }

    private static short[] load24bit(DicomObject dicomObject, RescaleParameters rescaleParameters, ByteBuffer byteBuffer, int n2, boolean bl2, int n3, long l2) {
        int[] nArray = new int[byteBuffer.capacity() / 3];
        short[] sArray = new short[byteBuffer.capacity() / 3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = byteBuffer.get() & 0xFF;
            int n4 = i2;
            nArray[n4] = nArray[n4] + ((byteBuffer.get() & 0xFF) << 8);
            int n5 = i2;
            nArray[n5] = nArray[n5] + ((byteBuffer.get() & 0xFF) << 16);
            nArray[i2] = (int)((long)nArray[i2] & l2);
            if (n2 == 0) continue;
            nArray[i2] = nArray[i2] << n3 >> n3;
        }
        PixelDataExtractor.fillShortBufferFromInts(dicomObject, rescaleParameters, sArray, nArray, bl2);
        return sArray;
    }

    private static short[] load32bit(DicomObject dicomObject, RescaleParameters rescaleParameters, ByteBuffer byteBuffer, int n2, boolean bl2, int n3, long l2, int n4, int n5) {
        long l3 = 0L;
        if (n2 == 0 && n4 == n5) {
            l3 = Integer.MIN_VALUE;
            rescaleParameters.intercept -= (float)l3 * rescaleParameters.slope;
        }
        short[] sArray = new short[byteBuffer.capacity() / 4];
        int[] nArray = new int[byteBuffer.capacity() / 4];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            nArray[i2] = n2 == 0 ? (int)(((long)byteBuffer.getInt() & l2) + l3) : byteBuffer.getInt() << n3 >> n3;
        }
        PixelDataExtractor.fillShortBufferFromInts(dicomObject, rescaleParameters, sArray, nArray, bl2);
        return sArray;
    }

    private static void fillShortBufferFromInts(DicomObject dicomObject, final RescaleParameters rescaleParameters, final short[] sArray, final int[] nArray, final boolean bl2) {
        int n2;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] > n4) {
                n4 = nArray[n2];
            }
            if (nArray[n2] >= n3 || rescaleParameters.pixelPadding != null && nArray[n2] <= rescaleParameters.pixelPadding) continue;
            n3 = nArray[n2];
        }
        if (rescaleParameters.pixelPadding != null) {
            for (n2 = 0; n2 < nArray[n2]; ++n2) {
                if (nArray[n2] > rescaleParameters.pixelPadding) continue;
                nArray[n2] = bl2 ? n4 : n3;
            }
            rescaleParameters.pixelPadding = null;
        }
        Modality modality = Modality.getModalityForSopClass(dicomObject.getString(524310));
        int n5 = 0;
        int n6 = 31767;
        PixelDataRescaler pixelDataRescaler = new PixelDataRescaler(modality, rescaleParameters, n3, n4, n5, n6){

            @Override
            public void applyOffset(long l2, float f2, long l3) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    long l4 = nArray[i2];
                    if (l4 > l3) {
                        l4 = l3;
                    }
                    short s2 = (short)(l4 + l2);
                    if (bl2) {
                        s2 = (short)(s2 * -1 - 1);
                    }
                    sArray[i2] = s2;
                }
                rescaleParameters.intercept = f2;
            }

            @Override
            public void applyRescale(float f2, float f3, double d2) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    long l2 = nArray[i2];
                    if ((double)l2 > d2) {
                        l2 = (long)d2;
                    }
                    double d3 = (double)l2 * (double)rescaleParameters.slope + (double)rescaleParameters.intercept;
                    short s2 = (short)Math.round((d3 - (double)f3) / (double)f2);
                    if (bl2) {
                        s2 = (short)(s2 * -1 - 1);
                    }
                    sArray[i2] = s2;
                }
                rescaleParameters.slope = f2;
                rescaleParameters.intercept = f3;
            }
        };
        pixelDataRescaler.execute();
    }

    public static Pair<Double, Double> adjustMinMaxForFunctionalSeries(int n2, int n3, RescaleParameters rescaleParameters, boolean bl2) {
        double d2;
        double d3 = n2;
        double d4 = n3;
        double d5 = d3 * (double)rescaleParameters.slope + (double)rescaleParameters.intercept;
        double d6 = d4 * (double)rescaleParameters.slope + (double)rescaleParameters.intercept;
        if (d5 > 0.0) {
            d5 = 0.0;
        } else if (d6 < 0.0) {
            d6 = 0.0;
        }
        if (bl2 && d6 > (d2 = (double)Math.max(0, DicomPrefs.doseCap.getValue()))) {
            d6 = d2;
        }
        d3 = (d5 - (double)rescaleParameters.intercept) / (double)rescaleParameters.slope;
        d4 = (d6 - (double)rescaleParameters.intercept) / (double)rescaleParameters.slope;
        return Pair.get(d3, d4);
    }

    public static class RescaleParameters {
        float slope;
        float intercept;
        Integer pixelPadding;

        public RescaleParameters(float f2, float f3, Integer n2) {
            this.slope = f2;
            this.intercept = f3;
            this.pixelPadding = n2;
        }

        public RescaleParameters(SliceInfo sliceInfo) {
            this.slope = sliceInfo.rescaleSlope;
            this.intercept = sliceInfo.rescaleIntercept;
            this.pixelPadding = sliceInfo.pixelPaddingValue;
        }

        public void applyTo(SliceInfo sliceInfo) {
            sliceInfo.rescaleSlope = this.slope;
            sliceInfo.rescaleIntercept = this.intercept;
            sliceInfo.pixelPaddingValue = this.pixelPadding;
        }
    }

    public static class MissingPixelDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

