/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.read.PixelDataExtractor;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import javax.vecmath.Point3d;

public abstract class PixelDataRescaler {
    private Modality mod;
    private PixelDataExtractor.RescaleParameters params;
    private int minInput;
    private int maxInput;
    private int minOutput;
    private int maxOutput;

    public PixelDataRescaler(Modality modality, PixelDataExtractor.RescaleParameters rescaleParameters, int n2, int n3, int n4, int n5) {
        this.mod = modality;
        this.params = rescaleParameters;
        this.minInput = n2;
        this.maxInput = n3;
        this.minOutput = n4;
        this.maxOutput = n5;
    }

    public void execute() {
        double d2;
        double d3;
        Long l2 = null;
        Long l3 = null;
        boolean bl2 = SeriesIdentifier.isFunctionalModality(this.mod);
        if (bl2) {
            long l4;
            Pair<Double, Double> pair = PixelDataExtractor.adjustMinMaxForFunctionalSeries(this.minInput, this.maxInput, this.params, Modality.RTDOSE.equals(this.mod));
            d3 = (Double)pair.x;
            d2 = (Double)pair.y;
            long l5 = Math.round(d3);
            if (MathUtils.b((double)l5, d3, (double)0.001f)) {
                l2 = l5;
            }
            if (MathUtils.b((double)(l4 = Math.round(d2)), d2, (double)0.001f)) {
                l3 = l4;
            }
        } else {
            d3 = this.minInput;
            d2 = this.maxInput;
            l2 = this.minInput;
            l3 = this.maxInput;
        }
        int n2 = this.minOutput;
        int n3 = this.maxOutput;
        if (l2 != null && l3 != null && d2 - d3 <= (double)(n3 - n2)) {
            long l6 = (long)n2 - l2;
            this.applyOffset(l6, this.params.intercept - (float)l6 * this.params.slope, l3);
        } else {
            double d4 = d3 * (double)this.params.slope + (double)this.params.intercept;
            double d5 = d2 * (double)this.params.slope + (double)this.params.intercept;
            double d6 = d5 - d4;
            double d7 = d6 / (double)(n3 - n2);
            double d8 = d4 - (double)n2 * d7;
            if (bl2 && 0.0 >= d4 && 0.0 <= d5) {
                double d9 = (0.0 - d8) / d7;
                long l7 = Math.round(d9);
                Point3d point3d = this.tryRescale1(d7, d8, d4, d5, l7);
                Point3d point3d2 = this.tryRescale2(d4, d5, d9, l7, n3);
                if (point3d != null && point3d2 != null) {
                    if (point3d.z >= point3d2.z) {
                        d7 = point3d.x;
                        d8 = point3d.y;
                    } else {
                        d7 = point3d2.x;
                        d8 = point3d2.y;
                    }
                } else if (point3d != null) {
                    d7 = point3d.x;
                    d8 = point3d.y;
                } else if (point3d2 != null) {
                    d7 = point3d2.x;
                    d8 = point3d2.y;
                }
            }
            this.applyRescale((float)d7, (float)d8, d2);
        }
    }

    private Point3d tryRescale1(double d2, double d3, double d4, double d5, double d6) {
        if (d6 != 0.0 && d3 != 0.0) {
            double d7 = -d3 / d6;
            double d8 = d3;
            double d9 = (0.0 - d8) / d7;
            double d10 = (d5 - d8) / d7 - (d4 - d8) / d7;
            ay.e("Rescale 1: Range = " + d10 + ", Zero = " + d9);
            return new Point3d(d7, d8, d10);
        }
        return null;
    }

    private Point3d tryRescale2(double d2, double d3, double d4, long l2, int n2) {
        if ((double)l2 >= d4 || l2 < (long)n2) {
            long l3;
            long l4 = l3 = (double)l2 >= d4 ? l2 : l2 + 1L;
            if (l3 != (long)n2 && d3 != 0.0) {
                double d5 = d3 / (double)((long)n2 - l3);
                double d6 = (double)(-l3) * d5;
                double d7 = (0.0 - d6) / d5;
                double d8 = (d3 - d6) / d5 - (d2 - d6) / d5;
                ay.e("Rescale 2: Range = " + d8 + ", Zero = " + d7);
                return new Point3d(d5, d6, d8);
            }
        }
        return null;
    }

    public abstract void applyOffset(long var1, float var3, long var4);

    public abstract void applyRescale(float var1, float var2, double var3);
}

