/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.MimJsonSerializable;
import com.mimvista.util.ay;
import com.mimvista.workflow.backend.t;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class RadionuclideCodeValueMapping {
    private static List<Isotope> isotopes = new ArrayList<Isotope>();
    private static List<Isotope> isotopesWithKnownDecayEnergies = new ArrayList<Isotope>();
    private static List<Isotope> isotopesWithKnownHalfLifes = new ArrayList<Isotope>();
    private static final Map<String, Isotope> codeValueToIsotopeMap = Maps.newHashMap();
    private static final Map<String, Isotope> codeMeaningToIsotopeMap = Maps.newHashMap();
    private static final double MAX_DECAY_ENERGY_DIFF_IN_KEV = 17.0;
    private static final double MIN_DIFF_TO_SECOND_BEST = 5.0;
    public static final Isotope TECHNETIUM_99M;
    public static final Isotope INDIUM_111;
    public static final Isotope GALIUM_67;
    public static final Isotope THALLIUM_201;
    public static final Isotope IODINE_123;
    public static final Isotope IODINE_131;

    public static String getMeaningForValue(String string) {
        Isotope isotope = codeValueToIsotopeMap.get(string.toUpperCase());
        if (isotope == null) {
            return null;
        }
        return isotope.codeMeaning;
    }

    public static Isotope getIsotopeWithClosestDecayEnergy(double d2) {
        Isotope isotope = null;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        for (Isotope isotope2 : isotopesWithKnownDecayEnergies) {
            double d5 = Math.abs(isotope2.decayEnergyInKev - d2);
            if (d5 < d3) {
                d4 = d3;
                d3 = d5;
                isotope = isotope2;
                continue;
            }
            if (!(d5 < d4)) continue;
            d4 = d5;
        }
        if (d3 > 17.0) {
            return null;
        }
        if (Math.abs(d3 - d4) < 5.0) {
            return null;
        }
        return isotope;
    }

    public static List<Isotope> getIsotopesWithKnownHalfLifes() {
        return Lists.newArrayList(isotopesWithKnownHalfLifes);
    }

    public static Isotope getIsotopeForMeaning(String string) {
        return codeMeaningToIsotopeMap.get(string.toUpperCase());
    }

    private static Isotope addIso(Isotope isotope) {
        isotopes.add(isotope);
        if (codeMeaningToIsotopeMap.put(isotope.codeMeaning.toUpperCase(), isotope) != null) {
            ay.d((Object)"Dupe code meaning?", RadionuclideCodeValueMapping.class);
        }
        if (codeValueToIsotopeMap.put(isotope.codeValue.toUpperCase(), isotope) != null) {
            ay.d((Object)"Dupe code value?", RadionuclideCodeValueMapping.class);
        }
        if (isotope.decayEnergyInKev != null) {
            isotopesWithKnownDecayEnergies.add(isotope);
        }
        if (isotope.halfLifeInSeconds != null) {
            isotopesWithKnownHalfLifes.add(isotope);
        }
        return isotope;
    }

    private RadionuclideCodeValueMapping() {
    }

    static {
        RadionuclideCodeValueMapping.addIso(new Isotope("C-1018C", "^14^Oxygen"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-1018D", "^188^Rhenium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-101ED", "^177^Lutetium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-105A1", "^11^Carbon"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-105A2", "^14^Carbon"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-106A1", "^32^Phosphorus"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-107A1", "^13^Nitrogen"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-111A1", "^18^Fluorine"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-113A1", "^75^Bromine"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-113A2", "^76^Bromine"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-113A3", "^77^Bromine"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-114A5", "^124^Iodine"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-114A6", "^125^Iodine"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-116A3", "^75^Selenium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-11906", "^186^Rhenium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-122A5", "^133^Barium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-127A1", "^61^Copper"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-127A2", "^64^Copper"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-127A3", "^67^Copper"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-127A4", "^60^Copper"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-127A5", "^62^Copper"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-128A2", "^68^Germanium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-129A2", "^51^Chromium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-130A3", "^59^Iron"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-131A1", "^66^Gallium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-131A3", "^68^Gallium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-135A2", "^42^Potassium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-135A3", "^43^Potassium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-135A4", "^38^Potassium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-141A1", "^62^Zinc"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-144A3", "^57^Cobalt"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-144A4", "^58^Cobalt"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-144A6", "^60^Cobalt"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-145A5", "^113m^Indium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-146A9", "^198^Gold"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-149A1", "^52^Manganese"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-155A1", "^22^Sodium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-155A2", "^24^Sodium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-158A3", "^85^Strontium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-158A5", "^87m^Strontium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-158A6", "^89^Strontium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-159A2", "^82^Rubidium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-162A3", "^86^Yttrium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-162A7", "^90^Yttrium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-163AA", "^94m^Technetium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-166A2", "^45^Titanium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-172A8", "^133^Xenon"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-173A5", "^81m^Krypton"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-173A7", "^85^Krypton"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-178A8", "^153^Gadolinium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-181A3", "^169^Ytterbium"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-B1038", "^15^Oxygen"));
        RadionuclideCodeValueMapping.addIso(new Isotope("C-B1134", "^153^Samarium"));
        TECHNETIUM_99M = RadionuclideCodeValueMapping.addIso(new Isotope("C-163A8", "^99m^Technetium", 21620.88, 140.5));
        INDIUM_111 = RadionuclideCodeValueMapping.addIso(new Isotope("C-145A4", "^111^Indium", 242326.08, 245.4));
        GALIUM_67 = RadionuclideCodeValueMapping.addIso(new Isotope("C-131A2", "^67^Gallium", 281767.68, 184.6));
        THALLIUM_201 = RadionuclideCodeValueMapping.addIso(new Isotope("C-138A9", "^201^Thallium", 262483.19999999995, 167.4));
        IODINE_123 = RadionuclideCodeValueMapping.addIso(new Isotope("C-114A4", "^123^Iodine", 47604.6, 159.0));
        IODINE_131 = RadionuclideCodeValueMapping.addIso(new Isotope("C-114B1", "^131^Iodine", 692988.4800000001, 364.0));
    }

    @MimJsonSerializable
    public static class Isotope
    implements t {
        public final String codeValue;
        public final String codeMeaning;
        public final Double halfLifeInSeconds;
        public final Double decayEnergyInKev;

        private Isotope() {
            this.codeValue = "";
            this.codeMeaning = "";
            this.halfLifeInSeconds = 0.0;
            this.decayEnergyInKev = 0.0;
        }

        public Isotope(String string, String string2) {
            this(string, string2, null);
        }

        public Isotope(String string, String string2, Double d2) {
            this(string, string2, d2, null);
        }

        public Isotope(String string, String string2, Double d2, Double d3) {
            this.codeValue = string;
            this.codeMeaning = string2;
            this.halfLifeInSeconds = d2;
            this.decayEnergyInKev = d3;
        }

        @Override
        public String getExternalizedString() {
            return this.codeMeaning;
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        public String toString() {
            return this.getExternalizedString();
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.codeMeaning == null ? 0 : this.codeMeaning.hashCode());
            n3 = 31 * n3 + (this.codeValue == null ? 0 : this.codeValue.hashCode());
            n3 = 31 * n3 + (this.decayEnergyInKev == null ? 0 : this.decayEnergyInKev.hashCode());
            n3 = 31 * n3 + (this.halfLifeInSeconds == null ? 0 : this.halfLifeInSeconds.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Isotope isotope = (Isotope)object;
            if (this.codeMeaning == null ? isotope.codeMeaning != null : !this.codeMeaning.equals(isotope.codeMeaning)) {
                return false;
            }
            if (this.codeValue == null ? isotope.codeValue != null : !this.codeValue.equals(isotope.codeValue)) {
                return false;
            }
            if (this.decayEnergyInKev == null ? isotope.decayEnergyInKev != null : !this.decayEnergyInKev.equals(isotope.decayEnergyInKev)) {
                return false;
            }
            return !(this.halfLifeInSeconds == null ? isotope.halfLifeInSeconds != null : !this.halfLifeInSeconds.equals(isotope.halfLifeInSeconds));
        }
    }
}

