/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.x;
import com.mimvista.mui.PresentationType;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class ReorientationParamsEvaluator {
    x loaderPrefs;

    ReorientationParamsEvaluator(x x2) {
        this.loaderPrefs = x2;
    }

    boolean evaluate(SeriesInfo seriesInfo, Component component) {
        ReorientationParams reorientationParams = this.loaderPrefs.e.clone();
        ArrayList<ReorientationParamsEvaluatorStep> arrayList = new ArrayList<ReorientationParamsEvaluatorStep>();
        arrayList.add(new NativeShortAxisStep());
        arrayList.add(new FulfilledParamsStep());
        arrayList.add(new LoadPreferenceForMrStep());
        arrayList.add(new SimpleAxisAlignedReorientStep());
        arrayList.add(new HeadlessSessionStep());
        arrayList.add(new ReorientPromptStep(component));
        arrayList.add(new SetUnspecifiedDefaultsStep());
        boolean bl2 = true;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && bl2) {
            ReorientationParamsEvaluatorStep reorientationParamsEvaluatorStep = (ReorientationParamsEvaluatorStep)iterator.next();
            bl2 = reorientationParamsEvaluatorStep.step(seriesInfo, reorientationParams);
        }
        return reorientationParams.reorient == ReorientationParams.ReorientPref.Reorient;
    }

    class ReorientPromptStep
    extends ReorientationParamsEvaluatorStep {
        private Component guiParent;

        ReorientPromptStep(Component component) {
            this.guiParent = null;
            this.guiParent = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean step(SeriesInfo seriesInfo, final ReorientationParams reorientationParams) {
            JComponent jComponent;
            Object object;
            JComponent jComponent2;
            JLabel jLabel;
            Frame frame;
            if (reorientationParams.ask != ReorientationParams.AskReorientPref.AskIfNecessary && reorientationParams.ask != ReorientationParams.AskReorientPref.AskAlways) {
                return true;
            }
            if (reorientationParams.reorient != ReorientationParams.ReorientPref.Unspecified && reorientationParams.ask != ReorientationParams.AskReorientPref.AskAlways) {
                return true;
            }
            reorientationParams.reorient = ReorientationParams.ReorientPref.DoNotReorient;
            List<String> list = null;
            PresentationType presentationType = SimpleOrientationHelper.d(seriesInfo.imageOrientation, seriesInfo.a(ReorientationParamsEvaluator.this.loaderPrefs));
            boolean bl2 = presentationType == PresentationType.b || presentationType == PresentationType.c;
            if (MIMContext.h() && (bl2 |= seriesInfo.lastSaveHadAppliedViewingRot)) {
                list = ReorientationParamsEvaluator.this.loaderPrefs.a();
            }
            if ((frame = JOptionPane.getFrameForComponent(this.guiParent)) == null) {
                return false;
            }
            final JDialog jDialog = new JDialog(frame);
            jDialog.setTitle(Messages.a("General", "ORIENTATION_WARNING_TITLE"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            jDialog.add(jPanel);
            if (list != null && list.size() > 0) {
                jLabel = new JLabel(Messages.a("General", "ORIENTATION_SIDESCAN_WARNING"));
                jLabel.setAlignmentX(0.5f);
                jPanel.add(jLabel);
                jComponent2 = new JLabel(Messages.a("General", "ORIENTATION_WARNING_DISABLED_TOOLS"));
                jComponent2.setAlignmentX(0.5f);
                jPanel.add(jComponent2);
                object = list.toArray(new String[0]);
                Arrays.sort((Object[])object);
                jComponent = new JList<Object>((E[])object);
                ((JList)jComponent).setVisibleRowCount(((Object[])object).length);
                JScrollPane jScrollPane = new JScrollPane(jComponent);
                jPanel.add(jScrollPane);
                jPanel.add(Box.createVerticalStrut(10));
            } else {
                jLabel = new JLabel(Messages.a("General", "ORIENTATION_WARNING"));
                jLabel.setAlignmentX(0.5f);
                jPanel.add(jLabel);
                jPanel.add(Box.createVerticalStrut(3));
            }
            jLabel = new JLabel(Messages.a("General", "ORIENTATION_REORIENT_QUESTION"));
            jLabel.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(Box.createVerticalStrut(5));
            jComponent2 = new Box(2);
            object = new JButton(Messages.a("General", "ORIENTATION_WARNING_REORIENT"));
            ((JButton)object).setDefaultCapable(true);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    reorientationParams.reorient = ReorientationParams.ReorientPref.Reorient;
                    jDialog.setVisible(false);
                }
            });
            jComponent = new JButton(Messages.a("General", "ORIENTATION_WARNING_DONT_REORIENT"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    reorientationParams.reorient = ReorientationParams.ReorientPref.DoNotReorient;
                    jDialog.setVisible(false);
                }
            });
            jComponent2.add((Component)object);
            jComponent2.add(Box.createHorizontalStrut(10));
            jComponent2.add(jComponent);
            jComponent2.setAlignmentX(0.5f);
            jPanel.add(jComponent2);
            jDialog.pack();
            ((JComponent)object).requestFocusInWindow();
            jDialog.setLocationRelativeTo(jDialog.getParent());
            jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setResizable(false);
            try {
                jDialog.setVisible(true);
            }
            finally {
                jDialog.dispose();
            }
            return false;
        }
    }

    class SetUnspecifiedDefaultsStep
    extends ReorientationParamsEvaluatorStep {
        SetUnspecifiedDefaultsStep() {
        }

        @Override
        boolean step(SeriesInfo seriesInfo, ReorientationParams reorientationParams) {
            if (reorientationParams.reorient == ReorientationParams.ReorientPref.Unspecified) {
                reorientationParams.reorient = ReorientationParams.ReorientPref.DoNotReorient;
            }
            return true;
        }
    }

    class HeadlessSessionStep
    extends ReorientationParamsEvaluatorStep {
        HeadlessSessionStep() {
        }

        @Override
        boolean step(SeriesInfo seriesInfo, ReorientationParams reorientationParams) {
            if (ReorientationParamsEvaluator.this.loaderPrefs.c) {
                reorientationParams.ask = ReorientationParams.AskReorientPref.DoNotAsk;
                if (reorientationParams.reorient == ReorientationParams.ReorientPref.Unspecified) {
                    reorientationParams.reorient = ReorientationParams.ReorientPref.DoNotReorient;
                }
                return false;
            }
            return true;
        }
    }

    class SimpleAxisAlignedReorientStep
    extends ReorientationParamsEvaluatorStep {
        SimpleAxisAlignedReorientStep() {
        }

        @Override
        boolean step(SeriesInfo seriesInfo, ReorientationParams reorientationParams) {
            if (reorientationParams.ask == ReorientationParams.AskReorientPref.AskAlways || reorientationParams.reorient != ReorientationParams.ReorientPref.Unspecified) {
                return true;
            }
            if (!ReorientationParamsEvaluator.this.loaderPrefs.d) {
                return true;
            }
            PresentationType presentationType = SimpleOrientationHelper.d(seriesInfo.imageOrientation, seriesInfo.a(ReorientationParamsEvaluator.this.loaderPrefs));
            float[] fArray = SimpleOrientationHelper.b(seriesInfo.imageOrientation, seriesInfo.a(ReorientationParamsEvaluator.this.loaderPrefs));
            if (SimpleOrientationHelper.f(fArray, seriesInfo.H()) && presentationType == PresentationType.a) {
                reorientationParams.reorient = ReorientationParams.ReorientPref.Reorient;
            }
            return true;
        }
    }

    class LoadPreferenceForMrStep
    extends ReorientationParamsEvaluatorStep {
        LoadPreferenceForMrStep() {
        }

        @Override
        boolean step(SeriesInfo seriesInfo, ReorientationParams reorientationParams) {
            if (reorientationParams.ask == ReorientationParams.AskReorientPref.AskAlways || reorientationParams.reorient != ReorientationParams.ReorientPref.Unspecified) {
                return true;
            }
            if (!"1.2.840.10008.5.1.4.1.1.4".equals(seriesInfo.sopClassUID)) {
                return true;
            }
            ReorientationParams.LoaderPreferencesMROrientation loaderPreferencesMROrientation = InterfacePrefs.specialMrReorientation.getValue();
            if (loaderPreferencesMROrientation == null) {
                return true;
            }
            if (loaderPreferencesMROrientation == ReorientationParams.LoaderPreferencesMROrientation.ALWAYS_REORIENT) {
                reorientationParams.reorient = ReorientationParams.ReorientPref.Reorient;
            } else if (loaderPreferencesMROrientation == ReorientationParams.LoaderPreferencesMROrientation.NEVER_REORIENT) {
                reorientationParams.reorient = ReorientationParams.ReorientPref.DoNotReorient;
            }
            return true;
        }
    }

    class FulfilledParamsStep
    extends ReorientationParamsEvaluatorStep {
        FulfilledParamsStep() {
        }

        @Override
        boolean step(SeriesInfo seriesInfo, ReorientationParams reorientationParams) {
            return reorientationParams.ask == ReorientationParams.AskReorientPref.AskIfNecessary || reorientationParams.ask == ReorientationParams.AskReorientPref.AskAlways || reorientationParams.reorient == ReorientationParams.ReorientPref.Unspecified;
        }
    }

    class NativeShortAxisStep
    extends ReorientationParamsEvaluatorStep {
        NativeShortAxisStep() {
        }

        @Override
        boolean step(SeriesInfo seriesInfo, ReorientationParams reorientationParams) {
            if (seriesInfo.nativeShortAxis) {
                reorientationParams.reorient = ReorientationParams.ReorientPref.DoNotReorient;
            }
            return true;
        }
    }

    abstract class ReorientationParamsEvaluatorStep {
        ReorientationParamsEvaluatorStep() {
        }

        abstract boolean step(SeriesInfo var1, ReorientationParams var2);
    }
}

