/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mimvista.d;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.dicom.read.SmartBufferAllocator;
import com.mimvista.dicom.read.TheDicomFilterManager;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.util.ay;
import com.mimvista.util.logging.a.c;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.dcm4che2.data.DicomObject;

public class SeriesHeaderCache {
    private static final int CURRENT_CACHE_VERSION = 9;
    boolean loadedFromCache = false;
    private Integer loadedVersion = null;
    private SmartBufferAllocator bufAlloc;
    Map<String, DicomHeaderEntry> dicomHeaderMap = new MapMaker().makeMap();
    Map<String, LameCompressedHistogram> histogramMap = new MapMaker().makeMap();
    Map<String, Tuple2f> rescaleMap = new MapMaker().makeMap();
    private static c log = ay.b(SeriesHeaderCache.class);
    private transient Map<String, ShortBuffer> dataMap = new MapMaker().makeMap();
    private int numSlices;
    private ObjectInputStream cacheInStream;

    public static int getMinimumCacheFileVersion(DicomObject dicomObject, @d Integer n2) {
        if ("MONOCHROME1".equals(dicomObject.getString(2621444, "")) && !"PT".equals(dicomObject.getString(524384, ""))) {
            return SeriesHeaderCache.logIfProblem(n2, 9, "Trying to load a cache file from version less than 9 for a MONOCHROME1 non-PT. Can't do it, must dump the cache.");
        }
        float f2 = dicomObject.getFloat(2625619, 0.0f);
        if (f2 < 0.0f) {
            return SeriesHeaderCache.logIfProblem(n2, 9, "Trying to load a cache file from version less than 9 for negative rescale slope. Can't do it, must dump the cache.");
        }
        int n3 = dicomObject.getInt(2621696, 0);
        if (n3 > 16) {
            return SeriesHeaderCache.logIfProblem(n2, 8, "Trying to load a cache file from version less than 8 for > 16 bits allocated. Can't do it, must dump the cache.");
        }
        DicomObject dicomObject2 = dicomObject.fileMetaInfo();
        if (dicomObject2 != null) {
            String string = dicomObject2.getString(131088, "");
            int n4 = dicomObject.getInt(2621699, 1);
            int n5 = dicomObject.getInt(2621696, 0);
            if (n4 == 0 && n5 == 16 && DicomJpegDecompressor.isJpegCompressed(string)) {
                return SeriesHeaderCache.logIfProblem(n2, 7, "Trying to load a cache file from version less than 7 for a unsigned JPEG. Can't do it, must dump the cache.");
            }
        }
        if ("MONOCHROME1".equals(dicomObject.getString(2621444, "")) && "PT".equals(dicomObject.getString(524384, ""))) {
            return SeriesHeaderCache.logIfProblem(n2, 6, "Trying to load a cache file from version less than 6 for a MONOCHROME1 PT. Can't do it, must dump the cache.");
        }
        if (dicomObject.contains(1884491785)) {
            return SeriesHeaderCache.logIfProblem(n2, 4, "Trying to load a v2 cache file with Philips BQML private tag. Can't do it, because it might be wrong.");
        }
        return 2;
    }

    private static int logIfProblem(Integer n2, int n3, String string) {
        if (n2 != null && n2 < n3) {
            ay.b((Object)string, SeriesHeaderCache.class);
        }
        return n3;
    }

    public SeriesHeaderCache(SmartBufferAllocator smartBufferAllocator) {
        this.bufAlloc = smartBufferAllocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCache(LoaderDataProvider loaderDataProvider, boolean bl2) {
        if (this.loadedFromCache) {
            return;
        }
        if (this.dicomHeaderMap.isEmpty() || this.histogramMap.size() > 0 && this.histogramMap.size() != this.dicomHeaderMap.size()) {
            ay.b((Object)"Can't write cache for this series, since stuff doesn't match up right...", this);
            return;
        }
        OutputStream outputStream = loaderDataProvider.getStreamToSaveCache();
        if (outputStream == null) {
            return;
        }
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(outputStream, 512){
                {
                    this.def.setLevel(-1);
                }
            };
            this.saveToCache(gZIPOutputStream, bl2);
        }
        catch (IOException iOException) {
            ay.d((Object)"Unable to save volume cache", (Throwable)iOException, this);
        }
        finally {
            try {
                if (gZIPOutputStream != null) {
                    ((OutputStream)gZIPOutputStream).close();
                }
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void saveToCache(OutputStream outputStream, boolean bl2) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        int n2 = 5;
        for (DicomHeaderEntry object : this.dicomHeaderMap.values()) {
            if (object != null) {
                int n3 = object.getRequiredCacheVersion();
                if (n3 <= n2) continue;
                n2 = n3;
                continue;
            }
            n2 = 9;
            break;
        }
        objectOutputStream.writeObject(n2);
        objectOutputStream.writeObject(this.dicomHeaderMap.size());
        for (String string : Lists.newArrayList(this.dicomHeaderMap.keySet())) {
            float[] fArray;
            DicomHeaderEntry dicomHeaderEntry = bl2 ? this.dicomHeaderMap.remove(string) : this.dicomHeaderMap.get(string);
            dicomHeaderEntry.writeToStream(objectOutputStream);
            LameCompressedHistogram lameCompressedHistogram = bl2 ? this.histogramMap.remove(string) : this.histogramMap.get(string);
            Tuple2f tuple2f = this.rescaleMap.get(string);
            if (lameCompressedHistogram == null) {
                objectOutputStream.writeObject(new int[0]);
                fArray = new float[]{};
            } else {
                objectOutputStream.writeObject(lameCompressedHistogram);
                fArray = new float[]{tuple2f.x, tuple2f.y};
            }
            objectOutputStream.writeObject(fArray);
            objectOutputStream.writeObject(string);
            objectOutputStream.reset();
        }
        objectOutputStream.close();
        outputStream.close();
    }

    public boolean openCacheStream(LoaderDataProvider loaderDataProvider) throws NewerCacheFileException {
        InputStream inputStream = loaderDataProvider.getCacheFile();
        if (inputStream == null) {
            return false;
        }
        try {
            this.cacheInStream = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(inputStream)));
            Object object = this.cacheInStream.readObject();
            if (!(object instanceof Number)) {
                log.b("Invalid cache file version: " + String.valueOf(object));
                this.closeCacheStream();
                return false;
            }
            int n2 = ((Number)object).intValue();
            if (n2 > 9) {
                throw new NewerCacheFileException("Found a cachefile with a unsupported newer version: " + n2);
            }
            if (n2 <= 1) {
                ay.e((Object)"Skipping this cache file, it's busted.", this);
                this.closeCacheStream();
                return false;
            }
            this.loadedVersion = n2;
            this.numSlices = (Integer)this.cacheInStream.readObject();
            return true;
        }
        catch (NewerCacheFileException newerCacheFileException) {
            this.closeCacheStream();
            throw newerCacheFileException;
        }
        catch (Exception exception) {
            log.c("Unable to read cache file", exception);
            this.closeCacheStream();
            return false;
        }
    }

    String getNextEntryName() {
        try {
            Object[] objectArray;
            NonCrashyDicomObject nonCrashyDicomObject = NonCrashyDicomObject.copyIfCrashy((DicomObject)this.cacheInStream.readObject());
            nonCrashyDicomObject = TheDicomFilterManager.filter((DicomObject)nonCrashyDicomObject);
            Object object = this.cacheInStream.readObject();
            Object object2 = object instanceof int[] ? ((objectArray = (int[])object).length == 0 ? null : new LameCompressedHistogram(IntBuffer.wrap(objectArray))) : (LameCompressedHistogram)object;
            objectArray = (float[])this.cacheInStream.readObject();
            String string = (String)this.cacheInStream.readObject();
            this.dicomHeaderMap.put(string, new DicomHeaderEntry((DicomObject)nonCrashyDicomObject));
            if (object2 != null && objectArray.length == 2) {
                this.histogramMap.put(string, (LameCompressedHistogram)object2);
                this.rescaleMap.put(string, (Tuple2f)new Point2f((float[])objectArray));
            }
            if (this.dicomHeaderMap.size() == this.numSlices) {
                try {
                    this.cacheInStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.loadedFromCache = true;
            }
            return string;
        }
        catch (IOException iOException) {
            log.c("Unable to read cache entry", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.c("Unable to read cache entry", classNotFoundException);
        }
        this.closeCacheStream();
        return null;
    }

    void closeCacheStream() {
        this.loadedFromCache = false;
        try {
            if (this.cacheInStream != null) {
                this.cacheInStream.close();
                this.cacheInStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Integer getLoadedVersion() {
        return this.loadedVersion;
    }

    int getNumberOfItemsInCache() {
        return this.numSlices;
    }

    void putDicom(String string, DicomObject dicomObject) {
        this.dicomHeaderMap.put(string, new DicomHeaderEntry(DicomLoadingUtility.derivedStrippedDicomObject(dicomObject)));
    }

    void putHistogram(String string, IntBuffer intBuffer, Tuple2f tuple2f) {
        this.histogramMap.put(string, new LameCompressedHistogram(intBuffer));
        this.rescaleMap.put(string, tuple2f);
    }

    void putData(String string, ShortBuffer shortBuffer) {
        this.dataMap.put(string, shortBuffer);
    }

    public ShortBuffer popData(String string) {
        return this.dataMap.remove(string);
    }

    public IntBuffer getHistogram(String string) {
        return IntBuffer.wrap(this.histogramMap.get(string).asArray());
    }

    public Tuple2f getRescale(String string) {
        return this.rescaleMap.get(string);
    }

    public DicomObject getDicom(String string) {
        return this.dicomHeaderMap.get(string).asDicomObject();
    }

    private class DicomHeaderEntry {
        private DicomObject dicomHeader;
        private ByteBuffer bufferedHeader;
        private int requiredCacheVersion;

        DicomHeaderEntry(DicomObject dicomObject) {
            try {
                this.requiredCacheVersion = SeriesHeaderCache.getMinimumCacheFileVersion(dicomObject, null);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error while checking DicomObject for cache version", throwable, SeriesHeaderCache.class);
                this.requiredCacheVersion = 9;
            }
            if (((SeriesHeaderCache)SeriesHeaderCache.this).bufAlloc.useDirectBuffers) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(dicomObject);
                    objectOutputStream.close();
                    this.bufferedHeader = SeriesHeaderCache.this.bufAlloc.directBufferify(byteArrayOutputStream.toByteArray());
                    return;
                }
                catch (IOException iOException) {
                    ay.d((Object)"Error while bufferifying the DicomObject", (Throwable)iOException, SeriesHeaderCache.class);
                }
            }
            this.dicomHeader = dicomObject;
        }

        int getRequiredCacheVersion() {
            return this.requiredCacheVersion;
        }

        void writeToStream(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.asDicomObject());
        }

        DicomObject asDicomObject() {
            if (this.dicomHeader != null) {
                return this.dicomHeader;
            }
            this.bufferedHeader.rewind();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(SeriesHeaderCache.this.bufAlloc.debufferify(this.bufferedHeader));
            try {
                return (DicomObject)new ObjectInputStream(byteArrayInputStream).readObject();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Megabooch reading DICOM header", throwable);
            }
        }
    }

    private static class LameCompressedHistogram
    implements Serializable {
        private static final long serialVersionUID = 1L;
        short[] bytePoolIdxs;
        short[] intPoolIdxs;
        byte[] bytePool;
        int[] intPool;

        public LameCompressedHistogram(IntBuffer intBuffer) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            intBuffer.rewind();
            while (intBuffer.hasRemaining()) {
                n2 = intBuffer.get();
                if (n2 > 0 && n2 <= 255) {
                    ++n3;
                }
                if (n2 <= 255) continue;
                ++n4;
            }
            if (n3 > 0) {
                this.bytePool = new byte[n3];
                this.bytePoolIdxs = new short[n3];
            }
            if (n4 > 0) {
                this.intPool = new int[n4];
                this.intPoolIdxs = new short[n4];
            }
            intBuffer.rewind();
            n2 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < intBuffer.limit(); ++i2) {
                int n6 = intBuffer.get(i2);
                if (n6 > 0 && n6 <= 255) {
                    this.bytePoolIdxs[n2] = (short)(i2 + Short.MIN_VALUE);
                    this.bytePool[n2++] = (byte)n6;
                }
                if (n6 <= 255) continue;
                this.intPoolIdxs[n5] = (short)(i2 + Short.MIN_VALUE);
                this.intPool[n5++] = n6;
            }
        }

        public int[] asArray() {
            int n2;
            int[] nArray = new int[65536];
            if (this.bytePoolIdxs != null) {
                for (n2 = 0; n2 < this.bytePoolIdxs.length; ++n2) {
                    int n3;
                    byte by2 = this.bytePool[n2];
                    nArray[this.bytePoolIdxs[n2] - Short.MIN_VALUE] = n3 = by2 & 0xFF;
                }
            }
            if (this.intPoolIdxs != null) {
                for (n2 = 0; n2 < this.intPoolIdxs.length; ++n2) {
                    nArray[this.intPoolIdxs[n2] - Short.MIN_VALUE] = this.intPool[n2];
                }
            }
            return nArray;
        }
    }

    public static class NewerCacheFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NewerCacheFileException(String string) {
            super(string);
        }
    }
}

