/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.internals.SliceInfo;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class SeriesRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final ImmutableSet<UIDContainer.SOPInstanceUID> sops;
    public final String seriesUID;

    public SeriesRef(Iterable<SliceInfo> iterable) {
        HashSet hashSet = Sets.newHashSet();
        String string = null;
        for (SliceInfo sliceInfo : iterable) {
            if (string == null) {
                string = sliceInfo.seriesInstanceUID;
            }
            if (!cn.a(string, sliceInfo.seriesInstanceUID, true)) {
                throw new IllegalArgumentException("At least two series referenced: " + string + ", " + sliceInfo.seriesInstanceUID);
            }
            hashSet.add(new UIDContainer.SOPInstanceUID(sliceInfo.sopInstanceUID));
        }
        this.sops = ImmutableSet.copyOf((Collection)hashSet);
        this.seriesUID = string;
    }

    public boolean matches(SliceInfo sliceInfo) {
        return new UIDContainer.SeriesUID(sliceInfo.seriesInstanceUID).equals(this.seriesUID) && this.sops.contains((Object)new UIDContainer.SOPInstanceUID(sliceInfo.sopInstanceUID));
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.seriesUID == null ? 0 : this.seriesUID.hashCode());
        n3 = 31 * n3 + (this.sops == null ? 0 : this.sops.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SeriesRef seriesRef = (SeriesRef)object;
        if (this.seriesUID == null ? seriesRef.seriesUID != null : !this.seriesUID.equals(seriesRef.seriesUID)) {
            return false;
        }
        return !(this.sops == null ? seriesRef.sops != null : !this.sops.equals(seriesRef.sops));
    }
}

