/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.a;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SerializableJsonDicomSeries;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.BackgroundVolumeLoaderDelegate;
import com.mimvista.dicom.read.DerivedSliceInfo;
import com.mimvista.dicom.read.DicomLoaderBase;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.DicomProgressHandlerJimmy;
import com.mimvista.dicom.read.DicomReadJavascriptFilterManager;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.DynamicVolumeSieve;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.MultiSeriesFrameData;
import com.mimvista.dicom.read.NonUniformHelper;
import com.mimvista.dicom.read.PixelDataExtractor;
import com.mimvista.dicom.read.PixelDataRescaler;
import com.mimvista.dicom.read.ReallyStupidBufferProvider;
import com.mimvista.dicom.read.ReorientationParamsEvaluator;
import com.mimvista.dicom.read.SeriesHeaderCache;
import com.mimvista.dicom.read.ShadyProgressInputStream;
import com.mimvista.dicom.read.SimpleDicomVolumeLoader;
import com.mimvista.dicom.read.SingleFileVolumeFiller;
import com.mimvista.dicom.read.SliceInfoComparator;
import com.mimvista.dicom.read.SliceOrientationMangler;
import com.mimvista.dicom.read.SlowCdVolumeFiller;
import com.mimvista.dicom.read.SmartBufferAllocator;
import com.mimvista.dicom.read.VolumeDataFiller;
import com.mimvista.extensions.util.i;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ax;
import com.mimvista.internals.q;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.internals.x;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.ArrayListImageCubeShort;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.Interpolate;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.SliceShower;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.bt;
import com.mimvista.util.logging.a.c;
import com.mimvista.util.logging.a.f;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;

@a
public class SimpleDicomVolumeLoaderImpl<IVType extends SimpleImageVolume<ImageCube.ImageCubeShort>>
extends DicomLoaderBase
implements SimpleDicomVolumeLoader {
    private static final int TOTAL_PROGRESS_MULTIPLIER = 4;
    private static final int PRELOAD_PROGRESS_WEIGHT = 1;
    private static final int PROCESS_LOAD_PROGRESS_WEIGHT = 3;
    private static final int LOAD_PROGRESS_WEIGHT = 3;
    private static final int PROCESS_PROGRESS_WEIGHT = 1;
    private static c log = new c(new f(SimpleDicomVolumeLoaderImpl.class));
    protected LoaderDataProvider dataProvider;
    protected boolean successfullyLoaded = false;
    protected boolean outOfMemory;
    protected boolean hasBigGap;
    protected boolean badCompression;
    protected q<IVType> dSeries;
    protected x loaderPrefs = new x();
    protected BackgroundVolumeLoaderDelegate backgroundDel = new BackgroundVolumeLoaderDelegate();
    protected boolean loadingInBackground = false;
    protected boolean loadingJustInTime = false;
    protected boolean didLoadJustInTime = false;
    protected boolean haveDecidedCrazySlopeStrat = false;
    protected boolean discardCrazySlopes = true;
    protected boolean memoryFriendly = false;
    protected SmartBufferAllocator bufAlloc = new SmartBufferAllocator();
    protected SeriesHeaderCache headerCache = new SeriesHeaderCache(this.bufAlloc);
    protected boolean newerCacheFileExists = false;
    protected SeriesMetaData volMeta = new SeriesMetaData();
    protected boolean loadingFromCache = false;
    protected boolean cacheOnly = false;
    protected Progress progress = new o();
    protected Component guiParent;
    final long loadingStartTime = System.currentTimeMillis();
    private final Map<IVType, com.mimvista.numerics.ay> spacingHandlerMap = Maps.newHashMap();
    Map<IVType, SliceOrientationMangler> manglerMap = Maps.newHashMap();
    private int scaleDownFactor = 1;
    private int[] origXYBeforeScale;
    private boolean hasBadSlices = false;
    protected boolean warnedAboutPixelSpacing = false;

    public SimpleDicomVolumeLoaderImpl() {
        this(new q());
    }

    public SimpleDicomVolumeLoaderImpl(q<IVType> q2) {
        this.dSeries = q2;
    }

    public void setGuiParentComponent(Component component) {
        this.guiParent = component;
    }

    @Override
    public void setLoaderPrefs(x x2) {
        this.loaderPrefs = x2;
        this.dSeries.c(this.loaderPrefs.h.h);
    }

    @Override
    public void setCacheOnly(boolean bl2) {
        this.cacheOnly = bl2;
        this.loaderPrefs.e.askAboutGantryTilt = false;
        this.loaderPrefs.e.gantryAnswer = false;
    }

    @Override
    public void setMemoryFriendlyLoading(boolean bl2) {
        this.bufAlloc.useDirectBuffers = true;
    }

    @Override
    public void setDataProvider(LoaderDataProvider loaderDataProvider) {
        this.dataProvider = loaderDataProvider;
        bt.a((Object)this, loaderDataProvider);
    }

    @Override
    public void setBackgroundLoaderDelegate(BackgroundVolumeLoaderDelegate backgroundVolumeLoaderDelegate) {
        this.backgroundDel = backgroundVolumeLoaderDelegate;
    }

    @Override
    public void setJustInTimeLoading(boolean bl2) {
        this.loadingJustInTime = bl2;
    }

    @Override
    public boolean didLoadJustInTime() {
        return this.didLoadJustInTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Progress progress) {
        this.progress = progress;
        this.successfullyLoaded = false;
        this.outOfMemory = false;
        this.hasBigGap = false;
        this.hasBadSlices = false;
        this.loaderPrefs.e.defaultGantryAnswer = true;
        if (this.loaderPrefs.e.askAboutGantryTilt == null) {
            this.loaderPrefs.e.askAboutGantryTilt = true;
        }
        try {
            if (this.dataProvider.getFilenames().size() > 1) {
                this.loadMultiFileVolume();
                this.saveCache();
            } else if (this.dataProvider.getFilenames().size() == 1) {
                this.loadSingleFileVolume();
            }
            if (this.cacheOnly) {
                return;
            }
            if (this.successfullyLoaded) {
                if (!this.loadingInBackground) {
                    for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
                        simpleImageVolume.g(true);
                        if (this.volMeta.allSerUIDs.size() <= 1) continue;
                        ArrayList arrayList = Lists.newArrayList(this.volMeta.allSerUIDs);
                        arrayList.remove(new UIDContainer.SeriesUID(simpleImageVolume.getUncopiedMutableInfo().ag()));
                        simpleImageVolume.getUncopiedMutableInfo().extraSeriesRequiredToLoad = arrayList;
                        HashSet<String> hashSet = new HashSet<String>();
                        for (SliceInfo sliceInfo : simpleImageVolume.ab()) {
                            hashSet.add(sliceInfo.seriesInstanceUID);
                        }
                        if (hashSet.size() <= 1) continue;
                        simpleImageVolume.getUncopiedMutableInfo().mimDerivedVolume = true;
                        simpleImageVolume.getUncopiedMutableInfo().volumeHasBeenSaved = false;
                    }
                }
            } else if (!MIMContext.P()) {
                if (this.outOfMemory) {
                    MOptionPane.b(this.guiParent, Messages.a("General", "DICOMLOADER_OUT_OF_MEMORY"), Messages.a("General", "DICOMLOADER_ERROR"), 0);
                } else if (this.badCompression) {
                    MOptionPane.b(this.guiParent, Messages.a("General", "DICOMLOADER_DATA_CORRUPTED"), Messages.a("General", "DICOMLOADER_ERROR"), 0);
                }
            }
            if (!MIMContext.P() && this.hasBadSlices) {
                MOptionPane.b(this.guiParent, Messages.a("General", "DICOMLOADER_BAD_SLICES"), Messages.a("General", "DICOMLOADER_ERROR"), 0);
            }
        }
        finally {
            if (progress.n() != Progress.Status.e) {
                progress.b();
            }
        }
    }

    private boolean loadCacheFileForMultifile() {
        SeriesHeaderCache seriesHeaderCache = new SeriesHeaderCache(this.bufAlloc);
        try {
            if (seriesHeaderCache.openCacheStream(this.dataProvider)) {
                this.headerCache = seriesHeaderCache;
                return true;
            }
            return false;
        }
        catch (SeriesHeaderCache.NewerCacheFileException newerCacheFileException) {
            log.c("", newerCacheFileException);
            this.newerCacheFileExists = true;
            return false;
        }
    }

    @Override
    public boolean isSuccessfullyLoaded() {
        return this.successfullyLoaded;
    }

    @Override
    public q<IVType> getDynamicSeriesInfo() {
        return this.dSeries;
    }

    public void saveCache() {
        if (!this.newerCacheFileExists) {
            this.headerCache.putCache(this.dataProvider, this.cacheOnly);
        }
    }

    @Override
    public List<String> getSortedFileOrdering() {
        ArrayList arrayList = Lists.newArrayList();
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            for (SliceInfo sliceInfo : simpleImageVolume.ab()) {
                if (sliceInfo.fileName == null) continue;
                arrayList.add(sliceInfo.fileName);
            }
        }
        return arrayList;
    }

    protected void loadSingleFileVolume() {
        DicomObject dicomObject;
        String string = this.dataProvider.getFilenames().get(0);
        InputStream inputStream = this.dataProvider.getStream(string);
        ShadyProgressInputStream shadyProgressInputStream = new ShadyProgressInputStream(inputStream);
        Object object = new DicomProgressHandlerJimmy(this.progress, shadyProgressInputStream, 100);
        if (this.cacheOnly) {
            object = new DicomReader.StopBeforeContentInputHandler(-1, (DicomInputHandler)object);
        }
        try {
            DicomReader.DicomReadParams dicomReadParams = new DicomReader.DicomReadParams().setHandler((DicomInputHandler)object).setAllowPartialPixelData(true);
            DicomReader.DicomReadResult dicomReadResult = DicomReader.readStreamIntoDicom(shadyProgressInputStream, dicomReadParams);
            if (dicomReadResult != null) {
                dicomObject = this.applyDicomObjectFilters(dicomReadResult.dob);
                if (dicomReadResult.wasMissingPixelData) {
                    this.hasBadSlices = true;
                }
            } else {
                dicomObject = null;
            }
        }
        catch (IOException iOException) {
            dicomObject = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ay.d((Object)("Ran out of memory while trying to read: " + string), SimpleDicomVolumeLoaderImpl.class);
            throw outOfMemoryError;
        }
        if (dicomObject != null && !dicomObject.isEmpty()) {
            this.loadSingleFileVolume(string, dicomObject);
        }
    }

    @Override
    public ShortBuffer loadImage(SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume, int n2) {
        ReallyStupidBufferProvider reallyStupidBufferProvider;
        SliceOrientationMangler sliceOrientationMangler = this.manglerMap.get(simpleImageVolume);
        DerivedSliceInfo derivedSliceInfo = sliceOrientationMangler.getDerivedSlices().get(n2);
        if (!(sliceOrientationMangler.getBufProvider() instanceof ReallyStupidBufferProvider)) {
            reallyStupidBufferProvider = new ReallyStupidBufferProvider(simpleImageVolume);
            sliceOrientationMangler.setBufProvider(reallyStupidBufferProvider);
        }
        sliceOrientationMangler.loadDerivedSlice(derivedSliceInfo);
        reallyStupidBufferProvider = (ReallyStupidBufferProvider)sliceOrientationMangler.getBufProvider();
        ShortBuffer shortBuffer = reallyStupidBufferProvider.preppedSlices.remove(n2);
        shortBuffer.rewind();
        return shortBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSingleFileVolume(String string, DicomObject dicomObject) {
        try {
            int n2;
            this.successfullyLoaded = false;
            this.dSeries.d();
            SliceInfo sliceInfo = this.loadSliceInfo(dicomObject, string);
            this.headerCache.putDicom(string, dicomObject);
            IVType IVType = this.initializeNewSingleFileVolume(dicomObject, sliceInfo);
            if (IVType == null || ((SimpleImageVolume)IVType).b() == null) {
                return;
            }
            if (this.cacheOnly) {
                this.successfullyLoaded = true;
                this.saveCache();
                return;
            }
            ShortBuffer shortBuffer = this.headerCache.popData(((SimpleImageVolume)IVType).ab().get((int)0).fileName);
            SeriesInfo seriesInfo = ((SimpleImageVolume)IVType).getUncopiedMutableInfo();
            this.flagInfoIfDICOMWasModified(seriesInfo, dicomObject);
            int[] nArray = ((SimpleImageVolume)IVType).a();
            float[] fArray = ((SimpleImageVolume)IVType).b();
            SimpleDicomVolumeLoaderImpl.readImageTags(dicomObject, sliceInfo);
            SingleFileVolumeFiller singleFileVolumeFiller = new SingleFileVolumeFiller(dicomObject, sliceInfo, seriesInfo, nArray, fArray, this.loaderPrefs);
            singleFileVolumeFiller.readFrameIntoVolume(shortBuffer, (SimpleImageVolume<ImageCube.ImageCubeShort>)IVType, 0);
            this.dSeries.b(IVType);
            int n3 = dicomObject.getInt(5505137, 1);
            if (n3 > 1) {
                int n4 = shortBuffer.limit() / (nArray[0] * nArray[1] * nArray[2]);
                if (n4 != n3) {
                    log.d("Attention: Dicom header shows there are " + String.valueOf(n3) + " time slots.");
                    log.d("But we only have data for " + String.valueOf(n4) + " frames.");
                }
                if (n4 > 1) {
                    float f2 = 0.0f;
                    f2 = dicomObject.contains(1577538) ? (float)dicomObject.getInt(1577538) : dicomObject.getFloat(1577059, 0.0f);
                    float f3 = dicomObject.getFloat(5505080, 0.0f);
                    seriesInfo.scanDuration = f2;
                    for (n2 = 1; n2 < n4; ++n2) {
                        Pair<Integer, Integer> pair;
                        SeriesInfo seriesInfo2 = seriesInfo.m();
                        float f4 = 0.0f;
                        int n5 = nArray[2] * n2;
                        if (seriesInfo2.modInfo.c()) {
                            try {
                                pair = seriesInfo2.modInfo.d().f(n5);
                                f4 = ((Integer)pair.x).intValue();
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        if (f4 == 0.0f) {
                            f4 = seriesInfo.frameReferenceTime + (float)n2 * (f2 + f3);
                        }
                        seriesInfo2.frameReferenceTime = f4;
                        if (f4 > 0.0f) {
                            seriesInfo.hasFrameReferenceTime = true;
                            seriesInfo2.hasFrameReferenceTime = true;
                        }
                        seriesInfo2.scanDuration = f2;
                        log.d("Frame Reference Time(ms): " + String.valueOf(seriesInfo2.frameReferenceTime));
                        pair = this.dSeries.m();
                        if (seriesInfo2.modInfo.c()) {
                            ((SimpleImageVolume)((Object)pair)).a(n5);
                        }
                        ((SimpleImageVolume)((Object)pair)).b(seriesInfo2);
                        ((SimpleImageVolume)((Object)pair)).aa().add(sliceInfo.a());
                        singleFileVolumeFiller.readFrameIntoVolume(shortBuffer, (SimpleImageVolume<ImageCube.ImageCubeShort>)((Object)pair), n2);
                        this.dSeries.b(pair);
                    }
                }
            }
            for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
                int[] nArray2 = this.getVolMinMaxDuringLoad(simpleImageVolume, false);
                n2 = SimpleDicomVolumeLoaderImpl.possiblyRescaleVolumeWithVeryFewValues(simpleImageVolume.getUncopiedMutableInfo(), nArray2);
                if (n2 != 0) {
                    int n6 = simpleImageVolume.getUncopiedMutableInfo().scalingFactorFromOriginal;
                    for (short[] sArray : ((ImageCube.ImageCubeShort)simpleImageVolume.ad()).b()) {
                        int n7 = 0;
                        while (n7 < sArray.length) {
                            int n8 = n7++;
                            sArray[n8] = (short)(sArray[n8] * n6);
                        }
                    }
                    simpleImageVolume.aj();
                    nArray2 = this.getVolMinMaxDuringLoad(simpleImageVolume, false);
                }
                this.possiblyAdjustDataRangeForVolume(simpleImageVolume, nArray2, false);
                if (!singleFileVolumeFiller.isGridFrameSpacingAvailable()) continue;
                this.fixSliceSeparation(simpleImageVolume);
            }
            this.dSeries.p();
            this.resampleLargeVolume(false);
            if (singleFileVolumeFiller.isGridFrameSpacingAvailable()) {
                this.handleSpacingVariations(false);
            }
            this.adjustOrientation(this.dSeries, false);
            this.adjustSeriesUnits();
            this.successfullyLoaded = true;
        }
        catch (SeriesIsNotImageTypeException seriesIsNotImageTypeException) {
        }
        finally {
            this.progress.b();
        }
    }

    protected void loadMultiFileVolume() throws Error {
        boolean bl2;
        if (!this.loadMultiFileSliceData()) {
            return;
        }
        if (!this.assembleMultiFileVolume()) {
            return;
        }
        if (this.cacheOnly) {
            this.successfullyLoaded = true;
            return;
        }
        boolean bl3 = this.handlePixelSpacing();
        if (bl3) {
            this.showPixelSpacingWarning(((SimpleImageVolume)this.dSeries.c(0)).getUncopiedMutableInfo().b());
        }
        this.resampleLargeVolume(true);
        if (!this.handleSpacingVariations(true)) {
            return;
        }
        this.adjustOrientation(this.dSeries, true);
        this.buildPrecomputedHistogramsForEachVolume();
        this.loadDicomObjectsIntoSeriesInfoForEachVolume();
        this.adjustSeriesUnits();
        SliceOrientationMangler sliceOrientationMangler = (SliceOrientationMangler)Iterables.get(this.manglerMap.values(), (int)0);
        boolean bl4 = bl2 = sliceOrientationMangler.convertCoronal || sliceOrientationMangler.convertSagittal;
        if (!this.loadingJustInTime || bl2) {
            this.fillSliceDataIntoVolumes();
        } else {
            this.successfullyLoaded = true;
            this.didLoadJustInTime = true;
        }
    }

    private void buildPrecomputedHistogramsForEachVolume() {
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            simpleImageVolume.c(this.buildWholeHistogram(simpleImageVolume));
        }
    }

    private int[] buildWholeHistogram(IVType IVType) {
        LinkedHashSet<SliceInfo> linkedHashSet = new LinkedHashSet<SliceInfo>();
        for (DerivedSliceInfo object : this.manglerMap.get(IVType).getDerivedSlices()) {
            linkedHashSet.add(object.first);
            if (object.second == null) continue;
            linkedHashSet.add(object.second);
        }
        Object object = new int[65536];
        for (SliceInfo sliceInfo : linkedHashSet) {
            IntBuffer intBuffer = this.headerCache.getHistogram(sliceInfo.fileName);
            for (int i2 = 0; i2 < intBuffer.limit(); ++i2) {
                int n2 = intBuffer.get(i2);
                if (n2 <= 0 || SimpleDicomVolumeLoaderImpl.isPixelPaddingValue(sliceInfo, Short.MIN_VALUE + i2)) continue;
                int n3 = SimpleDicomVolumeLoaderImpl.rescaleValueToFinal(((SimpleImageVolume)IVType).getUncopiedMutableInfo(), sliceInfo, i2 + Short.MIN_VALUE) - Short.MIN_VALUE;
                Object object2 = object;
                int n4 = n3;
                object2[n4] = object2[n4] + n2;
            }
        }
        return object;
    }

    private void loadDicomObjectsIntoSeriesInfoForEachVolume() {
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            SliceOrientationMangler sliceOrientationMangler = this.manglerMap.get(simpleImageVolume);
            sliceOrientationMangler.buildSlices();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean loadMultiFileSliceData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 19[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanupFailedCacheLoad() {
        this.headerCache.closeCacheStream();
        this.loadingFromCache = false;
        this.headerCache = new SeriesHeaderCache(this.bufAlloc);
        this.volMeta.allSlices.clear();
    }

    protected void warnDupedSlices(DynamicVolumeSieve.DuplicatedSliceException duplicatedSliceException) {
    }

    protected void warnRPMModified() {
    }

    protected void warnRPMSketchy() {
    }

    protected void warnSliceSelection(List<String> list) {
    }

    protected void warnAboutPixelSpacing(DicomObject dicomObject) {
    }

    private boolean assembleMultiFileVolume() {
        try {
            IVType IVType;
            int n2;
            DynamicVolumeSieve<IVType> dynamicVolumeSieve;
            block26: {
                dynamicVolumeSieve = new DynamicVolumeSieve<IVType>(this.dSeries, this.volMeta.allSlices, this.volMeta.numberOfTimeSlots, this.loaderPrefs.h, this.loaderPrefs.f);
                try {
                    dynamicVolumeSieve.cleanDupedSopInstanceUIDs();
                    if (dynamicVolumeSieve.getRemainingSliceCount() == 1) {
                        this.loadSingleFileVolume();
                        return false;
                    }
                    dynamicVolumeSieve.process(new Function<SliceInfo, SeriesInfo>(){

                        public SeriesInfo apply(SliceInfo sliceInfo) {
                            return DicomLoadingUtility.getSeriesInfo(SimpleDicomVolumeLoaderImpl.this.applyDicomObjectFilters(SimpleDicomVolumeLoaderImpl.this.headerCache.getDicom(sliceInfo.fileName)), SimpleDicomVolumeLoaderImpl.this.loaderPrefs);
                        }
                    });
                    if (dynamicVolumeSieve.wasRPMModified()) {
                        this.warnRPMModified();
                    }
                }
                catch (DynamicVolumeSieve.DuplicatedSliceException duplicatedSliceException) {
                    if (this.cacheOnly) break block26;
                    this.warnDupedSlices(duplicatedSliceException);
                    log.a(duplicatedSliceException);
                }
            }
            if (dynamicVolumeSieve.areSomeMissingSlices()) {
                this.backgroundDel = new BackgroundVolumeLoaderDelegate();
            }
            Function<SeriesInfo, Float> function = dynamicVolumeSieve.getPercentageFuncFor4D();
            ay.a((Object)("Assemble multi file volume. Size: " + this.dSeries.n()), this);
            boolean bl2 = true;
            for (n2 = 0; n2 < this.dSeries.n(); ++n2) {
                Object object;
                Object object2;
                IVType = this.dSeries.c(n2);
                SliceInfo sliceInfo = ((SimpleImageVolume)IVType).ab().get(0);
                SeriesInfo seriesInfo = DicomLoadingUtility.getSeriesInfo(this.applyDicomObjectFilters(this.headerCache.getDicom(sliceInfo.fileName)), this.loaderPrefs);
                if (this.dataProvider.deliberatelyContainsMultipleSeries()) {
                    if (seriesInfo.binNum >= 0) {
                        seriesInfo.frameNumFromSeriesDesc = new FrameNumber(seriesInfo.binNum);
                        seriesInfo.maxFramesFromSeriesDesc = seriesInfo.numOfBins;
                    } else {
                        seriesInfo.frameNumFromSeriesDesc = sliceInfo.explicitFrame;
                        if (sliceInfo.explicitMaxFrames != null) {
                            seriesInfo.maxFramesFromSeriesDesc = sliceInfo.explicitMaxFrames;
                        }
                        bl2 &= sliceInfo.explicitMultiSeries4D;
                    }
                }
                ArrayList arrayList = Lists.newArrayList();
                for (SliceInfo sliceInfo2 : ((SimpleImageVolume)IVType).ab()) {
                    object2 = this.applyDicomObjectFilters(this.headerCache.getDicom(sliceInfo2.fileName));
                    if (object2 != null) {
                        this.flagInfoIfDICOMWasModified(seriesInfo, (DicomObject)object2);
                        arrayList.add(new SerializableJsonDicomSeries(new JsonDicomSeries((DicomObject)object2)));
                        continue;
                    }
                    ay.c((Object)"Slice with no dicom?", this);
                }
                if (i.g()) {
                    seriesInfo.a(new JsonDicomBundle(arrayList));
                }
                ((SimpleImageVolume)IVType).b(seriesInfo);
                if (dynamicVolumeSieve.useSeriesSortValueAsPercentageForDisplay()) {
                    object = null;
                    if (function != null && (object = (Float)function.apply((Object)seriesInfo)) != null) {
                        seriesInfo.frameDesc = ("" + object + "%").replaceAll("\\.0%", "%");
                    }
                } else if (dynamicVolumeSieve.useCustomFrameDescription()) {
                    seriesInfo.frameDesc = dynamicVolumeSieve.getCustomFrameDescription(seriesInfo);
                } else if (sliceInfo.explicitFrameDesc != null) {
                    seriesInfo.frameDesc = sliceInfo.explicitFrameDesc;
                }
                DicomLoadingUtility.processVolumeOrientations(seriesInfo, this.loaderPrefs);
                SimpleDicomVolumeLoaderImpl.correctOrientationBasedOnSliceInfos(seriesInfo, this.volMeta.allSlices, this.loaderPrefs);
                for (SliceInfo sliceInfo2 : ((SimpleImageVolume)IVType).ab()) {
                    SimpleDicomVolumeLoaderImpl.processAcquisitionAndScalingForSlice(seriesInfo, sliceInfo2);
                }
                this.initializeNewMultiFileVolume(IVType);
                object = ((SimpleImageVolume)IVType).a();
                object[2] = ((SimpleImageVolume)IVType).ab().size();
                ((SimpleImageVolume)IVType).b((int[])object);
                ((SimpleImageVolume)IVType).a((int[])object);
                int n3 = this.volMeta.numberOfSlices;
                if (n3 > ((SimpleImageVolume)IVType).a()[2]) {
                    log.b("Number of slices claims to be " + n3 + " but only " + ((SimpleImageVolume)IVType).a()[2] + " could be loaded.");
                }
                this.sortSlices(IVType);
                object2 = ((SimpleImageVolume)IVType).ab().get(((SimpleImageVolume)IVType).ab().size() / 2);
                seriesInfo.presetsFromDICOM = DicomLoadingUtility.loadPresetsFromDICOM(this.applyDicomObjectFilters(this.headerCache.getDicom(object2.fileName)));
                if (this.cacheOnly) continue;
                ((SimpleImageVolume)IVType).b(new int[]{((SimpleImageVolume)IVType).a()[0], ((SimpleImageVolume)IVType).a()[1], ((SimpleImageVolume)IVType).ab().size()});
                ((SimpleImageVolume)IVType).a(new int[]{((SimpleImageVolume)IVType).a()[0], ((SimpleImageVolume)IVType).a()[1], ((SimpleImageVolume)IVType).ab().size()});
                SliceInfo sliceInfo3 = ((SimpleImageVolume)IVType).ab().get(0);
                SliceInfo sliceInfo4 = ((SimpleImageVolume)IVType).ab().get(((SimpleImageVolume)IVType).ab().size() - 1);
                ((SimpleImageVolume)IVType).b(new float[]{(sliceInfo3.sliceDicomCenter[0] + sliceInfo4.sliceDicomCenter[0]) / 2.0f, (sliceInfo3.sliceDicomCenter[1] + sliceInfo4.sliceDicomCenter[1]) / 2.0f, (sliceInfo3.sliceDicomCenter[2] + sliceInfo4.sliceDicomCenter[2]) / 2.0f});
                this.calculateRealVolumeScaling(IVType);
                this.fixSliceSeparation(IVType);
                ((SimpleImageVolume)IVType).getUncopiedMutableInfo().scanDuration = 0.0f;
                for (SliceInfo sliceInfo5 : ((SimpleImageVolume)IVType).ab()) {
                    if (sliceInfo5.frameTime == null) continue;
                    ((SimpleImageVolume)IVType).getUncopiedMutableInfo().scanDuration += sliceInfo5.frameTime.floatValue();
                }
            }
            if (this.dataProvider.deliberatelyContainsMultipleSeries()) {
                for (n2 = 0; n2 < this.dSeries.n(); ++n2) {
                    IVType = this.dSeries.c(n2);
                    ((SimpleImageVolume)IVType).getUncopiedMutableInfo().isMultiSeries4d = bl2;
                }
            }
            this.dSeries.p();
        }
        catch (Exception exception) {
            log.b("Error assembling volume", exception);
            ay.a((Object)"Error assembling volume", (Throwable)exception);
            return false;
        }
        return true;
    }

    private void flagInfoIfDICOMWasModified(SeriesInfo seriesInfo, DicomObject dicomObject) {
        if (DicomReadJavascriptFilterManager.wasObjectMunged(dicomObject)) {
            seriesInfo.wasModifiedByDICOMReadFilter = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSliceDataIntoVolumes() {
        boolean bl2 = false;
        try {
            if (this.backgroundDel.shouldBackgroundLoad() && this.loaderPrefs.e.gantryAnswer != null && this.loaderPrefs.e.gantryAnswer.booleanValue()) {
                this.backgroundDel = new BackgroundVolumeLoaderDelegate();
            }
            if (!this.loadingFromCache || !this.backgroundDel.shouldBackgroundLoad()) {
                String string2;
                final AtomicInteger atomicInteger = new AtomicInteger(1);
                Map<String, Pair<Set<IVType>, SliceInfo>> map = this.getFilenameSliceMap();
                ArrayList arrayList = Lists.newArrayList();
                List<String> list = this.dataProvider.getFilenames();
                for (String object2 : list) {
                    if (!map.containsKey(object2)) continue;
                    arrayList.add(object2);
                    if (!this.loadingFromCache) continue;
                    this.dataProvider.fetchNext(object2);
                }
                if (this.loadingFromCache) {
                    ay.a((Object)("Starting to load slice data for multifile volume with " + arrayList.size() + " files."), this);
                } else {
                    ay.a((Object)("Starting to load slice data for multifile volume with " + arrayList.size() + " files, but it should already all be in memory."), this);
                }
                ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(m.c);
                final Semaphore semaphore = new Semaphore(m.c.getCorePoolSize());
                ArrayList arrayList2 = Lists.newArrayList();
                for (String string2 : arrayList) {
                    if (this.progress.n() == Progress.Status.e) {
                        return;
                    }
                    semaphore.acquire();
                    final Pair<Set<IVType>, SliceInfo> pair = map.get(string2);
                    for (SimpleImageVolume simpleImageVolume : (Set)pair.x) {
                        final SliceOrientationMangler sliceOrientationMangler = this.manglerMap.get(simpleImageVolume);
                        final FuncUtils.j<ShortBuffer> j2 = this.getDataForSlice(simpleImageVolume, (SliceInfo)pair.y);
                        Runnable runnable = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    sliceOrientationMangler.addSlice((SliceInfo)pair.y, (ShortBuffer)j2.call());
                                    SimpleDicomVolumeLoaderImpl.this.updateSliceFillingProgress(atomicInteger.getAndIncrement());
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        if (executorCompletionService != null) {
                            arrayList2.add(executorCompletionService.submit(runnable, null));
                            continue;
                        }
                        runnable.run();
                    }
                }
                for (int f2 = 0; f2 < arrayList2.size(); ++f2) {
                    ((Future)arrayList2.get(f2)).get();
                }
                this.progress.b(this.progress.g());
                float f2 = (float)(System.currentTimeMillis() - this.loadingStartTime) / 1000.0f;
                string2 = String.format("Regularloaded in %.2fs", Float.valueOf(f2));
                if (MimpacsPrefs.enablePerformanceLogging.getValue().booleanValue()) {
                    ay.b((Object)string2, this);
                } else {
                    ay.e(string2);
                }
            } else {
                bl2 = true;
                this.startBackgroundLoading();
            }
            this.successfullyLoaded = !this.outOfMemory;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        finally {
            if (!bl2) {
                this.dataProvider.destroy();
            }
            log.d("Time to completely load the study(ms): " + String.valueOf(System.currentTimeMillis() - this.loadingStartTime));
        }
    }

    private void startBackgroundLoading() {
        this.loadingInBackground = true;
        final VolumeDataFiller volumeDataFiller = MIMContext.i() ? new SlowCdVolumeFiller(this, this.progress) : new VolumeDataFiller(this, this.progress);
        volumeDataFiller.makeMeACheckerBoard();
        new Thread("Background Loader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    volumeDataFiller.fill();
                }
                finally {
                    SimpleDicomVolumeLoaderImpl.this.dataProvider.destroy();
                }
            }
        }.start();
    }

    Map<String, Pair<Set<IVType>, SliceInfo>> getFilenameSliceMap() {
        HashMap hashMap = Maps.newHashMap();
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            for (DerivedSliceInfo derivedSliceInfo : this.manglerMap.get(simpleImageVolume).getDerivedSlices()) {
                HashSet hashSet = Sets.newHashSet();
                hashSet.add(simpleImageVolume);
                if (hashMap.containsKey(derivedSliceInfo.first.fileName)) {
                    ((Set)((Pair)hashMap.get((Object)derivedSliceInfo.first.fileName)).x).add(simpleImageVolume);
                } else {
                    hashMap.put(derivedSliceInfo.first.fileName, Pair.get(hashSet, derivedSliceInfo.first));
                }
                if (derivedSliceInfo.second == null) continue;
                if (hashMap.containsKey(derivedSliceInfo.second.fileName)) {
                    ((Set)((Pair)hashMap.get((Object)derivedSliceInfo.second.fileName)).x).add(simpleImageVolume);
                    continue;
                }
                hashMap.put(derivedSliceInfo.second.fileName, Pair.get(hashSet, derivedSliceInfo.second));
            }
        }
        return hashMap;
    }

    void updateSliceFillingProgress(int n2) {
        int n3 = this.headerCache.loadedFromCache ? 3 : 1;
        this.progress.c(n3);
        String string = MIMFormat.a(Messages.a("General", "PROCESS_SLICE_LABEL"), String.valueOf(n2++), String.valueOf(this.dataProvider.getFilenames().size()));
        this.progress.b_(string);
    }

    private DicomObject loadDicomObjectForSliceInfo(SliceInfo sliceInfo) {
        DicomInputHandler dicomInputHandler = DicomReader.getInputHandler(4325393, false);
        DicomReader.DicomReadParams dicomReadParams = new DicomReader.DicomReadParams().setHandler(dicomInputHandler).setAllowPartialPixelData(true);
        InputStream inputStream = this.dataProvider.getStream(sliceInfo.fileName);
        DicomReader.DicomReadResult dicomReadResult = DicomReader.readStreamIntoDicomNoThrow(inputStream, dicomReadParams);
        DicomObject dicomObject = null;
        if (dicomReadResult != null) {
            dicomObject = this.applyDicomObjectFilters(dicomReadResult.dob);
            if (dicomReadResult.wasMissingPixelData) {
                this.hasBadSlices = true;
            }
        }
        if (dicomObject == null) {
            throw new IllegalStateException("DICOM Read - could not load data for " + sliceInfo.fileName);
        }
        return dicomObject;
    }

    private void rescaleSingleSlice(IVType IVType, SliceInfo sliceInfo, ShortBuffer shortBuffer) {
        SeriesInfo seriesInfo = ((SimpleImageVolume)IVType).getUncopiedMutableInfo();
        if (sliceInfo.rescaleSlope == seriesInfo.rescale.slope && sliceInfo.rescaleIntercept == seriesInfo.rescale.intercept) {
            this.replacePaddingValueWithMinimum(IVType, sliceInfo, shortBuffer);
            return;
        }
        for (int i2 = 0; i2 < shortBuffer.limit(); ++i2) {
            short s2 = shortBuffer.get(i2);
            s2 = SimpleDicomVolumeLoaderImpl.isPixelPaddingValue(sliceInfo, s2) ? (short)((SimpleImageVolume)IVType).ah() : SimpleDicomVolumeLoaderImpl.rescaleValueToFinal(seriesInfo, sliceInfo, s2);
            shortBuffer.put(i2, s2);
        }
    }

    private void replacePaddingValueWithMinimum(IVType IVType, SliceInfo sliceInfo, ShortBuffer shortBuffer) {
        if (sliceInfo.pixelPaddingValue != null) {
            int n2 = sliceInfo.pixelPaddingValue;
            short s2 = (short)((SimpleImageVolume)IVType).ah();
            for (int i2 = 0; i2 < shortBuffer.limit(); ++i2) {
                if (shortBuffer.get(i2) != n2) continue;
                shortBuffer.put(i2, s2);
            }
        }
    }

    private static short rescaleValueToFinal(SeriesInfo seriesInfo, SliceInfo sliceInfo, int n2) {
        float f2 = (float)n2 * sliceInfo.rescaleSlope + sliceInfo.rescaleIntercept;
        int n3 = Math.round((f2 - seriesInfo.rescale.intercept) / seriesInfo.rescale.slope);
        if (n3 < Short.MIN_VALUE) {
            n3 = Short.MIN_VALUE;
        } else if (n3 > Short.MAX_VALUE) {
            n3 = Short.MAX_VALUE;
        }
        return (short)n3;
    }

    private boolean shouldProcessSlice(DicomObject dicomObject, String string) throws SeriesIsReallySingleFileException {
        if (dicomObject == null || dicomObject.isEmpty()) {
            return false;
        }
        String string2 = dicomObject.getString(0x20000E, "");
        if (!string2.equals(this.volMeta.seriesUID)) {
            if (!this.dataProvider.deliberatelyContainsMultipleSeries()) {
                return false;
            }
            this.volMeta.allSerUIDs.add(new UIDContainer.SeriesUID(string2));
        }
        if ("1.2.840.10008.5.1.4.1.1.104.1".equals(dicomObject.getString(524310, ""))) {
            return false;
        }
        if (this.isSingleFileVolumeType(dicomObject)) {
            this.bailOutFromMultifileLoad(dicomObject, string);
            throw new SeriesIsReallySingleFileException();
        }
        return true;
    }

    private void bailOutFromMultifileLoad(DicomObject dicomObject, String string) {
        this.loadSingleFileVolume(string, dicomObject);
    }

    private boolean isSingleFileVolumeType(DicomObject dicomObject) {
        return false;
    }

    protected void sortSlices(IVType IVType) {
        Collections.sort(((SimpleImageVolume)IVType).aa(), new SliceInfoComparator(((SimpleImageVolume)IVType).getUncopiedMutableInfo(), this.loaderPrefs));
    }

    protected boolean shouldDiscardCrazySlopes(SeriesInfo seriesInfo) {
        DicomLoadingUtility.CrazySlopeStrategy crazySlopeStrategy = DicomPrefs.crazySlopeStrat.getValue();
        Object[] objectArray = null;
        String string = null;
        if (crazySlopeStrategy == DicomLoadingUtility.CrazySlopeStrategy.ALWAYS_DISCARD || crazySlopeStrategy == null) {
            objectArray = Boolean.valueOf(true);
            string = seriesInfo.patientName + "\n" + Messages.a("General", "DICOMLOADER_CRAZY_SLOPES");
        }
        if (crazySlopeStrategy == DicomLoadingUtility.CrazySlopeStrategy.ALWAYS_KEEP) {
            objectArray = false;
            string = seriesInfo.patientName + "\n" + Messages.a("General", "DICOMLOADER_CRAZY_SLOPES_KEEP");
        }
        if (objectArray != null) {
            if (string != null) {
                final String string2 = string;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MOptionPane.b(SimpleDicomVolumeLoaderImpl.this.guiParent, string2, Messages.a("General", "DICOMLOADER_CRAZY_SLOPES_TITLE"), 1);
                    }
                });
            }
            return objectArray.booleanValue();
        }
        objectArray = new String[]{Messages.a("General", "DICOMLOADER_CRAZY_SLOPES_KEEP_CHOICE"), Messages.a("General", "DICOMLOADER_CRAZY_SLOPES_DISCARD_CHOICE")};
        string = crazySlopeStrategy == DicomLoadingUtility.CrazySlopeStrategy.PROMPT_USER_DISCARD_WHEN_HEADLESS ? objectArray[1] : objectArray[0];
        Object object = MOptionPane.a(this.guiParent, Messages.a("General", "DICOMLOADER_CRAZY_SLOPES_CHOICE_MESSAGE"), Messages.a("General", "DICOMLOADER_CRAZY_SLOPES_TITLE"), 3, null, objectArray, string);
        if (object == null) {
            object = string;
        }
        return !object.equals(objectArray[0]);
    }

    protected void calculateRealVolumeScaling(IVType IVType) {
        boolean bl2 = false;
        SeriesInfo seriesInfo = ((SimpleImageVolume)IVType).getUncopiedMutableInfo();
        List<SliceInfo> list = ((SimpleImageVolume)IVType).ab();
        int n2 = list.size();
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SliceInfo sliceInfo = list.get(i2);
            fArray[i2] = sliceInfo.rescaleSlope;
            fArray2[i2] = sliceInfo.rescaleIntercept;
        }
        Arrays.sort(fArray);
        Arrays.sort(fArray2);
        ArrayList arrayList = Lists.newArrayList();
        bl2 = fArray[0] != fArray[n2 - 1] || fArray2[0] != fArray2[n2 - 1];
        float f2 = fArray[n2 / 2];
        if (bl2) {
            float f3 = Float.MAX_VALUE;
            float f4 = Float.NEGATIVE_INFINITY;
            for (int i3 = 0; i3 < list.size(); ++i3) {
                float f5;
                SliceInfo sliceInfo = list.get(i3);
                if (Math.abs(sliceInfo.rescaleSlope / f2) > 100.0f) {
                    if (!this.haveDecidedCrazySlopeStrat) {
                        this.discardCrazySlopes = this.shouldDiscardCrazySlopes(seriesInfo);
                        this.haveDecidedCrazySlopeStrat = true;
                    }
                    if (this.discardCrazySlopes) continue;
                }
                arrayList.add(Float.valueOf(sliceInfo.rescaleSlope));
                short[] sArray = this.getSliceMinMaxViaHistogram(sliceInfo);
                short s2 = sArray[0];
                short s3 = sArray[1];
                float f6 = (float)s3 * sliceInfo.rescaleSlope + sliceInfo.rescaleIntercept;
                if (f6 > f4) {
                    f4 = f6;
                }
                if (!((f5 = (float)s2 * sliceInfo.rescaleSlope + sliceInfo.rescaleIntercept) < f3)) continue;
                f3 = f5;
            }
            Collections.sort(arrayList);
            if (f3 >= 0.0f && f4 <= 31767.0f) {
                seriesInfo.rescale.intercept = 0.0f;
                seriesInfo.rescale.slope = fArray[0] < 1.0f ? ((Float)arrayList.get(arrayList.size() - 1)).floatValue() * 2.0f : 1.0f;
            } else if (f4 - f3 <= 31767.0f) {
                seriesInfo.rescale.intercept = f3 - 0.0f;
                seriesInfo.rescale.slope = fArray[0] < 1.0f ? ((Float)arrayList.get(arrayList.size() - 1)).floatValue() * 2.0f : 1.0f;
            } else {
                seriesInfo.rescale.slope = (f4 - f3) / 31767.0f;
                seriesInfo.rescale.intercept = f3 - 0.0f * seriesInfo.rescale.slope;
            }
        }
        int[] nArray = this.getVolMinMaxDuringLoad(IVType, true);
        boolean bl3 = SimpleDicomVolumeLoaderImpl.possiblyRescaleVolumeWithVeryFewValues(((SimpleImageVolume)IVType).getUncopiedMutableInfo(), nArray);
        if (bl3) {
            nArray = this.getVolMinMaxDuringLoad(IVType, true);
        }
        this.possiblyAdjustDataRangeForVolume(IVType, nArray, true);
    }

    public static <J extends SimpleImageFrame> boolean possiblyRescaleVolumeWithVeryFewValues(SeriesInfo seriesInfo, int[] nArray) {
        if ("CT".equals(seriesInfo.modality) || seriesInfo.rescale.slope != 1.0f) {
            return false;
        }
        int n2 = Math.max(Math.abs(nArray[0]), Math.abs(nArray[1]));
        if (n2 < 1000 && n2 > 0) {
            int n3 = 15000 / n2;
            seriesInfo.rescale.slope /= (float)n3;
            seriesInfo.scalingFactorFromOriginal = n3;
            return true;
        }
        return false;
    }

    private int[] getVolMinMaxDuringLoad(IVType IVType, boolean bl2) {
        int[] nArray = bl2 ? this.getFinalRawVolMinMax(IVType) : new int[]{(int)((SimpleImageVolume)IVType).ah(), (int)((SimpleImageVolume)IVType).ai()};
        return nArray;
    }

    private int[] getFinalRawVolMinMax(IVType IVType) {
        int n2 = Short.MAX_VALUE;
        int n3 = Short.MIN_VALUE;
        SeriesInfo seriesInfo = ((SimpleImageVolume)IVType).getUncopiedMutableInfo();
        for (SliceInfo sliceInfo : ((SimpleImageVolume)IVType).ab()) {
            short[] sArray = this.getSliceMinMaxViaHistogram(sliceInfo);
            n2 = Math.min(n2, SimpleDicomVolumeLoaderImpl.rescaleValueToFinal(seriesInfo, sliceInfo, sArray[0]));
            n3 = Math.max(n3, SimpleDicomVolumeLoaderImpl.rescaleValueToFinal(seriesInfo, sliceInfo, sArray[1]));
        }
        return new int[]{n2, n3};
    }

    private short[] getSliceMinMaxViaHistogram(SliceInfo sliceInfo) {
        int n2;
        int n3 = Short.MAX_VALUE;
        int n4 = Short.MIN_VALUE;
        int n5 = 0;
        IntBuffer intBuffer = this.headerCache.getHistogram(sliceInfo.fileName);
        for (n2 = 0; n2 < intBuffer.limit(); ++n2) {
            if (intBuffer.get(n2) <= 0 || SimpleDicomVolumeLoaderImpl.isPixelPaddingValue(sliceInfo, Short.MIN_VALUE + n2)) continue;
            n3 = (short)(n2 + Short.MIN_VALUE);
            n5 = n2;
            break;
        }
        for (n2 = intBuffer.limit() - 1; n2 >= n5; --n2) {
            if (intBuffer.get(n2) <= 0 || SimpleDicomVolumeLoaderImpl.isPixelPaddingValue(sliceInfo, n2)) continue;
            n4 = n2 + Short.MIN_VALUE;
            break;
        }
        return new short[]{(short)n3, (short)n4};
    }

    private static boolean isPixelPaddingValue(SliceInfo sliceInfo, int n2) {
        return sliceInfo.pixelPaddingValue != null && n2 == sliceInfo.pixelPaddingValue;
    }

    protected void fixSliceSeparation(IVType IVType) {
        if (((SimpleImageVolume)IVType).ab().size() <= 1) {
            return;
        }
        float[] fArray = this.calculateSliceSeparations(IVType);
        ((SimpleImageVolume)IVType).e(fArray);
    }

    protected float[] calculateSliceSeparations(IVType IVType) {
        List<SliceInfo> list = ((SimpleImageVolume)IVType).ab();
        float[] fArray = SliceInfo.a(((SimpleImageVolume)IVType).getUncopiedMutableInfo(), list, this.loaderPrefs);
        SliceInfo.a(list, (float[])fArray.clone(), IVType);
        float[] fArray2 = (float[])fArray.clone();
        Arrays.sort(fArray2);
        this.hasBigGap = false;
        int n2 = 8;
        float f2 = fArray2[fArray2.length / 2];
        if (Float.isNaN(list.get((int)0).voxel.z)) {
            list.get((int)0).voxel.z = f2;
            if (fArray[0] < list.get((int)0).voxel.z * (float)n2) {
                list.get((int)0).voxel.z = fArray[0];
            } else {
                this.hasBigGap = true;
            }
        } else if (fArray[0] >= list.get((int)0).voxel.z * (float)n2) {
            this.hasBigGap = true;
        }
        int n3 = list.size();
        for (int i2 = 1; i2 < n3 - 1; ++i2) {
            float f3 = (fArray[i2 - 1] + fArray[i2]) / 2.0f;
            float f4 = list.get((int)i2).voxel.z;
            if (Float.isNaN(f4)) {
                f4 = f2;
            }
            if (f3 < f4 * (float)n2) {
                if (!Float.isNaN(list.get((int)i2).voxel.z)) continue;
                list.get((int)i2).voxel.z = f3;
                continue;
            }
            if (Float.isNaN(list.get((int)i2).voxel.z)) {
                list.get((int)i2).voxel.z = Math.min(fArray[i2 - 1], fArray[i2]);
            }
            this.hasBigGap = true;
        }
        if (Float.isNaN(list.get((int)(n3 - 1)).voxel.z)) {
            list.get((int)(n3 - 1)).voxel.z = f2;
            if (fArray[n3 - 2] < list.get((int)(n3 - 1)).voxel.z * (float)n2) {
                list.get((int)(n3 - 1)).voxel.z = fArray[n3 - 2];
            } else {
                this.hasBigGap = true;
            }
        } else if (fArray[n3 - 2] >= list.get((int)(n3 - 1)).voxel.z * (float)n2) {
            this.hasBigGap = true;
        }
        return fArray2;
    }

    static boolean needsTruncatedHawkeyeSpectHaxx(DicomObject dicomObject) {
        int n2;
        int n3;
        return dicomObject.getString(524400, "").contains("GE") && (n3 = dicomObject.getInt(0x280008, 0)) == (n2 = dicomObject.getInt(5505153, 0)) * 2 && n2 == dicomObject.getInts(5505152, new int[0]).length;
    }

    protected IVType initializeNewSingleFileVolume(DicomObject dicomObject, SliceInfo sliceInfo) {
        IVType IVType = this.dSeries.m();
        if (dicomObject == null) {
            return null;
        }
        SeriesInfo seriesInfo = DicomLoadingUtility.getSeriesInfo(dicomObject, this.loaderPrefs);
        ((SimpleImageVolume)IVType).b(seriesInfo);
        int[] nArray = new int[]{dicomObject.getInt(2621457, 0), dicomObject.getInt(2621456, 0), dicomObject.getInt(5505153, 0)};
        if (nArray[2] == 0) {
            nArray[2] = dicomObject.getInt(0x280008, 0);
        } else if (SimpleDicomVolumeLoaderImpl.needsTruncatedHawkeyeSpectHaxx(dicomObject)) {
            ay.b((Object)"Found a questionable GE scan with SliceVector half what it should be", this);
            nArray[2] = dicomObject.getInt(0x280008, 0);
        }
        ((SimpleImageVolume)IVType).b(nArray);
        ((SimpleImageVolume)IVType).a(nArray);
        float[] fArray = DicomLoadingUtility.getPixSpacingOrder(dicomObject);
        if (fArray == null || fArray.length < 2) {
            fArray = new float[]{1.0f, 1.0f};
        }
        float f2 = SimpleDicomVolumeLoaderImpl.getVoxelZ(dicomObject);
        this.handleCrazyVoxelSize(IVType, fArray, f2);
        SimpleDicomVolumeLoaderImpl.processAcquisitionAndScalingForSlice(seriesInfo, sliceInfo);
        ((SimpleImageVolume)IVType).aa().add(sliceInfo);
        if ("1.2.840.10008.5.1.4.1.1.481.2".equals(dicomObject.getString(524310))) {
            seriesInfo.u().a(dicomObject.getString(805568514, ""));
        }
        return IVType;
    }

    protected IVType initializeNewMultiFileVolume(IVType IVType) {
        float[] fArray;
        SliceInfo sliceInfo = ((SimpleImageVolume)IVType).ab().get(0);
        if (sliceInfo.voxel == null) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = sliceInfo.voxel.x;
            fArray = fArray2;
            fArray2[1] = sliceInfo.voxel.y;
        }
        float[] fArray3 = fArray;
        if (fArray3 == null) {
            ((SimpleImageVolume)IVType).a((float[])null);
        } else {
            float f2 = sliceInfo.voxel.z;
            this.handleCrazyVoxelSize(IVType, fArray3, f2);
        }
        return IVType;
    }

    private void handleCrazyVoxelSize(IVType IVType, float[] fArray, float f2) {
        if (Float.isNaN(f2)) {
            log.b("Slice spacing data not present - using default (2.5mm)");
            f2 = 2.5f;
        } else if (f2 < 0.0f) {
            f2 *= -1.0f;
        }
        ((SimpleImageVolume)IVType).a(new float[]{fArray[0], fArray[1], f2});
        log.d("Voxel: " + ((SimpleImageVolume)IVType).b()[0] + "x" + ((SimpleImageVolume)IVType).b()[1] + "x" + ((SimpleImageVolume)IVType).b()[2]);
    }

    private void adjustSeriesUnits() {
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            SimpleDicomVolumeLoaderImpl.adjustUnitsForVolume(simpleImageVolume);
        }
    }

    public static void adjustUnitsForVolume(SimpleImageFrame simpleImageFrame) {
        SeriesInfo seriesInfo = simpleImageFrame.getUncopiedMutableInfo();
        UnitHelper unitHelper = seriesInfo.u();
        String string = null;
        String string2 = null;
        float f2 = 1.0f;
        if (unitHelper.n()) {
            seriesInfo.u().a("GML");
            string = "SUV";
        }
        if ("PT".equalsIgnoreCase(seriesInfo.modality) && seriesInfo.manufacturer.toLowerCase().contains("philips")) {
            boolean bl2;
            boolean bl3 = bl2 = !unitHelper.w() && !unitHelper.p();
            if (bl2 && unitHelper.a(DataUnitUtils.COUNTS_CANON_) && seriesInfo.philipsSuvScalingTag != 0.0f) {
                string = "SUV";
                string2 = "bw";
                f2 = seriesInfo.philipsSuvScalingTag;
            }
        }
        if (string != null) {
            unitHelper.a(string, string2, f2);
            log.d("SUV Scale Float Val: " + seriesInfo.rescale.unitScale);
        }
    }

    private static void processAcquisitionAndScalingForSlice(SeriesInfo seriesInfo, SliceInfo sliceInfo) {
        sliceInfo.sliceDicomCenter = SimpleDicomVolumeLoaderImpl.computeSliceDicomCenter(sliceInfo, seriesInfo.imageOrientation);
        if (sliceInfo.acquisitionTime != null && (seriesInfo.acqTime == null || seriesInfo.acqTime.after(sliceInfo.acquisitionTime))) {
            seriesInfo.acqTime = sliceInfo.acquisitionTime;
            seriesInfo.originalAcqTime = sliceInfo.acquisitionTime;
        }
        seriesInfo.rescale.slope = sliceInfo.rescaleSlope;
        seriesInfo.rescale.intercept = sliceInfo.rescaleIntercept;
        if (Float.isNaN(sliceInfo.slicePosition)) {
            sliceInfo.slicePosition = sliceInfo.sliceDicomCenter[2];
        }
    }

    private SliceInfo loadSliceInfo(DicomObject dicomObject, String string) throws SeriesIsNotImageTypeException {
        short[] sArray;
        if (!dicomObject.contains(2621456) || !dicomObject.contains(2621457)) {
            if (this.cacheOnly) {
                log.d("Aborted cache generation for series of modality " + dicomObject.getString(524384));
            }
            throw new SeriesIsNotImageTypeException();
        }
        SliceInfo sliceInfo = this.loadSliceInfoMetadata(dicomObject, string);
        PixelDataExtractor.RescaleParameters rescaleParameters = new PixelDataExtractor.RescaleParameters(sliceInfo);
        try {
            sArray = SimpleDicomVolumeLoaderImpl.extractPixelDataInternal(dicomObject, rescaleParameters, sliceInfo);
            sliceInfo.pixelPaddingValue = rescaleParameters.pixelPadding;
        }
        catch (PixelDataExtractor.MissingPixelDataException missingPixelDataException) {
            ay.b((Object)("Failed to extract pixel data for slice: " + string), "");
            sArray = new short[sliceInfo.width * sliceInfo.height];
            Arrays.fill(sArray, (short)Short.MIN_VALUE);
            this.hasBadSlices = true;
        }
        catch (BadCompressionException badCompressionException) {
            this.badCompression = true;
            throw new IllegalArgumentException(badCompressionException.getMessage());
        }
        ShortBuffer shortBuffer = this.bufAlloc.bufferify(sArray);
        rescaleParameters.applyTo(sliceInfo);
        this.buildHistogram(sliceInfo, shortBuffer);
        if (!this.cacheOnly) {
            this.headerCache.putData(sliceInfo.fileName, shortBuffer);
        }
        return sliceInfo;
    }

    private SliceInfo loadSliceInfoMetadata(DicomObject dicomObject, String string) {
        MultiSeriesFrameData multiSeriesFrameData;
        float f2;
        SliceInfo sliceInfo = new SliceInfo();
        sliceInfo.fileName = string;
        SimpleDicomVolumeLoaderImpl.readImageTags(dicomObject, sliceInfo);
        float[] fArray = DicomLoadingUtility.getPixSpacingOrder(dicomObject);
        if (fArray == null || fArray.length < 2) {
            fArray = new float[]{1.0f, 1.0f};
            this.warnAboutPixelSpacing(dicomObject);
        }
        if (!Float.isNaN(f2 = SimpleDicomVolumeLoaderImpl.getVoxelZ(dicomObject)) && f2 < 0.0f) {
            f2 *= -1.0f;
        }
        sliceInfo.voxel = new Point3f(fArray[0], fArray[1], f2);
        try {
            sliceInfo.sliceNumber = dicomObject.getInt(2097171, dicomObject.getInt(5509936, -1));
        }
        catch (NumberFormatException numberFormatException) {
            log.d("Couldn't load slice number, must be garbage", numberFormatException);
        }
        sliceInfo.imageIndex = dicomObject.getInt(5509936);
        sliceInfo.pixelSpacing = DicomLoadingUtility.getPixSpacingOrder(dicomObject);
        sliceInfo.slicePosition = dicomObject.getFloat(2101313, Float.NaN);
        sliceInfo.sopInstanceUID = dicomObject.getString(524312);
        sliceInfo.seriesInstanceUID = dicomObject.getString(0x20000E);
        Tuple2f tuple2f = this.loadRescaleInfo(dicomObject);
        sliceInfo.rescaleSlope = tuple2f.x;
        sliceInfo.rescaleIntercept = tuple2f.y;
        sliceInfo.frameTime = SimpleDicomVolumeLoaderImpl.getFloatOrNull(dicomObject, 1577059);
        sliceInfo.triggerTime = SimpleDicomVolumeLoaderImpl.getFloatOrNull(dicomObject, 1577056);
        sliceInfo.frameReferenceTime = SimpleDicomVolumeLoaderImpl.getFloatOrNull(dicomObject, 5509888);
        if (dicomObject.contains(0x200100)) {
            sliceInfo.temporalPositionID = dicomObject.getInt(0x200100);
        }
        sliceInfo.echoTime = SimpleDicomVolumeLoaderImpl.getFloatOrNull(dicomObject, 0x180081);
        sliceInfo.imageComments = dicomObject.getString(0x204000);
        sliceInfo.gePrivatePctRpeakDelay = DicomReader.parseIntegerTag(dicomObject, 4526131);
        sliceInfo.philipsPrivatePhaseNumber = DicomReader.parseIntegerTag(dicomObject, 536940552);
        sliceInfo.gePrivateReconstructionMatrix = DicomReader.parseIntegerTag(dicomObject, 4395065);
        sliceInfo.seriesNumber = dicomObject.getString(0x200011);
        sliceInfo.acquisitionNumber = dicomObject.getString(0x200012);
        sliceInfo.binNumber = dicomObject.getInt(930308097, -1);
        sliceInfo.sequenceName = dicomObject.getString(1572900);
        sliceInfo.contentTime = dicomObject.getString(524339);
        sliceInfo.scanOptions = dicomObject.getString(1572898);
        sliceInfo.decayFactor = SimpleDicomVolumeLoaderImpl.getFloatOrNull(dicomObject, 5509921);
        sliceInfo.actualFrameDuration = SimpleDicomVolumeLoaderImpl.getIntegerOrNull(dicomObject, 1577538);
        sliceInfo.width = dicomObject.getInt(2621457, 0);
        sliceInfo.height = dicomObject.getInt(2621456, 0);
        sliceInfo.acquisitionTime = dicomObject.getDate(524338);
        if (this.dataProvider.deliberatelyContainsMultipleSeries() && (multiSeriesFrameData = this.dataProvider.getFrameDataForFile(string)) != null) {
            sliceInfo.explicitFrame = multiSeriesFrameData.getFrameNumberFromSeriesDesc();
            sliceInfo.explicitFrameDesc = multiSeriesFrameData.getFrameDesc();
            sliceInfo.explicitMaxFrames = multiSeriesFrameData.getMaxFramesFromSeriesDesc();
            sliceInfo.explicitMultiSeries4D = multiSeriesFrameData.isMultiSeries4d();
        }
        sliceInfo.pixelPaddingValue = PixelDataExtractor.readPixelPaddingValue(dicomObject);
        return sliceInfo;
    }

    static short[] extractPixelDataInternal(DicomObject dicomObject, PixelDataExtractor.RescaleParameters rescaleParameters, SliceInfo sliceInfo) {
        short[] sArray = PixelDataExtractor.extractPixelData(dicomObject, rescaleParameters);
        if (sArray == null) {
            try {
                DicomObject dicomObject2 = DicomReader.saveOutToTempFileAndDecompress(dicomObject);
                if (dicomObject2 != null) {
                    sArray = PixelDataExtractor.extractPixelData(dicomObject2, rescaleParameters);
                    int n2 = sliceInfo.width * sliceInfo.height;
                    if (n2 > 0 && n2 < sArray.length) {
                        short[] sArray2 = new short[n2];
                        System.arraycopy(sArray, 0, sArray2, 0, n2);
                        sArray = sArray2;
                        ay.c((Object)("The DICOM has more pixel data than the specified dimension on slice " + sliceInfo.sliceNumber), SimpleDicomVolumeLoaderImpl.class);
                    }
                }
            }
            catch (IOException iOException) {
                log.a(iOException);
            }
            if (sArray == null) {
                throw new BadCompressionException("Could not extract pixel data");
            }
        }
        return sArray;
    }

    private void buildHistogram(SliceInfo sliceInfo, ShortBuffer shortBuffer) {
        IntBuffer intBuffer = this.bufAlloc.allocateIntBuf(65536);
        shortBuffer.rewind();
        while (shortBuffer.hasRemaining()) {
            short s2 = shortBuffer.get();
            intBuffer.put(s2 - Short.MIN_VALUE, intBuffer.get(s2 - Short.MIN_VALUE) + 1);
        }
        shortBuffer.rewind();
        this.headerCache.putHistogram(sliceInfo.fileName, intBuffer, (Tuple2f)new Point2f(sliceInfo.rescaleSlope, sliceInfo.rescaleIntercept));
    }

    private Tuple2f loadRescaleInfo(DicomObject dicomObject) {
        float f2;
        Object object;
        float f3 = dicomObject.getFloat(2625618, 0.0f);
        float f4 = dicomObject.getFloat(2625619, 1.0f);
        if (f4 == 0.0f) {
            f4 = 1.0f;
        }
        if (dicomObject.getString(524310, "").equals("1.2.840.10008.5.1.4.1.1.20") && (object = DicomLoadingUtility.readRealWorldValueMapping(dicomObject)) != null) {
            f4 = (float)((DicomLoadingUtility.RealWorldValueMapping)object).slope;
            f3 = (float)((DicomLoadingUtility.RealWorldValueMapping)object).intercept;
        }
        if (dicomObject.contains(1375769136)) {
            float f5 = dicomObject.getFloat(new int[]{1375769136, 0, 2658629, 0, 2625619}, Float.NaN);
            f2 = dicomObject.getFloat(new int[]{1375769136, 0, 2658629, 0, 2625618}, Float.NaN);
            if (!Float.isNaN(f5) && !Float.isNaN(f2)) {
                boolean bl2 = true;
                int n2 = 1;
                while (n2 < dicomObject.get(1375769136).countItems()) {
                    float f6;
                    float f7 = dicomObject.getFloat(new int[]{1375769136, n2, 2658629, 0, 2625619}, Float.NaN);
                    if ((f6 = dicomObject.getFloat(new int[]{1375769136, n2++, 2658629, 0, 2625618}, Float.NaN)) == f2 && f7 == f5) continue;
                    ay.b((Object)"Found per-frame functional groups sequence with rescale slope and intercept, but they are not uniform", this);
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    f4 = f5;
                    f3 = f2;
                    log.a("using per-frame functional groups sequence rescale slope/intercept");
                }
            }
        }
        if ("PT".equals(dicomObject.getString(524384, "XX")) && dicomObject.getString(524400, "").toLowerCase().contains("philips") && (object = (Object)dicomObject.getBytes(1884491785)) != null && ((Object)object).length > 0) {
            f2 = Float.valueOf(new String((byte[])object)).floatValue();
            String string = dicomObject.getString(5509121, "");
            if (f2 != 0.0f && ("CNTS".equalsIgnoreCase(string) || "Counts".equalsIgnoreCase(string))) {
                f4 *= f2;
                f3 *= f2;
            }
        }
        if ("1.2.840.10008.5.1.4.1.1.481.2".equals(dicomObject.getString(524310))) {
            float f8 = dicomObject.getFloat(805568526, 1.0f);
            if (f8 != 0.0f) {
                f4 *= f8;
            }
            f3 *= dicomObject.getFloat(805568526, 1.0f);
        }
        return new Point2f(f4, f3);
    }

    private static Integer getIntegerOrNull(DicomObject dicomObject, int n2) {
        if (dicomObject.contains(n2)) {
            return dicomObject.getInt(n2);
        }
        return null;
    }

    private static Float getFloatOrNull(DicomObject dicomObject, int n2) {
        if (dicomObject.contains(n2)) {
            return Float.valueOf(dicomObject.getFloat(n2));
        }
        return null;
    }

    public static float[] computeSliceDicomCenter(SliceInfo sliceInfo, float[] fArray) {
        return SimpleDicomVolumeLoaderImpl.computeSliceDicomCenter(sliceInfo.width, sliceInfo.height, sliceInfo.ipp, fArray, sliceInfo.voxel.x, sliceInfo.voxel.y);
    }

    protected static float[] computeSliceDicomCenter(int n2, int n3, float[] fArray, float[] fArray2, float f2, float f3) {
        fArray = (float[])fArray.clone();
        float f4 = (float)(n2 - 1) / 2.0f * f2;
        fArray[0] = fArray[0] + f4 * fArray2[0];
        fArray[1] = fArray[1] + f4 * fArray2[1];
        fArray[2] = fArray[2] + f4 * fArray2[2];
        float f5 = (float)(n3 - 1) / 2.0f * f3;
        fArray[0] = fArray[0] + f5 * fArray2[3];
        fArray[1] = fArray[1] + f5 * fArray2[4];
        fArray[2] = fArray[2] + f5 * fArray2[5];
        return fArray;
    }

    protected static void readImageTags(DicomObject dicomObject, SliceInfo sliceInfo) {
        Object object;
        float[] fArray = dicomObject.getFloats(0x200032);
        DicomObject dicomObject2 = dicomObject.getNestedDicomObject(5505058);
        if (fArray == null || fArray.length != 3) {
            if (dicomObject2 != null) {
                fArray = dicomObject2.getFloats(0x200032);
            }
            if (fArray == null || fArray.length != 3) {
                object = SimpleDicomVolumeLoaderImpl.getEnhancedDicomPositionReferenceTags(dicomObject);
                if (object.isPresent()) {
                    DicomElement dicomElement = dicomObject.get(1375769136);
                    int n2 = ((int[])object.get())[0];
                    int n3 = ((int[])object.get())[1];
                    try {
                        double[] dArray = dicomElement.getDicomObject(0).get(n2).getDicomObject(0).getDoubles(n3);
                        fArray = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
                    }
                    catch (Exception exception) {
                        ay.d((Object)"Error parsing PerFrameFunctionalGroupSequence", (Throwable)exception, SimpleDicomVolumeLoaderImpl.class);
                    }
                } else {
                    log.d("ImagePositionPatient information is unavailable.");
                    log.d("We'll use the default value to calculate DICOM center.");
                    fArray = new float[]{0.0f, 0.0f, 0.0f};
                }
            }
        }
        if ((object = DicomLoadingUtility.readIOP(dicomObject)) == null) {
            log.d("ImageOrientationPatient information is unavailable.");
            log.d("We'll use the default value to calculate DICOM center.");
            object = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        }
        sliceInfo.ipp = fArray;
        sliceInfo.iop = object;
    }

    protected static Optional<int[]> getEnhancedDicomPositionReferenceTags(DicomObject dicomObject) {
        DicomElement dicomElement;
        if (dicomObject.contains(0x209222) && (dicomElement = dicomObject.get(0x209222)).countItems() >= 2) {
            int n2 = dicomElement.getDicomObject(1).getInt(2134375);
            int n3 = dicomElement.getDicomObject(1).getInt(2134373);
            return Optional.fromNullable((Object)new int[]{n2, n3});
        }
        return Optional.absent();
    }

    protected static float getVoxelZ(DicomObject dicomObject) {
        Optional<int[]> optional;
        float f2 = dicomObject.getFloat(0x180088, Float.NaN);
        if (Float.isNaN(f2) || f2 == 0.0f) {
            f2 = dicomObject.getFloat(1572944, Float.NaN);
        }
        if ((Float.isNaN(f2) || f2 == 0.0f) && (optional = SimpleDicomVolumeLoaderImpl.getEnhancedDicomPositionReferenceTags(dicomObject)).isPresent()) {
            int n2 = ((int[])optional.get())[0];
            int n3 = ((int[])optional.get())[1];
            DicomElement dicomElement = dicomObject.get(1375769136);
            try {
                double[] dArray = dicomElement.getDicomObject(0).get(n2).getDicomObject(0).getDoubles(n3);
                double[] dArray2 = dicomElement.getDicomObject(1).get(n2).getDicomObject(0).getDoubles(n3);
                f2 = Math.abs((float)dArray[2] - (float)dArray2[2]);
            }
            catch (Exception exception) {
                ay.d((Object)"Error parsing PerFrameFunctionalGroupSequence", SimpleDicomVolumeLoaderImpl.class);
                ay.d((Object)exception, SimpleDicomVolumeLoaderImpl.class);
            }
        }
        return f2;
    }

    protected void adjustOrientation(q<IVType> q2, boolean bl2) {
        SeriesInfo seriesInfo;
        boolean bl3 = false;
        boolean bl4 = false;
        if (q2.n() > 0) {
            IVType IVType = q2.c(0);
            seriesInfo = ((SimpleImageVolume)IVType).getUncopiedMutableInfo();
            float[] fArray = SimpleOrientationHelper.b(seriesInfo.imageOrientation, seriesInfo.a(this.loaderPrefs));
            boolean bl5 = bl3 = !SimpleOrientationHelper.b(fArray, SimpleOrientationHelper.a());
            if (this.loaderPrefs.g != null && this.loaderPrefs.g.a() != null) {
                boolean bl6 = bl3 = !SimpleOrientationHelper.b(fArray, this.loaderPrefs.g.a());
            }
            if (bl3) {
                ReorientationParamsEvaluator reorientationParamsEvaluator = new ReorientationParamsEvaluator(this.loaderPrefs);
                bl4 = reorientationParamsEvaluator.evaluate(seriesInfo, this.guiParent);
            }
        }
        for (int i2 = 0; i2 < q2.n(); ++i2) {
            seriesInfo = q2.c(i2);
            if (!bl3) continue;
            if (bl4) {
                if (bl2) {
                    if (this.loaderPrefs.g != null) {
                        ax.a((SimpleImageVolume<ImageCube.ImageCubeShort>)((Object)seriesInfo), this.manglerMap.get(seriesInfo).getSetupReorienter(), this.guiParent, this.loaderPrefs.g);
                    } else {
                        ax.a((SimpleImageVolume<ImageCube.ImageCubeShort>)((Object)seriesInfo), this.manglerMap.get(seriesInfo).getSetupReorienter(), this.guiParent);
                    }
                } else if (this.loaderPrefs.g != null) {
                    ax.a((SimpleImageVolume<ImageCube.ImageCubeShort>)((Object)seriesInfo), this.guiParent, this.loaderPrefs.g);
                } else {
                    ax.a((SimpleImageVolume<ImageCube.ImageCubeShort>)((Object)seriesInfo), this.guiParent);
                }
            } else {
                ((SimpleImageVolume)((Object)seriesInfo)).a(MatrixMultiplier.b());
                ((SimpleImageVolume)((Object)seriesInfo)).f(true);
            }
            ((SimpleImageVolume)((Object)seriesInfo)).getUncopiedMutableInfo().reoriented = bl4;
        }
    }

    private void possiblyAdjustDataRangeForVolume(IVType IVType, int[] nArray, final boolean bl2) {
        SeriesInfo seriesInfo = ((SimpleImageVolume)IVType).getUncopiedMutableInfo();
        Modality modality = Modality.getModalityForSopClass(seriesInfo.sopClassUID);
        PixelDataRescaler pixelDataRescaler = new PixelDataRescaler(modality, new PixelDataExtractor.RescaleParameters(seriesInfo.rescale.slope, seriesInfo.rescale.intercept, null), nArray[0], nArray[1], 0, 31767, (SimpleImageVolume)IVType, seriesInfo){
            final /* synthetic */ SimpleImageVolume val$volume;
            final /* synthetic */ SeriesInfo val$info;
            {
                this.val$volume = simpleImageVolume;
                this.val$info = seriesInfo;
                super(modality, rescaleParameters, n2, n3, n4, n5);
            }

            @Override
            public void applyOffset(long l2, float f2, long l3) {
                if (!bl2) {
                    int n2 = this.val$volume.a()[2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        short[] sArray = (short[])((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)this.val$volume.ad()).f((int)i2)).data;
                        for (int i3 = 0; i3 < sArray.length; ++i3) {
                            short s2 = sArray[i3];
                            if ((long)s2 > l3) {
                                s2 = (short)l3;
                            }
                            sArray[i3] = (short)((long)s2 + l2);
                        }
                    }
                    this.val$volume.aj();
                }
                this.val$info.rescale.intercept = f2;
            }

            @Override
            public void applyRescale(float f2, float f3, double d2) {
                if (!bl2) {
                    int n2 = this.val$volume.a()[2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        short[] sArray = (short[])((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)this.val$volume.ad()).f((int)i2)).data;
                        for (int i3 = 0; i3 < sArray.length; ++i3) {
                            long l2 = sArray[i3];
                            if ((double)l2 > d2) {
                                l2 = (long)d2;
                            }
                            double d3 = (double)l2 * (double)this.val$info.rescale.slope + (double)this.val$info.rescale.intercept;
                            sArray[i3] = (short)Math.round((d3 - (double)f3) / (double)f2);
                        }
                    }
                    this.val$volume.aj();
                }
                this.val$info.rescale.slope = f2;
                this.val$info.rescale.intercept = f3;
            }
        };
        pixelDataRescaler.execute();
    }

    protected void resampleLargeVolume(boolean bl2) {
        Object object;
        Object object222;
        int n2 = this.loaderPrefs.b;
        if (n2 == 0) {
            return;
        }
        IVType IVType = this.dSeries.c(0);
        this.scaleDownFactor = 1;
        int[] nArray = (int[])((SimpleImageVolume)IVType).a().clone();
        this.origXYBeforeScale = new int[]{nArray[0], nArray[1]};
        float[] fArray = (float[])((SimpleImageVolume)IVType).b().clone();
        int[] nArray2 = ((SimpleImageVolume)IVType).a();
        while (n2 < nArray2[0] || n2 < nArray2[1]) {
            this.scaleDownFactor *= 2;
            nArray2[0] = nArray[0] / this.scaleDownFactor;
            nArray2[1] = nArray[1] / this.scaleDownFactor;
            ((SimpleImageVolume)IVType).a(nArray2);
            float f2 = (float)nArray2[0] / (float)nArray[0];
            object222 = ((SimpleImageVolume)IVType).b();
            object222[0] = fArray[0] / f2;
            object222[1] = fArray[1] / f2;
            ((SimpleImageVolume)IVType).a((float[])object222);
            for (SliceInfo sliceInfo : ((SimpleImageVolume)IVType).ab()) {
                sliceInfo.width = nArray2[0];
                sliceInfo.height = nArray2[1];
            }
        }
        if (this.scaleDownFactor <= 1) {
            return;
        }
        ((SimpleImageVolume)IVType).getUncopiedMutableInfo().resampled = true;
        for (int i2 = 1; i2 < this.dSeries.n(); ++i2) {
            Object object3;
            object222 = this.dSeries.c(i2);
            object = ((SimpleImageVolume)object222).a();
            object[0] = object[0] / this.scaleDownFactor;
            object[1] = object[1] / this.scaleDownFactor;
            ((SimpleImageVolume)object222).a((int[])object.clone());
            float f3 = (float)object[0] / (float)nArray[0];
            Object object2 = object3 = (Object)((SimpleImageVolume)object222).b();
            object2[0] = object2[0] / f3;
            Object object4 = object3;
            object4[1] = object4[1] / f3;
            ((SimpleImageVolume)object222).a((float[])object3.clone());
            ((SimpleImageVolume)object222).getUncopiedMutableInfo().resampled = true;
            for (SliceInfo sliceInfo : ((SimpleImageVolume)object222).ab()) {
                sliceInfo.width = (int)object[0];
                sliceInfo.height = (int)object[1];
            }
        }
        if (!bl2) {
            for (Object object222 : this.dSeries.l()) {
                object = (ArrayListImageCubeShort)((SimpleImageVolume)object222).ad();
                ArrayList<short[]> arrayList = new ArrayList<short[]>(((ArrayListImageCubeShort)object).b());
                ((ArrayListImageCubeShort)object).c();
                for (short[] sArray : arrayList) {
                    ((ArrayListImageCubeShort)object).a(this.scaleImage(object222, sArray));
                }
            }
        }
    }

    private short[] scaleImage(IVType IVType, short[] sArray) {
        return Interpolate.a(sArray, this.origXYBeforeScale[0], this.origXYBeforeScale[1], ((SimpleImageVolume)IVType).a()[0], ((SimpleImageVolume)IVType).a()[1]);
    }

    protected boolean handlePixelSpacing() {
        boolean bl2 = false;
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            int n2 = 10000;
            for (int i2 = 0; i2 < simpleImageVolume.ab().size(); ++i2) {
                SliceInfo sliceInfo = simpleImageVolume.ab().get(i2);
                Point3f point3f = sliceInfo.voxel;
                if (point3f == null) continue;
                hashSet.add((int)(10000.0f * point3f.x));
                hashSet2.add((int)(10000.0f * point3f.y));
            }
            if (hashSet.isEmpty() || hashSet.size() <= 1 && hashSet2.size() <= 1) continue;
            log.a("Detected that the volume has [" + hashSet.size() + ", " + hashSet2.size() + "] PixelSpacing values.");
            com.mimvista.numerics.ay ay2 = new com.mimvista.numerics.ay(simpleImageVolume.ab(), simpleImageVolume.getUncopiedMutableInfo());
            this.spacingHandlerMap.put(simpleImageVolume, ay2);
            ay2.a(simpleImageVolume);
            bl2 = true;
        }
        return bl2;
    }

    protected void showPixelSpacingWarning(String string) {
    }

    protected boolean handleSpacingVariations(boolean bl2) {
        boolean bl3 = true;
        for (SimpleImageVolume simpleImageVolume : this.dSeries.l()) {
            if (this.hasBigGap) {
                bl3 = this.handleGappedVolume(simpleImageVolume);
            }
            List<DerivedSliceInfo> list = null;
            list = !SliceInfo.a(simpleImageVolume.ab(), simpleImageVolume.getUncopiedMutableInfo()) ? this.handleNonUniform(simpleImageVolume, !bl2) : this.buildUniformDerivedSlices(simpleImageVolume);
            if (!bl2) continue;
            final SimpleImageVolume simpleImageVolume2 = simpleImageVolume;
            SliceOrientationMangler sliceOrientationMangler = new SliceOrientationMangler(this.dSeries.d(simpleImageVolume), list, new SliceOrientationMangler.SliceProvider(){

                @Override
                public ShortBuffer getFinalDataForSlice(SliceInfo sliceInfo) {
                    return (ShortBuffer)SimpleDicomVolumeLoaderImpl.this.getDataForSlice(simpleImageVolume2, sliceInfo).call();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void markSliceLoaded(int n2) {
                    SimpleImageVolume simpleImageVolume = simpleImageVolume2;
                    synchronized (simpleImageVolume) {
                        simpleImageVolume2.ab().get((int)n2).sliceIsLoaded = true;
                        simpleImageVolume2.notifyAll();
                    }
                }
            });
            this.manglerMap.put(simpleImageVolume, sliceOrientationMangler);
        }
        return bl3;
    }

    private FuncUtils.j<ShortBuffer> getDataForSlice(final IVType IVType, final SliceInfo sliceInfo) {
        int n2 = 2;
        ShortBuffer shortBuffer = null;
        DicomObject dicomObject = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                shortBuffer = this.headerCache.popData(sliceInfo.fileName);
                if (shortBuffer != null) break;
                dicomObject = this.loadDicomObjectForSliceInfo(sliceInfo);
                this.flagInfoIfDICOMWasModified(((SimpleImageVolume)IVType).getUncopiedMutableInfo(), dicomObject);
                break;
            }
            catch (Exception exception) {
                if (i2 == 1) continue;
                ay.c((Object)("Error loading data for slice " + sliceInfo.sopInstanceUID + ", trying one more time"), (Throwable)exception, this);
                continue;
            }
        }
        if (shortBuffer != null) {
            final ShortBuffer shortBuffer2 = shortBuffer;
            return new FuncUtils.j<ShortBuffer>(){

                @Override
                public ShortBuffer call() {
                    try {
                        return SimpleDicomVolumeLoaderImpl.this.processDataForSlice(IVType, sliceInfo, shortBuffer2);
                    }
                    catch (Exception exception) {
                        ay.d((Object)exception, SimpleDicomVolumeLoaderImpl.this);
                        return SimpleDicomVolumeLoaderImpl.this.getFailureSlice(sliceInfo);
                    }
                }
            };
        }
        if (dicomObject != null) {
            final DicomObject dicomObject2 = dicomObject;
            return new FuncUtils.j<ShortBuffer>(){

                @Override
                public ShortBuffer call() {
                    try {
                        Tuple2f tuple2f = SimpleDicomVolumeLoaderImpl.this.loadRescaleInfo(dicomObject2);
                        Integer n2 = PixelDataExtractor.readPixelPaddingValue(dicomObject2);
                        PixelDataExtractor.RescaleParameters rescaleParameters = new PixelDataExtractor.RescaleParameters(tuple2f.x, tuple2f.y, n2);
                        ShortBuffer shortBuffer = SimpleDicomVolumeLoaderImpl.this.bufAlloc.bufferify(SimpleDicomVolumeLoaderImpl.extractPixelDataInternal(dicomObject2, rescaleParameters, sliceInfo));
                        return SimpleDicomVolumeLoaderImpl.this.processDataForSlice(IVType, sliceInfo, shortBuffer);
                    }
                    catch (Exception exception) {
                        ay.d((Object)exception, SimpleDicomVolumeLoaderImpl.this);
                        return SimpleDicomVolumeLoaderImpl.this.getFailureSlice(sliceInfo);
                    }
                }
            };
        }
        return new FuncUtils.j<ShortBuffer>(){

            @Override
            public ShortBuffer call() {
                return SimpleDicomVolumeLoaderImpl.this.getFailureSlice(sliceInfo);
            }
        };
    }

    private ShortBuffer getFailureSlice(SliceInfo sliceInfo) {
        ay.c((Object)("Error loading data for slice " + sliceInfo.sopInstanceUID + ", substituting a blank slice"), this);
        this.hasBadSlices = true;
        return ShortBuffer.wrap(new short[sliceInfo.width * sliceInfo.height]);
    }

    private ShortBuffer processDataForSlice(IVType IVType, SliceInfo sliceInfo, ShortBuffer shortBuffer) {
        this.rescaleSingleSlice(IVType, sliceInfo, shortBuffer);
        if (this.spacingHandlerMap.containsKey(IVType)) {
            shortBuffer = this.bufAlloc.bufferify(this.spacingHandlerMap.get(IVType).a(sliceInfo, this.bufAlloc.debufferify(shortBuffer)));
        }
        if (this.scaleDownFactor > 1) {
            shortBuffer = this.bufAlloc.bufferify(this.scaleImage(IVType, this.bufAlloc.debufferify(shortBuffer)));
        }
        return shortBuffer;
    }

    protected boolean handleGappedVolume(IVType IVType) {
        FuncUtils.f f2 = new FuncUtils.f();
        SliceShower sliceShower = new SliceShower((SimpleImageVolume<ImageCube.ImageCubeShort>)IVType, this.progress, f2);
        this.displayGappedVolumeDialog(sliceShower);
        f2.a();
        return this.progress.n() != Progress.Status.e;
    }

    protected void displayGappedVolumeDialog(SliceShower sliceShower) {
        sliceShower.a();
    }

    protected List<DerivedSliceInfo> buildUniformDerivedSlices(IVType IVType) {
        ArrayList arrayList = Lists.newArrayList();
        for (SliceInfo sliceInfo : ((SimpleImageVolume)IVType).ab()) {
            DerivedSliceInfo derivedSliceInfo = new DerivedSliceInfo();
            derivedSliceInfo.first = sliceInfo;
            arrayList.add(derivedSliceInfo);
        }
        return arrayList;
    }

    private Float simpleWobbleDetector(IVType IVType) {
        List<SliceInfo> list = ((SimpleImageVolume)IVType).ab();
        float f2 = ((SimpleImageVolume)IVType).aD();
        float f3 = ((SimpleImageVolume)IVType).aC();
        float f4 = ((SimpleImageVolume)IVType).aA();
        float f5 = f4 / (float)list.size();
        float f6 = Math.abs((f2 - f3) / f2);
        float f7 = Math.abs((f2 - f5) / f2);
        if (f6 < 0.03f && f7 < 0.015f) {
            return Float.valueOf(f2);
        }
        return null;
    }

    protected List<DerivedSliceInfo> handleNonUniform(IVType IVType, boolean bl2) {
        Object object;
        Object object2;
        float f2;
        log.d("Treating this Volume as Non-Uniform!!");
        List<SliceInfo> list = ((SimpleImageVolume)IVType).aa();
        float f3 = ((SimpleImageVolume)IVType).aB().get(0);
        float f4 = ((SimpleImageVolume)IVType).aC();
        float f5 = ((SimpleImageVolume)IVType).aA();
        Float f6 = this.simpleWobbleDetector(IVType);
        int n2 = 2;
        float f7 = f5 / (float)(n2 * list.size());
        float f8 = f4;
        if (f6 != null) {
            f8 = f6.floatValue();
        }
        if (f8 < f7) {
            log.a("MinThickness is waaaay to small, limiting non-uniform sampling");
            f8 = f7;
            if (f3 == f4) {
                f3 = f8;
            }
        }
        ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)((SimpleImageVolume)IVType).ad();
        ImageCube.ImageCubeShort imageCubeShort2 = ImageCube.ImageCubeShort.a(imageCubeShort.d(), 0);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        arrayList.add(Float.valueOf(f3 / 2.0f));
        Vector3f vector3f = new Vector3f(list.get((int)0).sliceDicomCenter);
        Vector3f vector3f2 = new Vector3f(SimpleOrientationHelper.a(((SimpleImageVolume)IVType).getUncopiedMutableInfo().imageOrientation, ((SimpleImageVolume)IVType).getUncopiedMutableInfo().H()));
        if (f3 == f8) {
            arrayList2.add(true);
        } else {
            arrayList2.add(false);
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            f2 = com.mimvista.internals.volumes.a.a(vector3f2, list.get((int)i2).sliceDicomCenter, vector3f);
            float f9 = com.mimvista.internals.volumes.a.a(vector3f2, list.get((int)(i2 - 1)).sliceDicomCenter, vector3f);
            arrayList.add(Float.valueOf(f3 / 2.0f + f2));
            if (f6 != null || f2 - f9 == f8) {
                arrayList2.add(true);
                continue;
            }
            arrayList2.add(false);
        }
        NonUniformHelper nonUniformHelper = new NonUniformHelper(list, arrayList, arrayList2);
        f2 = nonUniformHelper.determineOptimalStartingZOffset(f8);
        if (f6 != null) {
            f2 = f6.floatValue() / 2.0f;
        }
        imageCubeShort2.c();
        ArrayList arrayList3 = Lists.newArrayList();
        ArrayList<SliceInfo> arrayList4 = new ArrayList<SliceInfo>();
        for (float f10 = f2; f10 < f5; f10 += f8) {
            Serializable serializable;
            Serializable serializable2;
            object2 = nonUniformHelper.getDerivedSliceByDistanceFromTop(f10);
            arrayList3.add(object2);
            if (bl2) {
                serializable2 = ((ImageSlice.ImageSliceShort)imageCubeShort.f(list.indexOf(((DerivedSliceInfo)object2).first))).c();
                if (((DerivedSliceInfo)object2).second == null || ((DerivedSliceInfo)object2).firstPercent > NonUniformHelper.THRESH_PERCENT) {
                    imageCubeShort2.a(serializable2);
                } else {
                    serializable = (ImageSlice.ImageSliceShort)imageCubeShort.f(list.indexOf(((DerivedSliceInfo)object2).second));
                    imageCubeShort2.a(Interpolate.a((ImageSlice.ImageSliceShort)serializable2, serializable, ((DerivedSliceInfo)object2).secondPercent));
                }
            }
            serializable2 = this.getFakeSliceInfo();
            serializable = this.getClosestOriginalSliceInfoForZ(vector3f2, f10 - f3, list);
            serializable2.derivedFrom = (SliceInfo)serializable.x;
            object = (Vector3f)vector3f2.clone();
            object.scale(-((Float)serializable.y).floatValue());
            object.add((Tuple3f)new Point3f(serializable2.derivedFrom.sliceDicomCenter));
            serializable2.sliceDicomCenter = new float[]{((Vector3f)object).x, ((Vector3f)object).y, ((Vector3f)object).z};
            serializable2.sliceNumber = serializable2.derivedFrom.sliceNumber;
            serializable2.slicePosition = -1.0f;
            arrayList4.add((SliceInfo)serializable2);
        }
        ((SimpleImageVolume)IVType).b((List<SliceInfo>)new ArrayList<SliceInfo>(list));
        list.clear();
        list.addAll(arrayList4);
        int[] nArray = ((SimpleImageVolume)IVType).a();
        nArray[2] = arrayList3.size();
        imageCubeShort2.a(nArray);
        ((SimpleImageVolume)IVType).a((ImageCube.ImageCubeShort)imageCubeShort2);
        object2 = ((SimpleImageVolume)IVType).b();
        object2[2] = f8;
        ((SimpleImageVolume)IVType).a((float[])object2);
        float f11 = f8 * (float)arrayList4.size() - f8;
        float f12 = f11 / 2.0f;
        object = new Point3f((Tuple3f)vector3f);
        Vector3f vector3f3 = new Vector3f(vector3f2);
        vector3f3.scale(f12);
        object.sub((Tuple3f)vector3f3);
        ((SimpleImageVolume)IVType).b(((Point3f)((Object)object)).f());
        return arrayList3;
    }

    protected SliceInfo getFakeSliceInfo() {
        SliceInfo sliceInfo = new SliceInfo();
        sliceInfo.fileName = "";
        return sliceInfo;
    }

    protected Pair<SliceInfo, Float> getClosestOriginalSliceInfoForZ(Vector3f vector3f, float f2, List<SliceInfo> list) {
        Vector3f vector3f2 = new Vector3f(list.get((int)0).sliceDicomCenter);
        Vector3f vector3f3 = (Vector3f)vector3f.clone();
        vector3f3.scale(f2);
        vector3f2.sub((Tuple3f)vector3f3);
        float f3 = Float.POSITIVE_INFINITY;
        SliceInfo sliceInfo = list.get(0);
        float f4 = Float.POSITIVE_INFINITY;
        for (SliceInfo sliceInfo2 : list) {
            float f5 = com.mimvista.internals.volumes.a.a(vector3f, sliceInfo2.sliceDicomCenter, vector3f2);
            if (!(f5 < f3)) continue;
            f3 = f5;
            sliceInfo = sliceInfo2;
            f4 = com.mimvista.internals.volumes.a.b(vector3f, sliceInfo2.sliceDicomCenter, vector3f2);
        }
        return Pair.get(sliceInfo, Float.valueOf(f4));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean correctOrientationBasedOnSliceInfos(SeriesInfo seriesInfo, List<SliceInfo> list, x x2) {
        void var13_19;
        Object object2;
        Object object322;
        String string = seriesInfo.toString();
        if (list.size() < 2) {
            String string2 = "Not attempting orientation correction as series has < 2 slices.";
            log.a(string2);
            ay.e(string2);
            return false;
        }
        if (seriesInfo.gantryDetectorTilt != null) {
            String string3 = "Not attempting orientation correction as series has a gantry tilt of " + String.valueOf(seriesInfo.gantryDetectorTilt);
            log.a(string3);
            ay.e(string3);
            return false;
        }
        int n2 = -1;
        Object object4 = null;
        ArrayListMultimap<Vector2f, SliceInfo> arrayListMultimap = SimpleDicomVolumeLoaderImpl.binSlicesByPixelSpacing(new ArrayList<SliceInfo>(list));
        for (Object object322 : arrayListMultimap.keySet()) {
            object2 = arrayListMultimap.get(object322);
            if (object2.size() <= n2) continue;
            n2 = object2.size();
            object4 = object322;
        }
        List list2 = arrayListMultimap.get(object4);
        if (list2 == null || list2.size() < 2) {
            String string4 = "Not attempting orientation correction as there are no two slices with the same pixel spacing";
            log.b(string4);
            ay.e(string4);
            return false;
        }
        object322 = (SliceInfo)list2.get(0);
        float[] fArray = SimpleDicomVolumeLoaderImpl.getCorrectedOrientationBasedOnSliceInfos(seriesInfo, (SliceInfo)object322, (SliceInfo)(object2 = (SliceInfo)list2.get(list2.size() - 1)), x2);
        if (fArray == null) {
            return false;
        }
        for (SliceInfo object5 : list) {
            System.arraycopy(fArray, 0, object5.iop, 0, fArray.length);
        }
        System.arraycopy(fArray, 0, seriesInfo.imageOrientation, 0, fArray.length);
        PresentationType presentationType = seriesInfo.acqOrientation;
        seriesInfo.acqOrientation = SimpleOrientationHelper.c(seriesInfo.imageOrientation, seriesInfo.a(x2));
        String string2 = String.valueOf(seriesInfo.acqOrientation);
        if (seriesInfo.acqOrientation == null) {
            seriesInfo.acqOrientation = presentationType;
            String string3 = "null, so leaving as " + presentationType;
        }
        seriesInfo.f(false);
        String string5 = "Changing ImageOrientation to " + Arrays.toString(fArray) + " so AcquiredOrientation is " + (String)var13_19 + " for " + string;
        log.b(string5);
        ay.e(string5);
        return true;
    }

    private static ArrayListMultimap<Vector2f, SliceInfo> binSlicesByPixelSpacing(List<SliceInfo> list) {
        Collections.sort(list, new Comparator<SliceInfo>(){

            @Override
            public int compare(SliceInfo sliceInfo, SliceInfo sliceInfo2) {
                return Float.compare(sliceInfo2.slicePosition, sliceInfo.slicePosition);
            }
        });
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (SliceInfo sliceInfo : list) {
            Vector2f vector2f = null;
            if (sliceInfo.pixelSpacing != null && sliceInfo.pixelSpacing.length == 2 && !SimpleDicomVolumeLoaderImpl.hasNaN(sliceInfo.pixelSpacing)) {
                vector2f = new Vector2f(sliceInfo.pixelSpacing);
            }
            arrayListMultimap.put(vector2f, (Object)sliceInfo);
        }
        return arrayListMultimap;
    }

    private static float[] getCorrectedOrientationBasedOnSliceInfos(SeriesInfo seriesInfo, SliceInfo sliceInfo, SliceInfo sliceInfo2, x x2) {
        float[] fArray;
        Vector3f vector3f;
        double d2;
        double d3;
        String string = seriesInfo.toString();
        Vector3f vector3f2 = new Vector3f((float[])sliceInfo.ipp.clone());
        Vector3f vector3f3 = new Vector3f((float[])sliceInfo2.ipp.clone());
        String string2 = "Calculating orientation differences based on Slices: " + sliceInfo + " with ipp " + vector3f2 + " and " + sliceInfo2 + " with ipp " + vector3f3;
        log.a(string2);
        ay.e(string2);
        Vector3f vector3f4 = new Vector3f();
        vector3f4.sub((Tuple3f)vector3f3, (Tuple3f)vector3f2);
        vector3f4.normalize();
        Vector3f vector3f5 = new Vector3f(vector3f4);
        vector3f5.normalize();
        vector3f4.sub((Tuple3f)vector3f2, (Tuple3f)vector3f3);
        vector3f4.normalize();
        Vector3f vector3f6 = new Vector3f(vector3f4);
        vector3f6.normalize();
        if (SimpleDicomVolumeLoaderImpl.hasNaN(vector3f4) || SimpleDicomVolumeLoaderImpl.hasNaN(vector3f6)) {
            string2 = "According to the DICOM all the slices are in the same position. Cannot correct IOP for " + string;
            log.c(string2);
            ay.e(string2);
            return null;
        }
        float[] fArray2 = seriesInfo.imageOrientation;
        float[] fArray3 = SimpleOrientationHelper.a(fArray2, null);
        if (fArray3 == null) {
            string2 = "Unable to calculate UnitZ for ImageOrientation: " + Arrays.toString(fArray2) + ", for " + string;
            log.b(string2);
            ay.e(string2);
            return null;
        }
        Vector3f vector3f7 = new Vector3f(fArray3);
        vector3f7.normalize();
        if (SimpleDicomVolumeLoaderImpl.hasNaN(vector3f7)) {
            string2 = "Unable to calculate legitimate unitZ. Cannot correct IOP for " + string;
            log.c(string2);
            ay.e(string2);
            return null;
        }
        double d4 = Math.abs(Math.toDegrees(Math.acos(vector3f5.dot(vector3f7))));
        if (d4 < (d3 = Math.abs(Math.toDegrees(Math.acos(vector3f6.dot(vector3f7)))))) {
            d2 = d4;
            vector3f = vector3f5;
        } else {
            d2 = d3;
            vector3f = vector3f6;
        }
        if (Double.isNaN(d2) || d2 < 5.0) {
            string2 = "Angle difference between ActualZ:" + vector3f + " and UnitZ:" + vector3f7 + " is " + d2 + " degrees, so not correcting IOP for " + string;
            log.a(string2);
            ay.e(string2);
            return null;
        }
        string2 = "Series DICOM inconsistency. ImageOrientation states " + Arrays.toString(fArray3) + " but is actually " + vector3f + "; " + d2 + " degrees different, for " + string;
        log.b(string2);
        ay.e(string2);
        boolean bl2 = true;
        if (bl2) {
            Vector3f vector3f8;
            Vector3f vector3f9;
            boolean bl3 = Float.compare(fArray3[0], vector3f5.x) == 0;
            Vector3f vector3f10 = new Vector3f(fArray2[0], fArray2[1], fArray2[2]);
            Vector3f vector3f11 = new Vector3f(fArray2[3], fArray2[4], fArray2[5]);
            Vector3f vector3f12 = vector3f;
            if (bl3) {
                vector3f9 = new Vector3f(vector3f10);
                vector3f8 = new Vector3f();
                vector3f8.cross(vector3f12, vector3f9);
            } else {
                vector3f8 = new Vector3f(vector3f11);
                vector3f9 = new Vector3f();
                vector3f9.cross(vector3f8, vector3f12);
            }
            vector3f9.normalize();
            vector3f8.normalize();
            fArray = new float[]{vector3f9.x, vector3f9.y, vector3f9.z, vector3f8.x, vector3f8.y, vector3f8.z};
        } else {
            int n2 = 0;
            if (Float.compare(fArray3[0], vector3f5.x) != 0) {
                n2 = 3;
            }
            float[] fArray4 = new float[3];
            System.arraycopy(fArray2, n2, fArray4, 0, 3);
            Vector3f vector3f13 = new Vector3f(vector3f5);
            Vector3f vector3f14 = new Vector3f(fArray4);
            Vector3f vector3f15 = new Vector3f();
            Vector3f vector3f16 = new Vector3f();
            vector3f15.cross(vector3f14, vector3f13);
            vector3f15.normalize();
            vector3f16.cross(vector3f13, vector3f15);
            vector3f16.normalize();
            fArray = new float[]{vector3f16.x, vector3f16.y, vector3f16.z, vector3f15.x, vector3f15.y, vector3f15.z};
        }
        if (SimpleDicomVolumeLoaderImpl.hasNaN(fArray)) {
            string2 = "Unable to calculate legitimate unitZ. Cannot correct IOP for " + string;
            log.c(string2);
            ay.e(string2);
            return null;
        }
        return fArray;
    }

    private static boolean hasNaN(float[] fArray) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!Float.isNaN(fArray[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNaN(Vector3f vector3f) {
        return SimpleDicomVolumeLoaderImpl.hasNaN(new float[]{vector3f.x, vector3f.y, vector3f.z});
    }

    private static void tryFixCrazyPEMSlicePositions(List<SliceInfo> list) {
        float[] fArray = SimpleDicomVolumeLoaderImpl.getIppIfSameForAllSlices(list);
        if (fArray == null) {
            return;
        }
        String string = "(PEM Only) All slices have the same IPP: " + Arrays.toString(fArray) + " - setting the z-position to use slicePosition";
        log.b(string);
        ay.e(string);
        for (SliceInfo sliceInfo : list) {
            sliceInfo.ipp[2] = sliceInfo.slicePosition;
        }
    }

    private static float[] getIppIfSameForAllSlices(List<SliceInfo> list) {
        float[] fArray = null;
        for (SliceInfo sliceInfo : list) {
            if (fArray == null) {
                fArray = sliceInfo.ipp;
                continue;
            }
            if (Arrays.equals(fArray, sliceInfo.ipp)) continue;
            return null;
        }
        return fArray;
    }

    public static void main(String[] stringArray) {
        SimpleDicomVolumeLoaderImpl simpleDicomVolumeLoaderImpl = new SimpleDicomVolumeLoaderImpl();
        String string = "/Library/Application Support/MIM/DATA/ARCHIVE/0000-00__Studies/NEU-EPI^BRAIN_070221-1208.01_NM_0000-00-00_105909_(UMPATIENT.!).INTERICTAL_().int.aclp.rot_n40__147F6";
        simpleDicomVolumeLoaderImpl.setDataProvider(new LoaderDataProvider.FileBasedLoaderDataProvider(new File(string).listFiles()));
        long l2 = System.currentTimeMillis();
        simpleDicomVolumeLoaderImpl.load(new o());
        System.out.println("loading time(ms): " + (System.currentTimeMillis() - l2));
        System.out.print("SUCCESSFULLY LOADED: " + simpleDicomVolumeLoaderImpl.isSuccessfullyLoaded());
        System.exit(0);
    }

    private static class BadCompressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BadCompressionException(String string) {
            super(string);
        }
    }

    private static class SeriesIsNotImageTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SeriesIsNotImageTypeException() {
        }
    }

    private static class SeriesIsReallySingleFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SeriesIsReallySingleFileException() {
        }
    }

    private class SeriesMetaData {
        public List<SliceInfo> allSlices;
        public String seriesUID;
        public int numberOfSlices = -1;
        public int numberOfTimeSlots = -1;
        public LinkedHashSet<UIDContainer.SeriesUID> allSerUIDs = new LinkedHashSet();

        private SeriesMetaData() {
        }
    }
}

