/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.SimpleDicomVolumeLoaderImpl;
import com.mimvista.dicom.read.SliceInfoComparator;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.internals.x;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point3f;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.ck;
import com.mimvista.viewer.SeriesInfo;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.DicomObject;

public class SingleFileVolumeFiller {
    private int[] dims;
    private float[] voxel;
    private Vector3f unitZ;
    private float[] gridFrame;
    private boolean gridFrameAvailable;
    private boolean gridFrameReversed = false;
    private boolean gridFrameAbsolute = false;
    private boolean gridFrameIsCrackedOut = false;
    private Point3f firstSliceDcmCenter;
    private int[] sliceVector;
    private float spaceBtwnSlices;
    private x oPrefs;
    private boolean sortSlicesByUnitZ = false;

    public SingleFileVolumeFiller(DicomObject dicomObject, SliceInfo sliceInfo, SeriesInfo seriesInfo, int[] nArray, float[] fArray, x x2) {
        this.dims = nArray;
        this.voxel = fArray;
        this.oPrefs = x2;
        this.unitZ = new Vector3f(SimpleOrientationHelper.a(sliceInfo.iop, seriesInfo.a(x2)));
        this.spaceBtwnSlices = dicomObject.getFloat(0x180088, fArray[2]);
        if (this.spaceBtwnSlices == 0.0f) {
            this.spaceBtwnSlices = fArray[2];
        }
        float[] fArray2 = SimpleDicomVolumeLoaderImpl.computeSliceDicomCenter(nArray[0], nArray[1], sliceInfo.ipp, sliceInfo.iop, fArray[0], fArray[1]);
        this.firstSliceDcmCenter = new Point3f(fArray2);
        this.sliceVector = dicomObject.getInts(5505152, new int[0]);
        if (SimpleDicomVolumeLoaderImpl.needsTruncatedHawkeyeSpectHaxx(dicomObject)) {
            int n2 = dicomObject.getInt(0x280008, 0);
            this.sliceVector = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.sliceVector[i2] = i2 + 1;
            }
        }
        this.initGridFrame(dicomObject, sliceInfo);
        this.sortSlicesByUnitZ = DicomPrefs.nmSliceSort.getValue();
    }

    private void initGridFrame(DicomObject dicomObject, SliceInfo sliceInfo) {
        boolean bl2;
        this.gridFrame = dicomObject.getFloats(805568524, (float[])null);
        boolean bl3 = this.gridFrameAvailable = this.gridFrame != null && this.gridFrame.length >= this.dims[2];
        if (this.gridFrameAvailable) {
            if (this.gridFrame[0] != 0.0f) {
                if (MathUtils.a(this.gridFrame[0], sliceInfo.ipp[2], 0.01f) && MathUtils.a(Math.abs(this.unitZ.z), 1.0f, 0.001f)) {
                    this.gridFrameAbsolute = true;
                } else {
                    ay.c((Object)"Detected an invalid Grid Frame Offset Vector when loading non-orthogonal series - first offset is non-zero", this);
                    this.gridFrameIsCrackedOut = true;
                }
            }
            if (this.gridFrame.length > 1 && !this.gridFrameIsCrackedOut) {
                if (this.gridFrameAbsolute) {
                    this.gridFrameReversed = Math.signum(this.unitZ.z) != Math.signum(this.gridFrame[1] - this.gridFrame[0]);
                } else {
                    boolean bl4 = this.gridFrameReversed = this.gridFrame[1] < 0.0f;
                }
            }
        }
        if (bl2 = this.checkForAccurayReversedUnitZ(dicomObject, this.unitZ)) {
            System.out.println("applying flip");
            this.unitZ = new Vector3f(0.0f, 0.0f, 1.0f);
            this.gridFrameReversed = true;
        }
    }

    private boolean checkForAccurayReversedUnitZ(DicomObject dicomObject, Vector3f vector3f) {
        if (vector3f.epsilonEquals((Tuple3f)new Vector3f(0.0f, 0.0f, -1.0f), 0.001f)) {
            String string = dicomObject.getString(524400, "").toLowerCase();
            String string2 = dicomObject.getString(524384, "").toLowerCase();
            if (string.contains("nucletron")) {
                return true;
            }
            if ("rtdose".equals(string2) && string.contains("accuray") && !string.contains("mim software")) {
                String string3 = dicomObject.getString(1576992, "");
                String string4 = "(MultiPlan\\s+)(\\d)\\.(\\d)\\.(\\d)";
                Pattern pattern = Pattern.compile(string4);
                Matcher matcher = pattern.matcher(string3);
                if (matcher.find()) {
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    try {
                        n2 = Integer.parseInt(matcher.group(2));
                        n3 = Integer.parseInt(matcher.group(3));
                        n4 = Integer.parseInt(matcher.group(4));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return !(n2 == 4 && n3 == 5 && n4 > 0 || n2 == 4 && n3 > 5) && n2 <= 4;
                }
            }
        }
        return false;
    }

    public void readFrameIntoVolume(ShortBuffer shortBuffer, SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume, int n2) {
        Object object;
        simpleImageVolume.ad().c();
        simpleImageVolume.a(this.dims);
        simpleImageVolume.b(this.dims);
        simpleImageVolume.a(this.voxel);
        int n3 = n2 * this.dims[0] * this.dims[1] * this.dims[2];
        shortBuffer.position(n3);
        int n4 = this.dims[0] * this.dims[1];
        List<SliceInfo> list = simpleImageVolume.aa();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.dims[2]);
        for (int i2 = 0; i2 < this.dims[2]; ++i2) {
            object = new short[n4];
            int n5 = shortBuffer.remaining();
            if (n5 < ((short[])object).length) {
                ay.d((Object)"Not enough data to fill slice! Dims probably don't agree with data len.", this);
            }
            shortBuffer.get((short[])object);
            arrayList.add(object);
            SliceInfo sliceInfo = i2 > 0 ? new SliceInfo() : list.get(0);
            int n6 = n2 * this.dims[2] + i2;
            if (n6 < this.sliceVector.length) {
                sliceInfo.sliceNumber = this.sliceVector[n6];
            } else if (i2 < this.sliceVector.length) {
                sliceInfo.sliceNumber = this.sliceVector[i2];
            }
            if (this.gridFrameAvailable) {
                if (i2 > 0 && i2 < this.dims[2] - 1) {
                    float f2 = Math.abs(this.gridFrame[i2] - this.gridFrame[i2 - 1]);
                    float f3 = Math.abs(this.gridFrame[i2 + 1] - this.gridFrame[i2]);
                    sliceInfo.voxel = new Point3f(this.voxel[0], this.voxel[1], (f2 + f3) / 2.0f);
                } else {
                    sliceInfo.voxel = new Point3f(this.voxel[0], this.voxel[1], Float.NaN);
                }
            } else {
                sliceInfo.voxel = new Point3f(this.voxel);
            }
            Vector3f vector3f = new Vector3f();
            if (this.gridFrameAvailable) {
                if (this.gridFrameAbsolute) {
                    vector3f.set((Tuple3f)this.firstSliceDcmCenter);
                    vector3f.z = this.gridFrame[i2];
                } else if (this.gridFrameIsCrackedOut) {
                    vector3f.scaleAdd(Math.abs(this.gridFrame[i2] - this.gridFrame[0]), (Tuple3f)this.unitZ, (Tuple3f)this.firstSliceDcmCenter);
                } else {
                    vector3f.scaleAdd(this.gridFrame[i2], (Tuple3f)this.unitZ, (Tuple3f)this.firstSliceDcmCenter);
                }
            } else {
                vector3f.scaleAdd(this.spaceBtwnSlices * (float)i2, (Tuple3f)this.unitZ, (Tuple3f)this.firstSliceDcmCenter);
            }
            sliceInfo.sliceDicomCenter = new float[]{vector3f.x, vector3f.y, vector3f.z};
            if (i2 <= 0) continue;
            list.add(sliceInfo);
        }
        if (this.sortSlicesByUnitZ) {
            ay.b((Object)"Using single-file slice sort", this);
            ck.a(list, arrayList, new SliceInfoComparator(simpleImageVolume.getUncopiedMutableInfo(), this.oPrefs));
        } else if (this.spaceBtwnSlices >= 0.0f && !this.gridFrameReversed) {
            Collections.reverse(arrayList);
            Collections.reverse(list);
        }
        simpleImageVolume.ad().a(arrayList);
        SliceInfo sliceInfo = list.get(0);
        object = list.get(list.size() - 1);
        float[] fArray = new float[]{(sliceInfo.sliceDicomCenter[0] + object.sliceDicomCenter[0]) / 2.0f, (sliceInfo.sliceDicomCenter[1] + object.sliceDicomCenter[1]) / 2.0f, (sliceInfo.sliceDicomCenter[2] + object.sliceDicomCenter[2]) / 2.0f};
        simpleImageVolume.b(fArray);
    }

    public boolean isGridFrameSpacingAvailable() {
        return this.gridFrameAvailable;
    }
}

