/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.x;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MathUtils;
import com.mimvista.viewer.SeriesInfo;
import java.util.Comparator;
import javax.vecmath.Vector3f;

public class SliceInfoComparator
implements Comparator<SliceInfo> {
    private final double tol;
    private final int sliceAxis;
    private final Vector3f unitZ;
    private final boolean zInverted;
    private final PresentationType acqOrientation;

    SliceInfoComparator(SeriesInfo seriesInfo, x x2) {
        float[] fArray = seriesInfo.imageOrientation;
        this.acqOrientation = seriesInfo.acqOrientation;
        this.tol = Math.toRadians(15.0);
        this.unitZ = new Vector3f(SimpleOrientationHelper.a(fArray, seriesInfo.a(x2)));
        if (this.acqOrientation != null) {
            this.sliceAxis = this.acqOrientation.a()[2];
            switch (this.sliceAxis) {
                case 0: {
                    this.zInverted = this.unitZ.x < 0.0f;
                    break;
                }
                case 1: {
                    this.zInverted = this.unitZ.y < 0.0f;
                    break;
                }
                default: {
                    this.zInverted = this.unitZ.z < 0.0f;
                    break;
                }
            }
        } else {
            this.sliceAxis = 2;
            boolean bl2 = fArray[0] + fArray[3] >= 0.0f;
            boolean bl3 = fArray[1] + fArray[4] >= 0.0f;
            boolean bl4 = !(bl2 ^ bl3);
            this.zInverted = !bl4;
        }
    }

    @Override
    public int compare(SliceInfo sliceInfo, SliceInfo sliceInfo2) {
        float f2;
        float f3;
        if (this.acqOrientation != null) {
            if (sliceInfo.sliceDicomCenter[this.sliceAxis] != sliceInfo2.sliceDicomCenter[this.sliceAxis]) {
                if (!this.zInverted) {
                    return Float.compare(sliceInfo2.sliceDicomCenter[this.sliceAxis], sliceInfo.sliceDicomCenter[this.sliceAxis]);
                }
                return Float.compare(sliceInfo.sliceDicomCenter[this.sliceAxis], sliceInfo2.sliceDicomCenter[this.sliceAxis]);
            }
        } else if (!MathUtils.j(sliceInfo.sliceDicomCenter, sliceInfo2.sliceDicomCenter)) {
            f3 = this.unitZ.angle(new Vector3f(MathUtils.h(sliceInfo2.sliceDicomCenter, sliceInfo.sliceDicomCenter)));
            if ((double)f3 < this.tol) {
                return 1;
            }
            if (Math.PI - (double)f3 < this.tol) {
                return -1;
            }
        }
        if ((f3 = sliceInfo.slicePosition) == (f2 = sliceInfo2.slicePosition)) {
            f3 = sliceInfo.sliceNumber;
            f2 = sliceInfo2.sliceNumber;
            return Float.compare(f3, f2);
        }
        if (this.zInverted) {
            return Float.compare(f3, f2);
        }
        return Float.compare(f2, f3);
    }
}

