/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mimvista.dicom.read.DerivedSliceInfo;
import com.mimvista.dicom.read.ManglerBufferProvider;
import com.mimvista.dicom.read.NonUniformHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ag;
import com.mimvista.util.ay;
import com.mimvista.util.logging.a.c;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SliceOrientationMangler {
    public static c log = ay.b(SliceOrientationMangler.class);
    boolean rotate90 = false;
    boolean convertSagittal = false;
    boolean convertCoronal = false;
    boolean invertX;
    boolean invertY;
    boolean invertZ;
    private ManglerBufferProvider bufProvider;
    private final List<DerivedSliceInfo> derSlices;
    Multimap<SliceInfo, Integer> firstMap;
    Multimap<SliceInfo, Integer> secondMap;
    Map<SliceInfo, Integer> useCount;
    float[] xCoords = null;
    float[] yCoords = null;
    private int[] origDims;
    private final SliceProvider provider;
    private Map<String, ShortBuffer> cachedDataMap = Maps.newHashMap();

    public SliceOrientationMangler(ManglerBufferProvider manglerBufferProvider, List<DerivedSliceInfo> list, SliceProvider sliceProvider) {
        this.bufProvider = manglerBufferProvider;
        this.provider = sliceProvider;
        this.origDims = (int[])manglerBufferProvider.getDims().clone();
        this.derSlices = list;
        this.firstMap = HashMultimap.create();
        this.secondMap = HashMultimap.create();
        this.useCount = new HashMap<SliceInfo, Integer>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (((DerivedSliceInfo)object).first != null) {
                this.firstMap.put((Object)((DerivedSliceInfo)object).first, (Object)i2);
            }
            if (((DerivedSliceInfo)object).second == null) continue;
            this.secondMap.put((Object)((DerivedSliceInfo)object).second, (Object)i2);
        }
        for (Object object : this.firstMap.keySet()) {
            this.useCount.put((SliceInfo)object, this.firstMap.get(object).size());
        }
        for (Object object : this.secondMap.keySet()) {
            Integer n2 = this.useCount.get(object);
            if (n2 == null) {
                n2 = 0;
            }
            int n3 = this.secondMap.get(object).size();
            this.useCount.put((SliceInfo)object, n2 + n3);
        }
    }

    void setBufProvider(ManglerBufferProvider manglerBufferProvider) {
        this.bufProvider = manglerBufferProvider;
    }

    public ManglerBufferProvider getBufProvider() {
        return this.bufProvider;
    }

    public List<DerivedSliceInfo> getDerivedSlices() {
        ArrayList arrayList = Lists.newArrayList(this.derSlices);
        if (this.invertZ) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public void loadDerivedSlice(DerivedSliceInfo derivedSliceInfo) {
        if (!derivedSliceInfo.firstLoaded) {
            this.addSlice(derivedSliceInfo.first);
        }
        if (derivedSliceInfo.second != null && !derivedSliceInfo.secondLoaded) {
            this.addSlice(derivedSliceInfo.second);
        }
    }

    public ag getSetupReorienter() {
        return new ag(){

            @Override
            public void rotate90Degrees() {
                SliceOrientationMangler.this.rotate90 = true;
                int[] nArray = SliceOrientationMangler.this.bufProvider.getDims();
                SliceOrientationMangler.this.bufProvider.setDims(new int[]{nArray[1], nArray[0], nArray[2]});
            }

            @Override
            public void swapXaxis() {
                SliceOrientationMangler.this.invertX = true;
            }

            @Override
            public void swapYaxis() {
                SliceOrientationMangler.this.invertY = true;
            }

            @Override
            public void swapZaxis() {
                SliceOrientationMangler.this.invertZ = true;
            }

            @Override
            public void toAxialFromCoronal() {
                SliceOrientationMangler.this.convertCoronal = true;
                int[] nArray = SliceOrientationMangler.this.bufProvider.getDims();
                SliceOrientationMangler.this.bufProvider.setDims(new int[]{nArray[0], nArray[2], nArray[1]});
            }

            @Override
            public void toAxialFromSagittal() {
                SliceOrientationMangler.this.convertSagittal = true;
                int[] nArray = SliceOrientationMangler.this.bufProvider.getDims();
                SliceOrientationMangler.this.bufProvider.setDims(new int[]{nArray[2], nArray[0], nArray[1]});
            }
        };
    }

    public void buildSlices() {
        this.bufProvider.buildSlices();
    }

    public synchronized void addSlice(SliceInfo sliceInfo) {
        this.addSlice(sliceInfo, this.provider.getFinalDataForSlice(sliceInfo));
    }

    public synchronized void addSlice(SliceInfo sliceInfo, ShortBuffer shortBuffer) {
        if (sliceInfo == null) {
            return;
        }
        this.cachedDataMap.put(sliceInfo.fileName, shortBuffer);
        Collection collection = this.firstMap.get((Object)sliceInfo);
        Collection collection2 = this.secondMap.get((Object)sliceInfo);
        this.positionAndPossiblyInterpSliceIfRequiredDataIsLoaded(sliceInfo, collection, true);
        this.positionAndPossiblyInterpSliceIfRequiredDataIsLoaded(sliceInfo, collection2, false);
    }

    private void positionAndPossiblyInterpSliceIfRequiredDataIsLoaded(SliceInfo sliceInfo, Collection<Integer> collection, boolean bl2) {
        if (collection != null) {
            int n2 = 0;
            for (Integer n3 : collection) {
                DerivedSliceInfo derivedSliceInfo = this.derSlices.get(n3);
                SliceInfo sliceInfo2 = bl2 ? derivedSliceInfo.second : derivedSliceInfo.first;
                if (sliceInfo2 != null) {
                    boolean bl3 = bl2 ? derivedSliceInfo.secondLoaded : derivedSliceInfo.firstLoaded;
                    if (bl3) {
                        ShortBuffer shortBuffer;
                        if (derivedSliceInfo.firstPercent > NonUniformHelper.THRESH_PERCENT) {
                            shortBuffer = this.data(derivedSliceInfo.first);
                            log.d("Taking only first slice of nonuniform volume during interp");
                        } else if (derivedSliceInfo.secondPercent > NonUniformHelper.THRESH_PERCENT) {
                            shortBuffer = this.data(derivedSliceInfo.second);
                            log.d("Taking only second slice of nonuniform volume during interp");
                        } else {
                            shortBuffer = this.interpolateSlices(this.data(derivedSliceInfo.first), derivedSliceInfo.firstPercent, this.data(derivedSliceInfo.second), derivedSliceInfo.secondPercent);
                        }
                        this.positionSlice(shortBuffer, n3);
                        ++n2;
                        this.decDelete(sliceInfo2, 1);
                    }
                } else {
                    this.positionSlice(this.data(derivedSliceInfo.first), n3);
                    ++n2;
                }
                if (bl2) {
                    derivedSliceInfo.firstLoaded = true;
                    continue;
                }
                derivedSliceInfo.secondLoaded = true;
            }
            this.decDelete(sliceInfo, n2);
        }
    }

    private ShortBuffer data(SliceInfo sliceInfo) {
        return this.cachedDataMap.get(sliceInfo.fileName);
    }

    private void decDelete(SliceInfo sliceInfo, int n2) {
        if (n2 == 0) {
            return;
        }
        Integer n3 = this.useCount.get(sliceInfo);
        if (n3 == null) {
            this.cachedDataMap.remove(sliceInfo.fileName);
            return;
        }
        if (n3 - n2 == 0) {
            this.cachedDataMap.remove(sliceInfo.fileName);
            this.useCount.remove(sliceInfo);
        } else {
            this.useCount.put(sliceInfo, n3 - n2);
        }
    }

    private ShortBuffer interpolateSlices(ShortBuffer shortBuffer, float f2, ShortBuffer shortBuffer2, float f3) {
        ShortBuffer shortBuffer3 = ShortBuffer.allocate(shortBuffer.limit());
        if ((double)f2 > 0.999) {
            shortBuffer.rewind();
            shortBuffer3.put(shortBuffer);
            return shortBuffer3;
        }
        if ((double)f3 > 0.999) {
            shortBuffer2.rewind();
            shortBuffer3.put(shortBuffer2);
            return shortBuffer3;
        }
        for (int i2 = 0; i2 < shortBuffer3.limit(); ++i2) {
            shortBuffer3.put(i2, (short)((float)shortBuffer.get(i2) * f2 + (float)shortBuffer2.get(i2) * f3));
        }
        return shortBuffer3;
    }

    private int[] getOrigDims() {
        return this.origDims;
    }

    private void positionSlice(ShortBuffer shortBuffer, int n2) {
        if (this.convertSagittal) {
            if (this.rotate90) {
                this.sagittalColumnsToAxialColumns(shortBuffer, n2);
            } else {
                this.sagittalRowsToAxialColumns(shortBuffer, n2);
            }
        } else if (this.convertCoronal) {
            if (this.rotate90) {
                this.coronalColumnsToAxialRows(shortBuffer, n2);
            } else {
                this.coronalRowsToAxialRows(shortBuffer, n2);
            }
        } else {
            this.writeAxialSlice(shortBuffer, n2);
        }
    }

    private void sagittalColumnsToAxialColumns(ShortBuffer shortBuffer, int n2) {
        int[] nArray = this.getOrigDims();
        int n3 = nArray[2];
        int n4 = nArray[1];
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            int n5;
            ShortBuffer shortBuffer2 = this.bufProvider.getBufferForSlice(this.invertZ ? i2 : nArray[0] - 1 - i2);
            int n6 = this.invertX ? n3 - 1 - n2 : n2;
            int n7 = i2;
            if (this.invertY) {
                for (n5 = 0; n5 < n4; ++n5) {
                    shortBuffer2.put((n4 - 1 - n5) * n3 + n6, shortBuffer.get(n5 * nArray[0] + n7));
                }
                continue;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                shortBuffer2.put(n5 * n3 + n6, shortBuffer.get(n5 * nArray[0] + n7));
            }
        }
    }

    private void coronalColumnsToAxialRows(ShortBuffer shortBuffer, int n2) {
        int[] nArray = this.getOrigDims();
        int n3 = nArray[1];
        int n4 = nArray[2];
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            int n5;
            ShortBuffer shortBuffer2 = this.bufProvider.getBufferForSlice(!this.invertZ ? nArray[0] - 1 - i2 : i2);
            int n6 = !this.invertY ? (n4 - 1 - n2) * n3 : n2 * n3;
            int n7 = i2;
            if (this.invertX) {
                for (n5 = 0; n5 < n3; ++n5) {
                    shortBuffer2.put(n6 + (n3 - 1 - n5), shortBuffer.get(n7 + n5 * nArray[0]));
                }
                continue;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                shortBuffer2.put(n6 + n5, shortBuffer.get(n7 + n5 * nArray[0]));
            }
        }
    }

    private void sagittalRowsToAxialColumns(ShortBuffer shortBuffer, int n2) {
        int[] nArray = this.getOrigDims();
        int n3 = nArray[2];
        int n4 = nArray[0];
        for (int i2 = 0; i2 < nArray[1]; ++i2) {
            int n5;
            ShortBuffer shortBuffer2 = this.bufProvider.getBufferForSlice(this.invertZ ? nArray[1] - 1 - i2 : i2);
            int n6 = this.invertX ? n3 - 1 - n2 : n2;
            int n7 = i2 * n4;
            if (this.invertY) {
                for (n5 = 0; n5 < n4; ++n5) {
                    shortBuffer2.put((n4 - 1 - n5) * n3 + n6, shortBuffer.get(n7 + n5));
                }
                continue;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                shortBuffer2.put(n5 * n3 + n6, shortBuffer.get(n7 + n5));
            }
        }
    }

    private void coronalRowsToAxialRows(ShortBuffer shortBuffer, int n2) {
        int[] nArray = this.getOrigDims();
        int n3 = nArray[0];
        int n4 = nArray[2];
        for (int i2 = 0; i2 < nArray[1]; ++i2) {
            ShortBuffer shortBuffer2 = this.bufProvider.getBufferForSlice(this.invertZ ? nArray[1] - 1 - i2 : i2);
            int n5 = !this.invertY ? (n4 - 1 - n2) * n3 : n2 * n3;
            int n6 = i2 * n3;
            if (this.invertX) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    shortBuffer2.put(n5 + (n3 - 1 - i3), shortBuffer.get(n6 + i3));
                }
                continue;
            }
            shortBuffer2.position(n5);
            shortBuffer.position(n6);
            ShortBuffer shortBuffer3 = shortBuffer.slice();
            shortBuffer.rewind();
            shortBuffer3.limit(n3);
            shortBuffer2.put(shortBuffer3);
            shortBuffer2.rewind();
        }
    }

    private void writeAxialSlice(ShortBuffer shortBuffer, int n2) {
        int n3 = this.invertZ ? this.bufProvider.getDims()[2] - 1 - n2 : n2;
        int n4 = this.bufProvider.getDims()[0];
        int n5 = this.bufProvider.getDims()[1];
        if (this.rotate90) {
            ShortBuffer shortBuffer2 = this.bufProvider.getBufferForSlice(n3);
            int n6 = this.invertY ? (n5 - 1) * n4 : 0;
            int n7 = this.invertY ? -n4 : n4;
            int n8 = this.invertX ? n4 - 1 : 0;
            int n9 = this.invertX ? -1 : 1;
            int n10 = 0;
            int n11 = n6;
            int n12 = n5 - 1;
            while (n10 < n5) {
                int n13 = 0;
                int n14 = n12;
                int n15 = n11 + n8;
                while (n13 < n4) {
                    shortBuffer2.put(n15, shortBuffer.get(n14));
                    ++n13;
                    n14 += n5;
                    n15 += n9;
                }
                ++n10;
                n11 += n7;
                --n12;
            }
        } else if (this.invertX) {
            ShortBuffer shortBuffer3 = this.bufProvider.getBufferForSlice(n3);
            int n16 = (n5 - 1) * n4;
            int n17 = -n4;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n18 = this.invertY ? n16 - n17 : (n17 += n4);
                for (int i3 = 0; i3 < n4; ++i3) {
                    shortBuffer3.put(i3 + n18, shortBuffer.get(n17 + n4 - 1 - i3));
                }
            }
        } else if (this.invertY) {
            ShortBuffer shortBuffer4 = this.bufProvider.getBufferForSlice(n3);
            for (int i4 = 0; i4 < n5; ++i4) {
                int n19 = i4 * n4;
                int n20 = (n5 - 1 - i4) * n4;
                shortBuffer4.position(n20);
                shortBuffer.position(n19);
                ShortBuffer shortBuffer5 = shortBuffer.slice();
                shortBuffer.rewind();
                shortBuffer5.limit(n4);
                shortBuffer4.put(shortBuffer5);
                shortBuffer4.rewind();
            }
        } else {
            this.bufProvider.replaceSlice(n3, shortBuffer);
        }
        this.provider.markSliceLoaded(n3);
    }

    public static interface SliceProvider {
        public ShortBuffer getFinalDataForSlice(SliceInfo var1);

        public void markSliceLoaded(int var1);
    }
}

