/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.util.MIMContext;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.VM;

public class SmartBufferAllocator {
    private static final boolean DEBUG = false;
    private static final double DIRECTBUFFER_LOAD_FACTOR = 0.8;
    long maxDirectBufSizeAllowed = (long)((double)VM.maxDirectMemory() * 0.8);
    boolean useDirectBuffers;
    volatile long directBufferSizeUsed = 0L;

    public SmartBufferAllocator() {
        if (Runtime.getRuntime().maxMemory() > 0x20000000L) {
            this.useDirectBuffers = false;
            return;
        }
        if (MIMContext.h() || MIMContext.j()) {
            this.useDirectBuffers = false;
        }
    }

    public short[] debufferify(ShortBuffer shortBuffer) {
        if (shortBuffer.hasArray()) {
            return shortBuffer.array();
        }
        short[] sArray = new short[shortBuffer.limit()];
        shortBuffer.rewind();
        shortBuffer.get(sArray);
        shortBuffer.rewind();
        return sArray;
    }

    public ShortBuffer bufferify(short[] sArray) {
        int n2 = sArray.length * 2;
        if (this.useDirectBuffers && this.directBufferSizeUsed + (long)n2 < this.maxDirectBufSizeAllowed) {
            try {
                ByteBuffer byteBuffer = this.allocBuf(n2);
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                shortBuffer.put(sArray);
                shortBuffer.rewind();
                return shortBuffer;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return ShortBuffer.wrap(sArray);
    }

    ByteBuffer allocBuf(final int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        this.directBufferSizeUsed += (long)n2;
        Cleaner.create((Object)byteBuffer, (Runnable)new Runnable(){

            @Override
            public void run() {
                SmartBufferAllocator.this.directBufferSizeUsed -= (long)n2;
            }
        });
        return byteBuffer;
    }

    public ByteBuffer directBufferify(byte[] byArray) {
        if (this.directBufferSizeUsed + (long)byArray.length < this.maxDirectBufSizeAllowed) {
            try {
                ByteBuffer byteBuffer = this.allocBuf(byArray.length);
                byteBuffer.put(byArray);
                byteBuffer.rewind();
                return byteBuffer;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return ByteBuffer.wrap(byArray);
    }

    public IntBuffer allocateIntBuf(int n2) {
        int n3 = n2 * 4;
        return IntBuffer.allocate(n2);
    }

    public IntBuffer bufferify(int[] nArray) {
        int n2 = nArray.length * 4;
        return IntBuffer.wrap(nArray);
    }

    public byte[] debufferify(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return byteBuffer.array();
        }
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        byteBuffer.rewind();
        return byArray;
    }
}

