/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.intensitybasedwarp.qa.DeformationRating;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.fusionmode.FusionMode;
import com.mimvista.internals.fusionmode.FusionModeChecker;
import com.mimvista.internals.fusionmode.FusionModeType;
import com.mimvista.internals.linking.IdentityTransform;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.mui.ColorTable;
import com.mimvista.mui.overlays.DeformableSpyglassOverlay;
import com.mimvista.mui.overlays.FusionAlignOverlay;
import com.mimvista.mui.overlays.OverlayColor;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.ad;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.alignment.AlignedFusionImageFactory;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.ColorTableFactory;
import java.awt.Image;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class SpyglassOverlayLoadingHelper {
    public static void loadFusionAlignOverlaysFromStructureSetSequence(DicomObject dicomObject, ViewController viewController, ViewController viewController2) {
        try {
            if (dicomObject.contains(805699616)) {
                DicomElement dicomElement = dicomObject.get(805699616);
                for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                    try {
                        DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                        SpyglassOverlayLoadingHelper.readFusionAlignOverlay(dicomObject2, viewController, viewController2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error reading Fusion Align overlay", throwable, SpyglassOverlayLoadingHelper.class);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error loading Fusion Align overlays", throwable, SpyglassOverlayLoadingHelper.class);
        }
    }

    public static void loadQaOverlaysFromStructureSetSequence(DicomObject dicomObject, WarpTransform warpTransform) {
        try {
            if (dicomObject.contains(805699616)) {
                DicomElement dicomElement = dicomObject.get(805699616);
                for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                    try {
                        DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                        SpyglassOverlayLoadingHelper.readQAOverlay(dicomObject2, warpTransform);
                        continue;
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error reading QA overlay", throwable, SpyglassOverlayLoadingHelper.class);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error loading QA overlays", throwable, SpyglassOverlayLoadingHelper.class);
        }
    }

    private static void readQAOverlay(DicomObject dicomObject, WarpTransform warpTransform) {
        ViewController viewController = warpTransform.b().j();
        ad ad2 = new ad(viewController);
        SpyglassOverlayLoadingHelper.readAbstractSpyglassFields(dicomObject, ad2);
        if (ad2.e == null) {
            return;
        }
        DeformationRating deformationRating = SpyglassOverlayLoadingHelper.readRating(dicomObject);
        ad2.c = SpyglassOverlayLoadingHelper.readAlignedFusionImageParams(dicomObject, (MetricPoint3f)((Object)ad2.e.x), warpTransform);
        DeformableSpyglassOverlay deformableSpyglassOverlay = ad2.a(warpTransform, deformationRating);
        OverlayColor overlayColor = warpTransform.b().n().r().a(ad2.f);
        deformableSpyglassOverlay.a(overlayColor);
        warpTransform.b().n().a((Overlayish)deformableSpyglassOverlay, true);
    }

    private static AlignedFusionImageFactory.AlignedFusionImageParams readAlignedFusionImageParams(DicomObject dicomObject, MetricPoint3f metricPoint3f, WarpTransform warpTransform) {
        Matrix4f matrix4f = SpyglassOverlayLoadingHelper.readLocalAlignment(dicomObject, metricPoint3f, warpTransform);
        ViewController viewController = warpTransform.b().j();
        ViewController viewController2 = warpTransform.a().j();
        AlignedFusionImageFactory.LocallyAlignedFusionState locallyAlignedFusionState = new AlignedFusionImageFactory.LocallyAlignedFusionState(DynamicVolumeRef.a(viewController), DynamicVolumeRef.a(viewController2), matrix4f, metricPoint3f);
        AlignedFusionImageFactory.AlignedFusionImageParams alignedFusionImageParams = SpyglassOverlayLoadingHelper.readAlignedFusionImageParams(dicomObject, locallyAlignedFusionState);
        return alignedFusionImageParams;
    }

    private static AlignedFusionImageFactory.AlignedFusionImageParams readAlignedFusionImageParams(DicomObject dicomObject, AlignedFusionImageFactory.LocallyAlignedFusionState locallyAlignedFusionState) {
        AlignedFusionImageFactory.AlignedFusionImageParams alignedFusionImageParams = new AlignedFusionImageFactory.AlignedFusionImageParams();
        alignedFusionImageParams.state = locallyAlignedFusionState;
        alignedFusionImageParams.blend = (float)dicomObject.getDouble(2626566);
        alignedFusionImageParams.mode = SpyglassOverlayLoadingHelper.readFusionMode(dicomObject);
        alignedFusionImageParams.secTable = SpyglassOverlayLoadingHelper.readColorTable(dicomObject, 928055556);
        alignedFusionImageParams.fusTable = SpyglassOverlayLoadingHelper.readColorTable(dicomObject, 928055557);
        return alignedFusionImageParams;
    }

    private static Matrix4f readLocalAlignment(DicomObject dicomObject, MetricPoint3f metricPoint3f, WarpTransform warpTransform) {
        Matrix4f matrix4f = SpyglassOverlayLoadingHelper.readAlignmentFromDicom(dicomObject, metricPoint3f);
        if (matrix4f != null) {
            return matrix4f;
        }
        ay.d((Object)"Could not read local alignment from QA. Recomputing ..", SpyglassOverlayLoadingHelper.class);
        return AlignedFusionImageFactory.a(metricPoint3f, warpTransform, new IdentityTransform(warpTransform.b(), warpTransform.b()));
    }

    private static ColorTable readColorTable(DicomObject dicomObject, int n2) {
        ColorTable colorTable;
        DicomObject dicomObject2;
        String string;
        if (dicomObject.contains(n2) && !cn.h(string = (dicomObject2 = dicomObject.get(n2).getDicomObject()).getString(7340161)) && (colorTable = ColorTableFactory.a(string)) != null) {
            return colorTable;
        }
        return ColorTableFactory.b("Anatomic", "B-W Linear");
    }

    private static FusionMode<Image> readFusionMode(DicomObject dicomObject) {
        String string;
        String string2 = dicomObject.getString(928055553, FusionModeType.a.name());
        FusionModeType fusionModeType = FusionModeType.a;
        try {
            fusionModeType = FusionModeType.valueOf(string2.trim());
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error reading fusion mode for overlay", throwable, SpyglassOverlayLoadingHelper.class);
        }
        FusionMode fusionMode = FusionMode.a(fusionModeType);
        if (fusionModeType == FusionModeType.b && !cn.h(string = dicomObject.getString(928055554, (String)null))) {
            float f2 = -1.0f;
            try {
                f2 = Float.parseFloat(string);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error reading checker size", throwable, SpyglassOverlayLoadingHelper.class);
            }
            if (f2 > 0.0f) {
                ((FusionModeChecker)fusionMode).a(f2);
            }
        }
        return fusionMode;
    }

    private static Matrix4f readAlignmentFromDicom(DicomObject dicomObject, MetricPoint3f metricPoint3f) {
        float[] fArray;
        if (dicomObject.contains(805699782) && (fArray = dicomObject.getFloats(805699782, (float[])null)) != null && fArray.length == 16) {
            return new Matrix4f(fArray);
        }
        return null;
    }

    private static Pair<MetricPoint3f, MetricPoint3f> readCenterAndSizePoints(DicomObject dicomObject, ImageFrame imageFrame) {
        int n2 = dicomObject.getInt(805699654);
        if (n2 == 2) {
            float[] fArray = dicomObject.getFloats(805699664);
            if (fArray != null && fArray.length == 6) {
                DicomPoint3f dicomPoint3f = new DicomPoint3f(fArray[0], fArray[1], fArray[2], imageFrame);
                DicomPoint3f dicomPoint3f2 = new DicomPoint3f(fArray[3], fArray[4], fArray[5], imageFrame);
                return Pair.get(dicomPoint3f.c(), dicomPoint3f2.c());
            }
            ay.d((Object)"Malformed contour data for one of the QA overlays", SpyglassOverlayLoadingHelper.class);
        }
        return null;
    }

    private static AlignedFusionImageFactory.AlignedFusionImageParams readFusAlignTransform(DicomObject dicomObject, MetricPoint3f metricPoint3f, ViewController viewController, ViewController viewController2) {
        Matrix4f matrix4f = SpyglassOverlayLoadingHelper.readAlignmentFromDicom(dicomObject, metricPoint3f);
        AlignedFusionImageFactory.LocallyAlignedFusionState locallyAlignedFusionState = new AlignedFusionImageFactory.LocallyAlignedFusionState(DynamicVolumeRef.a(viewController), DynamicVolumeRef.a(viewController2), matrix4f, metricPoint3f);
        AlignedFusionImageFactory.AlignedFusionImageParams alignedFusionImageParams = SpyglassOverlayLoadingHelper.readAlignedFusionImageParams(dicomObject, locallyAlignedFusionState);
        return alignedFusionImageParams;
    }

    private static void readAbstractSpyglassFields(DicomObject dicomObject, ad ad2) {
        ad2.g = dicomObject.getString(805699622, "");
        ad2.h = dicomObject.getString(805699624, "");
        ad2.f = RawDicomUtils.readRoiDisplayColor(dicomObject);
        ad2.e = SpyglassOverlayLoadingHelper.readCenterAndSizePoints(dicomObject, ad2.a.aw());
        ad2.d = (MetricPoint3f)((Object)ad2.e.x);
    }

    private static void readFusionAlignOverlay(DicomObject dicomObject, ViewController viewController, ViewController viewController2) {
        ad ad2 = new ad(viewController);
        SpyglassOverlayLoadingHelper.readAbstractSpyglassFields(dicomObject, ad2);
        if (ad2.e == null) {
            return;
        }
        ad2.c = SpyglassOverlayLoadingHelper.readFusAlignTransform(dicomObject, (MetricPoint3f)((Object)ad2.e.x), viewController, viewController2);
        FusionAlignOverlay fusionAlignOverlay = ad2.a(viewController, viewController2);
        viewController.ba().a((Overlayish)fusionAlignOverlay, true);
    }

    private static DeformationRating readRating(DicomObject dicomObject) {
        try {
            String string = dicomObject.getString(806223874, DeformationRating.b.name());
            return DeformationRating.valueOf(string);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error reading approval status", throwable, SpyglassOverlayLoadingHelper.class);
            return DeformationRating.b;
        }
    }
}

