/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import com.mimvista.viewer.algo.SuvCalculator;
import java.util.List;

public abstract class SuvCorrector {
    protected SuvCorrectionListener correctionListener;

    public void setCorrectionListener(SuvCorrectionListener suvCorrectionListener) {
        this.correctionListener = suvCorrectionListener;
    }

    public abstract SuvCalculator.CalculationType getPreferredCalcType();

    public abstract SuvCalculator.CalculationType getCurrentCalculation();

    public abstract void setPreferredCalcType(SuvCalculator.CalculationType var1);

    public abstract List<String> testForPossibleOutOfRangeFields(SuvCalculator.CalculationType var1, SeriesInfo var2);

    public abstract void showPossibleOutOfRangeMessage(SeriesInfo var1, SuvCalculator.CalculationType var2, List<String> var3);

    public abstract void showErrorComputingSuvMessage(SeriesInfo var1, SuvCalculator.CalculationType var2);

    public abstract void showOutOfRangeAndErrorComputingMessage(SeriesInfo var1, SuvCalculator.CalculationType var2, List<String> var3);

    public abstract boolean shouldPromptIfSuvCalcFails();

    public boolean runSuvCorrection(SeriesInfo.a a2) {
        SeriesInfo seriesInfo = a2.getUncopiedMutableInfo();
        boolean bl2 = this.shouldPromptIfSuvCalcFails() && seriesInfo.af() != null;
        UnitHelper.AppliedImageUnit appliedImageUnit = seriesInfo.u().m();
        SuvCalculator.CalculationType calculationType = this.getPreferredCalcType();
        boolean bl3 = SuvCalculator.tryCalcSuv(seriesInfo, calculationType);
        if (bl2 && DataUnitUtils.BQML_CANON_.matchesUnit(seriesInfo.af())) {
            List<String> list = this.testForPossibleOutOfRangeFields(calculationType, seriesInfo);
            if (list.size() > 0 && bl3) {
                SuvCalculator.doBQML(seriesInfo);
                seriesInfo.u().b(appliedImageUnit);
                this.showPossibleOutOfRangeMessage(seriesInfo, calculationType, list);
                bl3 = false;
            } else if (list.size() > 0 && !bl3) {
                this.showOutOfRangeAndErrorComputingMessage(seriesInfo, calculationType, list);
                bl3 = false;
            } else if (list.size() == 0 && !bl3) {
                this.showErrorComputingSuvMessage(seriesInfo, calculationType);
                bl3 = false;
            }
        } else if (bl3 && !bl2) {
            this.fixDynamicInfos(seriesInfo, calculationType);
        }
        return bl3;
    }

    protected void fixDynamicInfos(SeriesInfo seriesInfo, SuvCalculator.CalculationType calculationType) {
    }

    public static abstract class SuvCorrectionListener {
        public void appliedCorrection() {
        }
    }
}

