/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.dicom.read.BackgroundVolumeLoaderDelegate;
import com.mimvista.dicom.read.SimpleDicomVolumeLoaderImpl;
import com.mimvista.dicom.read.SliceOrientationMangler;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.d;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import javax.vecmath.Point3i;

public class VolumeDataFiller<IVType extends SimpleImageVolume<ImageCube.ImageCubeShort>>
implements Comparable<VolumeDataFiller<SimpleImageVolume<ImageCube.ImageCubeShort>>> {
    private final int MAX_PREFETCH_BUFFER = 10;
    protected final SimpleDicomVolumeLoaderImpl<IVType> loader;
    private final Progress progress;
    protected BackgroundVolumeLoaderDelegate backgroundDel;
    protected Map<String, Pair<Set<IVType>, SliceInfo>> nameSliceMap;
    private int sliceNumForProgress;
    private static Object preemptor = null;
    long lastNotifyTime = 0L;
    private static List<WeakReference<VolumeDataFiller<? extends SimpleImageVolume<ImageCube.ImageCubeShort>>>> activeFillers = Lists.newArrayList();

    public VolumeDataFiller(SimpleDicomVolumeLoaderImpl<IVType> simpleDicomVolumeLoaderImpl, Progress progress) {
        this.loader = simpleDicomVolumeLoaderImpl;
        this.progress = progress;
        this.backgroundDel = this.loader.backgroundDel;
        this.nameSliceMap = this.loader.getFilenameSliceMap();
        this.sliceNumForProgress = 1;
    }

    public void makeMeACheckerBoard() {
        for (SimpleImageVolume simpleImageVolume : this.loader.dSeries.l()) {
            d.a(simpleImageVolume);
            for (SliceInfo sliceInfo : simpleImageVolume.ab()) {
                sliceInfo.sliceIsLoaded = false;
            }
        }
    }

    public static synchronized void preemptEverybody(Object object) {
        while (preemptor != null) {
            try {
                VolumeDataFiller.class.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        preemptor = object;
        VolumeDataFiller.class.notifyAll();
    }

    public static synchronized void stopPreempting(Object object) {
        VolumeDataFiller.class.notifyAll();
        if (preemptor != object) {
            throw new IllegalStateException("Trying to stop pre-empting with wrong object.");
        }
        preemptor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fill() {
        Object object;
        WeakReference<VolumeDataFiller> weakReference = new WeakReference<VolumeDataFiller>(this);
        try {
            object = VolumeDataFiller.class;
            synchronized (VolumeDataFiller.class) {
                activeFillers.add(weakReference);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.loadClosestSlices();
                this.backgroundDel.loadingFinished();
            }
        }
        catch (CancelledException cancelledException) {
            ay.e("Streamloaded in " + String.format("%.2fs", (double)(System.currentTimeMillis() - this.loader.loadingStartTime) / 1000.0));
            Class<VolumeDataFiller> clazz = VolumeDataFiller.class;
            synchronized (VolumeDataFiller.class) {
                activeFillers.remove(weakReference);
                VolumeDataFiller.class.notifyAll();
                // ** MonitorExit[var2_4] (shouldn't be in output)
                for (SimpleImageVolume simpleImageVolume : this.loader.dSeries.l()) {
                    simpleImageVolume.g(true);
                    for (SliceInfo sliceInfo : simpleImageVolume.ab()) {
                        sliceInfo.sliceIsLoaded = true;
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                ay.e("Streamloaded in " + String.format("%.2fs", (double)(System.currentTimeMillis() - this.loader.loadingStartTime) / 1000.0));
                Object object2 = VolumeDataFiller.class;
                synchronized (VolumeDataFiller.class) {
                    activeFillers.remove(weakReference);
                    VolumeDataFiller.class.notifyAll();
                    // ** MonitorExit[var8_12] (shouldn't be in output)
                    object2 = this.loader.dSeries.l().iterator();
                    block14: while (true) {
                        if (!object2.hasNext()) {
                            throw throwable;
                        }
                        SimpleImageVolume simpleImageVolume = (SimpleImageVolume)object2.next();
                        simpleImageVolume.g(true);
                        Iterator<SliceInfo> iterator = simpleImageVolume.ab().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block14;
                            SliceInfo sliceInfo = iterator.next();
                            sliceInfo.sliceIsLoaded = true;
                        }
                        break;
                    }
                }
            }
        }
        {
            ay.e("Streamloaded in " + String.format("%.2fs", (double)(System.currentTimeMillis() - this.loader.loadingStartTime) / 1000.0));
            object = VolumeDataFiller.class;
            synchronized (VolumeDataFiller.class) {
                activeFillers.remove(weakReference);
                VolumeDataFiller.class.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (SimpleImageVolume simpleImageVolume : this.loader.dSeries.l()) {
                    simpleImageVolume.g(true);
                    for (SliceInfo sliceInfo : simpleImageVolume.ab()) {
                        sliceInfo.sliceIsLoaded = true;
                    }
                }
                return;
            }
        }
    }

    private void loadClosestSlices() throws CancelledException {
        int n2 = this.getCurrentSliceIdx();
        SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume = this.getActiveVol();
        ArrayList arrayList = this.getClosestFilenames(n2);
        LinkedBlockingQueue<String> linkedBlockingQueue = new LinkedBlockingQueue<String>();
        block0: while (!this.nameSliceMap.isEmpty()) {
            String string3;
            for (String string2 : this.loader.dataProvider.getAlreadyAvailableFiles()) {
                arrayList.remove(string2);
                this.addSlice(string2);
            }
            if (this.loader.dataProvider.supportsPrefetchRequests()) {
                int n3 = 10;
                if (this.nameSliceMap.size() < n3) {
                    n3 = this.nameSliceMap.size();
                }
                for (String string3 : arrayList) {
                    if (linkedBlockingQueue.size() >= n3) break;
                    if (linkedBlockingQueue.contains(string3)) continue;
                    this.loader.dataProvider.fetchNext(string3);
                    linkedBlockingQueue.add(string3);
                }
            }
            if (this.nameSliceMap.isEmpty()) break;
            int n4 = this.getCurrentSliceIdx();
            SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume22 = this.getActiveVol();
            if (n4 != n2 || simpleImageVolume != simpleImageVolume22) {
                n2 = n4;
                simpleImageVolume = simpleImageVolume22;
                arrayList = Lists.newArrayList(this.getClosestFilenames(n2));
            }
            string3 = arrayList.get(0);
            List<String> list = this.loader.dataProvider.getBlockingFilesFor(string3);
            for (String string4 : list) {
                if (!this.nameSliceMap.containsKey(string4)) continue;
                arrayList.remove(string4);
                this.addSlice(string4);
                continue block0;
            }
            if (linkedBlockingQueue.size() > 0) {
                string3 = (String)linkedBlockingQueue.remove();
            }
            arrayList.remove(string3);
            this.addSlice(string3);
        }
    }

    private int getSliceDistance(int n2, SliceInfo sliceInfo, IVType IVType) {
        SliceOrientationMangler sliceOrientationMangler = this.loader.manglerMap.get(IVType);
        TreeSet treeSet = Sets.newTreeSet();
        if (sliceOrientationMangler.firstMap.containsKey((Object)sliceInfo)) {
            treeSet.addAll(sliceOrientationMangler.firstMap.get((Object)sliceInfo));
        }
        if (sliceOrientationMangler.secondMap.containsKey((Object)sliceInfo)) {
            treeSet.addAll(sliceOrientationMangler.secondMap.get((Object)sliceInfo));
        }
        if (treeSet.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        if (treeSet.contains(n2)) {
            return 0;
        }
        treeSet.add(Integer.MAX_VALUE);
        treeSet.add(Integer.MIN_VALUE);
        return Math.min(Math.abs(n2 - treeSet.lower(n2)), Math.abs(treeSet.higher(n2) - n2));
    }

    protected List<String> getClosestFilenames(final int n2) {
        final SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume = this.getActiveVol();
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Pair pair = VolumeDataFiller.this.nameSliceMap.get(string);
                Pair pair2 = VolumeDataFiller.this.nameSliceMap.get(string2);
                if (((Set)pair.x).contains(simpleImageVolume) && !((Set)pair2.x).contains(simpleImageVolume)) {
                    return -1;
                }
                if (!((Set)pair.x).contains(simpleImageVolume) && ((Set)pair2.x).contains(simpleImageVolume)) {
                    return 1;
                }
                int n22 = Integer.MAX_VALUE;
                int n3 = Integer.MAX_VALUE;
                for (SimpleImageVolume simpleImageVolume22 : (Set)pair.x) {
                    n22 = Math.min(n22, VolumeDataFiller.this.getSliceDistance(n2, (SliceInfo)pair.y, simpleImageVolume22));
                }
                for (SimpleImageVolume simpleImageVolume22 : (Set)pair2.x) {
                    n3 = Math.min(n3, VolumeDataFiller.this.getSliceDistance(n2, (SliceInfo)pair2.y, simpleImageVolume22));
                }
                if (n22 == n3) {
                    return string.compareTo(string2);
                }
                return n22 - n3;
            }
        });
        treeSet.addAll(this.nameSliceMap.keySet());
        return Lists.newArrayList(treeSet);
    }

    private int getCurrentSliceIdx() {
        Point3i point3i = this.backgroundDel.getCurrentLocalizedVoxelPoint();
        SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume = this.getActiveVol();
        SliceOrientationMangler sliceOrientationMangler = this.loader.manglerMap.get(simpleImageVolume);
        if (sliceOrientationMangler != null) {
            if (sliceOrientationMangler.convertCoronal) {
                if (sliceOrientationMangler.invertZ) {
                    return point3i.y;
                }
                return simpleImageVolume.a()[1] - point3i.y - 1;
            }
            if (sliceOrientationMangler.convertSagittal) {
                if (sliceOrientationMangler.invertZ) {
                    return point3i.y;
                }
                return simpleImageVolume.a()[0] - point3i.x - 1;
            }
            if (sliceOrientationMangler.invertZ) {
                return simpleImageVolume.a()[2] - point3i.z - 1;
            }
        }
        return point3i.z;
    }

    private SimpleImageVolume<ImageCube.ImageCubeShort> getActiveVol() {
        SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume = this.backgroundDel.getCurrentVolume();
        if (simpleImageVolume == null) {
            simpleImageVolume = this.loader.dSeries.c(0);
        }
        return simpleImageVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSlice(String string) throws CancelledException {
        Class<VolumeDataFiller> clazz = VolumeDataFiller.class;
        synchronized (VolumeDataFiller.class) {
            try {
                while (this.shouldWaitMyTurn()) {
                    try {
                        VolumeDataFiller.class.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.realAddSlice(string);
            }
            finally {
                VolumeDataFiller.class.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldWaitMyTurn() {
        Object object = VolumeDataFiller.class;
        synchronized (VolumeDataFiller.class) {
            if (preemptor != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = VolumeDataFiller.getHighestPriorityFiller();
            if (object == this) {
                return false;
            }
            if (this.backgroundDel.getBonusPoints() == 0) {
                return true;
            }
            return ((VolumeDataFiller)object).backgroundDel.getBonusPoints() != this.backgroundDel.getBonusPoints();
        }
    }

    protected void realAddSlice(String string) throws CancelledException {
        Pair<Set<IVType>, SliceInfo> pair = this.nameSliceMap.remove(string);
        if (pair == null) {
            return;
        }
        SliceInfo sliceInfo = (SliceInfo)pair.y;
        for (SimpleImageVolume simpleImageVolume : (Set)pair.x) {
            SliceOrientationMangler sliceOrientationMangler = this.loader.manglerMap.get(simpleImageVolume);
            sliceOrientationMangler.addSlice(sliceInfo);
            if (this.progress.n() == Progress.Status.e || this.backgroundDel.shouldStopLoading()) {
                if (this.backgroundDel.shouldStopLoading()) {
                    ay.a((Object)"Cancelled load because VC wants to stop loading.", this);
                }
                throw new CancelledException();
            }
            if (System.currentTimeMillis() - this.lastNotifyTime <= 50L) continue;
            this.backgroundDel.dataWasUpdated(simpleImageVolume);
            this.lastNotifyTime = System.currentTimeMillis();
        }
        this.loader.updateSliceFillingProgress(this.sliceNumForProgress++);
    }

    protected static synchronized VolumeDataFiller getHighestPriorityFiller() {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (WeakReference<VolumeDataFiller<? extends SimpleImageVolume<ImageCube.ImageCubeShort>>> weakReference : activeFillers) {
            if (weakReference.get() != null) {
                arrayList.add(weakReference.get());
                continue;
            }
            arrayList2.add(weakReference);
        }
        activeFillers.removeAll(arrayList2);
        Collections.sort(arrayList);
        return (VolumeDataFiller)arrayList.get(0);
    }

    @Override
    public int compareTo(VolumeDataFiller<SimpleImageVolume<ImageCube.ImageCubeShort>> volumeDataFiller) {
        int n2;
        int n3;
        int n4 = this.backgroundDel.getBonusPoints();
        if (n4 != (n3 = volumeDataFiller.backgroundDel.getBonusPoints())) {
            return n3 - n4;
        }
        int n5 = this.getDataSize();
        if (n5 != (n2 = super.getDataSize())) {
            return n5 - n2;
        }
        String string = ((SimpleImageVolume)this.loader.dSeries.c((int)0)).getUncopiedMutableInfo().modality;
        String string2 = ((SimpleImageVolume)volumeDataFiller.loader.dSeries.c((int)0)).getUncopiedMutableInfo().modality;
        if (!string.equals(string2)) {
            return -string.compareTo(string2);
        }
        return this.hashCode() - volumeDataFiller.hashCode();
    }

    private int getDataSize() {
        return (int)MathUtils.d(((SimpleImageVolume)this.loader.dSeries.c(0)).a()) * this.loader.dSeries.n();
    }

    protected static class CancelledException
    extends Exception {
        private static final long serialVersionUID = -6044057926953737590L;

        protected CancelledException() {
        }
    }
}

