/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read.defreg;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mimvista.d;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.SpyglassOverlayLoadingHelper;
import com.mimvista.dicom.read.defreg.DefRegReadHelpers;
import com.mimvista.dicom.read.defreg.DicomDeformableRegistrationFileFormat;
import com.mimvista.intensitybasedwarp.IntensityWarpHelpers;
import com.mimvista.intensitybasedwarp.IntensityWarpSettings;
import com.mimvista.intensitybasedwarp.s;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ab;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.volumes.ImageVolumeByte;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.neuro.c;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.extents.VolumeExtent;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadPoolExecutor;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public abstract class AbstractWarpLoader {
    protected DicomObject ds;
    protected Session sess;
    protected String sourceUID;
    protected String destUID;
    protected ViewController3D source;
    protected ViewController3D dest;
    protected ImageVolumeShort srcVol;
    protected ImageVolumeShort destVol;
    protected WarpTransform warpTransform;
    protected DicomDeformableRegistrationFileFormat fileFormat;

    public AbstractWarpLoader(Session session, DicomObject dicomObject) {
        this.sess = session;
        this.ds = dicomObject;
        this.fileFormat = DefRegReadHelpers.identifyVersion(this.ds.getString(524400, ""), this.ds.getString(1576992, ""));
    }

    protected abstract boolean shouldRestoreAlignmentOverlays();

    protected void findUIDs() {
        this.sourceUID = DefRegReadHelpers.findFirstSourceSOP(this.ds);
        this.destUID = DefRegReadHelpers.findFirstDestSOP(this.ds);
    }

    public DicomObject getDicom() {
        return this.ds;
    }

    protected boolean findVolumes() {
        for (ViewController3D viewController3D : this.sess.d(ViewController3D.class)) {
            ImageVolumeShort imageVolumeShort = DefRegReadHelpers.getVolWithMatchingSOPTrySliceInfoFirst(viewController3D, this.sourceUID);
            if (imageVolumeShort != null) {
                this.source = viewController3D;
                this.srcVol = imageVolumeShort;
            }
            if (this.destUID == null || (imageVolumeShort = DefRegReadHelpers.getVolWithMatchingSOPTrySliceInfoFirst(viewController3D, this.destUID)) == null) continue;
            this.dest = viewController3D;
            this.destVol = imageVolumeShort;
        }
        return this.source != null && this.dest != null;
    }

    protected Matrix4f readInitialDestToSourceAlignment() {
        Matrix4f matrix4f = null;
        float[] fArray = this.ds.getFloats(930283824, (float[])null);
        if (fArray != null && fArray.length == 16) {
            matrix4f = new Matrix4f(fArray);
            DicomObject dicomObject = DefRegReadHelpers.findDefRegSequenceItem(this.ds);
            DicomElement dicomElement = dicomObject.get(6553605);
            DicomObject dicomObject2 = dicomElement.getDicomObject(0);
            float[] fArray2 = dicomObject2.getFloats(2097207);
            float[] fArray3 = this.destVol != null ? this.destVol.av() : c.a().h();
            Matrix4f matrix4f2 = ab.a(fArray2, null, fArray3, null);
            matrix4f.mul(matrix4f, matrix4f2);
        }
        return matrix4f;
    }

    private String getSrcFOR() {
        DicomObject dicomObject = DefRegReadHelpers.findRigidRegSequenceItem(this.ds);
        if (dicomObject == null) {
            return null;
        }
        String string = dicomObject.getString(6553603);
        if (string != null) {
            return string;
        }
        return null;
    }

    private void loadQA(WarpTransform warpTransform) {
        if (this.ds.contains(930283825)) {
            warpTransform.c().a(true);
            DicomObject dicomObject = this.ds.get(930283825).getDicomObject();
            this.readRatingMapSequence(dicomObject, warpTransform);
            SpyglassOverlayLoadingHelper.loadQaOverlaysFromStructureSetSequence(dicomObject, warpTransform);
        }
    }

    private void loadFusAlignOverlays(WarpTransform warpTransform) {
        if (this.ds.contains(930283827)) {
            DicomObject dicomObject = this.ds.get(930283827).getDicomObject();
            SpyglassOverlayLoadingHelper.loadFusionAlignOverlaysFromStructureSetSequence(dicomObject, warpTransform.b().j(), warpTransform.a().j());
        }
    }

    private void loadWarpDescription(WarpTransform warpTransform) {
        if (this.ds.contains(930283828)) {
            String string = this.ds.getString(930283828, "");
            if (this.ds.contains(930283829)) {
                warpTransform.a(string, this.ds.getString(930283829, ""));
            } else {
                warpTransform.a(string, null);
            }
        }
    }

    private void loadWarpProfile(WarpTransform warpTransform) {
        if (this.ds.contains(930283830)) {
            String string = this.ds.getString(930283830, "");
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                warpTransform.a((IntensityWarpSettings)objectMapper.readValue(string, IntensityWarpSettings.class));
            }
            catch (IOException iOException) {
                ay.d((Object)"Failed to deserialize Warp Profile JSON", this);
            }
        }
    }

    private void readRatingMapSequence(DicomObject dicomObject, WarpTransform warpTransform) {
        try {
            if (dicomObject.contains(930283826)) {
                DicomObject dicomObject2 = dicomObject.get(930283826).getDicomObject();
                float[] fArray = DicomLoadingUtility.getPixSpacingOrder(dicomObject2);
                float f2 = dicomObject2.getFloat(1572944);
                float[] fArray2 = new float[3];
                System.arraycopy(fArray, 0, fArray2, 0, 2);
                fArray2[2] = f2;
                int n2 = dicomObject2.getInt(2621457);
                int n3 = dicomObject2.getInt(2621456);
                int n4 = dicomObject2.getInt(5505153);
                int[] nArray = new int[]{n2, n3, n4};
                byte[] byArray = dicomObject2.getBytes(2145386512);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                ImageCube.ImageCubeByte imageCubeByte = ImageCube.ImageCubeByte.a(byteBuffer, nArray);
                ImageVolumeByte imageVolumeByte = new ImageVolumeByte();
                imageVolumeByte.b(SeriesInfo.a(warpTransform.b().getUncopiedMutableInfo()));
                imageVolumeByte.a(fArray2);
                imageVolumeByte.a(imageCubeByte);
                imageVolumeByte.b(warpTransform.I().f());
                warpTransform.c().a(imageVolumeByte);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error loading QA rating map", throwable, this);
        }
    }

    protected WarpTransform buildWarpTransform(@d ImageFrame imageFrame, ImageFrame imageFrame2) {
        Cloneable cloneable;
        Object object;
        int[] nArray;
        Point3f.PointVolumeInfo pointVolumeInfo;
        Pair<Point3f.PointVolumeInfo, int[]> pair = DefRegReadHelpers.constructGridPVI(DefRegReadHelpers.findDefRegSequenceItem(this.ds), this.fileFormat.flipZDirection());
        Point3f.PointVolumeInfo pointVolumeInfo2 = (Point3f.PointVolumeInfo)pair.x;
        if (imageFrame == null) {
            pointVolumeInfo = pointVolumeInfo2;
            nArray = (int[])pair.y;
        } else {
            pointVolumeInfo = new Point3f.PointVolumeInfo(imageFrame);
            nArray = imageFrame.a();
        }
        VolumeExtent volumeExtent = this.fileFormat.buildExtents(this.ds, pointVolumeInfo);
        s s2 = this.extractOffsetField(this.fileFormat.flipZDirection());
        this.convertOffsetFieldToSourceIndices(s2, pointVolumeInfo2);
        if (this.fileFormat.allowResample(this.ds)) {
            object = volumeExtent.o();
            object[0] = MathUtils.a(object[0], MathUtils.a(0));
            object[1] = MathUtils.b(object[1], nArray);
            volumeExtent = new VolumeExtent((int[][])object, -1);
            cloneable = this.resampleFieldIfNecessary(s2, pointVolumeInfo, volumeExtent, pointVolumeInfo2);
            s2 = (s)((Pair)cloneable).x;
            pointVolumeInfo2 = (Point3f.PointVolumeInfo)((Pair)cloneable).y;
        }
        if (imageFrame == null) {
            imageFrame = IntensityWarpHelpers.a(s2, volumeExtent, this.srcVol, pointVolumeInfo.iop, this.getSrcFOR(), pointVolumeInfo.dicomCenter, o.o());
        }
        object = this.readInitialDestToSourceAlignment();
        cloneable = new WarpTransform(imageFrame, imageFrame2, (Matrix4f)object);
        cloneable.a(s2);
        cloneable.a(volumeExtent);
        DicomPoint3f dicomPoint3f = volumeExtent.a(imageFrame).d().d();
        cloneable.a(dicomPoint3f);
        if (this.shouldRestoreAlignmentOverlays()) {
            this.loadQA((WarpTransform)cloneable);
            this.loadFusAlignOverlays((WarpTransform)cloneable);
        }
        this.loadWarpDescription((WarpTransform)cloneable);
        this.loadWarpProfile((WarpTransform)cloneable);
        return cloneable;
    }

    private s extractOffsetField(final boolean bl2) {
        DicomObject dicomObject = DefRegReadHelpers.findDefRegSequenceItem(this.ds);
        if (dicomObject == null) {
            return null;
        }
        DicomElement dicomElement = dicomObject.get(6553605);
        DicomObject dicomObject2 = dicomElement.getDicomObject(0);
        final int[] nArray = dicomObject2.getInts(6553607);
        final ImageCube.ImageCubeFloat[] imageCubeFloatArray = new ImageCube.ImageCubeFloat[3];
        for (int i2 = 0; i2 < imageCubeFloatArray.length; ++i2) {
            imageCubeFloatArray[i2] = ImageCube.ImageCubeFloat.b(nArray);
        }
        final float[] fArray = dicomObject2.getFloats(6553609);
        final int n2 = nArray[0] * nArray[1];
        FuncUtils.a((ThreadPoolExecutor)m.c, nArray[2], new FuncUtils.e(){

            @Override
            public void f(int n22, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                for (int i2 = n22; i2 < n3; ++i2) {
                    int n5 = bl2 ? i2 : nArray[2] - i2 - 1;
                    float[] fArray4 = (float[])imageCubeFloatArray[0].b().get(n5);
                    float[] fArray2 = (float[])imageCubeFloatArray[1].b().get(n5);
                    float[] fArray3 = (float[])imageCubeFloatArray[2].b().get(n5);
                    int n6 = 3 * i2 * n2;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int n7 = n6 + 3 * i3;
                        fArray4[i3] = fArray[n7];
                        fArray2[i3] = fArray[n7 + 1];
                        fArray3[i3] = fArray[n7 + 2];
                    }
                }
            }
        });
        double[] dArray = dicomObject2.getDoubles(6553608);
        float[] fArray2 = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
        return new s(imageCubeFloatArray[0], imageCubeFloatArray[1], imageCubeFloatArray[2], fArray2);
    }

    private void convertOffsetFieldToSourceIndices(s s2, Point3f.PointVolumeInfo pointVolumeInfo) {
        DicomObject dicomObject = DefRegReadHelpers.findDefRegSequenceItem(this.ds);
        DicomElement dicomElement = dicomObject.get(6553615);
        DicomObject dicomObject2 = dicomElement.getDicomObject(0);
        float[] fArray = dicomObject2.getFloats(805699782);
        Matrix4f matrix4f = new Matrix4f(fArray);
        DicomElement dicomElement2 = dicomObject.get(6553616);
        dicomObject2 = dicomElement2.getDicomObject(0);
        float[] fArray2 = dicomObject2.getFloats(805699782);
        Matrix4f matrix4f2 = new Matrix4f(fArray2);
        this.fileFormat.processWarpFieldEntry(this.srcVol, matrix4f, matrix4f2, s2, pointVolumeInfo);
    }

    private Pair<s, Point3f.PointVolumeInfo> resampleFieldIfNecessary(s s2, final Point3f.PointVolumeInfo pointVolumeInfo, VolumeExtent volumeExtent, Point3f.PointVolumeInfo pointVolumeInfo2) {
        boolean bl2;
        float[] fArray = pointVolumeInfo2.iop;
        float[] fArray2 = pointVolumeInfo.iop;
        boolean bl3 = ab.b(fArray, fArray2, 0.001f);
        VoxelPoint3f voxelPoint3f = new VoxelPoint3f(0.0f, 0.0f, 0.0f, pointVolumeInfo2).b().d().b(pointVolumeInfo).b();
        VoxelPoint3f voxelPoint3f2 = volumeExtent.b(pointVolumeInfo).j();
        boolean bl4 = MathUtils.l(voxelPoint3f.f(), voxelPoint3f2.f()) < 0.001f;
        int[] nArray = s2.d();
        VoxelPoint3f voxelPoint3f3 = new VoxelPoint3f((float)nArray[0], (float)nArray[1], (float)nArray[2], pointVolumeInfo2).b().d().b(pointVolumeInfo).b();
        VoxelPoint3f voxelPoint3f4 = volumeExtent.c(pointVolumeInfo).j();
        boolean bl5 = bl2 = MathUtils.l(voxelPoint3f3.f(), voxelPoint3f4.f()) < 0.001f;
        if (!(bl3 && bl4 && bl2)) {
            Object object;
            float[] fArray3;
            ay.b((Object)"Deformation field did not align with destination extent, resampling.", this);
            this.convertSrcIndexToDICOMOffset(s2, pointVolumeInfo2, false);
            float[] fArray4 = new float[3];
            final MetricPoint3f metricPoint3f = volumeExtent.b(pointVolumeInfo).d();
            VoxelPoint3f voxelPoint3f5 = metricPoint3f.d().a(pointVolumeInfo2);
            for (int i2 = 0; i2 < fArray4.length; ++i2) {
                fArray3 = metricPoint3f.b().f();
                fArray3[i2] = volumeExtent.c(pointVolumeInfo).j().f()[i2];
                object = (Object)new VoxelPoint3f(fArray3, pointVolumeInfo).b().d().a(pointVolumeInfo2);
                fArray4[i2] = MathUtils.l(voxelPoint3f5.f(), ((Point3f)((Object)object)).f());
            }
            int[] nArray2 = MathUtils.a(MathUtils.e(fArray4));
            fArray3 = MathUtils.a(pointVolumeInfo.voxel, volumeExtent.k());
            object = MathUtils.b(fArray3, nArray2);
            ImageCube.ImageCubeFloat[] imageCubeFloatArray = new ImageCube.ImageCubeFloat[3];
            for (int i3 = 0; i3 < imageCubeFloatArray.length; ++i3) {
                imageCubeFloatArray[i3] = ImageCube.ImageCubeFloat.b(nArray2);
            }
            s s3 = s2;
            final Point3f.PointVolumeInfo pointVolumeInfo3 = pointVolumeInfo2;
            FuncUtils.a((ThreadPoolExecutor)m.c, nArray2[2], new FuncUtils.e((float[])object, imageCubeFloatArray, nArray2, s3){
                final /* synthetic */ float[] val$finalResampleRes;
                final /* synthetic */ ImageCube.ImageCubeFloat[] val$resampledField;
                final /* synthetic */ int[] val$finalResampleDims;
                final /* synthetic */ s val$initialWf;
                {
                    this.val$finalResampleRes = fArray;
                    this.val$resampledField = imageCubeFloatArray;
                    this.val$finalResampleDims = nArray;
                    this.val$initialWf = s2;
                }

                @Override
                public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                    MetricPoint3f metricPoint3f3 = new MetricPoint3f(pointVolumeInfo);
                    DicomPoint3f dicomPoint3f = new DicomPoint3f(pointVolumeInfo);
                    MetricPoint3f metricPoint3f2 = new MetricPoint3f(pointVolumeInfo3);
                    VoxelPoint3f voxelPoint3f = new VoxelPoint3f(pointVolumeInfo3);
                    for (int i2 = n2; i2 < n3; ++i2) {
                        metricPoint3f3.z = metricPoint3f.z + ((float)i2 + 0.5f) * this.val$finalResampleRes[2];
                        float[] fArray = (float[])this.val$resampledField[0].b().get(i2);
                        float[] fArray2 = (float[])this.val$resampledField[1].b().get(i2);
                        float[] fArray3 = (float[])this.val$resampledField[2].b().get(i2);
                        int n5 = 0;
                        for (int i3 = 0; i3 < this.val$finalResampleDims[1]; ++i3) {
                            metricPoint3f3.y = metricPoint3f.y + ((float)i3 + 0.5f) * this.val$finalResampleRes[1];
                            int n6 = 0;
                            while (n6 < this.val$finalResampleDims[0]) {
                                metricPoint3f3.x = metricPoint3f.x + ((float)n6 + 0.5f) * this.val$finalResampleRes[0];
                                metricPoint3f3.a(dicomPoint3f);
                                dicomPoint3f.a(metricPoint3f2, pointVolumeInfo3);
                                metricPoint3f2.a(voxelPoint3f);
                                fArray[n5] = this.val$initialWf.a().a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                                fArray2[n5] = this.val$initialWf.b().a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                                fArray3[n5] = this.val$initialWf.c().a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                                ++n6;
                                ++n5;
                            }
                        }
                    }
                }
            });
            s2 = new s(imageCubeFloatArray, (float[])object);
            pointVolumeInfo2 = new Point3f.PointVolumeInfo(volumeExtent.a(pointVolumeInfo).d().d().f(), null, fArray2, (float[])object, MathUtils.a(MathUtils.f((float[])object, 0.5f), s2.d()));
            this.convertSrcIndexToDICOMOffset(s2, pointVolumeInfo2, true);
        }
        return Pair.get(s2, pointVolumeInfo2);
    }

    private void convertSrcIndexToDICOMOffset(final s s2, final Point3f.PointVolumeInfo pointVolumeInfo, final boolean bl2) {
        final int[] nArray = s2.d();
        FuncUtils.a((ThreadPoolExecutor)m.c, nArray[2], new FuncUtils.e(){

            @Override
            public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(pointVolumeInfo);
                MetricPoint3f metricPoint3f = new MetricPoint3f(pointVolumeInfo);
                DicomPoint3f dicomPoint3f = new DicomPoint3f(pointVolumeInfo);
                Point3f.PointVolumeInfo pointVolumeInfo2 = new Point3f.PointVolumeInfo(AbstractWarpLoader.this.srcVol);
                MetricPoint3f metricPoint3f2 = new MetricPoint3f(pointVolumeInfo2);
                VoxelIndexPoint3f voxelIndexPoint3f2 = new VoxelIndexPoint3f(pointVolumeInfo2);
                DicomPoint3f dicomPoint3f2 = new DicomPoint3f(pointVolumeInfo2);
                for (int i2 = n2; i2 < n3; ++i2) {
                    voxelIndexPoint3f.z = i2;
                    float[] fArray = (float[])s2.a().b().get(i2);
                    float[] fArray2 = (float[])s2.b().b().get(i2);
                    float[] fArray3 = (float[])s2.c().b().get(i2);
                    int n5 = 0;
                    for (int i3 = 0; i3 < nArray[1]; ++i3) {
                        voxelIndexPoint3f.y = i3;
                        int n6 = 0;
                        while (n6 < nArray[0]) {
                            voxelIndexPoint3f.x = n6;
                            voxelIndexPoint3f.a(metricPoint3f);
                            metricPoint3f.a(dicomPoint3f);
                            if (bl2) {
                                dicomPoint3f2.x = dicomPoint3f.x + fArray[n5];
                                dicomPoint3f2.y = dicomPoint3f.y + fArray2[n5];
                                dicomPoint3f2.z = dicomPoint3f.z + fArray3[n5];
                                dicomPoint3f2.a(metricPoint3f2);
                                metricPoint3f2.a(voxelIndexPoint3f2);
                                fArray[n5] = voxelIndexPoint3f2.x;
                                fArray2[n5] = voxelIndexPoint3f2.y;
                                fArray3[n5] = voxelIndexPoint3f2.z;
                            } else {
                                voxelIndexPoint3f2.x = fArray[n5];
                                voxelIndexPoint3f2.y = fArray2[n5];
                                voxelIndexPoint3f2.z = fArray3[n5];
                                voxelIndexPoint3f2.a(metricPoint3f2);
                                metricPoint3f2.a(dicomPoint3f2);
                                fArray[n5] = dicomPoint3f2.x - dicomPoint3f.x;
                                fArray2[n5] = dicomPoint3f2.y - dicomPoint3f.y;
                                fArray3[n5] = dicomPoint3f2.z - dicomPoint3f.z;
                            }
                            ++n6;
                            ++n5;
                        }
                    }
                }
            }
        });
    }
}

