/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read.defreg;

import com.google.common.collect.Lists;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.dicom.read.defreg.DicomDeformableRegistrationFileFormat;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.internals.DicomDeformableRegistration;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ab;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.numerics.Point3f;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public final class DefRegReadHelpers {
    public static DicomDeformableRegistrationFileFormat identifyVersion(String string, String string2) {
        try {
            if (string.toLowerCase().contains("mim software") && VersionNumber.isValidVersionNumber(string2)) {
                VersionNumber versionNumber = new VersionNumber(string2);
                if (versionNumber.lessThanUpTo(new VersionNumber(5, 2, 1, ""), VersionNumberComparator.c)) {
                    return DicomDeformableRegistrationFileFormat.BEFORE_521;
                }
                if (versionNumber.lessThanUpTo(new VersionNumber(5, 3, 0, ""), VersionNumberComparator.c)) {
                    return DicomDeformableRegistrationFileFormat.BEFORE_660;
                }
                if (versionNumber.lessThanUpTo(new VersionNumber(5, 4, 0, ""), VersionNumberComparator.c)) {
                    return DicomDeformableRegistrationFileFormat.BEFORE_540;
                }
                if (versionNumber.lessThanUpTo(new VersionNumber(6, 6, 0, ""), VersionNumberComparator.c)) {
                    return DicomDeformableRegistrationFileFormat.BEFORE_660;
                }
            } else if (DefRegReadHelpers.isAccurayREGThatNeedsPre660Handling(string, string2)) {
                return DicomDeformableRegistrationFileFormat.BEFORE_660;
            }
        }
        catch (Exception exception) {
            ay.c((Object)"Error reading version of def REG file, assuming current format", DicomDeformableRegistration.class);
        }
        return DicomDeformableRegistrationFileFormat.CURRENT;
    }

    protected static boolean isAccurayREGThatNeedsPre660Handling(String string, String string2) {
        if (Boolean.TRUE.equals(DicomPrefs.loadAccurayDefRegWithOldMIMFormat.getValue())) {
            return string.toLowerCase().contains("accuray") && string2.toLowerCase().contains("multiplan 5.5.0");
        }
        return false;
    }

    public static DicomObject findDefRegSequenceItem(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(6553602);
        DicomObject dicomObject2 = null;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomElement dicomElement2 = dicomElement.getDicomObject(i2).get(6553605);
            if (dicomElement2 == null) continue;
            dicomObject2 = dicomElement.getDicomObject(i2);
            break;
        }
        return dicomObject2;
    }

    public static DicomObject findRigidRegSequenceItem(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(6553602);
        DicomObject dicomObject2 = null;
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomElement dicomElement2 = dicomElement.getDicomObject(i2).get(6553605);
            if (dicomElement2 == null) continue;
            dicomObject2 = dicomElement.getDicomObject(i2);
            break;
        }
        return dicomObject2;
    }

    public static String findSourceSeriesInstanceUID(DicomObject dicomObject) {
        String string = DefRegReadHelpers.findFirstSourceSOP(dicomObject);
        if (string == null) {
            return null;
        }
        DicomElement dicomElement = dicomObject.get(528661);
        if (dicomElement == null || dicomElement.countItems() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
            String string2 = dicomObject2.getString(0x20000E);
            DicomElement dicomElement2 = dicomObject2.get(528714);
            if (dicomElement2 == null) {
                return null;
            }
            for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                DicomObject dicomObject3 = dicomElement2.getDicomObject(i3);
                String string3 = dicomObject3.getString(528725);
                if (string3 == null || !string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    public static ImageVolumeShort getVolWithMatchingSOPTrySliceInfoFirst(ViewController3D viewController3D, String string) {
        ArrayList arrayList = Lists.newArrayList();
        if (viewController3D.cE() != null) {
            arrayList.addAll(viewController3D.cE().l());
        } else {
            arrayList.add(viewController3D.cw());
        }
        for (ImageVolumeShort imageVolumeShort : arrayList) {
            ArrayList arrayList2 = Lists.newArrayList();
            List<SliceInfo> list = imageVolumeShort.at();
            if (list != null) {
                arrayList2.addAll(list);
            }
            arrayList2.addAll(imageVolumeShort.ab());
            for (SliceInfo sliceInfo : arrayList2) {
                if (!string.equals(sliceInfo.sopInstanceUID)) continue;
                return imageVolumeShort;
            }
            if (!string.equals(RawDicomUtils.getSOPFromVolTrySliceInfoFirst(imageVolumeShort))) continue;
            return imageVolumeShort;
        }
        return null;
    }

    protected static Pair<Point3f.PointVolumeInfo, int[]> constructGridPVI(DicomObject dicomObject, boolean bl2) {
        DicomElement dicomElement = dicomObject.get(6553605);
        DicomObject dicomObject2 = dicomElement.getDicomObject(0);
        float[] fArray = dicomObject2.getFloats(0x200032);
        float[] fArray2 = dicomObject2.getFloats(2097207);
        float[] fArray3 = ab.a(fArray2, null);
        double[] dArray = dicomObject2.getDoubles(6553608);
        float[] fArray4 = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
        int[] nArray = dicomObject2.getInts(6553607);
        float[] fArray5 = (float[])fArray.clone();
        float f2 = (float)(nArray[0] - 1) / 2.0f * fArray4[0];
        fArray5[0] = fArray5[0] + f2 * fArray2[0];
        fArray5[1] = fArray5[1] + f2 * fArray2[1];
        fArray5[2] = fArray5[2] + f2 * fArray2[2];
        float f3 = (float)(nArray[1] - 1) / 2.0f * fArray4[1];
        fArray5[0] = fArray5[0] + f3 * fArray2[3];
        fArray5[1] = fArray5[1] + f3 * fArray2[4];
        fArray5[2] = fArray5[2] + f3 * fArray2[5];
        float f4 = (float)(nArray[2] - 1) / 2.0f * fArray4[2];
        if (bl2) {
            f4 = -f4;
        }
        fArray5[0] = fArray5[0] + f4 * fArray3[0];
        fArray5[1] = fArray5[1] + f4 * fArray3[1];
        fArray5[2] = fArray5[2] + f4 * fArray3[2];
        float[] fArray6 = new float[]{(float)nArray[0] * fArray4[0] / 2.0f, (float)nArray[1] * fArray4[1] / 2.0f, (float)nArray[2] * fArray4[2] / 2.0f};
        Point3f.PointVolumeInfo pointVolumeInfo = new Point3f.PointVolumeInfo(fArray5, null, fArray2, fArray4, fArray6);
        return Pair.get(pointVolumeInfo, nArray);
    }

    protected static String findFirstSourceSOP(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(6553602);
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomElement dicomElement2 = dicomElement.getDicomObject(i2).get(6553605);
            if (dicomElement2 == null) continue;
            DicomElement dicomElement3 = dicomElement.getDicomObject(i2).get(528704);
            DicomObject dicomObject2 = dicomElement3.getDicomObject(0);
            return dicomObject2.getString(528725);
        }
        return DefRegReadHelpers.getSrcUIDFromWarpRegOldMIMMethod(dicomObject);
    }

    protected static String findFirstDestSOP(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(6553602);
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomElement dicomElement2;
            DicomElement dicomElement3 = dicomElement.getDicomObject(i2).get(6553605);
            if (dicomElement3 != null || (dicomElement2 = dicomElement.getDicomObject(i2).get(528704)) == null || dicomElement2.countItems() <= 0) continue;
            DicomObject dicomObject2 = dicomElement2.getDicomObject(0);
            return dicomObject2.getString(528725);
        }
        try {
            return DefRegReadHelpers.getDestUIDFromWarpRegOldMIMMethod(dicomObject);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getSrcUIDFromWarpRegOldMIMMethod(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(6553602);
        DicomElement dicomElement2 = dicomElement.getDicomObject(0).get(528704);
        DicomObject dicomObject2 = dicomElement2.getDicomObject(0);
        return dicomObject2.getString(528725);
    }

    private static String getDestUIDFromWarpRegOldMIMMethod(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(6553602);
        DicomElement dicomElement2 = dicomElement.getDicomObject(0).get(528704);
        if (dicomElement2.countItems() > 1) {
            DicomObject dicomObject2 = dicomElement2.getDicomObject(1);
            return dicomObject2.getString(528725);
        }
        return null;
    }

    private DefRegReadHelpers() {
    }
}

