/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read.defreg;

import com.mimvista.dicom.read.defreg.DefRegReadHelpers;
import com.mimvista.intensitybasedwarp.s;
import com.mimvista.internals.ab;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.extents.VolumeExtent;
import com.mimvista.util.work.m;
import java.util.concurrent.ThreadPoolExecutor;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public enum DicomDeformableRegistrationFileFormat {
    BEFORE_521(true){

        @Override
        public VolumeExtent buildExtents(DicomObject dicomObject, Point3f.PointVolumeInfo pointVolumeInfo) {
            int[][] nArrayArray;
            DicomElement dicomElement = dicomObject.get(6553602);
            DicomElement dicomElement2 = dicomElement.getDicomObject(0).get(6553605);
            DicomObject dicomObject2 = dicomElement2.getDicomObject(0);
            float[] fArray = dicomObject2.getFloats(0x200032);
            int[] nArray = (int[])dicomObject2.getInts(6553607).clone();
            double[] dArray = dicomObject2.getDoubles(6553608);
            nArray[0] = (int)Math.round((double)nArray[0] * dArray[0] / (double)pointVolumeInfo.voxel[0]);
            nArray[1] = (int)Math.round((double)nArray[1] * dArray[1] / (double)pointVolumeInfo.voxel[1]);
            nArray[2] = (int)Math.round((double)nArray[2] * dArray[2] / (double)pointVolumeInfo.voxel[2]);
            nArrayArray = new int[][]{{(int)fArray[0], (int)fArray[1], (int)fArray[2]}, {nArray[0] + nArrayArray[0][0], nArray[1] + nArrayArray[0][1], nArray[2] + nArrayArray[0][2]}};
            VolumeExtent volumeExtent = new VolumeExtent(nArrayArray, -1);
            return volumeExtent;
        }

        @Override
        public void processWarpFieldEntry(ImageVolumeShort imageVolumeShort, Matrix4f matrix4f, Matrix4f matrix4f2, s s2, Point3f.PointVolumeInfo pointVolumeInfo) {
        }

        @Override
        public boolean allowResample(DicomObject dicomObject) {
            return false;
        }
    }
    ,
    BEFORE_540(true){

        @Override
        public VolumeExtent buildExtents(DicomObject dicomObject, Point3f.PointVolumeInfo pointVolumeInfo) {
            int[][] nArrayArray;
            DicomElement dicomElement = dicomObject.get(6553602);
            DicomElement dicomElement2 = dicomElement.getDicomObject(0).get(6553605);
            DicomObject dicomObject2 = dicomElement2.getDicomObject(0);
            int[] nArray = (int[])dicomObject2.getInts(6553607).clone();
            double[] dArray = dicomObject2.getDoubles(6553608);
            float[] fArray = pointVolumeInfo.voxel;
            nArray[0] = (int)Math.round((double)nArray[0] * dArray[0] / (double)fArray[0]);
            nArray[1] = (int)Math.round((double)nArray[1] * dArray[1] / (double)fArray[1]);
            nArray[2] = (int)Math.round((double)nArray[2] * dArray[2] / (double)fArray[2]);
            float[] fArray2 = dicomObject2.getFloats(0x200032);
            VoxelPoint3f voxelPoint3f = new DicomPoint3f(fArray2[0], fArray2[1], fArray2[2], pointVolumeInfo).b();
            nArrayArray = new int[][]{{(int)voxelPoint3f.x, (int)voxelPoint3f.y, (int)voxelPoint3f.z}, {nArray[0] + nArrayArray[0][0], nArray[1] + nArrayArray[0][1], nArray[2] + nArrayArray[0][2]}};
            VolumeExtent volumeExtent = new VolumeExtent(nArrayArray, -1);
            return volumeExtent;
        }

        @Override
        public void processWarpFieldEntry(ImageVolumeShort imageVolumeShort, Matrix4f matrix4f, Matrix4f matrix4f2, s s2, Point3f.PointVolumeInfo pointVolumeInfo) {
            DicomDeformableRegistrationFileFormat.processWarpFieldEntryFor521toBefore660(imageVolumeShort, matrix4f, matrix4f2, s2, pointVolumeInfo);
        }

        @Override
        public boolean allowResample(DicomObject dicomObject) {
            return false;
        }
    }
    ,
    BEFORE_660(true){

        @Override
        public VolumeExtent buildExtents(DicomObject dicomObject, Point3f.PointVolumeInfo pointVolumeInfo) {
            int[][] nArrayArray;
            try {
                if (DefRegReadHelpers.isAccurayREGThatNeedsPre660Handling(dicomObject.getString(524400, ""), dicomObject.getString(1576992, ""))) {
                    return DicomDeformableRegistrationFileFormat.buildExtentsFromGridCorners(dicomObject, true, pointVolumeInfo);
                }
            }
            catch (Exception exception) {
                ay.d((Object)exception, (Object)this);
            }
            DicomObject dicomObject2 = DefRegReadHelpers.findDefRegSequenceItem(dicomObject);
            DicomElement dicomElement = dicomObject2.get(6553605);
            DicomObject dicomObject3 = dicomElement.getDicomObject(0);
            int[] nArray = (int[])dicomObject3.getInts(6553607).clone();
            double[] dArray = dicomObject3.getDoubles(6553608);
            float[] fArray = pointVolumeInfo.voxel;
            nArray[0] = (int)Math.round((double)nArray[0] * dArray[0] / (double)fArray[0]);
            nArray[1] = (int)Math.round((double)nArray[1] * dArray[1] / (double)fArray[1]);
            nArray[2] = (int)Math.round((double)nArray[2] * dArray[2] / (double)fArray[2]);
            float[] fArray2 = dicomObject3.getFloats(0x200032);
            MetricPoint3f metricPoint3f = new DicomPoint3f(fArray2[0], fArray2[1], fArray2[2], pointVolumeInfo).c();
            metricPoint3f.x = (float)((double)metricPoint3f.x - dArray[0] / 2.0);
            metricPoint3f.y = (float)((double)metricPoint3f.y - dArray[1] / 2.0);
            metricPoint3f.z = (float)((double)metricPoint3f.z - dArray[2] / 2.0);
            metricPoint3f.x += fArray[0] / 2.0f;
            metricPoint3f.y += fArray[1] / 2.0f;
            metricPoint3f.z += fArray[2] / 2.0f;
            VoxelPoint3f voxelPoint3f = metricPoint3f.b();
            nArrayArray = new int[][]{{(int)voxelPoint3f.x, (int)voxelPoint3f.y, (int)voxelPoint3f.z}, {nArray[0] + nArrayArray[0][0], nArray[1] + nArrayArray[0][1], nArray[2] + nArrayArray[0][2]}};
            VolumeExtent volumeExtent = new VolumeExtent(nArrayArray, -1);
            return volumeExtent;
        }

        @Override
        public void processWarpFieldEntry(ImageVolumeShort imageVolumeShort, Matrix4f matrix4f, Matrix4f matrix4f2, s s2, Point3f.PointVolumeInfo pointVolumeInfo) {
            DicomDeformableRegistrationFileFormat.processWarpFieldEntryFor521toBefore660(imageVolumeShort, matrix4f, matrix4f2, s2, pointVolumeInfo);
        }

        @Override
        public boolean allowResample(DicomObject dicomObject) {
            try {
                if (DefRegReadHelpers.isAccurayREGThatNeedsPre660Handling(dicomObject.getString(524400, ""), dicomObject.getString(1576992, ""))) {
                    return true;
                }
            }
            catch (Exception exception) {
                ay.d((Object)exception, (Object)this);
            }
            return false;
        }
    }
    ,
    CURRENT(false){

        @Override
        public VolumeExtent buildExtents(DicomObject dicomObject, Point3f.PointVolumeInfo pointVolumeInfo) {
            return DicomDeformableRegistrationFileFormat.buildExtentsFromGridCorners(dicomObject, false, pointVolumeInfo);
        }

        @Override
        public void processWarpFieldEntry(final ImageVolumeShort imageVolumeShort, final Matrix4f matrix4f, final Matrix4f matrix4f2, final s s2, final Point3f.PointVolumeInfo pointVolumeInfo) {
            final float[] fArray = ab.a(pointVolumeInfo.iop, null);
            final int[] nArray = s2.d();
            final float[] fArray2 = pointVolumeInfo.voxel;
            final float[] fArray3 = pointVolumeInfo.iop;
            final float[] fArray4 = new VoxelIndexPoint3f(0.0f, 0.0f, (float)(nArray[2] - 1), pointVolumeInfo).d().d().f();
            FuncUtils.a((ThreadPoolExecutor)m.c, nArray[2], new FuncUtils.e(){

                @Override
                public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                    Point3d point3d = new Point3d();
                    Point3d point3d2 = new Point3d();
                    DicomPoint3f dicomPoint3f = new DicomPoint3f(pointVolumeInfo);
                    Point3f point3f = new Point3f();
                    DicomPoint3f dicomPoint3f2 = new DicomPoint3f(imageVolumeShort);
                    MetricPoint3f metricPoint3f = new MetricPoint3f(imageVolumeShort);
                    VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(imageVolumeShort);
                    for (int i2 = n2; i2 < n3; ++i2) {
                        point3d.x = fArray4[0] + (float)(nArray[2] - i2 - 1) * fArray2[2] * fArray[0];
                        point3d.y = fArray4[1] + (float)(nArray[2] - i2 - 1) * fArray2[2] * fArray[1];
                        point3d.z = fArray4[2] + (float)(nArray[2] - i2 - 1) * fArray2[2] * fArray[2];
                        float[] fArray5 = (float[])s2.a(0).b().get(i2);
                        float[] fArray22 = (float[])s2.a(1).b().get(i2);
                        float[] fArray32 = (float[])s2.a(2).b().get(i2);
                        int n5 = 0;
                        for (int i3 = 0; i3 < nArray[1]; ++i3) {
                            point3d2.x = point3d.x + (double)((float)i3 * fArray2[1] * fArray3[3]);
                            point3d2.y = point3d.y + (double)((float)i3 * fArray2[1] * fArray3[4]);
                            point3d2.z = point3d.z + (double)((float)i3 * fArray2[1] * fArray3[5]);
                            int n6 = 0;
                            while (n6 < nArray[0]) {
                                dicomPoint3f.x = (float)(point3d2.x + (double)((float)n6 * fArray2[0] * fArray3[0]));
                                dicomPoint3f.y = (float)(point3d2.y + (double)((float)n6 * fArray2[0] * fArray3[1]));
                                dicomPoint3f.z = (float)(point3d2.z + (double)((float)n6 * fArray2[0] * fArray3[2]));
                                matrix4f.transform((javax.vecmath.Point3f)dicomPoint3f, (javax.vecmath.Point3f)point3f);
                                point3f.x += fArray5[n5];
                                point3f.y += fArray22[n5];
                                point3f.z += fArray32[n5];
                                matrix4f2.transform((javax.vecmath.Point3f)point3f, (javax.vecmath.Point3f)dicomPoint3f2);
                                dicomPoint3f2.a(metricPoint3f);
                                metricPoint3f.a(voxelIndexPoint3f);
                                fArray5[n5] = voxelIndexPoint3f.x;
                                fArray22[n5] = voxelIndexPoint3f.y;
                                fArray32[n5] = voxelIndexPoint3f.z;
                                ++n6;
                                ++n5;
                            }
                        }
                    }
                }
            });
        }

        @Override
        public boolean allowResample(DicomObject dicomObject) {
            return true;
        }
    };

    private boolean flipZDirection;

    private static void processWarpFieldEntryFor521toBefore660(ImageVolumeShort imageVolumeShort, Matrix4f matrix4f, Matrix4f matrix4f2, s s2, Point3f.PointVolumeInfo pointVolumeInfo) {
        int[] nArray = s2.d();
        float[] fArray = new VoxelIndexPoint3f(0.0f, 0.0f, 0.0f, pointVolumeInfo).d().d().f();
        float[] fArray2 = pointVolumeInfo.voxel;
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    Point3f point3f = new Point3f(fArray);
                    point3f.x += (float)i4 * fArray2[0];
                    point3f.y += (float)i3 * fArray2[1];
                    point3f.z += (float)i2 * fArray2[2];
                    matrix4f.transform((javax.vecmath.Point3f)point3f);
                    DicomPoint3f dicomPoint3f = new DicomPoint3f(0.0f, 0.0f, 0.0f, imageVolumeShort);
                    dicomPoint3f.x = s2.a(0).a_(i4, i3, i2);
                    dicomPoint3f.y = s2.a(1).a_(i4, i3, i2);
                    dicomPoint3f.z = s2.a(2).a_(i4, i3, i2);
                    DicomPoint3f dicomPoint3f2 = new DicomPoint3f(0.0f, 0.0f, 0.0f, imageVolumeShort);
                    dicomPoint3f2.add((Tuple3f)dicomPoint3f);
                    dicomPoint3f2.add((Tuple3f)point3f);
                    VoxelIndexPoint3f voxelIndexPoint3f = dicomPoint3f2.b().c();
                    s2.a(0).a(i4, i3, i2, voxelIndexPoint3f.x);
                    s2.a(1).a(i4, i3, i2, voxelIndexPoint3f.y);
                    s2.a(2).a(i4, i3, i2, voxelIndexPoint3f.z);
                }
            }
        }
    }

    private static VolumeExtent buildExtentsFromGridCorners(DicomObject dicomObject, boolean bl2, Point3f.PointVolumeInfo pointVolumeInfo) {
        DicomObject dicomObject2 = DefRegReadHelpers.findDefRegSequenceItem(dicomObject);
        DicomElement dicomElement = dicomObject2.get(6553605);
        DicomObject dicomObject3 = dicomElement.getDicomObject(0);
        int[] nArray = dicomObject3.getInts(6553607);
        Pair<Point3f.PointVolumeInfo, int[]> pair = DefRegReadHelpers.constructGridPVI(dicomObject2, bl2);
        Point3f.PointVolumeInfo pointVolumeInfo2 = (Point3f.PointVolumeInfo)pair.x;
        float[] fArray = null;
        float[] fArray2 = null;
        for (int i2 = 0; i2 < 8; ++i2) {
            VoxelPoint3f voxelPoint3f = new VoxelPoint3f((i2 & 1) == 0 ? 0.0f : (float)nArray[0], (i2 & 2) == 0 ? 0.0f : (float)nArray[1], (i2 & 4) == 0 ? 0.0f : (float)nArray[2], pointVolumeInfo2);
            float[] fArray3 = voxelPoint3f.b().d().b(pointVolumeInfo).b().f();
            fArray = fArray == null ? fArray3 : MathUtils.b(fArray, fArray3);
            fArray2 = fArray2 == null ? fArray3 : MathUtils.a(fArray2, fArray3);
        }
        if (fArray == null || fArray2 == null) {
            return null;
        }
        int[][] nArray2 = new int[2][3];
        for (int i3 = 0; i3 < 3; ++i3) {
            nArray2[0][i3] = (int)Math.floor((double)(fArray[i3] + 0.001f));
            nArray2[1][i3] = (int)Math.ceil((double)(fArray2[i3] - 0.001f));
        }
        return new VolumeExtent(nArray2, -1);
    }

    private DicomDeformableRegistrationFileFormat(boolean bl2) {
        this.flipZDirection = bl2;
    }

    public boolean flipZDirection() {
        return this.flipZDirection;
    }

    public abstract VolumeExtent buildExtents(DicomObject var1, Point3f.PointVolumeInfo var2);

    public abstract void processWarpFieldEntry(ImageVolumeShort var1, Matrix4f var2, Matrix4f var3, s var4, Point3f.PointVolumeInfo var5);

    public abstract boolean allowResample(DicomObject var1);
}

