/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read.dynamic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.dicom.read.dynamic.DynamicSeriesPattern;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DynamicPatternMatcher {
    ListMultimap<AtomicLoadUnit, DynamicSeriesPattern> map = ArrayListMultimap.create();
    Map<Integer, Integer> totalFrameCounts = Maps.newHashMap();
    Collection<DynamicSeriesPattern> allPatterns = DynamicSeriesPattern.loadPatterns();
    int expectedNumberOfFrames;

    public DynamicPatternMatcher(Collection<AtomicLoadUnit> collection) {
        this.expectedNumberOfFrames = collection.size();
        this.initialize(collection);
    }

    public boolean matches4dPattern(AtomicLoadUnit atomicLoadUnit) {
        List list = this.map.get((Object)atomicLoadUnit);
        return list != null && !list.isEmpty();
    }

    public DynamicSeriesPattern getMatchingPattern(AtomicLoadUnit atomicLoadUnit) {
        List list = this.map.get((Object)atomicLoadUnit);
        if (list == null || list.isEmpty()) {
            return null;
        }
        List list2 = Ordering.from(this.getMatchCountComparator()).sortedCopy((Iterable)list);
        return (DynamicSeriesPattern)list2.get(0);
    }

    private void initialize(Iterable<AtomicLoadUnit> iterable) {
        for (AtomicLoadUnit atomicLoadUnit : iterable) {
            this.findMatchingPatterns(atomicLoadUnit);
        }
    }

    private void findMatchingPatterns(AtomicLoadUnit atomicLoadUnit) {
        for (DynamicSeriesPattern dynamicSeriesPattern : this.allPatterns) {
            if (!dynamicSeriesPattern.matches(atomicLoadUnit)) continue;
            this.incrementMatchCount(dynamicSeriesPattern);
            this.map.put((Object)atomicLoadUnit, (Object)dynamicSeriesPattern);
        }
    }

    private void incrementMatchCount(DynamicSeriesPattern dynamicSeriesPattern) {
        this.totalFrameCounts.put(dynamicSeriesPattern.getTotalFrames(), this.getCurrentCount(dynamicSeriesPattern) + 1);
    }

    private int getCurrentCount(DynamicSeriesPattern dynamicSeriesPattern) {
        Integer n2 = this.totalFrameCounts.get(dynamicSeriesPattern.getTotalFrames());
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    private Comparator<DynamicSeriesPattern> getMatchCountComparator() {
        return new Comparator<DynamicSeriesPattern>(){

            @Override
            public int compare(DynamicSeriesPattern dynamicSeriesPattern, DynamicSeriesPattern dynamicSeriesPattern2) {
                int n2 = DynamicPatternMatcher.this.compareByMatchCount(dynamicSeriesPattern, dynamicSeriesPattern2);
                if (n2 != 0) {
                    return n2;
                }
                n2 = DynamicPatternMatcher.this.compareByClosestToExpected(dynamicSeriesPattern, dynamicSeriesPattern2);
                if (n2 != 0) {
                    return n2;
                }
                return DynamicPatternMatcher.this.compareByTotalFramesUnderExpected(dynamicSeriesPattern, dynamicSeriesPattern2);
            }
        };
    }

    private int compareByMatchCount(DynamicSeriesPattern dynamicSeriesPattern, DynamicSeriesPattern dynamicSeriesPattern2) {
        return -(this.getCurrentCount(dynamicSeriesPattern) - this.getCurrentCount(dynamicSeriesPattern2));
    }

    private int compareByClosestToExpected(DynamicSeriesPattern dynamicSeriesPattern, DynamicSeriesPattern dynamicSeriesPattern2) {
        int n2 = Math.abs(dynamicSeriesPattern.getTotalFrames() - this.expectedNumberOfFrames);
        int n3 = Math.abs(dynamicSeriesPattern2.getTotalFrames() - this.expectedNumberOfFrames);
        int n4 = n2 - n3;
        return n4;
    }

    private int compareByTotalFramesUnderExpected(DynamicSeriesPattern dynamicSeriesPattern, DynamicSeriesPattern dynamicSeriesPattern2) {
        boolean bl2;
        boolean bl3 = dynamicSeriesPattern.getTotalFrames() < this.expectedNumberOfFrames;
        boolean bl4 = bl2 = dynamicSeriesPattern2.getTotalFrames() < this.expectedNumberOfFrames;
        if (bl3 ^ bl2) {
            if (bl3) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

