/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read.dynamic;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.dicom.read.LoadableFactory;
import com.mimvista.dicom.read.MultiSeriesFrameData;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.internals.FrameNumber;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.properties.af;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DynamicSeriesPattern {
    private static Pattern frameNumsPattern = Pattern.compile("\\(([0-9]+)/([0-9]+)\\)");
    private static Pattern frameDescPattern = Pattern.compile("\\) +\\[(.+)\\]");
    private String originalKey;
    private String value;
    private int frameNumber;
    private int totalFrames;
    private String frameDesc;
    private boolean malformed;

    public static Collection<DynamicSeriesPattern> loadPatterns() {
        af af2 = DynamicSeriesPattern.getDynamicPrefs();
        String[] stringArray = af2.getAllPropNames();
        ArrayList<DynamicSeriesPattern> arrayList = new ArrayList<DynamicSeriesPattern>(stringArray.length);
        for (String string : stringArray) {
            DynamicSeriesPattern dynamicSeriesPattern = new DynamicSeriesPattern(string);
            if (dynamicSeriesPattern.isMalformed()) continue;
            arrayList.add(dynamicSeriesPattern);
        }
        return arrayList;
    }

    private DynamicSeriesPattern(String string) {
        try {
            this.originalKey = string;
            this.value = DynamicSeriesPattern.getDynamicPrefs().get(string);
            this.malformed = false;
            Matcher matcher = frameNumsPattern.matcher(string);
            boolean bl2 = matcher.find();
            if (!bl2 || matcher.groupCount() < 2) {
                ay.c((Object)("Possibly malformed (frames/max frames) format in dynamic.txt key: " + string), this);
                this.malformed = true;
            }
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            this.frameNumber = Integer.parseInt(string2);
            this.totalFrames = Integer.parseInt(string3);
            Matcher matcher2 = frameDescPattern.matcher(string);
            boolean bl3 = matcher2.find();
            if (!bl3 || matcher2.groupCount() < 1) {
                ay.c((Object)("Possibly malformed frame description format in dynamic.txt key: " + string), this);
                this.malformed = true;
            }
            this.frameDesc = matcher2.group(1);
        }
        catch (Throwable throwable) {
            ay.d((Object)("Error reading malformed frame description format in dynamic.txt key:" + string), this);
            this.malformed = true;
        }
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public String getFrameDesc() {
        return this.frameDesc;
    }

    public void fillFrameData(MultiSeriesFrameData multiSeriesFrameData) {
        multiSeriesFrameData.setFrameNumberFromSeriesDesc(new FrameNumber(this.getFrameNumber()));
        multiSeriesFrameData.setMaxFramesFromSeriesDesc(this.getTotalFrames());
        multiSeriesFrameData.setFrameDesc(this.getFrameDesc());
        multiSeriesFrameData.setMultiSeries4d(true);
    }

    public boolean matches(AtomicLoadUnit atomicLoadUnit) {
        try {
            String string = atomicLoadUnit.getModality();
            String string2 = atomicLoadUnit.getStringTagValue(524400, true, "");
            if (!this.matchesModalityAndManufacturer(string, string2)) {
                return false;
            }
            return this.matchesTags(atomicLoadUnit);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error trying to match series with 4D pattern", throwable, this);
            return false;
        }
    }

    public String toString() {
        return this.originalKey + " := " + this.value;
    }

    boolean isMalformed() {
        return this.malformed;
    }

    private boolean matchesModalityAndManufacturer(String string, String string2) {
        String string3 = string + ", " + string2;
        string3 = string3.split("/ MIM Software")[0];
        return this.originalKey.startsWith(string3.toUpperCase());
    }

    private boolean matchesTags(AtomicLoadUnit atomicLoadUnit) {
        String[] stringArray = this.value.split("~~");
        if (stringArray.length % 2 != 0) {
            ay.c((Object)("Attempting to ID multi-series 4D scan: found malformed key/value in dynamic.txt for " + this.toString()), LoadableFactory.class);
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string = stringArray[n3++];
            String string2 = stringArray[n3++];
            String string3 = "";
            if ((string = cn.f(string)).equalsIgnoreCase("SeriesDescription")) {
                string3 = atomicLoadUnit.getSeriesDescription();
            } else {
                int n4 = TagUtils.forTagName(string);
                string3 = atomicLoadUnit.getStringTagValue(n4, true, null);
            }
            if (string3 == null || string3.isEmpty()) break;
            string2 = string2.replaceAll(" ", "(\\s|.)");
            if (!DicomPrefs.allowPrecedingDigitsDynamic.getValue().booleanValue() && Character.isDigit(string2.charAt(0))) {
                string2 = "(^|\\D)" + string2;
            }
            try {
                Pattern pattern = Pattern.compile(".*" + string2 + ".*", 2);
                if (!pattern.matcher(string3).matches()) continue;
                ++n2;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ay.d((Object)("Attempting to ID multi-series 4D scan: Pattern Syntax: " + patternSyntaxException.getMessage() + " in dynamic.txt"), LoadableFactory.class);
                InputNotification inputNotification = new InputNotification(new Notification.a(), BasicNotification.NotificationType.a.a(), BasicNotification.NotificationType.a.b());
                inputNotification.setShowReset(false);
                inputNotification.setScrollBarType(AbstractInputContainer.ScrollBarType.c);
                inputNotification.setButtonBarVisible(false);
                inputNotification.addLabel(MIMFormat.a(Messages.a("Dicom", "PATTERN_SYNTAX_ERROR"), string2));
                u.b().c(inputNotification);
            }
        }
        return n2 == stringArray.length / 2;
    }

    private static af getDynamicPrefs() {
        af af2 = af.getReadablePrefsFromCascade("SERVICES/dynamic.txt");
        if (af2.countProps() > 0) {
            return af2;
        }
        af af3 = af.getWriteablePrefsFromCascade("SERVICES/dynamic.txt");
        ay.b((Object)"Creating default dynamic.txt", LoadableFactory.class);
        Messages messages = Messages.a("dynamic_txt", true);
        ArrayList arrayList = Lists.newArrayList(messages.keySet());
        for (String string : arrayList) {
            af3.setConfig(string.replace('_', ' '), (String)messages.get(string));
        }
        return af3;
    }
}

