/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.reffinder.ReferencedSeriesResultsListener;
import com.mimvista.dicom.reffinder.params.ParamsBuilder;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReferencedSeriesFinder {
    public static Messages props = Messages.a("Archive");
    private SearchSource searchSource;
    private List<DcmSeries> seriesFound = Lists.newArrayList();
    private boolean throwXcpIfNoResultsFound = true;
    private ParamsBuilder paramsBuilder;
    private DcmSeries dcmSeries = null;
    private SeriesInfo seriesInfo = null;
    private SeriesParameters seriesParams;
    private DcmSeries resultFromParamsBuilder = null;

    public ReferencedSeriesFinder(SearchSource searchSource, DcmSeries dcmSeries) {
        this(searchSource);
        this.dcmSeries = dcmSeries;
        this.setParamsForSeries();
    }

    public ReferencedSeriesFinder(SearchSource searchSource, SeriesInfo seriesInfo) {
        this(searchSource);
        this.seriesInfo = seriesInfo;
        this.setParamsForSeries();
    }

    public ReferencedSeriesFinder(SearchSource searchSource, SeriesParameters seriesParameters) {
        this(searchSource);
        this.seriesParams = seriesParameters;
        this.setParamsForSeries();
    }

    private ReferencedSeriesFinder(SearchSource searchSource) {
        this.searchSource = searchSource;
        this.paramsBuilder = new ParamsBuilder(this.searchSource);
    }

    private void setParamsForSeries() {
        String string = null;
        if (this.dcmSeries != null) {
            string = this.dcmSeries.getLocalDir();
            this.seriesInfo = this.dcmSeries.getDataProvider().getUncopiedMutableInfo();
        }
        if (this.seriesInfo != null) {
            ParamsBuilder.SeriesParamsWrapper seriesParamsWrapper = this.paramsBuilder.buildSeriesParametersFromSeriesInfo(string, this.seriesInfo);
            this.setAdjustedParams(seriesParamsWrapper);
        }
    }

    public ReferencedSeriesFinder(SearchSource searchSource, DcmSeries dcmSeries, ParamsBuilder paramsBuilder, ParamsBuilder.SeriesParamsWrapper seriesParamsWrapper) {
        this.searchSource = searchSource;
        this.dcmSeries = dcmSeries;
        this.paramsBuilder = paramsBuilder;
        this.setAdjustedParams(seriesParamsWrapper);
        this.seriesInfo = dcmSeries.getDataProvider().getUncopiedMutableInfo();
    }

    private void setAdjustedParams(ParamsBuilder.SeriesParamsWrapper seriesParamsWrapper) {
        if (seriesParamsWrapper != null) {
            this.resultFromParamsBuilder = seriesParamsWrapper.cachedResult;
            this.seriesParams = seriesParamsWrapper.searchParams;
        } else {
            this.resultFromParamsBuilder = null;
            this.seriesParams = null;
        }
    }

    public void dontFind(List<UIDContainer> list) {
        this.paramsBuilder.addExistingUIDs(list);
        this.paramsBuilder.eliminateFoundSeries(this.seriesParams);
    }

    public void setThrowXcpIfNoResultsFound(boolean bl2) {
        this.throwXcpIfNoResultsFound = bl2;
    }

    public Set<UIDContainer> getAllNeededUIDs() {
        if (this.paramsBuilder != null) {
            return this.paramsBuilder.getAllNeededUIDs();
        }
        return null;
    }

    public DcmSeries getSearchedSeries() {
        return this.dcmSeries;
    }

    public List<DcmSeries> getSeriesFound() {
        if (this.seriesFound == null) {
            return null;
        }
        return Lists.newArrayList(this.seriesFound);
    }

    public boolean findReferencedSeries() throws FileNotFoundException {
        return this.findReferencedSeries(null);
    }

    public boolean findReferencedSeries(String string) throws FileNotFoundException {
        ReferencedSeriesResultsListener referencedSeriesResultsListener = new ReferencedSeriesResultsListener(this.dcmSeries, this.searchSource, this.paramsBuilder);
        if (cn.h(string) && this.seriesInfo != null) {
            string = this.seriesInfo.b();
        }
        if (this.seriesParams == null) {
            ay.d((Object)"Failed to collect parameters for referring series, bailing", this);
            throw new FileNotFoundException(string);
        }
        return this.findReferencedSeries(referencedSeriesResultsListener, string);
    }

    public SeriesParameters getSeriesParams() {
        return this.seriesParams;
    }

    private boolean findReferencedSeries(ReferencedSeriesResultsListener referencedSeriesResultsListener, String string) throws FileNotFoundException {
        this.resolveDcmSeriesReferences();
        if (this.seriesParams == null || this.seriesParams.uidList.isEmpty()) {
            ay.e("All referenced series already selected and/or open for: " + string);
            return true;
        }
        if (this.searchSource != null) {
            if (this.resultFromParamsBuilder != null) {
                DcmStudy dcmStudy = new DcmStudy();
                dcmStudy.addSeries(this.resultFromParamsBuilder);
                i i2 = new i(Collections.singletonList(dcmStudy), this.searchSource, Searchable.SearchType.a);
                referencedSeriesResultsListener.setSearchResults(i2);
            } else {
                this.searchSource.b(this.seriesParams, referencedSeriesResultsListener).run();
            }
        }
        this.seriesFound.addAll(referencedSeriesResultsListener.getSeriesFound());
        if (this.seriesFound.isEmpty() || referencedSeriesResultsListener.getNestedException() != null) {
            ay.d((Object)("Can't find one or more referenced series for: " + string), this);
            if (this.throwXcpIfNoResultsFound) {
                throw new FileNotFoundException(string);
            }
            return false;
        }
        return true;
    }

    private void resolveDcmSeriesReferences() {
        if (this.seriesParams != null && this.seriesParams.uidList != null && !this.seriesParams.uidList.isEmpty() && this.dcmSeries != null && this.dcmSeries.getReferencedSeries() != null) {
            boolean bl2;
            boolean bl3 = this.seriesParams.searchType == 0 || this.seriesParams.searchType == 7;
            boolean bl4 = bl2 = this.seriesParams.searchType == 0 || this.seriesParams.searchType == 3 || this.seriesParams.searchType == 5;
            if (bl3 || bl2) {
                HashSet hashSet = Sets.newHashSet();
                for (Serializable serializable : this.dcmSeries.getReferencedSeries().values()) {
                    if (((DcmSeriesReference)serializable).getReferencedDcmSeries() == null) continue;
                    hashSet.addAll(((DcmSeriesReference)serializable).getReferencedDcmSeries());
                }
                for (Serializable serializable : hashSet) {
                    Modality modality;
                    String string = ((DcmSeries)serializable).getSeriesInstanceUID();
                    String string2 = ((DcmSeries)serializable).getOneOfMySOPInstanceUIDs();
                    String string3 = null;
                    if (bl3 && string != null && this.seriesParams.uidList.contains(string)) {
                        string3 = string;
                    } else if (bl2 && string2 != null && this.seriesParams.uidList.contains(string2)) {
                        string3 = string2;
                    }
                    if (string3 == null || (modality = Modality.get(((DcmSeries)serializable).getModality())) == null || SeriesIdentifier.isReferringSeries(modality)) continue;
                    ((DcmSeries)serializable).setSearchSource(this.dcmSeries.getSearchSource());
                    this.seriesFound.add((DcmSeries)serializable);
                    this.seriesParams.uidList.remove(string3);
                }
            }
        }
    }
}

