/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.e;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.reffinder.ReferencedSeriesFinder;
import com.mimvista.dicom.reffinder.params.ParamsBuilder;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.RTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ReferencedSeriesResultsListener
extends e {
    private DcmSeries seriesToCheck = null;
    private List<DcmSeries> seriesFound = new ArrayList<DcmSeries>();
    private Set<UIDContainer> foundUids = new HashSet<UIDContainer>();
    private SearchSource searchSource;
    private ParamsBuilder paramsBuilder;
    private FileNotFoundException nestedException = null;

    ReferencedSeriesResultsListener(DcmSeries dcmSeries, SearchSource searchSource, ParamsBuilder paramsBuilder) {
        this.seriesToCheck = dcmSeries;
        this.searchSource = searchSource;
        this.paramsBuilder = paramsBuilder;
        this.foundUids = paramsBuilder.getExistingUIDs();
    }

    List<DcmSeries> getSeriesFound() {
        return Lists.newArrayList(this.seriesFound);
    }

    public FileNotFoundException getNestedException() {
        return this.nestedException;
    }

    @Override
    public void setSearchResults(i i2) {
        List<UIDContainer> list = this.processFoundSeries(i2.b());
        this.paramsBuilder.addExistingUIDs(list);
        if (this.seriesToCheck != null) {
            this.fillRtDosePlanMap(this.seriesFound);
        }
    }

    private List<UIDContainer> processFoundSeries(List<DcmSeries> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (DcmSeries dcmSeries : list) {
            SeriesInfo seriesInfo;
            String string = dcmSeries.getSeriesInstanceUID();
            if (cn.h(string) && (seriesInfo = dcmSeries.getDataProvider().getUncopiedMutableInfo()) != null) {
                string = seriesInfo.ag();
            }
            if (!cn.h(string)) {
                arrayList.add(new UIDContainer.SeriesUID(string));
                this.seriesFound.add(dcmSeries);
                continue;
            }
            ay.d((Object)("Could not determine UID for DcmSeries with path: " + dcmSeries.getArchiveDir() + " on " + this.searchSource), this);
        }
        this.foundUids.addAll(arrayList);
        return arrayList;
    }

    private void fillRtDosePlanMap(List<DcmSeries> list) {
        HashMap hashMap = this.seriesToCheck.getRtPlanMap();
        if (hashMap == null) {
            hashMap = Maps.newHashMap();
            this.seriesToCheck.setRtPlanMap(hashMap);
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        SeriesInfo seriesInfo = this.seriesToCheck.getDataProvider().getUncopiedMutableInfo();
        Modality modality = Modality.get(seriesInfo.modality);
        if (modality == Modality.RTPLAN || modality == Modality.RTDOSE || seriesInfo.y().getTagValue(930291986) != null) {
            boolean bl2 = false;
            FileNotFoundException fileNotFoundException = null;
            ArrayList arrayList = Lists.newArrayList();
            arrayList.addAll(list);
            for (DcmSeries dcmSeries : arrayList) {
                List<DcmSeries> list2;
                SeriesInfo seriesInfo2 = dcmSeries.getDataProvider().getUncopiedMutableInfo();
                if (seriesInfo2 == null) {
                    ay.c((Object)"Error finding referenced series for RT series", this);
                    return;
                }
                if (Modality.CT.isSameModality(seriesInfo2.modality)) {
                    return;
                }
                SeriesParameters seriesParameters = null;
                ParamsBuilder.SeriesParamsWrapper seriesParamsWrapper = this.paramsBuilder.buildSeriesParametersFromSeriesInfo(dcmSeries.getLocalDir(), seriesInfo2);
                if (seriesParamsWrapper != null) {
                    seriesParameters = seriesParamsWrapper.searchParams;
                }
                if (seriesParameters == null) {
                    ay.b((Object)"Series params built is null", this);
                    continue;
                }
                boolean bl3 = false;
                String string = seriesParamsWrapper.referencedUIDs.get(0);
                if (string != null) {
                    for (UIDContainer fileNotFoundException2 : this.foundUids) {
                        if (fileNotFoundException2 == null || !string.equals(fileNotFoundException2.uid)) continue;
                        bl3 = true;
                        break;
                    }
                }
                if (bl3) {
                    if (hashMap.get(seriesInfo.ag()) == null || seriesInfo2.sopInstanceUID.equals(((RTSeriesInfo)seriesInfo.modInfo).referencedRtStructUID)) {
                        hashMap.put(seriesInfo.ag(), string);
                    }
                    hashMap.put(seriesInfo2.ag(), string);
                    bl2 = true;
                    continue;
                }
                seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{string});
                ReferencedSeriesFinder referencedSeriesFinder = new ReferencedSeriesFinder(this.searchSource, dcmSeries, this.paramsBuilder, seriesParamsWrapper);
                try {
                    referencedSeriesFinder.findReferencedSeries();
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    fileNotFoundException = fileNotFoundException2;
                }
                if ((list2 = referencedSeriesFinder.getSeriesFound()) == null || list2.isEmpty()) continue;
                if ("rtdose".equalsIgnoreCase(seriesInfo.modality)) {
                    list2.add(dcmSeries);
                }
                hashMap.put(seriesInfo.ag(), string);
                hashMap.put(seriesInfo2.ag(), list2.get(0).getDataProvider().getUncopiedMutableInfo().ag());
                this.processFoundSeries(list2);
                bl2 = true;
            }
            if (!bl2 && fileNotFoundException != null) {
                ay.c((Object)"Error finding referenced series for RT series", fileNotFoundException, this);
                this.nestedException = fileNotFoundException;
            }
        }
    }
}

