/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder;

import com.google.common.collect.Lists;
import com.mimvista.archive.m;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.reffinder.SopSearchResultsListener;
import com.mimvista.numerics.helpers.b;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.SeriesInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class SopReferenceFinder {
    private final String patientName;
    private final String patientId;
    private final SearchSource searchSource;
    private boolean preferNonEmbeddedSeries = false;

    public SopReferenceFinder(String string, String string2, SearchSource searchSource) {
        this.patientName = string;
        this.patientId = string2;
        this.searchSource = searchSource;
    }

    public SopReferenceFinder(SeriesInfo seriesInfo, SearchSource searchSource) {
        this(seriesInfo.patientName, seriesInfo.patientId, searchSource);
    }

    public void setPreferNonEmbeddedSeries(boolean bl2) {
        this.preferNonEmbeddedSeries = bl2;
    }

    public DcmSeries find(String string, String string2, Progress progress) {
        b<List<DcmStudy>> b2 = this.startSearching(string2, progress);
        List<Object> list = Lists.newArrayList();
        try {
            list = b2.get();
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)"Error getting search results", (Throwable)interruptedException, this);
        }
        catch (ExecutionException executionException) {
            ay.d((Object)"Error getting search results", (Throwable)executionException, this);
        }
        progress.a(true);
        DcmSeries dcmSeries = null;
        for (DcmStudy dcmStudy : list) {
            if (dcmStudy == null) continue;
            for (DcmSeries dcmSeries2 : dcmStudy) {
                String string3 = dcmSeries2.getOneOfMySOPInstanceUIDs();
                if (string3 == null) {
                    string3 = dcmSeries2.getDataProvider().getValueForDicomTag(524312);
                }
                if (!string.equals(string3)) continue;
                if (this.preferNonEmbeddedSeries && dcmSeries2.isEmbedded()) {
                    if (dcmSeries != null) continue;
                    dcmSeries = dcmSeries2;
                    continue;
                }
                return dcmSeries2;
            }
        }
        return dcmSeries;
    }

    private b<List<DcmStudy>> startSearching(String string, Progress progress) {
        b<List<DcmStudy>> b2 = new b<List<DcmStudy>>();
        HashMap<String, String> hashMap = m.a("", this.patientName, this.patientId, string, "", "", "");
        SopSearchResultsListener sopSearchResultsListener = new SopSearchResultsListener(b2, progress);
        this.searchSource.a((Map<String, String>)hashMap, (f<i>)sopSearchResultsListener).run();
        return b2;
    }
}

