/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.Parser;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

@ExternallyVisible
public class StudyFinder {
    @Deprecated
    public static final int SERIES = 0;
    public static final int RTSTRUCT_REFERENCED_STUDY = 1;
    public static final int REG_REFERENCED_STUDY = 2;
    public static final int RTPLAN_REFERENCED_RTSTRUCT = 3;
    public static final int STUDY = 4;
    public static final int SERIES_BY_SOP_INSTANCE = 5;
    public static final int SERIES_BY_FRAME_OF_REFERENCE = 6;
    public static final int SERIES_BY_SERIES_INSTANCE = 7;
    private static boolean verbose = false;
    private static final ImmutableList<Integer> dcmTagsToRead = new ImmutableList.Builder().add((Object)0x20000E).add((Object)524312).add((Object)0x20000D).add((Object)0x200052).add((Object)805699600).add((Object)805699602).add((Object)805699604).add((Object)528896).add((Object)805699592).add((Object)805699593).add((Object)805699586).add((Object)805699588).add((Object)528496).add((Object)528446).build();
    private String archivePath = null;
    private String lastName = null;
    private String fullName = null;
    private String studyMonthFolder = null;
    private String contentMonthFolder = null;
    private String searchModality = null;
    private Map<String, String> uidsToFind = Maps.newHashMap();
    private int searchType = 0;
    private List<File> monthDirs = Lists.newArrayList();
    private int studyMonthIndex;
    private int contentMonthIndex;
    private int studyMonthMinus2 = -1;
    private int studyMonthMinus1 = -1;
    private int studyMonthPlus1 = -1;
    private int studyMonthPlus2 = -1;
    private List<QueryResult> foundSeries = new ArrayList<QueryResult>();
    private Set<File> alreadyChecked = Sets.newHashSet();
    private SearchNotifier notifier;
    private FileFilter dirOnlyFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public static String getReferencedSeriesIdFromRtstruct(DicomObject dicomObject) {
        String string = dicomObject.getString(new int[]{805699600, 0, 805699602, 0, 805699604, 0, 0x20000E});
        return string;
    }

    public static List<String> getReferencedSeriesIDsFromReg(DicomObject dicomObject) {
        Object object;
        DicomObject dicomObject2;
        int n2;
        DicomElement dicomElement;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)2);
        if (dicomObject.contains(528896)) {
            dicomElement = dicomObject.get(528896);
            for (n2 = 0; n2 < dicomElement.countItems(); ++n2) {
                dicomObject2 = dicomElement.getDicomObject(n2);
                if (!dicomObject2.contains(528661)) continue;
                object = dicomObject2.get(528661);
                for (int i2 = 0; i2 < object.countItems(); ++i2) {
                    DicomObject dicomObject3 = object.getDicomObject(i2);
                    String string = dicomObject3.getString(0x20000E, (String)null);
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
        }
        if (dicomObject.contains(528661)) {
            dicomElement = dicomObject.get(528661);
            for (n2 = 0; n2 < dicomElement.countItems(); ++n2) {
                dicomObject2 = dicomElement.getDicomObject(n2);
                object = dicomObject2.getString(0x20000E, (String)null);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public static String dateToMonthFolder(String string) {
        if (string.length() < 8) {
            return null;
        }
        return string.substring(0, 4) + "-" + string.substring(4, 6) + "__Studies";
    }

    public static String formatDate(String string) {
        if (string.length() < 8) {
            return string;
        }
        return string.substring(0, 4) + "-" + string.substring(4, 6) + "-" + string.substring(6, 8);
    }

    public static String formatTime(String string) {
        if (string.length() < 6) {
            return string;
        }
        return string.substring(0, 2) + ":" + string.substring(2, 4) + ":" + string.substring(4, 6);
    }

    public void setSearchModality(String string) {
        this.searchModality = string;
    }

    public void setSearchType(int n2) {
        this.searchType = n2;
    }

    public void setContentDate(String string) {
        this.contentMonthFolder = StudyFinder.dateToMonthFolder(string);
    }

    public void setStudyDate(String string) {
        this.studyMonthFolder = StudyFinder.dateToMonthFolder(string);
    }

    public void setName(String string) {
        this.fullName = string;
        String string2 = string.toLowerCase();
        int n2 = string.indexOf(94);
        if (n2 > -1) {
            if (n2 > 3) {
                n2 = 3;
            }
            string2 = string.substring(0, n2);
        }
        this.lastName = string2.toUpperCase();
        string = PathUtils.safeFilename(string);
        this.fullName = Parser.formatName(string);
    }

    public void addUID(String string) {
        this.uidsToFind.put(string, null);
    }

    public void setArchivePath(String string) {
        this.archivePath = string;
    }

    public void setReferencingFilePath(String string) {
        String string2 = PathUtils.getArchivePathFromSeriesFolder(string);
        if (string2 != null) {
            this.archivePath = string2;
            ay.b((Object)("Archive Path: " + this.archivePath), this);
        } else {
            ay.b((Object)("Bad Referencing File for getting Archive Path: " + string), this);
        }
    }

    private void loadMonthDirsSorted() {
        this.resetSearchIndices();
        File file = null;
        File file2 = null;
        ay.b((Object)("ArchivePath: " + this.archivePath), this);
        File[] fileArray = null;
        try {
            fileArray = new MIMFile(this.archivePath).listFiles(this.dirOnlyFilter);
        }
        catch (SecurityException securityException) {
            ay.d((Object)"Permissions error listing files in StudyFinder", (Throwable)securityException, this);
        }
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            if (this.isCancelled()) {
                return;
            }
            String string = file3.getName();
            if (string.toLowerCase().indexOf("__studies") == -1) continue;
            if (string.equalsIgnoreCase(this.studyMonthFolder)) {
                file = file3;
            }
            if (string.equalsIgnoreCase(this.contentMonthFolder)) {
                file2 = file3;
            }
            this.monthDirs.add(file3);
        }
        Collections.sort(this.monthDirs);
        if (file != null) {
            this.studyMonthIndex = this.monthDirs.indexOf(file);
        }
        if (this.studyMonthIndex != -1) {
            if (this.studyMonthIndex > 0) {
                this.studyMonthMinus1 = this.studyMonthIndex - 1;
            }
            if (this.studyMonthIndex > 1) {
                this.studyMonthMinus2 = this.studyMonthIndex - 2;
            }
            if (this.studyMonthIndex < this.monthDirs.size() - 1) {
                this.studyMonthPlus1 = this.studyMonthIndex + 1;
            }
            if (this.studyMonthIndex < this.monthDirs.size() - 2) {
                this.studyMonthPlus2 = this.studyMonthIndex + 2;
            }
        } else if (this.studyMonthFolder != null) {
            int n2;
            for (n2 = 0; n2 < this.monthDirs.size() && this.monthDirs.get(n2).getName().compareTo(this.studyMonthFolder) <= 0; ++n2) {
            }
            if (n2 > 0) {
                this.studyMonthMinus1 = n2 - 1;
            }
            if (n2 > 1) {
                this.studyMonthMinus2 = n2 - 2;
            }
            if (n2 <= this.monthDirs.size() - 1) {
                this.studyMonthPlus1 = n2;
            }
            if (n2 <= this.monthDirs.size() - 2) {
                this.studyMonthPlus2 = n2 + 1;
            }
        }
        if (file2 != null) {
            this.contentMonthIndex = this.monthDirs.indexOf(file2);
        }
        if (this.contentMonthIndex == -1 && this.contentMonthFolder != null) {
            int n3;
            for (n3 = 0; n3 < this.monthDirs.size() && this.monthDirs.get(n3).getName().compareTo(this.contentMonthFolder) <= 0; ++n3) {
            }
            this.contentMonthIndex = Math.min(n3, this.monthDirs.size() - 1);
        }
    }

    private void resetSearchIndices() {
        this.studyMonthIndex = -1;
        this.studyMonthMinus1 = -1;
        this.studyMonthMinus2 = -1;
        this.studyMonthPlus1 = -1;
        this.studyMonthPlus2 = -1;
        this.contentMonthIndex = -1;
    }

    public List<QueryResult> search() {
        if (this.notifier == null) {
            this.setNullNotifier();
        }
        this.updateLabelText(MIMFormat.a(Messages.a("Dicom", "STUDYFIND_FOUND"), "0"));
        long l2 = System.currentTimeMillis();
        try {
            this.loadMonthDirsSorted();
            this.searchStudyMonth();
            if (!this.allAreFound()) {
                this.searchAroundStudyMonth(true);
                if (!this.allAreFound()) {
                    this.searchAroundStudyMonth(false);
                }
            }
            if (!this.allAreFound()) {
                this.searchStudyMonthTillContentMonth();
            }
            if (!this.allAreFound() && this.searchType == 0) {
                this.searchStudyMonthBackwards();
            }
            if (!this.allAreFound() && this.doFullSearch()) {
                this.fullSearch();
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error in search", (Throwable)exception, this);
        }
        ay.e("StudyFinder completed in " + (System.currentTimeMillis() - l2) + "ms");
        this.notifier.finished();
        return this.foundSeries;
    }

    private boolean doFullSearch() {
        return this.searchType == 0 || this.searchType == 3 || this.searchType == 5 || this.searchType == 7 || this.searchType == 6;
    }

    private void searchStudyMonth() {
        if (this.studyMonthIndex != -1) {
            this.searchMonthDir(this.monthDirs.get(this.studyMonthIndex), true);
            if (!this.allAreFound()) {
                this.searchMonthDir(this.monthDirs.get(this.studyMonthIndex), false);
            }
        }
    }

    private void searchAroundStudyMonth(boolean bl2) {
        if (this.isCancelled()) {
            return;
        }
        if (this.studyMonthMinus1 != -1) {
            this.searchMonthDir(this.monthDirs.get(this.studyMonthMinus1), bl2);
        }
        if (this.allAreFound() || this.isCancelled()) {
            return;
        }
        if (this.studyMonthMinus2 != -1) {
            this.searchMonthDir(this.monthDirs.get(this.studyMonthMinus2), bl2);
        }
        if (this.allAreFound() || this.isCancelled()) {
            return;
        }
        if (this.studyMonthPlus1 != -1) {
            this.searchMonthDir(this.monthDirs.get(this.studyMonthPlus1), bl2);
        }
        if (this.allAreFound() || this.isCancelled()) {
            return;
        }
        if (this.studyMonthPlus2 != -1) {
            this.searchMonthDir(this.monthDirs.get(this.studyMonthPlus2), bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void searchStudyMonthTillContentMonth() {
        int n2;
        if (this.contentMonthIndex == -1) {
            return;
        }
        int n3 = MathUtils.m(this.studyMonthMinus2, this.studyMonthMinus1, this.studyMonthIndex, this.studyMonthPlus1, this.studyMonthPlus2);
        if (n3 == -1) {
            if (this.doFullSearch() || this.monthDirs.size() <= 0) return;
            n3 = 0;
        } else {
            ++n3;
        }
        for (n2 = n3; n2 <= this.contentMonthIndex && !this.allAreFound(); ++n2) {
            if (this.isCancelled()) {
                return;
            }
            this.searchMonthDir(this.monthDirs.get(n2), true);
        }
        if (this.allAreFound() || this.isCancelled()) {
            return;
        }
        for (n2 = n3; n2 <= this.contentMonthIndex && !this.allAreFound(); ++n2) {
            if (this.isCancelled()) {
                return;
            }
            this.searchMonthDir(this.monthDirs.get(n2), false);
        }
    }

    private void searchStudyMonthBackwards() {
        int n2;
        for (n2 = this.studyMonthMinus2 - 1; n2 >= 0 && !this.allAreFound(); --n2) {
            if (this.isCancelled()) {
                return;
            }
            this.searchMonthDir(this.monthDirs.get(n2), true);
        }
        if (this.allAreFound() || this.isCancelled()) {
            return;
        }
        for (n2 = this.studyMonthMinus2 - 1; n2 >= 0 && !this.allAreFound(); --n2) {
            if (this.isCancelled()) {
                return;
            }
            this.searchMonthDir(this.monthDirs.get(n2), false);
        }
    }

    private void searchMonthDir(File file, boolean bl2) {
        if (file == null) {
            ay.c((Object)"Null File passed to searchMonthDir, archive dir is possibly incorrect.", this);
            return;
        }
        if (verbose) {
            ay.b((Object)("Looking in " + file.getName()), this);
        }
        String string = null;
        if (bl2 && this.lastName != null && !this.lastName.isEmpty()) {
            string = String.valueOf(Character.toLowerCase(this.lastName.charAt(0)));
        }
        if (string == null) {
            bl2 = false;
        }
        File[] fileArray = null;
        try {
            fileArray = file.listFiles(this.dirOnlyFilter);
        }
        catch (SecurityException securityException) {
            ay.d((Object)"Permission error listing files in StudyFinder", (Throwable)securityException, this);
        }
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (this.isCancelled()) {
                return;
            }
            if (this.alreadyChecked.contains(file2) || !this.shouldCheck(file2.getAbsolutePath(), string, bl2)) continue;
            if (verbose) {
                ay.b((Object)("\tChecking3 " + file2.getName() + (bl2 ? " with " + string : "")), this);
            }
            this.checkStudyDir(file2);
            this.alreadyChecked.add(file2);
            if (!this.allAreFound()) continue;
            return;
        }
    }

    private boolean shouldCheck(String string, String string2, boolean bl2) {
        boolean bl3 = true;
        boolean bl4 = true;
        if (bl2 || this.searchModality != null) {
            Parser.b b2 = Parser.parse(string);
            if (bl2) {
                bl3 = b2.a().toLowerCase().startsWith(string2);
            }
            if (this.searchModality != null) {
                bl4 = b2.d().toLowerCase().indexOf(this.searchModality.toLowerCase()) > -1;
            }
        }
        return bl3 && bl4;
    }

    private void fullSearch() {
        for (File file : this.monthDirs) {
            if (this.isCancelled()) {
                return;
            }
            if (verbose) {
                ay.b((Object)("Looking in " + file.getName()), this);
            }
            File[] fileArray = null;
            try {
                fileArray = file.listFiles(this.dirOnlyFilter);
            }
            catch (SecurityException securityException) {
                ay.d((Object)"Permission error listing files in StudyFinder", (Throwable)securityException, this);
            }
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (this.isCancelled()) {
                    return;
                }
                if (this.alreadyChecked.contains(file2) || !this.shouldCheck(file2.getAbsolutePath(), null, false)) continue;
                if (this.searchType == 0 || this.searchType == 4 || this.searchType == 7 || this.searchType == 5 || this.searchType == 6) {
                    Parser.b b2 = Parser.parse(file2.getAbsolutePath());
                    String string = b2.d();
                    int n2 = b2.l();
                    if (("CT".equals(string) || "MR".equals(string) || "PT".equals(string) || "NM".equals(string)) && n2 < 4) {
                        if (!verbose) continue;
                        ay.b((Object)("skipping " + file2.getAbsolutePath()), this);
                        continue;
                    }
                }
                if (verbose) {
                    ay.b((Object)("\tChecking2 " + file2.getName()), this);
                }
                this.checkStudyDir(file2);
                this.alreadyChecked.add(file2);
                if (!this.allAreFound()) continue;
                return;
            }
        }
    }

    private void checkStudyDir(File file) {
        File[] fileArray = null;
        try {
            fileArray = file.listFiles();
        }
        catch (SecurityException securityException) {
            ay.d((Object)"Permission error listing files in StudyFinder", (Throwable)securityException, this);
        }
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (this.isCancelled()) {
                return;
            }
            if (!this.checkDataSet(file2)) continue;
            if (!this.allAreFound()) break;
            return;
        }
    }

    private boolean checkDataSet(File file) {
        DicomReader.FilteredTagInputHandler filteredTagInputHandler = new DicomReader.FilteredTagInputHandler(MathUtils.a(dcmTagsToRead), DicomReader.FilteredTagInputHandler.FilterMode.INCLUDE);
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file, filteredTagInputHandler);
        if (dicomObject == null || dicomObject.isEmpty()) {
            return false;
        }
        if (verbose) {
            ay.b((Object)("checking " + file), this);
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)2);
        switch (this.searchType) {
            case 0: {
                arrayList.add(dicomObject.getString(0x20000E));
                arrayList.add(dicomObject.getString(524312));
                break;
            }
            case 7: {
                arrayList.add(dicomObject.getString(0x20000E));
                break;
            }
            case 3: 
            case 5: {
                arrayList.add(dicomObject.getString(524312));
                break;
            }
            case 6: {
                arrayList.add(dicomObject.getString(0x200052));
                break;
            }
            case 1: {
                arrayList.add(StudyFinder.getReferencedSeriesIdFromRtstruct(dicomObject));
                break;
            }
            case 2: {
                arrayList.addAll(StudyFinder.getReferencedSeriesIDsFromReg(dicomObject));
                break;
            }
            case 4: {
                arrayList.add(dicomObject.getString(0x20000D));
                String string = Parser.getNameFromFile(file.getAbsolutePath()).toUpperCase();
                if (string != null && string.startsWith(this.fullName.toUpperCase())) break;
                return true;
            }
        }
        this.compareWithPending(arrayList, dicomObject, file.getAbsolutePath());
        return true;
    }

    private boolean allAreFound() {
        if (this.searchType == 0 || this.searchType == 3 || this.searchType == 5 || this.searchType == 7) {
            for (Map.Entry<String, String> entry : this.uidsToFind.entrySet()) {
                if (entry.getValue() != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void compareWithPending(List<String> list, DicomObject dicomObject, String string) {
        if (list == null) {
            ay.c((Object)("null uid at " + string), this);
            return;
        }
        boolean bl2 = false;
        if (this.searchType == 2) {
            int n2 = 0;
            for (String string2 : list) {
                if (!this.uidsToFind.containsKey(string2)) continue;
                ++n2;
            }
            bl2 = n2 == this.uidsToFind.size();
        } else {
            for (String string3 : list) {
                if (!this.uidsToFind.containsKey(string3)) continue;
                if (this.searchType == 0 || this.searchType == 3 || this.searchType == 5 || this.searchType == 7) {
                    this.uidsToFind.put(string3, string);
                }
                bl2 = true;
            }
        }
        if (bl2) {
            if (verbose) {
                ay.b((Object)"Found!", this);
            }
            QueryResult queryResult = new QueryResult(string);
            this.foundSeries.add(queryResult);
            this.updateLabelText(MIMFormat.a(Messages.a("Dicom", "STUDYFIND_FOUND"), this.foundSeries.size()));
            String string4 = new MIMFile(string).getParent();
            if (this.searchType == 1) {
                String string2;
                string2 = dicomObject.getString(805699592, "00000000");
                String string5 = dicomObject.getString(805699593, "000000");
                queryResult.attributes.put("label", dicomObject.getString(805699586, ""));
                queryResult.attributes.put("name", dicomObject.getString(805699588, ""));
                queryResult.attributes.put("creator", dicomObject.getString(528496, ""));
                queryResult.attributes.put("when", StudyFinder.formatDate(string2) + " " + StudyFinder.formatTime(string5));
                queryResult.attributes.put("desc", dicomObject.getString(528446, ""));
                queryResult.attributes.put("path", string4);
                queryResult.attributes.put("rawdatetime", string2 + string5);
            } else {
                queryResult.attributes.put("seriesinstanceuid", dicomObject.getString(0x20000E));
                queryResult.attributes.put("sopinstanceuid", dicomObject.getString(524312));
                queryResult.attributes.put("frameofreferenceuid", dicomObject.getString(0x200052));
                queryResult.attributes.put("path", string4);
            }
        }
    }

    public void setNullNotifier() {
        this.setNotifier(new SearchNotifier(){

            @Override
            public void finished() {
            }

            @Override
            public void setLabelText(String string) {
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
    }

    private boolean isCancelled() {
        if (this.notifier != null) {
            return this.notifier.isCancelled();
        }
        return false;
    }

    private void updateLabelText(String string) {
        if (this.notifier != null) {
            this.notifier.setLabelText(string);
        }
    }

    public void setNotifier(SearchNotifier searchNotifier) {
        this.notifier = searchNotifier;
    }

    public void applyParams(SeriesParameters seriesParameters) {
        if (seriesParameters.uidList != null) {
            for (String string : seriesParameters.uidList) {
                this.addUID(string);
            }
        }
        if (seriesParameters.contentDate != null) {
            this.setContentDate(seriesParameters.contentDate);
        }
        if (seriesParameters.studyDate != null) {
            this.setStudyDate(seriesParameters.studyDate);
        }
        if (seriesParameters.archivePath != null) {
            this.archivePath = seriesParameters.archivePath;
        }
        if (seriesParameters.name != null) {
            this.setName(seriesParameters.name);
        }
        if (seriesParameters.modality != null) {
            this.setSearchModality(seriesParameters.modality);
        }
        if (seriesParameters.referencingFilePath != null) {
            this.setReferencingFilePath(seriesParameters.referencingFilePath);
        }
        if (seriesParameters.searchType != -1) {
            this.setSearchType(seriesParameters.searchType);
        }
    }

    public static interface SearchNotifier {
        public void setLabelText(String var1);

        public boolean isCancelled();

        public void finished();
    }
}

