/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder.params;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.reffinder.params.ReferencedSeriesFinderStrategy;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParamsBuilder {
    private SearchSource searchSource;
    private Set<UIDContainer> allNeededUIDs = Sets.newHashSet();
    private Set<UIDContainer> existingUIDs = Sets.newHashSet();

    public ParamsBuilder(SearchSource searchSource) {
        this.searchSource = searchSource;
    }

    public void addExistingUIDs(List<UIDContainer> list) {
        this.existingUIDs.addAll(list);
    }

    public Set<UIDContainer> getExistingUIDs() {
        return this.existingUIDs;
    }

    public Set<UIDContainer> getAllNeededUIDs() {
        return this.allNeededUIDs;
    }

    public SeriesParamsWrapper buildSeriesParametersFromSeriesInfo(String string, SeriesInfo seriesInfo) {
        if (seriesInfo == null) {
            ay.d((Object)("Got null SeriesInfo for referring series: " + string), this);
            return null;
        }
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.referencingFilePath = string;
        seriesParameters.searchType = 0;
        seriesParameters.studyDate = seriesInfo.N();
        seriesParameters.name = seriesInfo.patientNameRaw;
        if (seriesInfo.modInfo == null) {
            return null;
        }
        ReferencedSeriesFinderStrategy referencedSeriesFinderStrategy = seriesInfo.modInfo.a(seriesInfo);
        if (referencedSeriesFinderStrategy == null) {
            return null;
        }
        if (!referencedSeriesFinderStrategy.strategizeParams(seriesParameters, this.searchSource)) {
            return null;
        }
        Map<String, UIDContainer> map = referencedSeriesFinderStrategy.getUIDsReferenced();
        if (seriesParameters.uidList.size() == 0) {
            ay.c((Object)("Failed to find any valid references inside referring series " + seriesInfo.sopInstanceUID), this);
            return null;
        }
        SeriesParamsWrapper seriesParamsWrapper = new SeriesParamsWrapper();
        seriesParamsWrapper.cachedResult = referencedSeriesFinderStrategy.getCachedResult();
        seriesParamsWrapper.referencedUIDs = Lists.newArrayList(seriesParameters.uidList);
        seriesParamsWrapper.searchParams = seriesParameters;
        Iterator<String> iterator = seriesParameters.uidList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (this.allNeededUIDs.contains(map.get(string2))) {
                iterator.remove();
                continue;
            }
            UIDContainer uIDContainer = map.get(string2);
            if (uIDContainer == null) continue;
            this.allNeededUIDs.add(uIDContainer);
        }
        return seriesParamsWrapper;
    }

    public SeriesParameters eliminateFoundSeries(SeriesParameters seriesParameters) {
        int n2 = 0;
        if (seriesParameters == null || seriesParameters.uidList == null) {
            return null;
        }
        Iterator<String> iterator = seriesParameters.uidList.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = false;
            String string = iterator.next();
            for (UIDContainer uIDContainer : this.existingUIDs) {
                if (!uIDContainer.equals(string)) continue;
                iterator.remove();
                bl2 = true;
                break;
            }
            if (bl2) continue;
            ++n2;
        }
        if (n2 > 0) {
            return seriesParameters;
        }
        return null;
    }

    public static class SeriesParamsWrapper {
        public SeriesParameters searchParams;
        public DcmSeries cachedResult;
        public List<String> referencedUIDs;
    }
}

