/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder.params;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.reffinder.SopReferenceFinder;
import com.mimvista.dicom.reffinder.params.ReferencedSeriesFinderStrategy;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RefSeriesFinderStrategyRTDOSE
extends ReferencedSeriesFinderStrategy {
    public RefSeriesFinderStrategyRTDOSE(SeriesInfo seriesInfo) {
        super(seriesInfo);
    }

    @Override
    public boolean strategizeParams(SeriesParameters seriesParameters, SearchSource searchSource) {
        this.cachedResult = null;
        if (this.seriesInfo.modInfo == null || !(this.seriesInfo.modInfo instanceof RTDoseSeriesInfo)) {
            return false;
        }
        RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)this.seriesInfo.modInfo;
        SopReferenceFinder sopReferenceFinder = new SopReferenceFinder(this.seriesInfo, searchSource);
        sopReferenceFinder.setPreferNonEmbeddedSeries(true);
        ArrayList<RtStFinderStrategy> arrayList = new ArrayList<RtStFinderStrategy>();
        arrayList.add(new RtStFinderStrategyUID(rTDoseSeriesInfo, seriesParameters, sopReferenceFinder));
        arrayList.add(new RtStFinderStrategyRTST(rTDoseSeriesInfo, seriesParameters, sopReferenceFinder));
        arrayList.add(new RtStFinderStrategyRTPLAN(rTDoseSeriesInfo, seriesParameters, sopReferenceFinder));
        boolean bl2 = false;
        Iterator iterator = arrayList.iterator();
        while (!bl2 && iterator.hasNext()) {
            RtStFinderStrategy rtStFinderStrategy = (RtStFinderStrategy)iterator.next();
            bl2 = rtStFinderStrategy.find();
            UIDContainer uIDContainer = rtStFinderStrategy.getUIDused();
            if (uIDContainer == null) continue;
            this.uidsReferenced.put(uIDContainer.uid, uIDContainer);
        }
        return bl2;
    }

    private class RtStFinderStrategyUID
    extends RtStFinderStrategy {
        RtStFinderStrategyUID(RTDoseSeriesInfo rTDoseSeriesInfo, SeriesParameters seriesParameters, SopReferenceFinder sopReferenceFinder) {
            super(rTDoseSeriesInfo, seriesParameters, sopReferenceFinder);
        }

        @Override
        boolean find() {
            String string;
            if (!cn.h(this.rtInfo.referencedSeriesUID)) {
                string = this.rtInfo.referencedSeriesUID;
            } else if (!cn.h(this.rtInfo.referencedImageUID)) {
                string = this.rtInfo.referencedImageUID;
            } else {
                return false;
            }
            this.params.uidList = Lists.newArrayList((Object[])new String[]{string});
            this.uidUsed = new UIDContainer.SeriesUID(string);
            this.params.searchType = 0;
            return true;
        }
    }

    private class RtStFinderStrategyRTST
    extends RtStFinderStrategy {
        RtStFinderStrategyRTST(RTDoseSeriesInfo rTDoseSeriesInfo, SeriesParameters seriesParameters, SopReferenceFinder sopReferenceFinder) {
            super(rTDoseSeriesInfo, seriesParameters, sopReferenceFinder);
        }

        @Override
        boolean find() {
            String string = this.rtInfo.referencedRtStructUID;
            if (cn.h(string)) {
                return false;
            }
            this.params.uidList = Lists.newArrayList((Object[])new String[]{string});
            this.uidUsed = new UIDContainer.SOPInstanceUID(string);
            this.params.studyDate = RefSeriesFinderStrategyRTDOSE.this.seriesInfo.N();
            this.params.contentDate = this.rtInfo.rtPlanDate;
            this.params.modality = "RTst";
            this.params.searchType = 3;
            try {
                DcmSeries dcmSeries = this.sopFinder.find(string, "RTST", new o());
                if (dcmSeries != null) {
                    Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference> multimap;
                    String string2 = dcmSeries.getFrameOfReferenceUID();
                    if (cn.h(string2) && (multimap = dcmSeries.getReferencedSeries()) != null) {
                        for (DcmSeriesReference dcmSeriesReference : multimap.get((Object)DcmSeriesReference.ReferenceSource.ReferencedFrameOfReferenceSequence)) {
                            String string3 = dcmSeriesReference.getReferences().get((Object)DcmSeriesReference.ReferenceUidType.FrameOfReferenceUID);
                            if (cn.h(string3)) continue;
                            string2 = string3;
                            break;
                        }
                    }
                    if (cn.h(string2) || cn.h(RefSeriesFinderStrategyRTDOSE.this.seriesInfo.frameOfRefUID) || RefSeriesFinderStrategyRTDOSE.this.seriesInfo.frameOfRefUID.equals(string2)) {
                        RefSeriesFinderStrategyRTDOSE.this.cachedResult = dcmSeries;
                        return true;
                    }
                    ay.a((Object)("Found a referenced RTSTRUCT for this dose, but it has a different FrameOfReferenceUID so we're ignoring it\nDose: " + RefSeriesFinderStrategyRTDOSE.this.seriesInfo + "\nRTst: " + dcmSeries), this);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return false;
        }
    }

    private class RtStFinderStrategyRTPLAN
    extends RtStFinderStrategy {
        RtStFinderStrategyRTPLAN(RTDoseSeriesInfo rTDoseSeriesInfo, SeriesParameters seriesParameters, SopReferenceFinder sopReferenceFinder) {
            super(rTDoseSeriesInfo, seriesParameters, sopReferenceFinder);
        }

        @Override
        boolean find() {
            List<String> list = this.rtInfo.referencedRtPlanUIDs;
            if (list.isEmpty()) {
                return false;
            }
            this.params.uidList = Lists.newArrayList(list);
            this.params.studyDate = RefSeriesFinderStrategyRTDOSE.this.seriesInfo.N();
            this.params.modality = "RTPlan";
            this.params.searchType = 3;
            for (String string : list) {
                if (cn.h(string)) continue;
                try {
                    DcmSeries dcmSeries = this.sopFinder.find(string, "RTPLAN", new o());
                    if (dcmSeries == null) continue;
                    String string2 = dcmSeries.getFrameOfReferenceUID();
                    if (cn.h(string2) || cn.h(RefSeriesFinderStrategyRTDOSE.this.seriesInfo.frameOfRefUID) || RefSeriesFinderStrategyRTDOSE.this.seriesInfo.frameOfRefUID.equals(string2)) {
                        this.uidUsed = new UIDContainer.SOPInstanceUID(string);
                        RefSeriesFinderStrategyRTDOSE.this.cachedResult = dcmSeries;
                        return true;
                    }
                    ay.a((Object)("Found a referenced RTPLAN for this dose, but it has a different FrameOfReferenceUID so we're ignoring it\nDose: " + RefSeriesFinderStrategyRTDOSE.this.seriesInfo + "\nPlan: " + dcmSeries), this);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    ay.d((Object)"Error finding RTDose Refs", (Throwable)unsupportedOperationException, RefSeriesFinderStrategyRTDOSE.class);
                }
            }
            return false;
        }
    }

    private abstract class RtStFinderStrategy {
        final RTDoseSeriesInfo rtInfo;
        final SeriesParameters params;
        final SopReferenceFinder sopFinder;
        UIDContainer uidUsed = null;

        RtStFinderStrategy(RTDoseSeriesInfo rTDoseSeriesInfo, SeriesParameters seriesParameters, SopReferenceFinder sopReferenceFinder) {
            this.rtInfo = rTDoseSeriesInfo;
            this.params = seriesParameters;
            this.sopFinder = sopReferenceFinder;
        }

        abstract boolean find();

        UIDContainer getUIDused() {
            return this.uidUsed;
        }
    }
}

